<?php
/**
 * Single Product tabs
 *
 * @author      WooThemes
 * @package     WooCommerce/Templates
 * @version     3.8.0
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Filter tabs and allow third parties to add their own
 *
 * Each tab is an array containing title, callback and priority.
 * @see woocommerce_default_product_tabs()
 */

if ( get_option( 'etheme_single_product_builder', false ) && function_exists('etheme_core_hooks') ) {
    wc_get_template( 'single-product/tabs/single-product-builder-tabs.php' );
    return;
}

$product_tabs = apply_filters( 'woocommerce_product_tabs', array() );

$close_tab = etheme_get_option('first_tab_closed');

$et_tabs['custom_tab'] = etheme_get_option( 'custom_tab_title' );
$et_tabs['custom_tab1'] = etheme_get_custom_field('custom_tab1_title');
$et_tabs['check'] = ( ! empty( $et_tabs['custom_tab'] ) || ! empty( $et_tabs['custom_tab1'] ) ) ? 1 : 0;

if ( ( ! empty( $product_tabs ) || $et_tabs['check'] ) && etheme_get_option('tabs_type') != 'disable' ) : $i=0; ?>
<?php if (etheme_get_option( 'single_layout' ) == 'center' && etheme_get_option('tabs_location') == 'after_content') : ?>
<div data-vc-full-width="true" data-vc-full-width-init="false" class="vc_row wpb_row tabs-full-width">
<?php endif ?>
    <div class="woocommerce-tabs wc-tabs-wrapper tabs <?php etheme_option('tabs_type'); ?> <?php echo (etheme_get_option('tabs_scroll') && etheme_get_option('tabs_type') == 'accordion') ? 'tabs-with-scroll' : ''; ?>">

    <?php global $post;
           $terms = get_the_terms( $post->ID, 'product_cat' );

           foreach ($terms as $term) {
            $product_cat_id = $term->term_id;

                if ($product_cat_id == 16 /* Borok */) {
                        $tabtitle = "Az évjáratról";
                        $tabtitle2 = "Analitika";
                }  elseif ($product_cat_id == 101 /* Wines */) {
                    $tabtitle = "About the vintage";
                    $tabtitle2 = "Analytics";
                 }  else { 
                    $tabtitle = $et_tabs['custom_tab1']; 
                    $tabtitle2 =  $et_tabs['custom_tab'];
                }
             
            break;
        }
        ?>



        <ul class="wc-tabs tabs-nav">
            <?php foreach ( $product_tabs as $key => $product_tab ) : $i++; ?>
                <li <?php if($i == 1 && $close_tab) echo 'class="tab_closed"'; ?>>
					<?php $get_tab_callback = wp_kses_post( apply_filters( 'woocommerce_product_' . $key . '_tab_title', $product_tab['callback'], $key ) ); ?>
					<?php if ( $get_tab_callback == 'woocommerce_product_description_tab' ) : ?>

                        <?php
          
                        foreach ($terms as $term) {
                            $product_cat_id = $term->term_id;
                                if ($product_cat_id == 16) /* Borok */ {
                                    if ($product_tab['title'] == "Leírás") {
                                        $product_tab['title'] = "A borról";
                                    }
                                } 

                                if ($product_cat_id == 101) /* Wines */ {
                                    if ($product_tab['title'] == "Description") {
                                        $product_tab['title'] = "About the wine";
                                    }
                                } 
                        break;
                        }
                        ?>


						<a href="#tab_<?php echo esc_attr($key) ?>" id="tab_<?php echo esc_attr($key) ?>" class="tab-title <?php if($i == 1 && !$close_tab) echo 'opened'; ?>"><span><?php echo wp_kses_post( apply_filters( 'woocommerce_product_' . $key . '_tab_title',  $product_tab['title'], $key ) ); ?></span></a>




					<?php endif; ?>
				</li>
            <?php endforeach; ?>
            
            <?php if ( $et_tabs['custom_tab1'] && $et_tabs['custom_tab1'] != '' ) : ?>
                <li>


  


                    <a href="#tab_7" id="tab_7" class="tab-title <?php if( empty( $product_tabs ) && ! empty( $et_tabs['custom_tab1'] ) ) echo 'opened'; ?>"><span><?php echo $tabtitle; ?></span></a>
                </li>
            <?php endif; ?>
        
            <?php if ( $et_tabs['custom_tab'] && $et_tabs['custom_tab'] != '' ) : ?>
                <li>
                    <a href="#tab_9" id="tab_9" class="tab-title <?php if( empty( $product_tabs ) && empty( $et_tabs['custom_tab1'] ) && ! empty( $et_tabs['custom_tab'] ) ) echo 'opened'; ?>"><span><?php $et_tabs['custom_tab']; ?></span></a>
                </li>                
            <?php endif; ?>
			
			<?php foreach ( $product_tabs as $key => $product_tab ) : $i++; ?>
                <li <?php if($i == 1 && $close_tab) echo 'class="tab_closed"'; ?>>
					<?php $get_tab_callback = wp_kses_post( apply_filters( 'woocommerce_product_' . $key . '_tab_title', $product_tab['callback'], $key ) ); ?>
					<?php if ( $get_tab_callback == 'woocommerce_product_additional_information_tab' ) : ?>


                        <?php  if ($product_tab['title'] == "További információk") { ?>

                            <?php foreach ($terms as $term) {
                            $product_cat_id = $term->term_id;

                                if ($product_cat_id == 16 /* Borok */) {
                                    $product_tab['title'] = "Analitika";
                                } 
                            break;
                            }
                            ?>

                        <?php } ?>

                        <?php  if ($product_tab['title'] == "Additional information") { ?>

                            <?php foreach ($terms as $term) {
                            $product_cat_id = $term->term_id;

                                if ($product_cat_id == 101 /* Wines */) {
                                    $product_tab['title'] = "Analitycs";
                                } 
                            break;
                            }
                            ?>

                            <?php } ?>


						<a href="#tab_<?php echo esc_attr($key) ?>" id="tab_<?php echo esc_attr($key) ?>" class="tab-title <?php if($i == 1 && !$close_tab) echo 'opened'; ?>"><span><?php echo wp_kses_post( apply_filters( 'woocommerce_product_' . $key . '_tab_title', $product_tab['title'], $key ) ); ?></span></a>




					<?php endif; ?>
				</li>
            <?php endforeach; ?>
        </ul>

        <?php $i = 0; foreach ( $product_tabs as $key => $product_tab ) : $i++; ?>
            <div class="accordion-title <?php if($i == 1 && $close_tab) echo 'tab_closed'; ?>"><a href="#tab_<?php echo esc_attr($key) ?>" id="tab_<?php echo esc_attr($key) ?>" class="tab-title <?php if($i == 1 && !$close_tab) echo 'opened'; ?>"><span><?php echo wp_kses_post( apply_filters( 'woocommerce_product_' . $key . '_tab_title', $product_tab['title'], $key ) ); ?></span></a></div>
            <div class="tab-content tab-<?php echo esc_attr($key) ?>" id="content_tab_<?php echo esc_attr($key) ?>" <?php if($i == 1 && !$close_tab) echo 'style="display:block;"'; ?>>
                <div class="tab-content-inner">
                    <div class="tab-content-scroll">
                        <?php call_user_func( $product_tab['callback'], esc_attr($key), $product_tab ) ?>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
        
        <?php if ( $et_tabs['custom_tab1'] && $et_tabs['custom_tab1'] != '' ) : ?>
            <div class="accordion-title"><a href="#tab_7" id="tab_7" class="tab-title <?php if( empty( $product_tabs ) && ! empty( $et_tabs['custom_tab1'] ) ) echo 'opened'; ?>"><span><?php echo esc_html($et_tabs['custom_tab1']); ?></span></a></div>
            <div id="content_tab_7" class="tab-content" <?php if( empty( $product_tabs ) && ! empty( $et_tabs['custom_tab1'] ) ) echo 'style="display:block;"'; ?>>
                <div class="tab-content-inner">
                    <div class="tab-content-scroll">
                        <?php echo do_shortcode(etheme_get_custom_field('custom_tab1')); ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>  
        
        <?php if ( $et_tabs['custom_tab'] && $et_tabs['custom_tab'] != '' ) : ?>
            <div class="accordion-title"><a href="#tab_9" id="tab_9" class="tab-title <?php if( empty( $product_tabs ) && empty( $et_tabs['custom_tab1'] ) && ! empty( $et_tabs['custom_tab'] ) ) echo 'opened'; ?>"><span><?php echo esc_html($et_tabs['custom_tab']); ?></span></a></div>
            <div id="content_tab_9" class="tab-content" <?php if( empty( $product_tabs ) && empty( $et_tabs['custom_tab1'] ) && ! empty( $et_tabs['custom_tab'] ) ) echo 'style="display:block;"'; ?>>
                <div class="tab-content-inner">
                    <div class="tab-content-scroll">
                        <?php echo do_shortcode(etheme_get_option('custom_tab')); ?>
                    </div>
                </div>
            </div>
        <?php endif; ?> 
        <?php do_action( 'woocommerce_product_after_tabs' ); ?>
    </div>
<?php if (etheme_get_option( 'single_layout' ) == 'center' && etheme_get_option('tabs_location') == 'after_content' ) : ?>
</div>
<div class="vc_row-full-width vc_clearfix"></div>
    <?php // ! WC Marketplace fix ?>
    <?php if ( class_exists( 'WCMp_Ajax' ) ): ?>
        <script>
        jQuery(document).ready(function($) {
            $('.goto_more_offer_tab').click(function (e) {   
                if (!$('#tab_singleproductmultivendor').hasClass('opened')) {
                    $('#tab_singleproductmultivendor').click();
                }     
            }); 
        });
        </script>
    <?php endif; ?>
<?php endif; ?>
<?php endif; ?>