<?php

/*
 *
 * Plugin Name: Back In Stock Notifier for WooCommerce | WooCommerce Waitlist Pro
 * Plugin URI: https://codewoogeek.online/shop/free-plugins/back-in-stock-notifier/
 * Description: Notify subscribed users when products back in stock
 * Version: 3.0
 * Author: codewoogeek
 * Author URI: https://codewoogeek.online
 * Text Domain: back-in-stock-notifier-for-woocommerce
 * Domain Path: /languages
 * WC requires at least: 2.2.0
 * WC tested up to: 6.5.1
 * @package     cwginstocknotifier
 * @author      codewoogeek
 * @copyright   2022 CodeWooGeek LLC
 * @license     GPL-3.0+
 * License URI: https://www.gnu.org/licenses/gpl-3.0.txt
 * @icons used from https://www.flaticon.com/authors/roundicons
 */

if (!defined('ABSPATH')) {
	exit; // avoid direct access to the file
}

if (isset($_GET['post_type']) && 'cwginstocknotifier' == $_GET['post_type']) {
	require('includes/library/WP_Persistent_Notices.php');
}
require_once 'includes/library/wp-async-request.php';
require_once 'includes/library/wp-background-process.php';

if (!class_exists('CWG_Instock_Notifier')) {

	class CWG_Instock_Notifier {

		/**
		 * Plugin Version
		 *
		 * @var string Version
		 */
		public $version = '3.0';

		/**
		 * Instance variable
		 *
		 * @var instance object
		 */
		protected static $_instance = null;

		/**
		 * Return Object
		 *
		 * @see CWG_Instock_Notifier()
		 */
		public static function instance() {
			if (is_null(self::$_instance)) {
				self::$_instance = new self();
			}
			return self::$_instance;
		}

		/**
		 * Return error when this function called as it is private method
		 */
		public function __wakeup() {
			return false;
		}

		/**
		 * Return error when this function called as it is a private method, so clonning will be forbidden
		 */
		private function __clone() {
			
		}

		/**
		 * Construct the class
		 */
		public function __construct() {
			include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
			$this->avoid_header_sent();
			$this->define_constant();
			$this->initialize();
			$this->include_files();
			add_action('wp_enqueue_scripts', array($this, 'enqueue_scripts'), 999);
			add_action('admin_enqueue_scripts', array($this, 'admin_enqueue_scripts'));
			add_filter('woocommerce_screen_ids', array($this, 'add_screen_ids_to_woocommerce'));
			add_filter('admin_head', array($this, 'remove_help_tab_context'));
			add_action('plugins_loaded', array($this, 'load_plugin_textdomain'));
		}

		/**
		 * Avoid Header already sent issue
		 */
		public function avoid_header_sent() {
			ob_start();
		}

		/**
		 * Include necessary files to load
		 */
		public function include_files() {
			include('includes/class-template.php');
			include('includes/admin/class-post-type.php');
			include('includes/frontend/class-product.php');
			include('includes/class-ajax.php');
			include('includes/class-core.php');
			include('includes/class-api.php');
			include('includes/admin/class-settings.php');
			include('includes/class-logger.php');
			include('includes/class-privacy.php');
			include('includes/admin/class-extra.php');
			include('includes/class-google-recaptcha.php');
			include('includes/class-troubleshoot.php');
			include('includes/class-privacy-checkbox.php');
			include('includes/class-upgrade.php');
			include('includes/class-popup.php');
			include('includes/class-webhook.php');
			include('includes/class-rest-api.php');
			include('includes/abstract-mailer.php');
			include('includes/class-subscription-mail.php');
			include('includes/class-instock-mail.php');
			include('includes/admin/class-status.php');
			include('includes/class-test-mail.php');
			include('includes/class-stock-third-party.php');
			include('includes/class-auto-delete.php');
		}

		public function initialize() {
			require_once('includes/class-background-mail-process.php');
		}

		public function define_constant() {
			$this->define('CWGINSTOCK_PLUGINURL', plugins_url('/', __FILE__));
			$this->define('CWGINSTOCK_DIRNAME', basename(dirname(__FILE__)));
			$this->define('CWGINSTOCK_FILE', __FILE__);
			$this->define('CWGSTOCKPLUGINBASENAME', plugin_basename(__FILE__));
			$this->define('CWGINSTOCK_PLUGINDIR', plugin_dir_path(__FILE__));
			$this->define('CWGINSTOCK_VERSION', $this->version);
		}

		private function define( $name, $value) {
			if (!defined($name)) {
				define($name, $value);
			}
		}

		public function check_script_is_already_loaded( $handle, $list = 'enqueued') {
			return wp_script_is($handle, $list);
		}

		public function enqueue_scripts() {
			$check_already_enqueued = $this->check_script_is_already_loaded('jquery-blockui');
			if (!$check_already_enqueued) {
				wp_register_script('jquery-blockui', CWGINSTOCK_PLUGINURL . 'assets/js/jquery.blockUI.js', array('jquery'), $this->version, true);
			}
			wp_register_script('cwginstock_js', CWGINSTOCK_PLUGINURL . 'assets/js/frontend-dev.min.js', array('jquery', 'jquery-blockui'), $this->version, true);
			wp_register_script('sweetalert2', CWGINSTOCK_PLUGINURL . 'assets/js/sweetalert2.min.js', array('jquery', 'jquery-blockui'), $this->version, true);
			wp_register_script('cwginstock_popup', CWGINSTOCK_PLUGINURL . 'assets/js/cwg-popup.min.js', array('jquery', 'jquery-blockui', 'sweetalert2'), $this->version, true);

			wp_register_style('cwginstock_frontend_css', CWGINSTOCK_PLUGINURL . 'assets/css/frontend.min.css', array(), $this->version, false);
			wp_register_style('cwginstock_bootstrap', CWGINSTOCK_PLUGINURL . 'assets/css/bootstrap.min.css', array(), $this->version, false);
			$get_option = get_option('cwginstocksettings');

			$check_visibility = isset($get_option['hide_form_guests']) && '' != $get_option['hide_form_guests'] && !is_user_logged_in() ? false : true;
			if ($check_visibility) {
				wp_enqueue_script('jquery');
				wp_enqueue_script('jquery-blockui');
				wp_enqueue_style('cwginstock_frontend_css');
				wp_enqueue_style('cwginstock_bootstrap');
				$phone_field_visibility = isset($get_option['show_phone_field']) && '' != $get_option['show_phone_field'] ? true : false;
				if ($phone_field_visibility) {
					wp_enqueue_style('cwginstock_phone_css', CWGINSTOCK_PLUGINURL . 'assets/css/intlTelInput.min.css', array(), $this->version, false);
					wp_enqueue_script('cwginstock_phone_js', CWGINSTOCK_PLUGINURL . 'assets/js/intlTelInput.min.js', array('jquery', 'jquery-blockui'), $this->version, true);
				}
				$phone_field_optional = isset($get_option['phone_field_optional']) && '' != $get_option['phone_field_optional'] ? true : false;
				$get_empty_name = isset($get_option['empty_name_message']) && '' != $get_option['empty_name_message'] ? $get_option['empty_name_message'] : __('Name cannot be empty', 'back-in-stock-notifier-for-woocommerce');
				$get_empty_msg = isset($get_option['empty_error_message']) && '' != $get_option['empty_error_message'] ? $get_option['empty_error_message'] : __('Email Address cannot be empty', 'back-in-stock-notifier-for-woocommerce');
				$invalid_msg = isset($get_option['invalid_email_error']) && '' != $get_option['invalid_email_error'] ? $get_option['invalid_email_error'] : __('Please Enter Valid Email Address', 'back-in-stock-notifier-for-woocommerce');
				$form_submission_mode = isset($get_option['ajax_submission_via']) && ( 'wordpress_rest_api_route' == $get_option['ajax_submission_via'] ) ? true : false;
				$is_popup = isset($get_option['mode']) && ( '2' == $get_option['mode'] ) ? 'yes' : 'no';
				$empty_phone_message = isset($get_option['empty_phone_message']) ? $get_option['empty_phone_message'] : esc_html__('Phone Number cannot be empty', 'back-in-stock-notifier-for-woocommerce');
				$invalid_phone_number = isset($get_option['invalid_phone_error']) ? $get_option['invalid_phone_error'] : esc_html__('Please enter valid Phone Number', 'back-in-stock-notifier-for-woocommerce');
				$phone_number_too_short = isset($get_option['phone_number_too_short']) ? $get_option['phone_number_too_short'] : esc_html__('Phone Number too short', 'back-in-stock-notifier-for-woocommerce');
				$phone_number_too_long = isset($get_option['phone_number_too_long']) ? $get_option['phone_number_too_long'] : esc_html__('Phone Number too long', 'back-in-stock-notifier-for-woocommerce');
				$default_country_code = isset($get_option['default_country']) ? $get_option['default_country'] : '';
				$custom_country_placeholder = isset($get_option['default_country_placeholder']) ? $get_option['default_country_placeholder'] : 'default';
				$custom_placehoder_value = isset($get_option['custom_placeholder']) ? $get_option['custom_placeholder'] : '';
				$translation_array = apply_filters('cwginstock_localization_array', array(
					'ajax_url' => $form_submission_mode ? rest_url() . 'back-in-stock/v1/subscriber/create/' : admin_url('admin-ajax.php'),
					'default_ajax_url' => admin_url('admin-ajax.php'),
					'security' => $form_submission_mode ? wp_create_nonce('wp_rest') : wp_create_nonce('cwg_subscribe_product'),
					'user_id' => get_current_user_id(),
					'security_error' => __('Something went wrong, please try after sometime', 'cwginstocknotifier'),
					'empty_name' => $get_empty_name,
					'empty_email' => $get_empty_msg,
					'invalid_email' => $invalid_msg,
					'is_popup' => $is_popup,
					'phone_field' => $phone_field_visibility ? '1' : '2',
					'phone_field_error' => array($invalid_phone_number, $invalid_phone_number, $phone_number_too_short, $phone_number_too_long, $invalid_phone_number),
					'phone_utils_js' => $phone_field_visibility ? CWGINSTOCK_PLUGINURL . 'assets/js/utils.js' : '',
					'is_phone_field_optional' => $phone_field_optional ? '1' : '2',
					'default_country_code' => $default_country_code,
					'custom_country_placeholder' => '' != $default_country_code && 'default' != $custom_country_placeholder && '' != $custom_placehoder_value ? $custom_placehoder_value : '',
				));
								wp_localize_script('cwginstock_js', 'cwginstock', $translation_array);
				wp_enqueue_script('cwginstock_js');
				wp_enqueue_script('sweetalert2');
				wp_enqueue_script('cwginstock_popup');
				$is_read_more_hide = isset($get_option['hide_readmore_button']) && '' != $get_option['hide_readmore_button'] ? true : false;
				if ($is_read_more_hide) {
					$read_more = '.products .outofstock .button {display: none; }';
					wp_add_inline_style('cwginstock_frontend_css', $read_more);
				}
				//google v3 recaptcha 
				$is_v3 = CWG_Instock_Google_Recaptcha::is_recaptcha_v3() ? 'yes' : 'no';
				$hide_recaptchav3_badge = 'yes' == $is_v3 && isset($get_option['recaptchav3_badge_hide']) && '' != $get_option['recaptchav3_badge_hide'] ? true : false;
				if ($hide_recaptchav3_badge) {
					$hide_badge_css = '.grecaptcha-badge { visibility: hidden !important; }';
					wp_add_inline_style('cwginstock_frontend_css', $hide_badge_css);
				}
			}
		}

		public function admin_enqueue_scripts() {
			$screen = get_current_screen();
			if (isset($screen->id) && ( ( 'cwginstocknotifier_page_cwg-instock-mailer' == $screen->id ) || ( 'edit-cwginstocknotifier' == $screen->id ) || ( 'cwginstocknotifier_page_cwg-instock-status' == $screen->id ) || ( 'cwginstocknotifier_page_cwg-instock-extensions' == $screen->id ) )) {
				wp_enqueue_style('cwginstock_admin_css', CWGINSTOCK_PLUGINURL . '/assets/css/admin.css', array(), $this->version);
				wp_register_script('cwginstock_admin_js', CWGINSTOCK_PLUGINURL . '/assets/js/admin.js', array('jquery', 'wc-enhanced-select'), $this->version);
				wp_localize_script('cwginstock_admin_js', 'cwg_enhanced_selected_params', array('search_tags_nonce' => wp_create_nonce('search-tags'), 'ajax_url' => admin_url('admin-ajax.php')));
				wp_enqueue_script('cwginstock_admin_js');
			}
		}

		public function load_plugin_textdomain() {
			$domain = 'back-in-stock-notifier-for-woocommerce';
			$dir = untrailingslashit(WP_LANG_DIR);
			$locale = apply_filters('plugin_locale', get_locale(), $domain);
			$exists = load_textdomain($domain, $dir . '/plugins/' . $domain . '-' . $locale . '.mo');
			if ($exists) {
				return $exists;
			} else {
				load_plugin_textdomain($domain, false, basename(dirname(__FILE__)) . '/languages/');
			}
		}

		public function add_screen_ids_to_woocommerce( $screen_ids) {
			$extend_screen_ids = apply_filters('cwginstock_screen_ids', array('edit-cwginstocknotifier', 'cwginstocknotifier_page_cwg-instock-mailer'));
			$screen_ids = array_merge($screen_ids, $extend_screen_ids);
			return $screen_ids;
		}

		// hide help context tab

		public function remove_help_tab_context() {
			$screen = get_current_screen();
			if ('edit-cwginstocknotifier' == $screen->id || 'cwginstocknotifier_page_cwg-instock-mailer' == $screen->id) {
				$screen->remove_help_tabs();
			}
		}

	}

	/**
	 * Return object
	 *
	 * @since 1.0
	 */
	function CWG_Instock_Notifier() {
		include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		if (cwg_is_woocommerce_activated()) {
			return CWG_Instock_Notifier::instance();
		}
	}

	if (!function_exists('cwg_is_woocommerce_activated')) {

		function cwg_is_woocommerce_activated() {
			include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
			if (is_plugin_active('woocommerce/woocommerce.php')) {
				return true;
			} elseif (is_plugin_active_for_network('woocommerce/woocommerce.php')) {
				return true;
			} else {
				return false;
			}
		}

	}

	CWG_Instock_Notifier();
}
