<?php
class installerPps {
	static public $update_to_version_method = '';
	static private $_firstTimeActivated = false;
	static public function init( $isUpdate = false ) {
		global $wpdb;
		$wpPrefix = $wpdb->prefix; /* add to 0.0.3 Versiom */
		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		$current_version = get_option($wpPrefix. PPS_DB_PREF. 'db_version', 0);
		if(!$current_version)
			self::$_firstTimeActivated = true;
		/**
		 * modules
		 */
		if (!dbPps::exist("@__modules")) {
			dbDelta(dbPps::prepareQuery("CREATE TABLE IF NOT EXISTS `@__modules` (
			  `id` smallint(3) NOT NULL AUTO_INCREMENT,
			  `code` varchar(32) NOT NULL,
			  `active` tinyint(1) NOT NULL DEFAULT '0',
			  `type_id` tinyint(1) NOT NULL DEFAULT '0',
			  `label` varchar(64) DEFAULT NULL,
			  `ex_plug_dir` varchar(255) DEFAULT NULL,
			  PRIMARY KEY (`id`),
			  UNIQUE INDEX `code` (`code`)
			) DEFAULT CHARSET=utf8;"));
			dbPps::query("INSERT INTO `@__modules` (id, code, active, type_id, label) VALUES
				(NULL, 'adminmenu',1,1,'Admin Menu'),
				(NULL, 'options',1,1,'Options'),
				(NULL, 'user',1,1,'Users'),
				(NULL, 'pages',1,1,'Pages'),
				(NULL, 'templates',1,1,'templates'),
				(NULL, 'supsystic_promo',1,1,'supsystic_promo'),
				(NULL, 'admin_nav',1,1,'admin_nav'),

				(NULL, 'popup',1,1,'popup'),
				(NULL, 'subscribe',1,1,'subscribe'),
				(NULL, 'sm',1,1,'sm'),
				(NULL, 'statistics',1,1,'statistics'),

				(NULL, 'mail',1,1,'mail');");
		}
		if(!dbPps::exist("@__modules", "code", "tgm_promo")) {
			dbPps::query("INSERT INTO `@__modules` (id, code, active, type_id, label) VALUES (NULL, 'tgm_promo',1,1,'tgm_promo')");
		}
		/**
		 *  modules_type
		 */
		if(!dbPps::exist("@__modules_type")) {
			dbDelta(dbPps::prepareQuery("CREATE TABLE IF NOT EXISTS `@__modules_type` (
			  `id` smallint(3) NOT NULL AUTO_INCREMENT,
			  `label` varchar(32) NOT NULL,
			  PRIMARY KEY (`id`)
			) AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;"));
			dbPps::query("INSERT INTO `@__modules_type` VALUES
				(1,'system'),
				(6,'addons');");
		}
		/**
		 * Popup table
		 */
		if (!dbPps::exist("@__popup")) {
			dbDelta(dbPps::prepareQuery("CREATE TABLE IF NOT EXISTS `@__popup` (
				`id` INT(11) NOT NULL AUTO_INCREMENT,
				`label` VARCHAR(255) NOT NULL,
				`active` TINYINT(1) NOT NULL,
				`original_id` INT(11) NOT NULL DEFAULT '0',
				`params` TEXT NOT NULL,
				`html` TEXT NOT NULL,
				`css` TEXT NOT NULL,
				`img_preview` VARCHAR(128) NULL DEFAULT NULL,
				`show_on` TINYINT(1) NOT NULL DEFAULT '0',
				`show_to` TINYINT(1) NOT NULL DEFAULT '0',
				`show_pages` TINYINT(1) NOT NULL DEFAULT '0',
				`type_id` TINYINT(1) NOT NULL DEFAULT '1',

				`views` INT(11) NOT NULL DEFAULT '0',
				`unique_views` INT(11) NOT NULL DEFAULT '0',
				`actions` INT(11) NOT NULL DEFAULT '0',

				`date_created` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
				PRIMARY KEY (`id`)
			) DEFAULT CHARSET=utf8;"));
		}
		if(!dbPps::exist("@__popup", "show_on")) {
			dbPps::query("ALTER TABLE `@__popup` ADD COLUMN `show_on` TINYINT(1) NOT NULL DEFAULT '0';");
		}
		if(!dbPps::exist("@__popup", "views")) {	// All those columns - were added in one update - so can place them in one condition - to not overload database
			dbPps::query("ALTER TABLE `@__popup`
				ADD COLUMN `views` INT(11) NOT NULL DEFAULT '0',
				ADD COLUMN `unique_views` INT(11) NOT NULL DEFAULT '0',
				ADD COLUMN `actions` INT(11) NOT NULL DEFAULT '0';");
		}
		if(!dbPps::exist("@__popup", "sort_order")) {	// So, let's add some sorting here?;)
			dbPps::query("ALTER TABLE `@__popup` ADD COLUMN `sort_order` MEDIUMINT(5) NOT NULL DEFAULT '0';");
		}
		if(!dbPps::exist("@__popup", "show_in_admin_area")) {	// So, let's add some sorting here?;)
			dbPps::query("ALTER TABLE `@__popup` ADD COLUMN `show_in_admin_area` TINYINT(1) NOT NULL DEFAULT '0';");
		}
		self::addAdditionalPopups();
		self::makeTextFieldsCssUpdate();
		self::makeTextFieldsCssUpdateRound2();
		/**
		 * Popup ShowOn pages
		 */
		if (!dbPps::exist("@__popup_show_pages")) {
			dbDelta(dbPps::prepareQuery("CREATE TABLE `@__popup_show_pages` (
				`popup_id` INT(10) NOT NULL,
				`post_id` INT(10) NOT NULL,
				`not_show` TINYINT(1) NOT NULL DEFAULT '0'
			) DEFAULT CHARSET=utf8;"));
		}
		/**
		 * Popup ShowOn categories (terms)
		 */
		if (!dbPps::exist("@__popup_show_categories")) {
			dbDelta(dbPps::prepareQuery("CREATE TABLE `@__popup_show_categories` (
				`popup_id` INT(10) NOT NULL,
				`term_id` INT(10) NOT NULL,
				`not_show` TINYINT(1) NOT NULL DEFAULT '0'
			) DEFAULT CHARSET=utf8;"));
		}
		/**
		* Plugin usage statistics
		*/
		if(!dbPps::exist("@__usage_stat")) {
			dbDelta(dbPps::prepareQuery("CREATE TABLE `@__usage_stat` (
			  `id` int(11) NOT NULL AUTO_INCREMENT,
			  `code` varchar(64) NOT NULL,
			  `visits` int(11) NOT NULL DEFAULT '0',
			  `spent_time` int(11) NOT NULL DEFAULT '0',
			  `modify_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
			  UNIQUE INDEX `code` (`code`),
			  PRIMARY KEY (`id`)
			) DEFAULT CHARSET=utf8"));
			dbPps::query("INSERT INTO `@__usage_stat` (code, visits) VALUES ('installed', 1)");
		}
		/**
		 * Statistics
		 */
		if (!dbPps::exist("@__statistics")) {
			  dbDelta(dbPps::prepareQuery("CREATE TABLE `@__statistics` (
				`id` int(11) NOT NULL AUTO_INCREMENT,
				`popup_id` int(11) NOT NULL DEFAULT '0',
				`type` TINYINT(2) NOT NULL DEFAULT '0',
				`sm_id` TINYINT(2) NOT NULL DEFAULT '0',
				`is_unique` TINYINT(1) NOT NULL DEFAULT '0',
				`date_created` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
				PRIMARY KEY (`id`)
			  ) DEFAULT CHARSET=utf8;"));
		}
		if(!dbPps::exist("@__statistics", "sm_id")) {	// Social Media ID
			dbPps::query("ALTER TABLE `@__statistics` ADD COLUMN `sm_id` TINYINT(2) NOT NULL DEFAULT '0';");
		}
		if(!dbPps::exist("@__statistics", "is_unique")) {	// Unique
			dbPps::query("ALTER TABLE `@__statistics` ADD COLUMN `is_unique` TINYINT(1) NOT NULL DEFAULT '0';");
		}
		/**
		 * Subscribers
		 */
		if (!dbPps::exist("@__subscribers")) {
			  dbDelta(dbPps::prepareQuery("CREATE TABLE `@__subscribers` (
				`id` int(11) NOT NULL AUTO_INCREMENT,
				`username` VARCHAR(128) NULL DEFAULT NULL,
				`email` VARCHAR(128) NOT NULL,
				`hash` VARCHAR(128) NOT NULL,
				`activated` TINYINT(1) NOT NULL DEFAULT '0',
				`popup_id` int(11) NOT NULL DEFAULT '0',
				`date_created` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
				`all_data` TEXT NOT NULL,
				PRIMARY KEY (`id`)
			  ) DEFAULT CHARSET=utf8;"));
		}
		if(!dbPps::exist("@__subscribers", "popup_id")) {	// Popup ID for subscribers
			dbPps::query("ALTER TABLE `@__subscribers` ADD COLUMN `popup_id` int(11) NOT NULL DEFAULT '0';");
		}
		if(!dbPps::exist("@__subscribers", "all_data")) {	// All submit data for subscribers
			dbPps::query("ALTER TABLE `@__subscribers` ADD COLUMN `all_data` TEXT NOT NULL;");
		}
		/**
		 * Countries
		 */
		if (!dbPps::exist("@__countries")) {
			  dbDelta(dbPps::prepareQuery("CREATE TABLE `@__countries` (
				`id` int(11) NOT NULL AUTO_INCREMENT,
				`name` varchar(128) NOT NULL,
				`iso_code_2` varchar(2) DEFAULT NULL,
				`iso_code_3` varchar(3) DEFAULT NULL,
				PRIMARY KEY (`id`)
			  ) DEFAULT CHARSET=utf8;"));
			  self::_insertCountries();
		}
		installerDbUpdaterPps::runUpdate();
		if($current_version && !self::$_firstTimeActivated) {
			self::setUsed();
			self::_setOldUser();
			// For users that just updated our plugin - don't need tp show step-by-step tutorial
			update_user_meta(get_current_user_id(), PPS_CODE . '-tour-hst', array('closed' => 1));
		}
		update_option($wpPrefix. PPS_DB_PREF. 'db_version', PPS_VERSION);
		add_option($wpPrefix. PPS_DB_PREF. 'db_installed', 1);
	}

	static private function _setOldUser() {
		update_option(PPS_DB_PREF. 'is_old_user', 1);
	}

	static public function isNewUser() {
		$isOld = (int)get_option(PPS_DB_PREF. 'is_old_user');
		return !$isOld;
	}

	static public function setUsed() {
		update_option(PPS_DB_PREF. 'plug_was_used', 1);
	}
	static public function isUsed() {
		//return true;	// No welcome page for now
		//return 0;
		return (int) get_option(PPS_DB_PREF. 'plug_was_used');
	}
	static public function delete() {
		self::_checkSendStat('delete');
		global $wpdb;
		$wpPrefix = $wpdb->prefix;
		$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.PPS_DB_PREF."modules`");
		$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.PPS_DB_PREF."modules_type`");
		$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.PPS_DB_PREF."usage_stat`");
		//$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.PPS_DB_PREF."popup`");
		$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.PPS_DB_PREF."popup_show_pages`");
		$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.PPS_DB_PREF."statistics`");
		$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.PPS_DB_PREF."statistics_sm`");
		$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.PPS_DB_PREF."subscribers`");
		delete_option($wpPrefix. PPS_DB_PREF. 'db_version');
		delete_option($wpPrefix. PPS_DB_PREF. 'db_installed');
	}
	static public function deactivate() {
		self::_checkSendStat('deactivate');
	}
	static private function _checkSendStat($statCode) {
		if(class_exists('framePps')
			&& framePps::_()->getModule('supsystic_promo')
			&& framePps::_()->getModule('options')
		) {
			framePps::_()->getModule('supsystic_promo')->getModel()->saveUsageStat( $statCode );
			framePps::_()->getModule('supsystic_promo')->getModel()->checkAndSend( true );
		}
	}
	static public function update() {
		global $wpdb;
		$wpPrefix = $wpdb->prefix; /* add to 0.0.3 Versiom */
		$currentVersion = get_option($wpPrefix. PPS_DB_PREF. 'db_version', 0);
		if(!$currentVersion || version_compare(PPS_VERSION, $currentVersion, '>')) {
			self::init( true );
			update_option($wpPrefix. PPS_DB_PREF. 'db_version', PPS_VERSION);
		}
	}
	static private function _insertCountries() {
		dbPps::query('INSERT INTO @__countries VALUES
			(1, "Afghanistan", "AF", "AFG"),
			(2, "Albania", "AL", "ALB"),
			(3, "Algeria", "DZ", "DZA"),
			(4, "American Samoa", "AS", "ASM"),
			(5, "Andorra", "AD", "AND"),
			(6, "Angola", "AO", "AGO"),
			(7, "Anguilla", "AI", "AIA"),
			(8, "Antarctica", "AQ", "ATA"),
			(9, "Antigua and Barbuda", "AG", "ATG"),
			(10, "Argentina", "AR", "ARG"),
			(11, "Armenia", "AM", "ARM"),
			(12, "Aruba", "AW", "ABW"),
			(13, "Australia", "AU", "AUS"),
			(14, "Austria", "AT", "AUT"),
			(15, "Azerbaijan", "AZ", "AZE"),
			(16, "Bahamas", "BS", "BHS"),
			(17, "Bahrain", "BH", "BHR"),
			(18, "Bangladesh", "BD", "BGD"),
			(19, "Barbados", "BB", "BRB"),
			(20, "Belarus", "BY", "BLR"),
			(21, "Belgium", "BE", "BEL"),
			(22, "Belize", "BZ", "BLZ"),
			(23, "Benin", "BJ", "BEN"),
			(24, "Bermuda", "BM", "BMU"),
			(25, "Bhutan", "BT", "BTN"),
			(26, "Bolivia", "BO", "BOL"),
			(27, "Bosnia and Herzegowina", "BA", "BIH"),
			(28, "Botswana", "BW", "BWA"),
			(29, "Bouvet Island", "BV", "BVT"),
			(30, "Brazil", "BR", "BRA"),
			(31, "British Indian Ocean Territory", "IO", "IOT"),
			(32, "Brunei Darussalam", "BN", "BRN"),
			(33, "Bulgaria", "BG", "BGR"),
			(34, "Burkina Faso", "BF", "BFA"),
			(35, "Burundi", "BI", "BDI"),
			(36, "Cambodia", "KH", "KHM"),
			(37, "Cameroon", "CM", "CMR"),
			(38, "Canada", "CA", "CAN"),
			(39, "Cape Verde", "CV", "CPV"),
			(40, "Cayman Islands", "KY", "CYM"),
			(41, "Central African Republic", "CF", "CAF"),
			(42, "Chad", "TD", "TCD"),
			(43, "Chile", "CL", "CHL"),
			(44, "China", "CN", "CHN"),
			(45, "Christmas Island", "CX", "CXR"),
			(46, "Cocos (Keeling) Islands", "CC", "CCK"),
			(47, "Colombia", "CO", "COL"),
			(48, "Comoros", "KM", "COM"),
			(49, "Congo", "CG", "COG"),
			(50, "Cook Islands", "CK", "COK"),
			(51, "Costa Rica", "CR", "CRI"),
			(52, "Cote D\'Ivoire", "CI", "CIV"),
			(53, "Croatia", "HR", "HRV"),
			(54, "Cuba", "CU", "CUB"),
			(55, "Cyprus", "CY", "CYP"),
			(56, "Czech Republic", "CZ", "CZE"),
			(57, "Denmark", "DK", "DNK"),
			(58, "Djibouti", "DJ", "DJI"),
			(59, "Dominica", "DM", "DMA"),
			(60, "Dominican Republic", "DO", "DOM"),
			(61, "East Timor", "TP", "TMP"),
			(62, "Ecuador", "EC", "ECU"),
			(63, "Egypt", "EG", "EGY"),
			(64, "El Salvador", "SV", "SLV"),
			(65, "Equatorial Guinea", "GQ", "GNQ"),
			(66, "Eritrea", "ER", "ERI"),
			(67, "Estonia", "EE", "EST"),
			(68, "Ethiopia", "ET", "ETH"),
			(69, "Falkland Islands (Malvinas)", "FK", "FLK"),
			(70, "Faroe Islands", "FO", "FRO"),
			(71, "Fiji", "FJ", "FJI"),
			(72, "Finland", "FI", "FIN"),
			(73, "France", "FR", "FRA"),
			(74, "France, Metropolitan", "FX", "FXX"),
			(75, "French Guiana", "GF", "GUF"),
			(76, "French Polynesia", "PF", "PYF"),
			(77, "French Southern Territories", "TF", "ATF"),
			(78, "Gabon", "GA", "GAB"),
			(79, "Gambia", "GM", "GMB"),
			(80, "Georgia", "GE", "GEO"),
			(81, "Germany", "DE", "DEU"),
			(82, "Ghana", "GH", "GHA"),
			(83, "Gibraltar", "GI", "GIB"),
			(84, "Greece", "GR", "GRC"),
			(85, "Greenland", "GL", "GRL"),
			(86, "Grenada", "GD", "GRD"),
			(87, "Guadeloupe", "GP", "GLP"),
			(88, "Guam", "GU", "GUM"),
			(89, "Guatemala", "GT", "GTM"),
			(90, "Guinea", "GN", "GIN"),
			(91, "Guinea-bissau", "GW", "GNB"),
			(92, "Guyana", "GY", "GUY"),
			(93, "Haiti", "HT", "HTI"),
			(94, "Heard and Mc Donald Islands", "HM", "HMD"),
			(95, "Honduras", "HN", "HND"),
			(96, "Hong Kong", "HK", "HKG"),
			(97, "Hungary", "HU", "HUN"),
			(98, "Iceland", "IS", "ISL"),
			(99, "India", "IN", "IND"),
			(100, "Indonesia", "ID", "IDN"),
			(101, "Iran (Islamic Republic of)", "IR", "IRN"),
			(102, "Iraq", "IQ", "IRQ"),
			(103, "Ireland", "IE", "IRL"),
			(104, "Israel", "IL", "ISR"),
			(105, "Italy", "IT", "ITA"),
			(106, "Jamaica", "JM", "JAM"),
			(107, "Japan", "JP", "JPN"),
			(108, "Jordan", "JO", "JOR"),
			(109, "Kazakhstan", "KZ", "KAZ"),
			(110, "Kenya", "KE", "KEN"),
			(111, "Kiribati", "KI", "KIR"),
			(112, "Korea, Democratic People\'s Republic of", "KP", "PRK"),
			(113, "Korea, Republic of", "KR", "KOR"),
			(114, "Kuwait", "KW", "KWT"),
			(115, "Kyrgyzstan", "KG", "KGZ"),
			(116, "Lao People\'s Democratic Republic", "LA", "LAO"),
			(117, "Latvia", "LV", "LVA"),
			(118, "Lebanon", "LB", "LBN"),
			(119, "Lesotho", "LS", "LSO"),
			(120, "Liberia", "LR", "LBR"),
			(121, "Libyan Arab Jamahiriya", "LY", "LBY"),
			(122, "Liechtenstein", "LI", "LIE"),
			(123, "Lithuania", "LT", "LTU"),
			(124, "Luxembourg", "LU", "LUX"),
			(125, "Macau", "MO", "MAC"),
			(126, "Macedonia, The Former Yugoslav Republic of", "MK", "MKD"),
			(127, "Madagascar", "MG", "MDG"),
			(128, "Malawi", "MW", "MWI"),
			(129, "Malaysia", "MY", "MYS"),
			(130, "Maldives", "MV", "MDV"),
			(131, "Mali", "ML", "MLI"),
			(132, "Malta", "MT", "MLT"),
			(133, "Marshall Islands", "MH", "MHL"),
			(134, "Martinique", "MQ", "MTQ"),
			(135, "Mauritania", "MR", "MRT"),
			(136, "Mauritius", "MU", "MUS"),
			(137, "Mayotte", "YT", "MYT"),
			(138, "Mexico", "MX", "MEX"),
			(139, "Micronesia, Federated States of", "FM", "FSM"),
			(140, "Moldova, Republic of", "MD", "MDA"),
			(141, "Monaco", "MC", "MCO"),
			(142, "Mongolia", "MN", "MNG"),
			(143, "Montenegro", "ME", "MNE"),
			(144, "Montserrat", "MS", "MSR"),
			(145, "Morocco", "MA", "MAR"),
			(146, "Mozambique", "MZ", "MOZ"),
			(147, "Myanmar", "MM", "MMR"),
			(148, "Namibia", "NA", "NAM"),
			(149, "Nauru", "NR", "NRU"),
			(150, "Nepal", "NP", "NPL"),
			(151, "Netherlands", "NL", "NLD"),
			(152, "Netherlands Antilles", "AN", "ANT"),
			(153, "New Caledonia", "NC", "NCL"),
			(154, "New Zealand", "NZ", "NZL"),
			(155, "Nicaragua", "NI", "NIC"),
			(156, "Niger", "NE", "NER"),
			(157, "Nigeria", "NG", "NGA"),
			(158, "Niue", "NU", "NIU"),
			(159, "Norfolk Island", "NF", "NFK"),
			(160, "Northern Mariana Islands", "MP", "MNP"),
			(161, "Norway", "NO", "NOR"),
			(162, "Oman", "OM", "OMN"),
			(163, "Pakistan", "PK", "PAK"),
			(164, "Palau", "PW", "PLW"),
			(165, "Panama", "PA", "PAN"),
			(166, "Papua New Guinea", "PG", "PNG"),
			(167, "Paraguay", "PY", "PRY"),
			(168, "Peru", "PE", "PER"),
			(169, "Philippines", "PH", "PHL"),
			(170, "Pitcairn", "PN", "PCN"),
			(171, "Poland", "PL", "POL"),
			(172, "Portugal", "PT", "PRT"),
			(173, "Puerto Rico", "PR", "PRI"),
			(174, "Qatar", "QA", "QAT"),
			(175, "Reunion", "RE", "REU"),
			(176, "Romania", "RO", "ROM"),
			(177, "Russian Federation", "RU", "RUS"),
			(178, "Rwanda", "RW", "RWA"),
			(179, "Saint Kitts and Nevis", "KN", "KNA"),
			(180, "Saint Lucia", "LC", "LCA"),
			(181, "Saint Vincent and the Grenadines", "VC", "VCT"),
			(182, "Samoa", "WS", "WSM"),
			(183, "San Marino", "SM", "SMR"),
			(184, "Sao Tome and Principe", "ST", "STP"),
			(185, "Saudi Arabia", "SA", "SAU"),
			(186, "Senegal", "SN", "SEN"),
			(187, "Serbia", "RS", "SRB"),
			(188, "Seychelles", "SC", "SYC"),
			(189, "Sierra Leone", "SL", "SLE"),
			(190, "Singapore", "SG", "SGP"),
			(191, "Slovakia (Slovak Republic)", "SK", "SVK"),
			(192, "Slovenia", "SI", "SVN"),
			(193, "Solomon Islands", "SB", "SLB"),
			(194, "Somalia", "SO", "SOM"),
			(195, "South Africa", "ZA", "ZAF"),
			(196, "South Georgia and the South Sandwich Islands", "GS", "SGS"),
			(197, "Spain", "ES", "ESP"),
			(198, "Sri Lanka", "LK", "LKA"),
			(199, "St. Helena", "SH", "SHN"),
			(200, "St. Pierre and Miquelon", "PM", "SPM"),
			(201, "Sudan", "SD", "SDN"),
			(202, "Suriname", "SR", "SUR"),
			(203, "Svalbard and Jan Mayen Islands", "SJ", "SJM"),
			(204, "Swaziland", "SZ", "SWZ"),
			(205, "Sweden", "SE", "SWE"),
			(206, "Switzerland", "CH", "CHE"),
			(207, "Syrian Arab Republic", "SY", "SYR"),
			(208, "Taiwan", "TW", "TWN"),
			(209, "Tajikistan", "TJ", "TJK"),
			(210, "Tanzania, United Republic of", "TZ", "TZA"),
			(211, "Thailand", "TH", "THA"),
			(212, "Togo", "TG", "TGO"),
			(213, "Tokelau", "TK", "TKL"),
			(214, "Tonga", "TO", "TON"),
			(215, "Trinidad and Tobago", "TT", "TTO"),
			(216, "Tunisia", "TN", "TUN"),
			(217, "Turkey", "TR", "TUR"),
			(218, "Turkmenistan", "TM", "TKM"),
			(219, "Turks and Caicos Islands", "TC", "TCA"),
			(220, "Tuvalu", "TV", "TUV"),
			(221, "Uganda", "UG", "UGA"),
			(222, "Ukraine", "UA", "UKR"),
			(223, "United Arab Emirates", "AE", "ARE"),
			(224, "United Kingdom", "GB", "GBR"),
			(225, "United States", "US", "USA"),
			(226, "United States Minor Outlying Islands", "UM", "UMI"),
			(227, "Uruguay", "UY", "URY"),
			(228, "Uzbekistan", "UZ", "UZB"),
			(229, "Vanuatu", "VU", "VUT"),
			(230, "Vatican City State (Holy See)", "VA", "VAT"),
			(231, "Venezuela", "VE", "VEN"),
			(232, "Viet Nam", "VN", "VNM"),
			(233, "Virgin Islands (British)", "VG", "VGB"),
			(234, "Virgin Islands (U.S.)", "VI", "VIR"),
			(235, "Wallis and Futuna Islands", "WF", "WLF"),
			(236, "Western Sahara", "EH", "ESH"),
			(237, "Yemen", "YE", "YEM"),
			(238, "Zaire", "ZR", "ZAR"),
			(239, "Zambia", "ZM", "ZMB"),
			(240, "Zimbabwe", "ZW", "ZWE")');
	}
	static public function addAdditionalPopups() {
		// Remember last increment value
		$lastAutoIncrement = dbPps::getAutoIncrement('@__popup');
		$lastAutoIncrement = $lastAutoIncrement && $lastAutoIncrement > 30 ? $lastAutoIncrement : 100;
		$popupLastId = 39;
		//dbPps::query('DELETE FROM @__popup WHERE id IN ('. implode(',', range(0, $popupLastId)). ')');	// We updated all popups as we did changes in all of them
		if(!dbPps::exist('@__popup', 'id', '7')) {	// First set of additional templates
			dbPps::query('INSERT INTO @__popup (id,label,active,original_id,params,html,css,img_preview,show_on,show_to,show_pages,type_id,date_created,sort_order) VALUES
("1","List Building","1","0","a:3:{s:4:\"main\";a:15:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:10:\"show_pages\";s:3:\"all\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";}s:3:\"tpl\";a:58:{s:5:\"width\";s:3:\"824\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#ebebeb\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#066dab\";s:9:\"bg_type_2\";s:5:\"color\";s:8:\"bg_img_2\";s:0:\"\";s:10:\"bg_color_2\";s:7:\"#00eaea\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#000000\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#000000\";s:10:\"font_txt_1\";s:7:\"default\";s:17:\"text_font_color_1\";s:7:\"#000000\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#000000\";s:9:\"close_btn\";s:11:\"lists_black\";s:7:\"bullets\";s:11:\"lists_green\";s:11:\"layered_pos\";s:0:\"\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:140:\"The Best WordPress <i style=\\"color: #0069a7;\\">PopUp optin plugin</i> to help you gain more subscribers, social followers or advertisement.\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"enb_txt_1\";s:1:\"1\";s:13:\"enb_foot_note\";s:1:\"1\";s:9:\"foot_note\";s:118:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time \";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:8:\"Sign-up!\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us subscriber information:<br />[subscriber_data]\";s:5:\"txt_0\";s:160:\"<p><a href=\\"http://supsystic.com\\" target=\\"_blank\\"><img style=\\"max-width: 200px;\\" src=\\"[PPS_ASSETS_URL]img/assets/supsystic_icon.png\\" alt=\\"\\" /></a></p>\";s:5:\"txt_1\";s:313:\"<p>Popup by Supsystic lets you easily create elegant overlapping windows with unlimited features. Pop-ups with Slider, Lightbox, Contact and Subscription forms and more:</p><ul><li>Unlimited Content Customization</li><li>Auto Open Popups</li><li>Contact Form with pop-up</li><li>Popup Opening Animations</li></ul>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"3\";s:16:\"txt_block_number\";s:1:\"2\";}}","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			[if enb_txt_1]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_1 ppsPopupTxt_1\">\r\n				[txt_1]\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n		</div>\r\n		<div class=\"ppsRightCol\">\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			[if enb_sm]\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 66%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n  	vertical-align: top;\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n	font-family: \"Myriad Pro\",\"Trebuchet MS\",\"Helvetica Neue\",Helvetica,Arial,Sans-Serif;\r\n	font-size: 30px;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	letter-spacing: -1px;\r\n	font-weight: bold;\r\n	margin-top: 15px;\r\n	margin-bottom: 16px;\r\n	padding-left: 20px;\r\n	text-shadow: 0px 0px 1px #000;\r\n	-moz-text-shadow: 0px 0px 1px #000;\r\n	-webkit-text-shadow: 0px 0px 1px #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	display: table-cell;\r\n  	width: 34%;\r\n  	height: 100%;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}), color-stop(100%, [bg_color_1])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ie10+ */\r\n  background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}\', endColorstr=\'[bg_color_1]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 30px 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: 1px solid #d1b36d;\r\n  	border-radius: 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 10px;\r\n  	font-size: 17px;\r\n  	background-color: #fff;\r\n  	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n  	\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	margin-left: -5px;\r\n  	font-size: 17px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/mail-icon.png\");\r\n  	background-repeat: no-repeat;\r\n  	background-position: 90% center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n  	[if bg_type_2 == \'color\']\r\n  	background: [bg_color_2];\r\n    background: -moz-linear-gradient(90deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -webkit-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -o-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -ms-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: linear-gradient(0deg, [bg_color_2]) 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	color: #fff;\r\n    font-size: 20px;\r\n    text-shadow: 2px 2px 2px #000;\r\n  	cursor: pointer;\r\n  	padding: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 50%;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_1 {\r\n	float: right;\r\n    [if enb_txt_0]\r\n    width: 50%;\r\n    [else]\r\n    width: 100%;\r\n    [endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}","","1","1","1","1","2015-01-10 18:59:43","7"),
("2","Classy","1","0","a:3:{s:4:\"main\";a:17:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:8:\"close_on\";s:10:\"user_close\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";}s:3:\"tpl\";a:59:{s:5:\"width\";s:3:\"630\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#d1d1d1\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#7fb6cb\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#555555\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#555555\";s:10:\"font_txt_1\";s:7:\"default\";s:17:\"text_font_color_1\";s:7:\"#555555\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#999999\";s:9:\"close_btn\";s:11:\"classy_grey\";s:7:\"bullets\";s:11:\"classy_blue\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:8:\"Sign-Up!\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:18:\"PopUp by Supsystic\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"enb_txt_1\";s:1:\"1\";s:9:\"foot_note\";s:0:\"\";s:5:\"txt_0\";s:208:\"<p>Popup by Supsystic lets you easily create elegant overlapping windows with unlimited features:</p><ul><li>Unlimited Content Customization</li><li>Auto Open Popups</li><li>Contact Form with pop-up</li></ul>\";s:5:\"txt_1\";s:123:\"<p><img style=\\"max-width: 180px; max-height: auto;\\" src=\\"[PPS_ASSETS_URL]img/assets/supsystic_icon.png\\" alt=\\"\\" /></p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"2\";s:16:\"txt_block_number\";s:1:\"2\";}}","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupClassyShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose\"></a>\r\n	<div class=\"ppsPopupClassyInner\">\r\n		[if enb_label]\r\n			<div class=\"ppsPopupLabel ppsPopupClassyLabel\">[label]</div>\r\n		[endif]\r\n		[if enb_txt_0]\r\n		<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupTxt_0\">\r\n			[txt_0]\r\n		</div>\r\n		[endif]\r\n		[if enb_txt_1]\r\n		<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupTxt_1\">\r\n			[txt_1]\r\n		</div>\r\n		[endif]\r\n      	[if enb_sm]\r\n        <div class=\"ppsSm\">\r\n            [sm_html]\r\n        </div>\r\n        [endif]\r\n		<div style=\"clear: both;\"></div>\r\n	</div>\r\n	[if enb_subscribe]\r\n	<div class=\"ppsSubscribeShell\">\r\n		[sub_form_start]\r\n          	[sub_fields_html]\r\n			<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n		[sub_form_end]\r\n	</div>\r\n  	[endif]\r\n  	[if enb_foot_note]\r\n  	<div class=\"ppsFootNote\">[foot_note]</div>\r\n  	[endif]\r\n</div>","#ppsPopupShell_[ID] {\r\n  	width: [width][width_measure];\r\n	[if bg_type_0 == \'color\']\r\n	background-color: {{ popup.params.tpl.bg_color_0 }};\r\n	[elseif bg_type_0 == \'img\']\r\n	background-image: url(\"[bg_img_0]\");\r\n	background-size: 100%;\r\n  	background-repeat: no-repeat;\r\n	[endif]\r\n	padding: 7px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClassyInner {\r\n	padding: 15px;\r\n	border: {{ adjust_brightness(popup.params.tpl.bg_color_0, 30) }};\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_0 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }} 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ popup.params.tpl.bg_color_0 }}), color-stop(100%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }})); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_0 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }} 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_0 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }} 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_0 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }} 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ popup.params.tpl.bg_color_0 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }} 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ popup.params.tpl.bg_color_0 }}\', endColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }}\',GradientType=1 ); /* ie6-9 */\r\n	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	height: 48px;\r\n	font-size: 27px;\r\n	border: none;\r\n	padding: 1px 8px 0;\r\n	width: calc((100% - 70px) / 3);\r\n  	box-sizing: content-box;\r\n  	margin-top: 10px;\r\n  	float: left;\r\n  	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	[if bg_type_0 == \'color\']\r\n	-webkit-box-shadow: inset 4px 4px 4px 0px {{ adjust_brightness(popup.params.tpl.bg_color_0, -40) }};\r\n	-moz-box-shadow: inset 4px 4px 4px 0px {{ adjust_brightness(popup.params.tpl.bg_color_0, -40) }};\r\n	box-shadow: inset 4px 4px 4px 0px {{ adjust_brightness(popup.params.tpl.bg_color_0, -40) }};\r\n	background-color: {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }};\r\n	color: {{ adjust_brightness(popup.params.tpl.bg_color_0, -100) }};\r\n	[endif]\r\n	margin-right: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n  	display: table-cell;\r\n  	height: 48px;\r\n  	vertical-align: middle;\r\n  	background-color: transparent;\r\n  	border: none;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select option {\r\n	font-size: 27px;\r\n  	color: #6d6d6d;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: calc(100% - 30px);\r\n  	height: auto;\r\n  	font-family: inherit;\r\n  	padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	color: #eee;\r\n	margin-right: 0;\r\n	cursor: pointer;\r\n	[if bg_type_1 == \'color\']\r\n	text-shadow: -1px -1px 1px {{ adjust_brightness(popup.params.tpl.bg_color_1, -80) }};\r\n	border: 1px solid {{ adjust_brightness(popup.params.tpl.bg_color_1, -40) }};\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_1 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }} 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ popup.params.tpl.bg_color_1 }}), color-stop(100%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }})); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_1 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }} 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_1 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }} 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_1 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }} 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ popup.params.tpl.bg_color_1 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }} 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ popup.params.tpl.bg_color_1 }}\', endColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }}\',GradientType=1 ); /* ie6-9 */\r\n\r\n	-webkit-box-shadow: inset 0px 0px 2px 2px {{ adjust_brightness(popup.params.tpl.bg_color_1, 10) }};\r\n	-moz-box-shadow: inset 0px 0px 2px 2px {{ adjust_brightness(popup.params.tpl.bg_color_1, 10) }};\r\n	box-shadow: inset 0px 0px 2px 2px {{ adjust_brightness(popup.params.tpl.bg_color_1, 10) }};\r\n	[elseif bg_type_1 == \'img\']\r\n	background-image: url(\"[bg_img_1]\");\r\n	background-size: 100%;\r\n  	background-repeat: no-repeat;\r\n	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:disabled {\r\n	color: transparent;\r\n  	cursor: progress;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	margin: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClassyLabel {\r\n	width: 100%;\r\n	text-align: center;\r\n	color: #555555;\r\n	text-shadow: 1px 1px 1px #ffffff;\r\n	font-size: 35px;\r\n	margin-top: 26px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSuccessMsg {\r\n	color: #555555;\r\n  	border: 1px solid #555555;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt {\r\n	font-size: 20px;\r\n	line-height: 160%;\r\n	color: rgb(85, 85, 85);\r\n	padding-top: 14px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	[if enb_txt_1]\r\n	width: 70%;\r\n  	float: left;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_1 {\r\n	float: right;\r\n	width: 30%;\r\n}\r\n#ppsPopupShell_[ID] ul {\r\n	margin-top: 15px;\r\n	padding-left: 0;\r\n}\r\n#ppsPopupShell_[ID] ul li {\r\n	list-style: inside none disc;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n	color: #999;\r\n    font-size: 12px;\r\n    padding-top: 10px;\r\n    text-align: center;\r\n}\r\n/*SM*/\r\n#ppsPopupShell_[ID] .ppsSm {\r\n	padding: 10px 10px 0 10px;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_1_435376 .ppsSm > div {\r\n	vertical-align: top !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm .ppsSmBtn {\r\n	margin-right: 5px;\r\n}","","1","1","1","1","2015-01-03 17:00:43","19"),
("3","Fastest and the Easiest","1","0","a:3:{s:4:\"main\";a:17:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:8:\"close_on\";s:10:\"user_close\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";}s:3:\"tpl\";a:63:{s:5:\"width\";s:3:\"770\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#e5e5e5\";s:9:\"bg_type_1\";s:3:\"img\";s:8:\"bg_img_1\";s:39:\"[PPS_ASSETS_URL]img/assets/button-1.png\";s:10:\"bg_color_1\";s:0:\"\";s:9:\"bg_type_2\";s:3:\"img\";s:8:\"bg_img_2\";s:42:\"[PPS_ASSETS_URL]img/assets/big-arrow-1.png\";s:10:\"bg_color_2\";s:0:\"\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#414141\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#000000\";s:10:\"font_txt_1\";s:7:\"default\";s:17:\"text_font_color_1\";s:7:\"#000000\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#979696\";s:9:\"close_btn\";s:11:\"lists_black\";s:7:\"bullets\";s:11:\"lists_green\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:5:\"Join!\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:55:\"Increase subscribers, social followers or advertisement\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"enb_txt_1\";s:1:\"1\";s:13:\"enb_foot_note\";s:1:\"1\";s:9:\"foot_note\";s:117:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time\";s:5:\"txt_0\";s:44:\"<p>The Best WordPress PopUp optin plugin</p>\";s:5:\"txt_1\";s:313:\"<p>Popup by Supsystic lets you easily create elegant overlapping windows with unlimited features. Pop-ups with Slider, Lightbox, Contact and Subscription forms and more:</p><ul><li>Unlimited Content Customization</li><li>Auto Open Popups</li><li>Contact Form with pop-up</li><li>Popup Opening Animations</li></ul>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"3\";s:16:\"txt_block_number\";s:1:\"2\";}}","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose\"></a>\r\n  	<div class=\"ppsPopupListsInner\">\r\n  		[if enb_txt_0]\r\n  		<div class=\"ppsPopupTxt ppsPopupTxt_0\">\r\n          <div class=\"ppsTxtContent\">[txt_0]</div>\r\n      	</div>\r\n  		[endif]\r\n      	<div class=\"ppsPopupTblCols\">\r\n          <div class=\"ppsPopupLeftCol\">\r\n            [if enb_label]\r\n            <div class=\"ppsPopupLabel\">[label]</div>\r\n            [endif]\r\n            [if enb_txt_1]\r\n            <div class=\"ppsPopupTxt ppsPopupTxt_1\">[txt_1]</div>\r\n            [endif]\r\n          </div>\r\n          <div class=\"ppsPopupRightCol\">\r\n            [if enb_subscribe]\r\n            <div class=\"ppsSubscribeShell\">\r\n              <div class=\"ppsBigArrow\"></div>\r\n              [sub_form_start]\r\n              [sub_fields_html]\r\n              <input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n              [sub_form_end]\r\n            </div>\r\n            [endif]\r\n            [if enb_sm]\r\n            <div class=\"ppsSm\">\r\n              [sm_html]\r\n            </div>\r\n            [endif]\r\n            [if enb_foot_note]\r\n            <div class=\"ppsFootNote\">\r\n              [foot_note]\r\n            </div>\r\n            [endif]\r\n          </div>\r\n      	</div>\r\n  	</div>\r\n  	\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: Helvetica,Arial,sans-serif;\r\n  	font-size: 14px;\r\n  \r\n  	[if bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #414141;\r\n    font-size: 28px;\r\n    font-style: normal;\r\n    font-weight: bold;\r\n    letter-spacing: -1px;\r\n    line-height: 35px;\r\n    text-shadow: 0 1px 1px #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupListsInner {\r\n  	[if bg_type_0 == \'color\']\r\n    background: {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}; /* Old browsers */\r\n    background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* FF3.6+ */\r\n    background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%,[bg_color_0])); /* Chrome,Safari4+ */\r\n    background: -webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* Chrome10+,Safari5.1+ */\r\n    background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* Opera 12+ */\r\n    background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* IE10+ */\r\n    background: radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* W3C */\r\n    filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'#eaeaea\',GradientType=1 ); /* IE6-9 fallback on horizontal gradient */\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	width: 100%;\r\n  	border-bottom: 1px solid {{ adjust_brightness(popup.params.tpl.bg_color_0, -50) }};\r\n  	clear: both;\r\n  	font-size: 13px;\r\n    font-weight: bold;\r\n  	font-family: Helvetica,Arial,sans-serif;\r\n  	[if bg_type_0 == \'color\']\r\n  	background: [bg_color_0]; /* Old browsers */\r\n    background: -moz-linear-gradient(top, [bg_color_0] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 20) }} 100%); /* FF3.6+ */\r\n    background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,[bg_color_0]), color-stop(100%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 20) }})); /* Chrome,Safari4+ */\r\n    background: -webkit-linear-gradient(top, [bg_color_0] 0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 20) }} 100%); /* Chrome10+,Safari5.1+ */\r\n    background: -o-linear-gradient(top, [bg_color_0] 0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 20) }} 100%); /* Opera 11.10+ */\r\n    background: -ms-linear-gradient(top, [bg_color_0] 0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 20) }} 100%); /* IE10+ */\r\n    background: linear-gradient(to bottom, [bg_color_0] 0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 20) }} 100%); /* W3C */\r\n    filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'[bg_color_0]\', endColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 20) }}\',GradientType=0 ); /* IE6-9 */\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 .ppsTxtContent {\r\n	padding: 10px 10px 10px 50px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTblCols {\r\n	display: table;\r\n  	padding: 10px 10px 10px 50px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLeftCol {\r\n	display: table-cell;\r\n  	vertical-align: top;\r\n  	[if enb_subscribe]\r\n  	width: 64%;\r\n  	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupRightCol {\r\n  	width: 36%;\r\n	display: table-cell;\r\n  	position: relative;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 30px 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: 1px solid #000;\r\n  	border-radius: 10px;\r\n  	display: block;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 10px;\r\n  	font-size: 17px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n  	vertical-align: middle;\r\n  	height: 40px;\r\n  	background-color: transparent;\r\n  	border: none;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	margin-left: -10px;\r\n  	font-size: 17px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	height: auto;\r\n  	font-family: inherit;\r\n  	padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/mail-icon.png\");\r\n  	background-repeat: no-repeat;\r\n  	background-position: 90% center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border: none;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: [bg_color_1];\r\n    background: -moz-linear-gradient(90deg, [bg_color_1] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 100) }} 63%);\r\n    background: -webkit-linear-gradient(270deg, [bg_color_1] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 100) }} 63%);\r\n    background: -o-linear-gradient(270deg, [bg_color_1] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 100) }} 63%);\r\n    background: -ms-linear-gradient(270deg, [bg_color_1] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 100) }} 63%);\r\n    background: linear-gradient(0deg, [bg_color_1]) 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 100) }} 63%);\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	color: #000;\r\n    font-size: 20px;\r\n    text-shadow: 2px 2px 2px #000;\r\n  	cursor: pointer;\r\n  	max-width: 230px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n    color: #979696;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: xx-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n    text-align: left;\r\n  	margin-left: 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsBigArrow {\r\n	[if bg_type_2 == \'img\']\r\n  	position: absolute;\r\n  	width: 102px;\r\n    height: 81px;\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	top: -20px;\r\n  	right: 20px;\r\n  	z-index: 100;\r\n  	[else]\r\n  	display: none;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSuccessMsg {\r\n	padding: 55px 5px 5px;\r\n}","","1","1","1","1","2015-01-13 19:22:48","13"),
("4","Facebook Like","1","0","a:3:{s:4:\"main\";a:30:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:26:\"close_on_after_action_time\";s:1:\"1\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";s:24:\"hide_for_user_roles_show\";s:1:\"0\";}s:3:\"tpl\";a:20:{s:5:\"width\";s:3:\"300\";s:13:\"width_measure\";s:2:\"px\";s:6:\"height\";s:0:\"\";s:14:\"height_measure\";s:2:\"px\";s:12:\"fb_like_opts\";a:3:{s:4:\"href\";s:57:\"https://www.facebook.com/pages/Supsystic/1389390198028999\";s:4:\"tabs\";a:1:{i:0;s:8:\"timeline\";}s:13:\"show_facepile\";s:1:\"1\";}s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:4:\"#000\";s:14:\"bg_overlay_img\";s:0:\"\";s:18:\"bg_overlay_img_pos\";s:7:\"stretch\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#ffffff\";s:15:\"responsive_mode\";s:3:\"def\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:11:\"classy_grey\";s:11:\"layered_pos\";s:3:\"top\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:1:\"1\";s:12:\"stat_ga_code\";s:0:\"\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"1\";s:16:\"txt_block_number\";s:1:\"0\";}}","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupFbLikeShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose\"></a>\r\n  	[fb_like_widget_html]\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	/*height: [height][height_measure];*/\r\n  	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-repeat: no_repeat;\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	z-index: 99;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n","","1","1","1","2","2015-01-16 19:35:51","3"),
("5","Video List","1","0","a:3:{s:4:\"main\";a:27:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";s:24:\"hide_for_user_roles_show\";s:1:\"0\";}s:3:\"tpl\";a:63:{s:9:\"video_url\";s:43:\"https://www.youtube.com/watch?v=nKIu9yen5nc\";s:5:\"width\";s:3:\"824\";s:13:\"width_measure\";s:2:\"px\";s:6:\"height\";s:3:\"400\";s:14:\"height_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:4:\"#000\";s:14:\"bg_overlay_img\";s:0:\"\";s:18:\"bg_overlay_img_pos\";s:7:\"stretch\";s:9:\"bg_type_0\";s:4:\"none\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#ffffff\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#3bd0d0\";s:9:\"bg_type_2\";s:5:\"color\";s:8:\"bg_img_2\";s:0:\"\";s:10:\"bg_color_2\";s:7:\"#0e6868\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#015050\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#015050\";s:15:\"responsive_mode\";s:3:\"def\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:11:\"classy_grey\";s:11:\"layered_pos\";s:0:\"\";s:5:\"label\";s:26:\"Check video and subscribe!\";s:13:\"enb_foot_note\";s:1:\"1\";s:9:\"foot_note\";s:118:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time \";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:8:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";s:10:\"set_preset\";s:0:\"\";}s:5:\"email\";a:8:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:10:\"set_preset\";s:0:\"\";s:3:\"enb\";s:1:\"1\";}}s:9:\"blacklist\";s:0:\"\";s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:7:\"SIGN-UP\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_subject\";s:28:\"New subscriber on [sitename]\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here is subscriber information:<br />[subscriber_data]\";s:12:\"contact_form\";s:2:\"19\";s:12:\"stat_ga_code\";s:0:\"\";}s:10:\"opts_attrs\";a:3:{s:9:\"bg_number\";s:1:\"3\";s:16:\"txt_block_number\";s:1:\"0\";s:21:\"video_height_as_popup\";s:1:\"1\";}}","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div class=\"ppsPopupVideo \">\r\n				[video_html]\r\n			</div>\r\n			<div style=\"clear: both;\"></div>\r\n		</div>\r\n		<div class=\"ppsRightCol\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				<div style=\"clear: both;\"></div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			[if enb_sm]\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 0;\r\n  	font-family: arial;\r\n	font-size: 13px;\r\n	line-height: normal;\r\n	font-weight: normal;\r\n	color: #015050;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] iframe {\r\n	width: 100% !important;\r\n	margin: 0;\r\n    padding: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n	display: table-cell;\r\n	vertical-align: middle;\r\n	\r\n	{% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 66%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n\r\n	[if bg_type_0 == \"color\"]\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\", endColorstr=\"[bg_color_0]\",GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n	background-position: center top;\r\n	[else]\r\n	background: none;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	display: table-cell;\r\n  	width: 34%;\r\n  	height: 100%;\r\n  	vertical-align: middle;\r\n	padding: 15px 0;\r\n	margin: 0;\r\n	\r\n  	[if bg_type_1 == \"color\"]\r\n  	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}), color-stop(100%, [bg_color_1])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}\", endColorstr=\"[bg_color_1]\",GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_1 == \"img\"]\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n	background-position: center top;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 15px 30px 0;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-moz-placeholder { /* Firefox 19+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input:-ms-input-placeholder { /* IE 10+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input:-moz-placeholder { /* Firefox 18- */\r\n    color: #ccc;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea::-moz-placeholder { /* Firefox 19+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea:-ms-input-placeholder { /* IE 10+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea:-moz-placeholder { /* Firefox 18- */\r\n    color: #ccc;\r\n}\r\n/*For all Elements*/\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"password\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: arial;\r\n	font-size: 16px;\r\n	font-weight: normal;\r\n	line-height: normal;\r\n	color: #aaa;\r\n	text-align:center;\r\n	width: 100%;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	border: 0px solid transparent;\r\n	display:block;\r\n    \r\n    margin: 10px 0 0;\r\n	padding: 0 10px 0 10px;\r\n	height: 40px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	height: auto;\r\n	padding-top: 9px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeForm input:first-child {\r\n	margin-top: 0px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select  {\r\n	margin: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  {\r\n	display: block;\r\n	font-family: arial;\r\n	font-size: 16px;\r\n	font-weight: normal;\r\n	line-height: normal;\r\n	color: #015050;\r\n	\r\n	margin: 10px 0 0;\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  span {\r\n	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"][name=\"name\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/user-black-icon.png\");\r\n	background-position: 12px center;\r\n	background-repeat: no-repeat;\r\n	background-size: 16px auto;\r\n	padding: 0 25px 0 35px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/email-black-icon.png\");\r\n	background-position: 11px center;\r\n	background-repeat: no-repeat;\r\n	background-size: 18px auto;\r\n	padding: 0 25px 0 35px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"submit\"] {\r\n	display: block;\r\n	font-family: arial;\r\n	font-size: 17px;\r\n	font-weight: bold;\r\n	line-height: normal;\r\n	color: #fff;\r\n  	cursor: pointer;\r\n	margin: 10px 0 0;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	border: 0px solid transparent;\r\n	width: 100%;\r\n	height: 50px;\r\n	\r\n  	[if bg_type_2 == \"color\"]\r\n  	background: [bg_color_2] 100%;\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #015050;\r\n	font-family: arial;\r\n	font-size: 30px;\r\n	line-height: 40px;\r\n	font-weight: bold;\r\n	margin: 0 15px 15px;\r\n	padding: 0;\r\n	text-align: center;\r\n\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupVideo {\r\n  	width: 100%;\r\n  	line-height: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSuccessMsg {\r\n	color: #015050 !important;\r\n	font-weight: bold;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg {\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n	color: #015050;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: normal;\r\n	font-weight: bold;\r\n    line-height: 14px;\r\n  	margin: 15px 30px 5px;\r\n	padding: 0;\r\n	text-align: center;\r\n}","2016-230-5-video-list-prev.png","1","1","1","3","2015-01-10 18:59:43","1"),
("6","Video Classy","1","0","a:3:{s:4:\"main\";a:24:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";}s:3:\"tpl\";a:71:{s:9:\"video_url\";s:43:\"https://www.youtube.com/watch?v=nKIu9yen5nc\";s:5:\"width\";s:3:\"630\";s:13:\"width_measure\";s:2:\"px\";s:6:\"height\";s:3:\"480\";s:14:\"height_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#ece0d1\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#7fb6cb\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#555555\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#999999\";s:9:\"close_btn\";s:11:\"classy_grey\";s:11:\"layered_pos\";s:3:\"top\";s:5:\"label\";s:18:\"Look our new video\";s:9:\"foot_note\";s:0:\"\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:8:\"Sign-Up!\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us subscriber information:<br />[subscriber_data]\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:5:\"Login\";s:16:\"reg_redirect_url\";s:0:\"\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:27:\"Thank you for registration!\";s:21:\"reg_txt_invalid_email\";s:22:\"Empty or invalid email\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"reg_txt_confirm_mail_message\";s:196:\"You registered on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your registration. If you did not register here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:14:\"admin@mail.com\";s:15:\"reg_new_message\";s:121:\"You have new member on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us member information:<br />[subscriber_data]\";}s:10:\"opts_attrs\";a:4:{s:9:\"bg_number\";s:1:\"2\";s:16:\"txt_block_number\";s:1:\"0\";s:20:\"video_width_as_popup\";s:1:\"1\";s:21:\"video_height_as_popup\";s:1:\"1\";}}","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupClassyShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose\"></a>\r\n	<div class=\"ppsPopupClassyInner\">\r\n		[if enb_label]\r\n			<div class=\"ppsPopupLabel ppsPopupClassyLabel\">[label]</div>\r\n		[endif]\r\n		<div class=\"ppsPopupVideo\">\r\n			[video_html]\r\n		</div>\r\n      	[if enb_sm]\r\n        <div class=\"ppsSm\">\r\n            [sm_html]\r\n        </div>\r\n        [endif]\r\n		<div style=\"clear: both;\"></div>\r\n	</div>\r\n	[if enb_subscribe]\r\n	<div class=\"ppsSubscribeShell\">\r\n		[sub_form_start]\r\n          	[sub_fields_html]\r\n			<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n		[sub_form_end]\r\n	</div>\r\n  	[endif]\r\n  	[if enb_foot_note]\r\n  	<div class=\"ppsFootNote\">[foot_note]</div>\r\n  	[endif]\r\n</div>","#ppsPopupShell_[ID] {\r\n  	width: [width][width_measure];\r\n	[if bg_type_0 == \'color\']\r\n	background-color: {{ popup.params.tpl.bg_color_0 }};\r\n	[elseif bg_type_0 == \'img\']\r\n	background-image: url(\"[bg_img_0]\");\r\n	background-size: 100%;\r\n  	background-repeat: no-repeat;\r\n	[endif]\r\n	padding: 7px;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClassyInner {\r\n	padding: 0;\r\n	border: {{ adjust_brightness(popup.params.tpl.bg_color_0, 30) }};\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_0 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }} 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ popup.params.tpl.bg_color_0 }}), color-stop(100%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }})); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_0 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }} 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_0 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }} 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_0 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }} 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ popup.params.tpl.bg_color_0 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }} 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ popup.params.tpl.bg_color_0 }}\', endColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }}\',GradientType=1 ); /* ie6-9 */\r\n	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	height: 48px;\r\n	font-size: 27px;\r\n	border: none;\r\n	padding: 1px 8px 0;\r\n	width: calc((100% - 70px) / 3);\r\n  	box-sizing: content-box;\r\n  	margin-top: 10px;\r\n  	float: left;\r\n  	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	[if bg_type_0 == \'color\']\r\n	-webkit-box-shadow: inset 4px 4px 4px 0px {{ adjust_brightness(popup.params.tpl.bg_color_0, -40) }};\r\n	-moz-box-shadow: inset 4px 4px 4px 0px {{ adjust_brightness(popup.params.tpl.bg_color_0, -40) }};\r\n	box-shadow: inset 4px 4px 4px 0px {{ adjust_brightness(popup.params.tpl.bg_color_0, -40) }};\r\n	background-color: {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }};\r\n	color: {{ adjust_brightness(popup.params.tpl.bg_color_0, -100) }};\r\n	[endif]\r\n	margin-right: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n  	display: table-cell;\r\n  	height: 48px;\r\n  	vertical-align: middle;\r\n  	background-color: transparent;\r\n  	border: none;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select option {\r\n	font-size: 27px;\r\n  	color: #6d6d6d;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: calc(100% - 30px);\r\n  	height: auto;\r\n  	font-family: inherit;\r\n  	padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	color: #eee;\r\n	margin-right: 0;\r\n	cursor: pointer;\r\n	[if bg_type_1 == \'color\']\r\n	text-shadow: -1px -1px 1px {{ adjust_brightness(popup.params.tpl.bg_color_1, -80) }};\r\n	border: 1px solid {{ adjust_brightness(popup.params.tpl.bg_color_1, -40) }};\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_1 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }} 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ popup.params.tpl.bg_color_1 }}), color-stop(100%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }})); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_1 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }} 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_1 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }} 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_1 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }} 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ popup.params.tpl.bg_color_1 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }} 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ popup.params.tpl.bg_color_1 }}\', endColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }}\',GradientType=1 ); /* ie6-9 */\r\n\r\n	-webkit-box-shadow: inset 0px 0px 2px 2px {{ adjust_brightness(popup.params.tpl.bg_color_1, 10) }};\r\n	-moz-box-shadow: inset 0px 0px 2px 2px {{ adjust_brightness(popup.params.tpl.bg_color_1, 10) }};\r\n	box-shadow: inset 0px 0px 2px 2px {{ adjust_brightness(popup.params.tpl.bg_color_1, 10) }};\r\n	[elseif bg_type_1 == \'img\']\r\n	background-image: url(\"[bg_img_1]\");\r\n	background-size: 100%;\r\n  	background-repeat: no-repeat;\r\n	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:disabled {\r\n	color: transparent;\r\n  	cursor: progress;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell {\r\n	padding-top: 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	margin: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClassyLabel {\r\n	width: 100%;\r\n	text-align: center;\r\n	color: #555555;\r\n	text-shadow: 1px 1px 1px #ffffff;\r\n	font-size: 35px;\r\n	margin-top: 26px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSuccessMsg {\r\n	color: #555555;\r\n  	border: 1px solid #555555;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClassyTxt {\r\n	font-size: 20px;\r\n	line-height: 160%;\r\n	color: rgb(85, 85, 85);\r\n	padding-top: 14px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupVideo {\r\n	width: 100%;\r\n  	line-height: 0;\r\n  	padding: 0;\r\n  	margin: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupVideo iframe {\r\n  	margin: 0;\r\n}\r\n#ppsPopupShell_[ID] ul {\r\n	margin-top: 15px;\r\n	padding-left: 0;\r\n}\r\n#ppsPopupShell_[ID] ul li {\r\n	list-style: inside none disc;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n	color: #999;\r\n    font-size: 12px;\r\n    padding-top: 10px;\r\n    text-align: center;\r\n}\r\n/*SM*/\r\n#ppsPopupShell_[ID] .ppsSm {\r\n	padding: 10px 10px 0 10px;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_1_435376 .ppsSm > div {\r\n	vertical-align: top !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm .ppsSmBtn {\r\n	margin-right: 5px;\r\n}","","1","1","1","3","2015-01-03 17:00:43","16"),
("7","Layered Popup","1","0","a:3:{s:4:\"main\";a:21:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";}s:3:\"tpl\";a:80:{s:5:\"width\";s:3:\"400\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#f0622e\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#dad2bf\";s:9:\"bg_type_2\";s:5:\"color\";s:8:\"bg_img_2\";s:0:\"\";s:10:\"bg_color_2\";s:7:\"#555555\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#ffffff\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#ffffff\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#585858\";s:15:\"responsive_mode\";s:3:\"def\";s:9:\"close_btn\";s:11:\"while_close\";s:7:\"bullets\";s:11:\"lists_green\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:18:\"The Best WordPress\";s:9:\"enb_txt_0\";s:1:\"1\";s:13:\"enb_foot_note\";s:1:\"1\";s:9:\"foot_note\";s:118:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time \";s:6:\"enb_sm\";s:1:\"1\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:4:\"boxy\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:3:\"500\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:8:\"Sign-up!\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us subscriber information:<br />[subscriber_data]\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:5:\"Login\";s:16:\"reg_redirect_url\";s:0:\"\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:27:\"Thank you for registration!\";s:21:\"reg_txt_invalid_email\";s:22:\"Empty or invalid email\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"reg_txt_confirm_mail_message\";s:196:\"You registered on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your registration. If you did not register here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:14:\"admin@mail.com\";s:15:\"reg_new_message\";s:121:\"You have new member on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us member information:<br />[subscriber_data]\";s:5:\"txt_0\";s:172:\"<p>Popup by Supsystic lets you easily create elegant overlapping windows with unlimited features. Pop-ups with Slider, Lightbox, Contact and Subscription forms and more</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"3\";s:16:\"txt_block_number\";s:1:\"1\";}}","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_sm]\r\n					<div style=\"clear: both;\"></div>\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #fff;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 100%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #FFF;\r\n	font-family: \"Myriad Pro\",\"Trebuchet MS\",\"Helvetica Neue\",Helvetica,Arial,Sans-Serif;\r\n	font-size: 30px;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	letter-spacing: -1px;\r\n	font-weight: bold;\r\n	text-align: center;\r\n	margin-bottom: 16px;\r\n	padding-left: 20px;\r\n	-moz-text-shadow: 0px 0px 1px #000;\r\n	-webkit-text-shadow: 0px 0px 1px #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n  	height: 100%;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}), color-stop(100%, [bg_color_1])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ie10+ */\r\n  background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}\', endColorstr=\'[bg_color_1]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 10% 15% 0;\r\n	text-align:center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: 1px solid #d1b36d;\r\n  	color: #888;\r\n	text-shadow: 1px 1px 5px #888;\r\n  	padding: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	font-size: 17px;\r\n	width:100%;\r\n  	background-color: #fff;\r\n  	padding-left: 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	color: #888;\r\n	text-shadow: 1px 1px 5px #888;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/mail-icon.png\");\r\n  	background-repeat: no-repeat;\r\n  	background-position: 90% center;\r\n	width:100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n	width: 60%;\r\n  	[if bg_type_2 == \'color\']\r\n  	background: [bg_color_2];\r\n   box-shadow: -4px -4px 0px rgba(0, 0, 0, 0.1) inset;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	color: #fff;\r\n    font-size: 20px;\r\n    text-shadow: 1px 1px 1px #000;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n   box-shadow: 4px 4px 0px rgba(0, 0, 0, 0.1) inset;\r\n	\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 80%;\r\n	margin-left: 10%;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_1 {\r\n	float: right;\r\n    [if enb_txt_0]\r\n    width: 50%;\r\n    [else]\r\n    width: 100%;\r\n    [endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	top:15px;\r\n  	right:10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\nmargin-top:20px;\r\n}","layered-popup.jpg","1","1","1","1","2015-01-10 18:59:43","1"),
("9","SIGN UP","1","0","a:3:{s:4:\"main\";a:29:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:26:\"close_on_after_action_time\";s:1:\"1\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";}s:3:\"tpl\";a:88:{s:5:\"width\";s:3:\"400\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#8c7764\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#75362c\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#ffffff\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#f9e6ce\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#585858\";s:15:\"responsive_mode\";s:3:\"def\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:11:\"while_close\";s:7:\"bullets\";s:11:\"lists_green\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:30:\"SIGN UP<br> to our Newsletter!\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"foot_note\";s:118:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time \";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:4:\"boxy\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:16:\"sub_gr_cycle_day\";s:1:\"0\";s:13:\"sub_ic_app_id\";s:0:\"\";s:15:\"sub_ic_app_user\";s:0:\"\";s:15:\"sub_ic_app_pass\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:13:\"sub_sf_app_id\";s:0:\"\";s:14:\"sub_ck_api_key\";s:0:\"\";s:14:\"sub_mem_acc_id\";s:0:\"\";s:15:\"sub_mem_pud_key\";s:0:\"\";s:16:\"sub_mem_priv_key\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:7:\"SIGN UP\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us subscriber information:<br />[subscriber_data]\";s:8:\"login_by\";s:8:\"username\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:5:\"Login\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:27:\"Thank you for registration!\";s:21:\"reg_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"reg_redirect_url\";s:0:\"\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"reg_txt_confirm_mail_message\";s:196:\"You registered on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your registration. If you did not register here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:14:\"admin@mail.com\";s:15:\"reg_new_message\";s:121:\"You have new member on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us member information:<br />[subscriber_data]\";s:5:\"txt_0\";s:172:\"<p>Popup by Supsystic lets you easily create elegant overlapping windows with unlimited features. Pop-ups with Slider, Lightbox, Contact and Subscription forms and more</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"2\";s:16:\"txt_block_number\";s:1:\"1\";}}","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Amatic+SC\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_sm]\r\n					<div style=\"clear: both;\"></div>\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: \'arial\', arial;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #f9e6ce;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n  	width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 100%;\r\n  	box-shadow: rgba(192,192,192,1) 0 4px 20px, 6px -6px 0px rgba(0, 0, 0, 0.1) inset;\r\n  	border-radius: 4px;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #FFF;\r\n	font-family: \'Amatic SC\', arial;\r\n	font-size: 45px;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	letter-spacing: -1px;\r\n	font-weight: bold;\r\n	margin-top: 15px;\r\n	margin-bottom: 16px;\r\n	padding-left: 20px;\r\n	-moz-text-shadow: 0px 0px 1px #000;\r\n	-webkit-text-shadow: 0px 0px 1px #000;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 10% 10% 5% 5%;\r\n	text-align:right;\r\n	margin-bottom: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	/*width: 100%;*/\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: 0px solid #d1b36d;\r\n	border-radius: 4px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 20px;\r\n  	font-size: 17px;\r\n	width:100%;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n  	color: #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	margin-left: -4px;\r\n  	font-size: 17px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/email-icon.png\");\r\n  	background-repeat: no-repeat;\r\n	width:100%;\r\n	background-attachment: scroll;\r\n	background-position: 0px center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n	width: 60%;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: [bg_color_1] 100%;\r\n   	box-shadow: -4px -4px 0px rgba(0, 0, 0, 0.1) inset;\r\n  	background-image: none;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	color: #fff;\r\n    font-size: 20px;\r\n    text-shadow: 1px 1px 1px #000;\r\n  	cursor: pointer;\r\n  	padding: 0 6px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n   box-shadow: 4px 4px 0px rgba(0, 0, 0, 0.1) inset;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 80%;\r\n	margin-left: 10%;\r\n	text-align: justify;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n  	top:15px;\r\n  	right:10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}\r\n#ppsPopupShell_[ID] input[name=\"name\"] {\r\n    background-image: url(\"[PPS_ASSETS_URL]img/assets/user-icon.png\");\r\n    background-repeat: no-repeat;\r\n    background-attachment: scroll;\r\n    background-position: 0px center;\r\n}","sing-up.jpg","1","1","1","1","2015-01-10 18:59:43","3"),
("10","Informed","1","0","a:3:{s:4:\"main\";a:31:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:14:\"visit_page_cnt\";s:0:\"\";s:8:\"close_on\";s:10:\"user_close\";s:26:\"close_on_after_action_time\";s:1:\"1\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";s:24:\"hide_for_user_roles_show\";s:1:\"0\";}s:3:\"tpl\";a:116:{s:5:\"width\";s:3:\"400\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:4:\"#000\";s:14:\"bg_overlay_img\";s:0:\"\";s:18:\"bg_overlay_img_pos\";s:7:\"stretch\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#cccccc\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#ff0000\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#000000\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#000000\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#585858\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:9:\"sqr_close\";s:7:\"bullets\";s:11:\"lists_green\";s:19:\"layer_rel_selectors\";s:0:\"\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:12:\"Be informed!\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"foot_note\";s:118:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time \";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:4:\"boxy\";s:8:\"anim_key\";s:4:\"none\";s:14:\"anim_close_key\";s:0:\"\";s:13:\"anim_duration\";s:0:\"\";s:19:\"anim_close_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:23:\"sub_confirm_reload_time\";s:2:\"10\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:16:\"sub_gr_cycle_day\";s:1:\"0\";s:13:\"sub_ic_app_id\";s:0:\"\";s:15:\"sub_ic_app_user\";s:0:\"\";s:15:\"sub_ic_app_pass\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:13:\"sub_sf_app_id\";s:0:\"\";s:14:\"sub_ck_api_key\";s:0:\"\";s:14:\"sub_mem_acc_id\";s:0:\"\";s:15:\"sub_mem_pud_key\";s:0:\"\";s:16:\"sub_mem_priv_key\";s:0:\"\";s:14:\"sub_sb_api_key\";s:0:\"\";s:14:\"sub_v6_api_key\";s:0:\"\";s:12:\"sub_vtig_url\";s:0:\"\";s:13:\"sub_vtig_name\";s:0:\"\";s:12:\"sub_vtig_key\";s:0:\"\";s:16:\"sub_ymlp_api_key\";s:0:\"\";s:13:\"sub_ymlp_name\";s:0:\"\";s:11:\"sub_4d_name\";s:0:\"\";s:11:\"sub_4d_pass\";s:0:\"\";s:16:\"sub_dms_api_user\";s:0:\"\";s:20:\"sub_dms_api_password\";s:0:\"\";s:13:\"sub_dms_optin\";s:7:\"Unknown\";s:15:\"sub_mm_username\";s:0:\"\";s:14:\"sub_mm_api_key\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:5:\"email\";a:8:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:10:\"set_preset\";s:0:\"\";s:3:\"enb\";s:1:\"1\";}s:4:\"name\";a:7:{s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";s:10:\"set_preset\";s:0:\"\";}}s:13:\"capt_site_key\";s:0:\"\";s:15:\"capt_secret_key\";s:0:\"\";s:9:\"blacklist\";s:0:\"\";s:15:\"blacklist_error\";s:26:\"Your email is in blacklist\";s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:15:\"admin@gmail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:15:\"admin@gmail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:9:\"Subscribe\";s:13:\"sub_new_email\";s:15:\"admin@gmail.com\";s:15:\"sub_new_subject\";s:35:\"New Subscriber on Supsystic WP Test\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here is subscriber information:<br />[subscriber_data]\";s:8:\"login_by\";s:8:\"username\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:5:\"Login\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:27:\"Thank you for registration!\";s:21:\"reg_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"reg_redirect_url\";s:0:\"\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:15:\"admin@gmail.com\";s:28:\"reg_txt_confirm_mail_message\";s:196:\"You registered on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your registration. If you did not register here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:15:\"admin@gmail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:15:\"admin@gmail.com\";s:15:\"reg_new_message\";s:121:\"You have new member on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us member information:<br />[subscriber_data]\";s:12:\"contact_form\";s:2:\"11\";s:12:\"stat_ga_code\";s:0:\"\";s:5:\"txt_0\";s:172:\"<p>Popup by Supsystic lets you easily create elegant overlapping windows with unlimited features. Pop-ups with Slider, Lightbox, Contact and Subscription forms and more</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"2\";s:16:\"txt_block_number\";s:1:\"1\";}}","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Amatic+SC\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input class=\"butt\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_sm]\r\n					<div style=\"clear: both;\"></div>\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: \'arial\', arial;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 100%;\r\n  	border-radius: 4px;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	padding: 10px;\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n	text-align: center;\r\n	font-size: 45px;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	letter-spacing: -1px;\r\n	font-weight: bold;\r\n	margin-top: 15px;\r\n	margin-bottom: 16px;\r\n	padding-left: 20px;\r\n	-moz-text-shadow: 0px 0px 1px #000;\r\n	-webkit-text-shadow: 0px 0px 1px #000;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 1% 1% 1% 1%;\r\n	text-align:right;\r\n	margin-bottom: 20px;\r\n  	padding-left: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	/*width: 100%;*/\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: 0px solid #d1b36d;\r\n	border-radius: 4px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 20px;\r\n  	font-size: 17px;\r\n	width: 100%;\r\n  	max-width: 284px;\r\n	display: block;\r\n	float: left;\r\n  	border: 1px solid #000;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n	border-top-right-radius: 4px;\r\n  	border-bottom-right-radius: 4px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"] {\r\n	width:75%;\r\n	background-attachment: scroll;\r\n	background-position: 0px center;\r\n  	border: 1px solid #000;\r\n  	display:block;\r\n  	float:left;\r\n  	padding-left:20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n	line-height: 1;\r\n  	display:block;\r\n  	float: left;\r\n	margin-left: 10px;\r\n  	padding: 10px;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: [bg_color_1] 100%;\r\n   box-shadow: -4px -4px 0px rgba(0, 0, 0, 0.1) inset;\r\n  	background-image: none;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	color: #fff;\r\n    font-size: 20px;\r\n    text-shadow: 1px 1px 1px #000;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n   box-shadow: 4px 4px 0px rgba(0, 0, 0, 0.1) inset;\r\n	\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 80%;\r\n	margin-left: 10%;\r\n	text-align: center;\r\n	color: black;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg{\r\n	clear: both;\r\n  	text-align: left;\r\n}\r\n\r\n\r\n\r\n","informed.jpg","1","1","1","1","2015-01-10 18:59:43","5"),
("11","START popup","1","0","a:3:{s:4:\"main\";a:31:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:14:\"visit_page_cnt\";s:0:\"\";s:8:\"close_on\";s:10:\"user_close\";s:26:\"close_on_after_action_time\";s:1:\"1\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";s:24:\"hide_for_user_roles_show\";s:1:\"0\";}s:3:\"tpl\";a:124:{s:5:\"width\";s:3:\"824\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:4:\"#000\";s:14:\"bg_overlay_img\";s:0:\"\";s:18:\"bg_overlay_img_pos\";s:7:\"stretch\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#ffffff\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#da9732\";s:9:\"bg_type_2\";s:5:\"color\";s:8:\"bg_img_2\";s:0:\"\";s:10:\"bg_color_2\";s:7:\"#548d2c\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#56912d\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#888888\";s:10:\"font_txt_1\";s:7:\"default\";s:17:\"text_font_color_1\";s:7:\"#ffffff\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#585858\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:11:\"while_close\";s:7:\"bullets\";s:12:\"circle_green\";s:19:\"layer_rel_selectors\";s:0:\"\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:25:\"Do you want more traffic?\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"enb_txt_1\";s:1:\"1\";s:13:\"enb_foot_note\";s:1:\"1\";s:9:\"foot_note\";s:47:\"* we never share your e-mail with third parties\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:4:\"none\";s:14:\"anim_close_key\";s:0:\"\";s:13:\"anim_duration\";s:0:\"\";s:19:\"anim_close_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:23:\"sub_confirm_reload_time\";s:2:\"10\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:16:\"sub_gr_cycle_day\";s:1:\"0\";s:13:\"sub_ic_app_id\";s:0:\"\";s:15:\"sub_ic_app_user\";s:0:\"\";s:15:\"sub_ic_app_pass\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:13:\"sub_sf_app_id\";s:0:\"\";s:14:\"sub_ck_api_key\";s:0:\"\";s:14:\"sub_mem_acc_id\";s:0:\"\";s:15:\"sub_mem_pud_key\";s:0:\"\";s:16:\"sub_mem_priv_key\";s:0:\"\";s:14:\"sub_sb_api_key\";s:0:\"\";s:14:\"sub_v6_api_key\";s:0:\"\";s:12:\"sub_vtig_url\";s:0:\"\";s:13:\"sub_vtig_name\";s:0:\"\";s:12:\"sub_vtig_key\";s:0:\"\";s:16:\"sub_ymlp_api_key\";s:0:\"\";s:13:\"sub_ymlp_name\";s:0:\"\";s:11:\"sub_4d_name\";s:0:\"\";s:11:\"sub_4d_pass\";s:0:\"\";s:16:\"sub_dms_api_user\";s:0:\"\";s:20:\"sub_dms_api_password\";s:0:\"\";s:13:\"sub_dms_optin\";s:7:\"Unknown\";s:15:\"sub_mm_username\";s:0:\"\";s:14:\"sub_mm_api_key\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:8:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";s:10:\"set_preset\";s:0:\"\";}s:5:\"email\";a:8:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:10:\"set_preset\";s:0:\"\";s:3:\"enb\";s:1:\"1\";}}s:13:\"capt_site_key\";s:0:\"\";s:15:\"capt_secret_key\";s:0:\"\";s:9:\"blacklist\";s:0:\"\";s:15:\"blacklist_error\";s:26:\"Your email is in blacklist\";s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:25:\"strilezkijslawa@gmail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:25:\"strilezkijslawa@gmail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:13:\"SUBSCRIBE NOW\";s:13:\"sub_new_email\";s:25:\"strilezkijslawa@gmail.com\";s:15:\"sub_new_subject\";s:35:\"New Subscriber on Supsystic WP Test\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us subscriber information:<br />[subscriber_data]\";s:8:\"login_by\";s:8:\"username\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:5:\"Login\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:27:\"Thank you for registration!\";s:21:\"reg_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"reg_redirect_url\";s:0:\"\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:25:\"strilezkijslawa@gmail.com\";s:28:\"reg_txt_confirm_mail_message\";s:196:\"You registered on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your registration. If you did not register here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:25:\"strilezkijslawa@gmail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:25:\"strilezkijslawa@gmail.com\";s:15:\"reg_new_message\";s:121:\"You have new member on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us member information:<br />[subscriber_data]\";s:12:\"contact_form\";s:2:\"11\";s:12:\"stat_ga_code\";s:0:\"\";s:5:\"txt_0\";s:386:\"<p>Popup by Supsystic lets you easily create elegant overlapping windows with unlimited features. Pop-ups with Slider, Lightbox, Contact and Subscription forms and more:</p><ul><li>Unlimited Content Customization</li><li>Auto Open Popups</li><li>Contact Form with pop-up</li><li>Popup Opening Animations</li><li>Unlimited Content Customization</li><li>Popup Opening Animations</li></ul>\";s:5:\"txt_1\";s:73:\"<p>SUBSCRIBE TO OUR NEWSLETTER AND START INCREASING YOUR PROFITS NOW!</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"3\";s:16:\"txt_block_number\";s:1:\"2\";}}","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n		<div class=\"ppsRightCol\">\r\n			[if enb_txt_1]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_1 ppsPopupTxt_1\">\r\n				[txt_1]\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			[if enb_sm]\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 60%;\r\n  	box-shadow: rgba(32,32,32,1) 0 4px 20px;\r\n  	border-radius:3px;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: block;\r\n  	float: left;\r\n  	margin-top: 30px;\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #56912d;\r\n	font-family: \'arial\', arial;\r\n	font-size: 30px;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	letter-spacing: -1px;\r\n	font-weight: bold;\r\n	margin-top: 15px;\r\n	padding-left: 20px;\r\n	text-shadow: 0px 0px 1px #56912d;\r\n	-moz-text-shadow: 0px 0px 1px #56912d;\r\n	-webkit-text-shadow: 0px 0px 1px #56912d;\r\n  	\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	display: table-cell;\r\n  	border-radius:3px;\r\n  	width: 40%;\r\n  	height: 110%;\r\n	display: block;\r\n  	float: right;\r\n  	box-shadow: rgba(32,32,32,1) 0 4px 20px;\r\n  	padding: 10px 0;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}), color-stop(100%, [bg_color_1])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ie10+ */\r\n  background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}\', endColorstr=\'[bg_color_1]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 30px 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: 1px solid #d1b36d;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 22px;\r\n  	font-size: 17px;\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/user-black-icon.png\");\r\n  	background-repeat: no-repeat;\r\n  	background-position: 5px center;\r\n  	border-radius: 2px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/email-black-icon.png\");\r\n  	background-repeat: no-repeat;\r\n  	background-position: 5px center;\r\n  	border-radius: 2px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n  	[if bg_type_2 == \'color\']\r\n  	background: [bg_color_2];\r\n    background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	color: #fff;\r\n    font-size: 20px;\r\n    text-shadow: 2px 2px 2px #000;\r\n  	cursor: pointer;\r\n    line-height: 1;\r\n  	padding: .2180469716em 1.41575em;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 100%;\r\n  	color: #888888;\r\n  	font-family: \'arial\', arial;\r\n	font-weight: 400;\r\n	line-height: 1.3;\r\n  	font-size: 14px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_1 , #ppsPopupShell_[ID] .ppsPopupTxt_1  * {\r\n  	color:#ffffff;\r\n  	font-family: \'arial\', arial;\r\n  	font-weight: 700;\r\n  	text-shadow: #000000 1px 1px 1px;\r\n  	font-size: 25px;\r\n  	padding: 0 10px;\r\n  	margin: 0;\r\n  	letter-spacing: -1px;\r\n  	text-align: center;\r\n  	line-height: 1.475;\r\n    [if enb_txt_0]\r\n    width: 95;\r\n    [else]\r\n    width: 95%;\r\n    [endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	top:-20px;\r\n  	right:1px;\r\n  	z-index:99999;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n\r\n#ppsPopupShell_[ID] p{\r\n	margin-left:20px;\r\n}\r\n#ppsPopupShell_[ID] b{\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID] ul li {\r\n	height:30px;\r\n}\r\n#ppsPopupShell_[ID] ul {\r\n	margin: 14px 0;\r\n  	padding: 0 0 0 40px;\r\n}","start-popup.jpg","1","1","1","1","2015-01-10 18:59:43","26"),
("12","Nature","1","0","a:3:{s:4:\"main\";a:27:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";s:24:\"hide_for_user_roles_show\";s:1:\"0\";}s:3:\"tpl\";a:55:{s:5:\"width\";s:3:\"670\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:3:\"img\";s:8:\"bg_img_0\";s:37:\"[PPS_ASSETS_URL]img/assets/nature.jpg\";s:10:\"bg_color_0\";s:7:\"#232323\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#81d742\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#ffffff\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#ffffff\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#585858\";s:15:\"responsive_mode\";s:3:\"def\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:11:\"while_close\";s:7:\"bullets\";s:11:\"lists_green\";s:11:\"layered_pos\";s:0:\"\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:23:\"SUBSCRIBE TO NEWSLETTER\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"foot_note\";s:118:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time \";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:8:\"Sign-up!\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_subject\";s:40:\"New Subscriber on My WordPress Test Site\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here is subscriber information:<br />[subscriber_data]\";s:5:\"txt_0\";s:189:\"<p>Turpis dis amet adipiscing hac montes odio ac velit? Porta, non rhoncus vut, vel, et adipiscing magna pulvinar adipiscing est adipiscing urna. Dignissim rhoncus scelerisque pulvinar?</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"2\";s:16:\"txt_block_number\";s:1:\"1\";}}","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"label-window\">\r\n					<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n					[txt_0]\r\n					</div>\r\n				[endif]\r\n				<div style=\"clear: both;\"></div>\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						[sub_fields_html]\r\n						<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						[sub_form_end]\r\n						<div style=\"clear: both;\"></div>\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n  [if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 50%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .label-window{\r\n    background-color: rgba(10,10,10,0.6);\r\n    width: 70%;\r\n    padding-top: 10px;\r\n    padding-bottom: 10px;\r\n    margin-top: 20px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n	font-family: \'Open Sans\', arial;\r\n	font-size: 28px;\r\n	font-weight: 100;\r\n	color: #ffffff;\r\n	text-shadow: #000000 1px 1px 1px;\r\n	margin-top: 15px;\r\n	margin-bottom: 16px;\r\n	padding-left: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	/*display: table-cell;*/\r\n  	float:right;\r\n  	width: 50%;\r\n  	height: 100%;\r\n  	margin-bottom: 30px;\r\n  	margin-top: 65px;\r\n  	[if bg_type_1 == \'color\']\r\n  	background-color: rgba(0,0,0,0.7);\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 30px 0;\r\n	text-align: right;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: none;\r\n  	border-radius: 3px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	background-color: rgba(0,0,0,0.8) !important;\r\n  	padding-left: 10px;\r\n  	font-size: 17px;\r\n  	color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	color: #fff;\r\n  	border-top-right-radius: 3px;\r\n  	border-bottom-right-radius: 3px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select option {\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n  	font-family: \'Open Sans\', arial;\r\n	font-weight: 100;\r\n	color: #ffffff;\r\n  	width: 60%;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: [bg_color_1];\r\n    background: -moz-linear-gradient(90deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -webkit-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -o-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -ms-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: linear-gradient(0deg, [bg_color_2]) 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	text-align: center;\r\n  	font-family: \'Open Sans\', arial;\r\n 	font-weight: 100;\r\n	color: #ffffff;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	font-size: 14px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	margin: 20px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}","nature.png","1","1","1","1","2015-01-10 18:59:43","21"),
("13","Ready","1","0","a:3:{s:4:\"main\";a:21:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";}s:3:\"tpl\";a:78:{s:5:\"width\";s:3:\"500\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:3:\"img\";s:8:\"bg_img_0\";s:36:\"[PPS_ASSETS_URL]img/assets/ready.jpg\";s:10:\"bg_color_0\";s:7:\"#232323\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#ff4300\";s:9:\"bg_type_2\";s:5:\"color\";s:8:\"bg_img_2\";s:0:\"\";s:10:\"bg_color_2\";s:7:\"#ff4300\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#ffffff\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#ffffff\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#ffffff\";s:9:\"close_btn\";s:11:\"while_close\";s:7:\"bullets\";s:11:\"classy_blue\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:26:\"ARE YOU READY? GET IT NOW!\";s:9:\"enb_txt_0\";s:1:\"1\";s:13:\"enb_foot_note\";s:1:\"1\";s:9:\"foot_note\";s:58:\"Your Information will never be shared with any third party\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:8:\"tin_down\";s:13:\"anim_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:8:\"Sign-up!\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us subscriber information:<br />[subscriber_data]\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:5:\"Login\";s:16:\"reg_redirect_url\";s:0:\"\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:27:\"Thank you for registration!\";s:21:\"reg_txt_invalid_email\";s:22:\"Empty or invalid email\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"reg_txt_confirm_mail_message\";s:196:\"You registered on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your registration. If you did not register here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:14:\"admin@mail.com\";s:15:\"reg_new_message\";s:121:\"You have new member on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us member information:<br />[subscriber_data]\";s:5:\"txt_0\";s:52:\"<p>Increase more than 700% of Email Subscribers!</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"3\";s:16:\"txt_block_number\";s:1:\"1\";}}","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<div id=\"close\"><a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a></div>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_label]\r\n					<div class=\"label-window\">\r\n						<div class=\"ppsPopupLabel ppsPopupListsLabel\"><h2>[label]</h2></div>\r\n					</div>\r\n				[endif]\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n					[txt_0]\r\n					</div>\r\n				[endif]\r\n				<div style=\"clear: both;\"></div>\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						[sub_fields_html]\r\n						<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						[sub_form_end]\r\n						<div style=\"clear: both;\"></div>\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n  	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  	{% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 50%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .label-window{\r\n    padding-top: 10px;\r\n    padding-bottom: 10px;\r\n    margin-top: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel,\r\n#ppsPopupShell_[ID] h2 {\r\n	font-family: Open Sans, Arial, Tahoma, sans-serif;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n	font-size: 18px;\r\n	font-weight: 100;\r\n	color: #ffffff;\r\n	text-shadow: #000000 1px 1px 1px;\r\n	text-align: center;\r\n	margin-top: 15px;\r\n	margin-bottom: 16px;\r\n	padding-left: 5%;\r\n	padding-right: 5%;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel h2:after{\r\n    margin-top: 50px;\r\n    position: absolute;\r\n    left: 25%;\r\n    right: 25%;\r\n    height: 4px;\r\n    background: [bg_color_1];\r\n    content: \' \';\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	/*display: table-cell;*/\r\n  	height: 100%;\r\n  	margin-top: 35%;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: rgba(48, 20, 28, 0.7);\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 30px 0;\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: none;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	background-color: transparent;\r\n	padding: 0 0 0 10px;\r\n	font-size: 17px;\r\n	border: 1px solid [bg_color_1];\r\n  	color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select option {\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n  	font-family: \'Open Sans\', arial;\r\n	font-weight: 100;\r\n	color: #ffffff;\r\n  	width: 50%;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	padding: 0;\r\n  	float: none;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: [bg_color_1];\r\n    \r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	-webkit-transition: all 0.2s ease-in-out;\r\n	-moz-transition: all 0.2s ease-in-out;\r\n	-ms-transition: all 0.2s ease-in-out;\r\n	-o-transition: all 0.2s ease-in-out;\r\n  	\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n  	background:#fff;\r\n	color: [bg_color_1];\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	text-align: center;\r\n  	font-family: \'Open Sans\', arial;\r\n 	font-weight: 100;\r\n	color: #ffffff;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	font-size: 14px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	margin: 20px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n 	top: 15px;\r\n	right: 15px;\r\n	background: [bg_color_2];\r\n  	background-repeat: round;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #fff;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n	text-align: center;\r\n}\r\n\r\n#ppsPopupShell_[ID]{\r\n	color:[bg_color_1];\r\n}","ready.png","1","1","1","1","2015-01-10 18:59:43","2"),
("14","Innovation","1","0","a:3:{s:4:\"main\";a:17:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:8:\"close_on\";s:10:\"user_close\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";}s:3:\"tpl\";a:59:{s:5:\"width\";s:3:\"660\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:36:\"[PPS_ASSETS_URL]img/assets/ready.jpg\";s:10:\"bg_color_0\";s:7:\"#222222\";s:9:\"bg_type_1\";s:3:\"img\";s:8:\"bg_img_1\";s:41:\"[PPS_ASSETS_URL]img/assets/innovation.png\";s:10:\"bg_color_1\";s:7:\"#ff0000\";s:9:\"bg_type_2\";s:5:\"color\";s:8:\"bg_img_2\";s:0:\"\";s:10:\"bg_color_2\";s:7:\"#ff0000\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#ffffff\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#ffffff\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#ffffff\";s:9:\"close_btn\";s:9:\"red_close\";s:7:\"bullets\";s:11:\"lists_green\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:14:\"Subscribe Now!\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:8:\"tin_down\";s:13:\"anim_duration\";s:0:\"\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:26:\"ARE YOU READY? GET IT NOW!\";s:9:\"enb_txt_0\";s:1:\"1\";s:13:\"enb_foot_note\";s:1:\"1\";s:9:\"foot_note\";s:58:\"Your Information will never be shared with any third party\";s:5:\"txt_0\";s:242:\"<h3>Increase more than 700% of Email Subscribers!</h3><p><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis viverra<br /> urna vitae vehicula congue, purus nibh vestibulum lacus, sit amet tristique ante odio viverra orci.</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"3\";s:16:\"txt_block_number\";s:1:\"1\";}}","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<div id=\"close\"><a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a></div>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"label-window\">\r\n					<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				</div>\r\n			[endif]\r\n			<div class=\"header\">\r\n			</div>\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						[sub_fields_html]\r\n						<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						[sub_form_end]\r\n						<div style=\"clear: both;\"></div>\r\n					</div>\r\n				[endif]\r\n			</div>\r\n			[if enb_sm]\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n  	[if bg_type_0 == \'color\']\r\n	background:[bg_color_0]; /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 50%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .label-window{\r\n    padding-top: 10px;\r\n    padding-bottom: 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n	font-family: Open Sans, Arial, Tahoma, sans-serif;\r\n	font-size: 24px;\r\n	font-weight: 900;\r\n	color: #ffffff;\r\n	text-shadow: #000000 1px 1px 1px;\r\n	text-align: center;\r\n	margin-top: 15px;\r\n	margin-bottom: 16px;\r\n	padding-left: 5%;\r\n	padding-right: 5%;\r\n	\r\n}\r\n\r\n#ppsPopupShell_[ID] .header{\r\n  	width: 100%;\r\n	height: 80px;\r\n	[if bg_type_1 == \'color\']\r\n	background:[bg_color_1]; \r\n	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	/*display: table-cell;*/\r\n  	height: 100%;\r\n  	[if bg_type_2 == \'color\']\r\n  	background:[bg_color_2]; \r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 30px 0;\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 25px;\r\n  	height: 40px;\r\n  	border: none;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	padding-left: 10px;\r\n	font-size: 17px;\r\n	border: 1px solid transparent;\r\n  	color: #959595;\r\n  	border-radius: 50px;\r\n  	box-sizing: border-box;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	color: #959595;\r\n  	margin-left: -20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding: 5px 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n  	border-radius: 50px;\r\n  	font-family: \'Open Sans\', arial;\r\n	font-weight: 800;\r\n  	font-size:16px;\r\n	color: #ffffff;\r\n  	width: 35%;\r\n	height: 45px;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	background: transparent;\r\n  	-webkit-transition: all 0.5s ease-in-out;\r\n	-moz-transition: all 0.5s ease-in-out;\r\n	-ms-transition: all 0.5s ease-in-out;\r\n	-o-transition: all 0.5s ease-in-out;\r\n	border: 4px solid #fff;\r\n  	text-transform: uppercase;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n  	background:[bg_color_0];\r\n	color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	text-align: center;\r\n  	font-family: \'Open Sans\', arial;\r\n 	font-weight: 100;\r\n	color: #ffffff;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	font-size: 14px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	margin: 20px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n 	top: 15px;\r\n	right: 15px;\r\n}\r\n\r\n\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #fff;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n	text-align: center;\r\n}","innovation.png","1","1","1","1","2015-01-10 18:59:43","25"),
("15","Bonus","1","0","a:3:{s:4:\"main\";a:29:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:26:\"close_on_after_action_time\";s:1:\"1\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";}s:3:\"tpl\";a:96:{s:5:\"width\";s:3:\"770\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#e5e5e5\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:39:\"[PPS_ASSETS_URL]img/assets/button-1.png\";s:10:\"bg_color_1\";s:7:\"#ff4411\";s:9:\"bg_type_2\";s:3:\"img\";s:8:\"bg_img_2\";s:36:\"[PPS_ASSETS_URL]img/assets/bonus.png\";s:10:\"bg_color_2\";s:0:\"\";s:9:\"bg_type_3\";s:5:\"color\";s:8:\"bg_img_3\";s:0:\"\";s:10:\"bg_color_3\";s:7:\"#3d3d3d\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#ff4411\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#000000\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#979696\";s:15:\"responsive_mode\";s:3:\"def\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:11:\"classy_grey\";s:7:\"bullets\";s:4:\"tick\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:57:\"Get it NOW! Increase more than 700% of Email Subscribers!\";s:9:\"enb_txt_0\";s:1:\"1\";s:13:\"enb_foot_note\";s:1:\"1\";s:9:\"foot_note\";s:117:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time\";s:6:\"enb_sm\";s:1:\"1\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:16:\"sub_gr_cycle_day\";s:1:\"0\";s:13:\"sub_ic_app_id\";s:0:\"\";s:15:\"sub_ic_app_user\";s:0:\"\";s:15:\"sub_ic_app_pass\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:13:\"sub_sf_app_id\";s:0:\"\";s:14:\"sub_ck_api_key\";s:0:\"\";s:14:\"sub_mem_acc_id\";s:0:\"\";s:15:\"sub_mem_pud_key\";s:0:\"\";s:16:\"sub_mem_priv_key\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:9:\"Subscribe\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us subscriber information:<br />[subscriber_data]\";s:8:\"login_by\";s:8:\"username\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:5:\"Login\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:27:\"Thank you for registration!\";s:21:\"reg_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"reg_redirect_url\";s:0:\"\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"reg_txt_confirm_mail_message\";s:196:\"You registered on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your registration. If you did not register here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:14:\"admin@mail.com\";s:15:\"reg_new_message\";s:121:\"You have new member on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us member information:<br />[subscriber_data]\";s:5:\"txt_0\";s:433:\"<p>Bonus Popup it is the most powerful popup system for WordPress on the market. It combines a professionally designed welcome/exit window social locker and subscribing opt-in system for smart e-mail marketing.</p><ul><li>Welcome, exit popup window</li><li>Social network sharing locker</li><li>Smart newsletter opt-in system</li><li>Full popup window customizing</li><li>Page level Targeting</li><li>Many layouts to choose</li></ul>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"4\";s:16:\"txt_block_number\";s:1:\"1\";}}","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose\"></a>\r\n	<div class=\"ppsPopupListsInner\">\r\n		<div class=\"ppsPopupTblCols\">\r\n			<div class=\"ppsPopupLeftCol\">\r\n				[if enb_label]\r\n					<div class=\"ppsPopupLabel\">[label]</div>\r\n				[endif]\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupTxt_0\">[txt_0]</div>\r\n				[endif]\r\n			</div>\r\n			<div class=\"ppsPopupRightCol\">\r\n				<div class=\"ppsBigArrow\"></div>\r\n				[if bg_type_2 == \'img\']\r\n					<img src=\"[bg_img_2]\" />\r\n				[endif]\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						[sub_fields_html]\r\n						<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						[sub_form_end]\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: Helvetica,Arial,sans-serif;\r\n  	font-size: 14px;\r\n  	[if bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: [bg_color_1];\r\n    font-size: 25px;\r\n    font-weight: bold;\r\n	line-height: 1.2;\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupListsInner {\r\n  	border: 3px solid #bac0ac;\r\n	border-radius: 8px;\r\n	-webkit-border-radius: 8px;\r\n	-moz-border-radius: 8px;\r\n  	-webkit-box-shadow: inset 0 0 0 5px #fff, 0 10px 25px rgba(0,0,0,0.5);\r\n	-moz-box-shadow: inset 0 0 0 5px #fff, 0 10px 25px rgba(0,0,0,0.5);\r\n	box-shadow: inset 0 0 0 5px #fff, 0 10px 25px rgba(0,0,0,0.5);\r\n  	[if bg_type_0 == \'color\']\r\n    background: {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}; /* Old browsers */\r\n    background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* FF3.6+ */\r\n    background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%,[bg_color_0])); /* Chrome,Safari4+ */\r\n    background: -webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* Chrome10+,Safari5.1+ */\r\n    background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* Opera 12+ */\r\n    background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* IE10+ */\r\n    background: radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* W3C */\r\n    filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'#eaeaea\',GradientType=1 ); /* IE6-9 fallback on horizontal gradient */\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 .ppsTxtContent {\r\n	padding: 10px 10px 10px 50px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTblCols {\r\n	display: table;\r\n  	padding: 10px 10px 10px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLeftCol {\r\n	display: table-cell;\r\n  	[if enb_subscribe]\r\n  	width: 60%;\r\n  	[else]\r\n  	width: 60%;\r\n  	min-height: 60%;\r\n  	[endif]\r\n  	vertical-align: top;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupRightCol {\r\n  	width: 36%;\r\n	display: table-cell;\r\n  	border: 3px solid [bg_color_1];\r\n  	border-radius: 8px;\r\n	-moz-border-radius: 8px;\r\n	-webkit-border-radius: 8px;\r\n  	margin: 8px 5px 5px 5px;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 20px 0;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 35px;\r\n  	border-radius: 50px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 0px [bg_color_1] inset;\r\n  	padding-left: 10px;\r\n  	font-size: 17px;\r\n  	background: [bg_color_1];\r\n  	border: 1px solid transparent;\r\n  	color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	color: #fff;\r\n  	margin-left: -15px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding: 20px 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border: none;\r\n  	[if bg_type_3 == \'color\']\r\n  	background: [bg_color_3];\r\n	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	color: #fff;\r\n    font-size: 20px;\r\n  	cursor: pointer;\r\n  	width:  auto;\r\n  	padding: 5px 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	right: -5px;\r\n	top: 2px;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n  	[if enb_subscribe]\r\n    color: #979696;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: xx-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n    text-align: left;\r\n  	margin-left: 10px;\r\n  	[else]\r\n  	margin-top: 10px;\r\n  	color: #979696;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: xx-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n    text-align: left;\r\n    margin-left: 10px;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n[if enb_subscribe]\r\n  [else]\r\n  	margin-top: 130px;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] li{\r\n	font-weight: bold;\r\n  	font-size: 13px;\r\n  	padding-top: 3px;\r\n	padding-bottom: 3px;\r\n  	color: #737E86;\r\n}","bonus.png","1","1","1","1","2015-01-13 19:22:48","20"),
("16","Pink","1","0","a:3:{s:4:\"main\";a:30:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:26:\"close_on_after_action_time\";s:1:\"1\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";s:24:\"hide_for_user_roles_show\";s:1:\"0\";}s:3:\"tpl\";a:99:{s:5:\"width\";s:3:\"600\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:37:\"[PPS_ASSETS_URL]img/assets/nature.jpg\";s:10:\"bg_color_0\";s:7:\"#666666\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#d110cb\";s:9:\"bg_type_2\";s:3:\"img\";s:8:\"bg_img_2\";s:41:\"[PPS_ASSETS_URL]img/assets/mail-white.png\";s:10:\"bg_color_2\";s:0:\"\";s:9:\"bg_type_3\";s:5:\"color\";s:8:\"bg_img_3\";s:0:\"\";s:10:\"bg_color_3\";s:7:\"#d110cb\";s:9:\"bg_type_4\";s:5:\"color\";s:8:\"bg_img_4\";s:0:\"\";s:10:\"bg_color_4\";s:7:\"#c6c3c3\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#c6c3c3\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#c6c3c3\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#c6c3c3\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:11:\"while_close\";s:7:\"bullets\";s:11:\"lists_green\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:23:\"SUBSCRIBE TO NEWSLETTER\";s:9:\"enb_txt_0\";s:1:\"1\";s:13:\"enb_foot_note\";s:1:\"1\";s:9:\"foot_note\";s:58:\"Your Information will never be shared with any third party\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:14:\"use_sss_prj_id\";s:1:\"0\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:16:\"sub_gr_cycle_day\";s:1:\"0\";s:13:\"sub_ic_app_id\";s:0:\"\";s:15:\"sub_ic_app_user\";s:0:\"\";s:15:\"sub_ic_app_pass\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:13:\"sub_sf_app_id\";s:0:\"\";s:14:\"sub_ck_api_key\";s:0:\"\";s:14:\"sub_mem_acc_id\";s:0:\"\";s:15:\"sub_mem_pud_key\";s:0:\"\";s:16:\"sub_mem_priv_key\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:8:\"Sign-up!\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_subject\";s:40:\"New Subscriber on My WordPress Test Site\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here is subscriber information:<br />[subscriber_data]\";s:8:\"login_by\";s:8:\"username\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:5:\"Login\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:27:\"Thank you for registration!\";s:21:\"reg_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"reg_redirect_url\";s:0:\"\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"reg_txt_confirm_mail_message\";s:196:\"You registered on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your registration. If you did not register here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:14:\"admin@mail.com\";s:15:\"reg_new_message\";s:121:\"You have new member on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us member information:<br />[subscriber_data]\";s:5:\"txt_0\";s:189:\"<p>Turpis dis amet adipiscing hac montes odio ac velit? Porta, non rhoncus vut, vel, et adipiscing magna pulvinar adipiscing est adipiscing urna. Dignissim rhoncus scelerisque pulvinar?</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"5\";s:16:\"txt_block_number\";s:1:\"1\";}}","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div class=\"mail-img\"></div>\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_label]\r\n					<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				[endif]\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n					[txt_0]\r\n					</div>\r\n				[endif]\r\n				<div style=\"clear: both;\"></div>\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						[sub_fields_html]\r\n						<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						[sub_form_end]\r\n						<div style=\"clear: both;\"></div>\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n  [if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 50%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n	font-family: \'Open Sans\', arial;\r\n	font-size: 28px;\r\n  	font-weight: bold;\r\n	color: #ffffff;\r\n	margin-top: 15px;\r\n	margin-bottom: 16px;\r\n	padding-left: 75px;\r\n	[if bg_type_4 == \'color\']\r\n  	color: [bg_color_4];\r\n  	[elseif bg_type_4 == \'img\']\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .mail-img{\r\n	[if bg_type_1 == \'color\']\r\n	background: [bg_color_1];\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	border-radius: 50%;\r\n	-moz-border-radius: 50%;\r\n	-webkit-border-radius: 50%;\r\n	position: absolute;\r\n	top: 40px;\r\n	left: -35px;\r\n	height: 110px;\r\n	width: 110px;\r\n  	[if bg_type_2 == \'color\']\r\n	background: [bg_color_1];\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	[endif]\r\n	background-position: 22px 31px;\r\n	box-shadow: 0px 0 0px 8px rgba(115, 125, 143, 0.5);\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	/*display: table-cell;*/\r\n  	float:right;\r\n  	width: 100%;\r\n  	height: 100%;\r\n  	margin-bottom: 30px;\r\n  	margin-top: 65px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 50px 0 70px;\r\n	text-align: right;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: none;\r\n  	border-radius: 3px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	padding-left: 30px;\r\n  	font-size: 17px;\r\n  	background-image: url(\"[PPS_ASSETS_URL]img/assets/input-name.png\");\r\n	background-repeat: no-repeat;\r\n	background-position: 5px center;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	margin-left: -5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"][name=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"][name=\"email\"] {\r\n  	padding-left: 30px;\r\n    background-image: url(\"[PPS_ASSETS_URL]img/assets/input-email.png\");\r\n    background-repeat: no-repeat;\r\n    background-position: 5px center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n  	font-family: \'Open Sans\', arial;\r\n	/*margin-right: -30px;*/\r\n	font-weight: 100;\r\n	color: #ffffff;\r\n  	width: 40%;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	[if bg_type_3 == \'color\']\r\n  	background: [bg_color_3];\r\n   	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n  	opacity:0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	text-align: center;\r\n  	font-family: \'Open Sans\', arial;\r\n 	font-weight: 100;\r\n	color: #ffffff;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	font-size: 17px;\r\n  	[if bg_type_4 == \'color\']\r\n  	color: [bg_color_4];\r\n  	[elseif bg_type_4 == \'img\']\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	margin: 20px;\r\n  	margin-left: 70px;\r\n	margin-right: 40px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n  	padding-left: 30px;\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/security_ico.png\");\r\n	background-repeat: no-repeat;\r\n	background-position: 5px center;\r\n  	height: 20px;\r\n  	[if bg_type_4 == \'color\']\r\n  	color: [bg_color_4];\r\n  	[elseif bg_type_4 == \'img\']\r\n  	[endif]\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n@media (max-width: 768px) {\r\n  #ppsPopupShell_[ID] .ppsPopupLabel {\r\n  	padding-left: 0;\r\n    text-align: center;\r\n  }\r\n  #ppsPopupShell_[ID] .ppsPopupLabel,\r\n  #ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	margin-left: 20px;\r\n  }\r\n  #ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n  	padding-left: 20px;\r\n  }\r\n  #ppsPopupShell_[ID] .mail-img {\r\n  	left: 50%;\r\n    top: -30px;\r\n    transform: translate(-50%, 0);\r\n  }\r\n}","pink.png","1","1","1","1","2015-01-10 18:59:43","4"),
("17","Exclusive Listings","1","0","a:3:{s:4:\"main\";a:17:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:8:\"close_on\";s:10:\"user_close\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";}s:3:\"tpl\";a:58:{s:5:\"width\";s:3:\"600\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#f2f2f2\";s:9:\"bg_type_1\";s:3:\"img\";s:8:\"bg_img_1\";s:34:\"[PPS_ASSETS_URL]img/assets/btn.png\";s:10:\"bg_color_1\";s:7:\"#eded00\";s:9:\"bg_type_2\";s:3:\"img\";s:8:\"bg_img_2\";s:36:\"[PPS_ASSETS_URL]img/assets/23644.png\";s:10:\"bg_color_2\";s:0:\"\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#000000\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#666666\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#585858\";s:9:\"close_btn\";s:15:\"exclusive_close\";s:7:\"bullets\";s:11:\"lists_green\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:6:{s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:8:\"Join Now\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:4:\"boxy\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:36:\"Sign Up To Receive Exclusive Listing\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"foot_note\";s:118:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time \";s:5:\"txt_0\";s:172:\"<p>Popup by Supsystic lets you easily create elegant overlapping windows with unlimited features. Pop-ups with Slider, Lightbox, Contact and Subscription forms and more</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"3\";s:16:\"txt_block_number\";s:1:\"1\";}}","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Amatic+SC\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input class=\"butt\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_sm]\r\n					<div style=\"clear: both;\"></div>\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: \'arial\', arial;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 100%;\r\n  	border-image: url(\"[bg_img_2]\") 2 round;\r\n  	-moz-border-image: url(\"[bg_img_2]\") 2 round;\r\n  	-o-border-image: url(\"[bg_img_2]\") 2 round;\r\n  	border-width: 5px;\r\n  	border-radius: 4px;\r\n  	border-style: solid;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	padding: 10px;\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n    font-family: \'PT Sans\', sans-serif;\r\n	text-align: center;\r\n	font-size: 28px;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	letter-spacing: -1px;\r\n	margin-top: 15px;\r\n	display: block;\r\n  	margin-bottom: 15px;;\r\n	padding-left: 20px;\r\n	-moz-text-shadow: 0px 0px 1px #000;\r\n	-webkit-text-shadow: 0px 0px 1px #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 1% 1% 1% 1%;\r\n	text-align:right;\r\n	margin-bottom: 20px;\r\n  	padding-left: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	/*width: 100%;*/\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: 0px solid #d1b36d;\r\n	border-radius: 4px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 20px;\r\n  	font-size: 15px;\r\n	width:100%;\r\n  	max-width: 284px;\r\n	display: block;\r\n	float: left;\r\n  	border: 1px solid #e2e2e2;\r\n  	margin-top: 1px;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	border-radius: 4px !important;\r\n  	margin-left: -1px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n	width: 30%;\r\n  	padding: 6px 0 0 0;\r\n  	text-align: center;\r\n  	cursor: pointer;\r\n  	text-decoration: none;\r\n  	color: #333333;\r\n  	font-size: 17px;\r\n  	font-family: \'PT Sans\', sans-serif;\r\n  	text-shadow: 0px 1px 0px #FFF;\r\n  	display:block;\r\n  	float: left;\r\n	margin-left: 30px;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: [bg_color_1] 100%;\r\n   	box-shadow: -4px -4px 0px rgba(0, 0, 0, 0.1) inset;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	color: #fff;\r\n    font-size: 20px;\r\n    text-shadow: 1px 1px 1px #000;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n   box-shadow: 4px 4px 0px rgba(0, 0, 0, 0.1) inset;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 90%;\r\n	font-family: \'PT Serif\', serif;\r\n  	color: #666666;\r\n  	font-size: 15px;\r\n  	line-height: 22px;\r\n  	display: block;\r\n  	margin-bottom: 27px;\r\n    padding: 0px 20px 0px 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg {\r\n	clear: both;\r\n   	float: left;\r\n}\r\n","ExcluziveListings.jpg","1","1","1","1","2015-01-10 18:59:43","15"),
("18","Best Of Collection","1","0","a:3:{s:4:\"main\";a:30:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:26:\"close_on_after_action_time\";s:1:\"1\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";s:24:\"hide_for_user_roles_show\";s:1:\"0\";}s:3:\"tpl\";a:90:{s:5:\"width\";s:3:\"400\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:4:\"#000\";s:14:\"bg_overlay_img\";s:0:\"\";s:18:\"bg_overlay_img_pos\";s:7:\"stretch\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#eeee22\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:34:\"[PPS_ASSETS_URL]img/assets/btn.png\";s:10:\"bg_color_1\";s:7:\"#009327\";s:9:\"bg_type_2\";s:3:\"img\";s:8:\"bg_img_2\";s:41:\"[PPS_ASSETS_URL]img/assets/flyin-free.png\";s:10:\"bg_color_2\";s:0:\"\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#000000\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#000000\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#585858\";s:15:\"responsive_mode\";s:3:\"def\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:9:\"sqr_close\";s:7:\"bullets\";s:11:\"lists_green\";s:19:\"layer_rel_selectors\";s:0:\"\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:37:\"Sign Up To Receive Exclusive Listing \";s:9:\"foot_note\";s:118:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time \";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:4:\"boxy\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:14:\"sub_v6_api_key\";s:0:\"\";s:16:\"sub_ymlp_api_key\";s:0:\"\";s:13:\"sub_ymlp_name\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:5:\"email\";a:8:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:10:\"set_preset\";s:0:\"\";s:3:\"enb\";s:1:\"1\";}s:4:\"name\";a:8:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";s:10:\"set_preset\";s:0:\"\";}}s:9:\"blacklist\";s:0:\"\";s:15:\"blacklist_error\";s:26:\"Your email is in blacklist\";s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:8:\"Join Now\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_subject\";s:26:\"New Subscriber on Dev Site\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here is subscriber information:<br />[subscriber_data]\";s:8:\"login_by\";s:8:\"username\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:5:\"Login\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:27:\"Thank you for registration!\";s:21:\"reg_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"reg_redirect_url\";s:0:\"\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"reg_txt_confirm_mail_message\";s:196:\"You registered on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your registration. If you did not register here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:14:\"admin@mail.com\";s:15:\"reg_new_message\";s:121:\"You have new member on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us member information:<br />[subscriber_data]\";s:12:\"stat_ga_code\";s:0:\"\";s:5:\"txt_0\";s:172:\"<p>Popup by Supsystic lets you easily create elegant overlapping windows with unlimited features. Pop-ups with Slider, Lightbox, Contact and Subscription forms and more</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"3\";s:16:\"txt_block_number\";s:1:\"1\";}}","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Amatic+SC\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			<div class=\"ppsPopupLogo\"></div>\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n						[sub_fields_html]\r\n						<input class=\"butt\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_sm]\r\n					<div style=\"clear: both;\"></div>\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n				<div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: \'arial\', arial;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 100%;\r\n  	border-width: 5px;\r\n  	border-radius: 4px;\r\n    box-shadow: 0 0 10px rgba(0,0,0,0.5);\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n    padding: 10px 0 2px 0;\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n      font-family: Comic Sans, Comic Sans MS, cursive;\r\n	text-align: center;\r\n	font-size: 28px;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	letter-spacing: -1px;\r\n	margin-top: 15px;\r\n	display: block;\r\n  	margin-bottom: 15px;;\r\n	padding-left: 20px;\r\n	-moz-text-shadow: 0px 0px 1px #000;\r\n	-webkit-text-shadow: 0px 0px 1px #000;\r\n}\r\n\r\n.ppsPopupLogo{\r\n  width: 100%;\r\n  height: 200px;\r\n  float: left;\r\n [if bg_type_2 == \'color\']\r\n  	background: [bg_color_2] 100%;\r\n  [elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 1% 1% 1% 1%;\r\n	margin-bottom: 20px;\r\n  	padding-left: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input {\r\n	/*width: 100%;*/\r\n  	margin-bottom: 10px;\r\n  	height: 30px;\r\n  	border: 0px solid #d1b36d;\r\n	border-radius: 4px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email] {\r\n  -webkit-transition: opacity .5s;\r\n  transition: opacity .5s;\r\n  border-radius: 5px;\r\n  -moz-border-radius: 5px;\r\n  -webkit-border-radius: 5px;\r\n  margin: 0 0 10px;\r\n  width: 80%;\r\n  background: #f8fafa;\r\n  padding: 11px 20px;\r\n  border: 1px solid #e4e9e9;\r\n  color: #b3b3b3;\r\n  font-size: 13px;\r\n  	height: 35px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"] {\r\n    -webkit-transition: opacity .5s;\r\n  transition: opacity .5s;\r\n  border-radius: 5px;\r\n  -moz-border-radius: 5px;\r\n  -webkit-border-radius: 5px;\r\n  margin: 0 0 10px;\r\n  width: 80%;\r\n  background: #f8fafa;\r\n  padding: 11px 20px;\r\n  border: 1px solid #e4e9e9;\r\n  color: #b3b3b3;\r\n  font-size: 13px;\r\n  	height: 35px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n\r\n  -webkit-transition: opacity .5s ease,background-color .5s ease;\r\n  transition: opacity .5s ease,background-color .5s ease;\r\n  border-radius: 5px;\r\n  -moz-border-radius: 5px;\r\n  -webkit-border-radius: 5px;\r\n  border: none;\r\n  width: 100%;\r\n  height: 40px;\r\n  color: #fff;\r\n  font-size: 16px;\r\n  font-family: Comic Sans, Comic Sans MS, cursive;\r\n [if bg_type_1 == \'color\']\r\n  	background: [bg_color_1] 100%;\r\n  [elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  padding: 11px 0 10px;\r\n  text-align: center;\r\n  cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n   box-shadow: 4px 4px 0px rgba(0, 0, 0, 0.1) inset;\r\n	\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 90%;\r\n	font-family: \'PT Serif\', serif;\r\n  	color: #000000;\r\n  	font-size: 15px;\r\n  	line-height: 22px;\r\n  	display: block;\r\n    padding: 0px 20px 0px 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 p{font-family:Comic Sans, Comic Sans MS, cursive;}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}","BestOfCollection.png","1","1","1","1","2015-01-10 18:59:43","22"),
("19","Business","1","0","a:3:{s:4:\"main\";a:21:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";}s:3:\"tpl\";a:81:{s:5:\"width\";s:3:\"950\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:3:\"img\";s:8:\"bg_img_0\";s:50:\"[PPS_ASSETS_URL]img/assets/bussines-background.jpg\";s:10:\"bg_color_0\";s:7:\"#232323\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#2b2a29\";s:9:\"bg_type_2\";s:3:\"img\";s:8:\"bg_img_2\";s:35:\"[PPS_ASSETS_URL]img/assets/lamp.png\";s:10:\"bg_color_2\";s:0:\"\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#000000\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#000000\";s:10:\"font_txt_1\";s:7:\"default\";s:17:\"text_font_color_1\";s:7:\"#000000\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#000000\";s:9:\"close_btn\";s:11:\"classy_grey\";s:7:\"bullets\";s:11:\"lists_green\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:22:\"Subscribe and Get News\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"enb_txt_1\";s:1:\"1\";s:9:\"foot_note\";s:118:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time \";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:6:\"Submit\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us subscriber information:<br />[subscriber_data]\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:5:\"Login\";s:16:\"reg_redirect_url\";s:0:\"\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:27:\"Thank you for registration!\";s:21:\"reg_txt_invalid_email\";s:22:\"Empty or invalid email\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"reg_txt_confirm_mail_message\";s:196:\"You registered on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your registration. If you did not register here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:14:\"admin@mail.com\";s:15:\"reg_new_message\";s:121:\"You have new member on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us member information:<br />[subscriber_data]\";s:5:\"txt_0\";s:173:\"<p>Popup by Supsystic lets you easily create elegant overlapping windows with unlimited features. Pop-ups with Slider, Lightbox, Contact and Subscription forms and more.</p>\";s:5:\"txt_1\";s:20:\"<p>Your Business</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"3\";s:16:\"txt_block_number\";s:1:\"2\";}}","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Dancing+Script\" />\r\n<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Didact+Gothic\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_txt_1]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_1 ppsPopupTxt_1\">\r\n					[txt_1]\r\n					</div>\r\n				[endif]\r\n				<div class=\"logo\">\r\n              		[if bg_type_2 == \'img\']\r\n                  		<img src=\"[bg_img_2]\" />\r\n                  	[endif]\r\n              	</div>\r\n				[if enb_label]\r\n					<div class=\"label-window\">\r\n						<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n					</div>\r\n				[endif]\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n					[txt_0]\r\n					</div>\r\n				[endif]\r\n				<div style=\"clear: both;\"></div>\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						[sub_fields_html]\r\n						<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						[sub_form_end]\r\n						<div style=\"clear: both;\"></div>\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n  [if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 50%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .label-window{\r\n    width: 100%;\r\n    padding-top: 10px;\r\n    padding-bottom: 10px;\r\n    margin-top: 20px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n	font-family: \'Dancing Script\';\r\n	font-size: 56px;\r\n	font-weight: 100;\r\n	color: #000;\r\n	text-shadow: #000000 1px 1px 1px;\r\n	\r\n	padding-left: 20px;\r\n  	text-align:center;\r\n  	line-height: 1em;\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	/*display: table-cell;*/\r\n  	float:right;\r\n  	width: 40%;\r\n  	border-radius:20px;\r\n  	height: 100%;\r\n  	margin-bottom: 30px;\r\n  	margin-right: 30px;\r\n  	margin-top: 65px;\r\n  	background-color: #ebecec;\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsRightCol .logo{\r\n  	display: block;\r\n    width: 100%;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol .logo img {\r\n	max-height: 220px;\r\n  	width: auto;\r\n  	max-width: 100%;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 1px 30px 0;\r\n	text-align: right;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: none;\r\n  	border-radius: 3px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	padding-left: 10px;\r\n  	font-size: 17px;\r\n  	color: #000;\r\n  	border: 1px solid #928C8C;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	color: #fff;\r\n  	border-top-right-radius: 3px;\r\n  	border-bottom-right-radius: 3px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n  	font-family: \'Open Sans\', arial;\r\n	font-weight: 100;\r\n	color: #ffffff;\r\n  	width: 104%;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: [bg_color_1];\r\n    background: -moz-linear-gradient(90deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -webkit-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -o-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -ms-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: linear-gradient(0deg, [bg_color_2]) 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	text-align: center;\r\n  	font-family: \'Didact Gothic\';\r\n 	font-weight: 100;\r\n	color: #000;\r\n  	font-size: 18px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	margin: 2px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_1 {\r\n  	text-align: center;\r\n  	font-family: \'Didact Gothic\';\r\n 	font-weight: 100;\r\n	color: #000;\r\n  	font-size: 24px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_1 {\r\n  	margin: 20px 0px 20px 0px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}","bussines.png","1","1","1","1","2015-01-10 18:59:43","18"),
("20","Discount","1","0","a:3:{s:4:\"main\";a:17:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:8:\"close_on\";s:10:\"user_close\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";}s:3:\"tpl\";a:66:{s:5:\"width\";s:3:\"500\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:37:\"[PPS_ASSETS_URL]img/assets/nature.jpg\";s:10:\"bg_color_0\";s:7:\"#585570\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#42c5bf\";s:9:\"bg_type_2\";s:3:\"img\";s:8:\"bg_img_2\";s:41:\"[PPS_ASSETS_URL]img/assets/mail-white.png\";s:10:\"bg_color_2\";s:0:\"\";s:9:\"bg_type_3\";s:5:\"color\";s:8:\"bg_img_3\";s:0:\"\";s:10:\"bg_color_3\";s:7:\"#f54f36\";s:9:\"bg_type_4\";s:5:\"color\";s:8:\"bg_img_4\";s:0:\"\";s:10:\"bg_color_4\";s:7:\"#ffffff\";s:9:\"bg_type_5\";s:3:\"img\";s:8:\"bg_img_5\";s:44:\"[PPS_ASSETS_URL]img/assets/Discount-Code.png\";s:10:\"bg_color_5\";s:0:\"\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#000000\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#000000\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#000000\";s:9:\"close_btn\";s:11:\"classy_grey\";s:7:\"bullets\";s:11:\"lists_green\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:6:\"Submit\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:35:\"Subscribe <br />and  <br />Get News\";s:9:\"foot_note\";s:58:\"Your Information will never be shared with any third party\";s:5:\"txt_0\";s:189:\"<p>Turpis dis amet adipiscing hac montes odio ac velit? Porta, non rhoncus vut, vel, et adipiscing magna pulvinar adipiscing est adipiscing urna. Dignissim rhoncus scelerisque pulvinar?</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"6\";s:16:\"txt_block_number\";s:1:\"1\";}}","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Didact+Gothic\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div class=\"mail-img\"></div>\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_label]\r\n					<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				[endif]\r\n				<div class=\"logo\"></div>\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n					[txt_0]\r\n					</div>\r\n				[endif]\r\n				<div style=\"clear: both;\"></div>\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						[sub_fields_html]\r\n						<input class=\"singup\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						<input class=\"ppsPopupClose ppsPopupClose_[close_btn]\" type=\"submit\" name=\"submit\" value=\"Exit\"/>\r\n						[sub_form_end]\r\n						<div style=\"clear: both;\"></div>\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n  [if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  	{% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 50%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n	font-family: \'Didact Gothic\';\r\n	font-size: 50px;\r\n  	font-style: normal;\r\n	font-variant: normal;\r\n	font-weight: 500;\r\n	line-height: 46.4px;\r\n	color: #ffffff;\r\n	margin-bottom: 16px;\r\n	padding-left: 50px;\r\n  	width:60%;\r\n  	float: left;\r\n	[if bg_type_4 == \'color\']\r\n  	color: [bg_color_4];\r\n  	[elseif bg_type_4 == \'img\']\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .mail-img{\r\n	[if bg_type_1 == \'color\']\r\n	background: [bg_color_1];\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	border-radius: 50%;\r\n	-moz-border-radius: 50%;\r\n	-webkit-border-radius: 50%;\r\n	position: absolute;\r\n	top: -20px;\r\n	left: -30px;\r\n	height: 110px;\r\n	width: 110px;\r\n  	[if bg_type_2 == \'color\']\r\n	background: [bg_color_1];\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	[endif]\r\n	background-position: 22px 31px;\r\n	box-shadow: 0px 0 0px 8px rgba(115, 125, 143, 0.5);\r\n}\r\n#ppsPopupShell_[ID] .logo{\r\n	[if bg_type_5 == \'color\']\r\n	background: [bg_color_1];\r\n  	[elseif bg_type_5 == \'img\']\r\n  	background-image: url(\"[bg_img_5]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	border-radius: 50%;\r\n	-moz-border-radius: 50%;\r\n	-webkit-border-radius: 50%;\r\n	height: 130px;\r\n	width: 130px;\r\n  	float: left;\r\n  	[if bg_type_5 == \'color\']\r\n	background: [bg_color_5];\r\n  	[elseif bg_type_5 == \'img\']\r\n  	background-image: url(\"[bg_img_5]\");\r\n  	background-repeat: no-repeat;\r\n  	[endif]\r\n	box-shadow: 0px 0 0px 8px rgba(115, 125, 143, 0.5);\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	/*display: table-cell;*/\r\n  	float:right;\r\n  	width: 100%;\r\n  	height: 100%;\r\n  	margin-bottom: 30px;\r\n  	margin-top: 65px;\r\n  	padding-right: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell {\r\n	padding: 30px 50px 0 70px;\r\n	text-align: right;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: none;\r\n  	border-radius: 3px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	padding-left: 30px;\r\n  	font-size: 17px;\r\n  	background-image: url(\"[PPS_ASSETS_URL]img/assets/input-name.png\");\r\n	background-repeat: no-repeat;\r\n	background-position: 5px center;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	margin-left: -5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"] {\r\n  	padding-left: 30px;\r\n    background-image: url(\"[PPS_ASSETS_URL]img/assets/input-email.png\");\r\n    background-repeat: no-repeat;\r\n    background-position: 5px center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n  	font-family: \'Open Sans\', arial;\r\n	margin-right: -30px;;\r\n	font-weight: 100;\r\n	color: #ffffff;\r\n  	float: left;\r\n  	width: 40%;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	padding: 0;\r\n  	[if bg_type_3 == \'color\']\r\n  	background: [bg_color_3];\r\n   \r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n  	opacity:0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	text-align: center;\r\n  	font-family: \'Open Sans\', arial;\r\n 	font-weight: 100;\r\n	color: #ffffff;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	font-size: 17px;\r\n  	[if bg_type_4 == \'color\']\r\n  	color: [bg_color_4];\r\n  	[elseif bg_type_4 == \'img\']\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	margin-left: 70px;\r\n	margin-right: 40px;\r\n    float: left;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	position: static !important;\r\n  	background-image: none !important;\r\n    width: 192px !important;\r\n    height: 40px !important;\r\n  	float:right !important;\r\n    [if bg_type_1 == \'color\']\r\n	background: [bg_color_1] !important;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\") !important;\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n  	padding-left: 30px;\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/security_ico.png\");\r\n	background-repeat: no-repeat;\r\n	background-position: 5px center;\r\n  	height: 20px;\r\n  	[if bg_type_4 == \'color\']\r\n  	color: [bg_color_4];\r\n  	[elseif bg_type_4 == \'img\']\r\n  	[endif]\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg {\r\n	clear: both;\r\n  	float: left;\r\n}","discount.png","1","1","1","1","2015-01-10 18:59:43","8"),
("21","Eco Style","1","0","a:3:{s:4:\"main\";a:17:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:8:\"close_on\";s:10:\"user_close\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";}s:3:\"tpl\";a:58:{s:5:\"width\";s:3:\"550\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#ffffff\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:34:\"[PPS_ASSETS_URL]img/assets/btn.png\";s:10:\"bg_color_1\";s:7:\"#81d742\";s:9:\"bg_type_2\";s:5:\"color\";s:8:\"bg_img_2\";s:36:\"[PPS_ASSETS_URL]img/assets/23644.png\";s:10:\"bg_color_2\";s:7:\"#81d742\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#1e73be\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#81d742\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#585858\";s:9:\"close_btn\";s:11:\"while_close\";s:7:\"bullets\";s:11:\"lists_green\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:6:{s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:6:\"Submit\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:4:\"boxy\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:22:\"Subscribe and Get News\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"foot_note\";s:118:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time \";s:5:\"txt_0\";s:38:\"<p>discounts on all types of goods</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"3\";s:16:\"txt_block_number\";s:1:\"1\";}}","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Amatic+SC\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input class=\"butt\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_sm]\r\n					<div style=\"clear: both;\"></div>\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: \'arial\', arial;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 100%;\r\n  	border-left: 15px solid;\r\n  	[if bg_type_2 == \'color\']\r\n  	border-color:[bg_color_2];\r\n    [elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n      \r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	box-shadow: 0 0 10px rgba(0,0,0,0.5);\r\n  	padding: 10px;\r\n  	border-radius: 3px;\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n    font-family: \'PT Sans\', sans-serif;\r\n	text-align: center;\r\n	font-size: 38px;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	letter-spacing: -1px;\r\n	margin-top: 15px;\r\n	display: block;\r\n  	margin-bottom: 15px;;\r\n	padding-left: 20px;\r\n	-moz-text-shadow: 0px 0px 1px #000;\r\n	-webkit-text-shadow: 0px 0px 1px #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 1% 1% 1% 1%;\r\n	text-align:right;\r\n	margin-bottom: 20px;\r\n  	padding-left: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	/*width: 100%;*/\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: 0px solid #d1b36d;\r\n	border-radius: 4px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 20px;\r\n  	font-size: 15px;\r\n	width:100%;\r\n  	max-width: 284px;\r\n	display: block;\r\n	float: left;\r\n  	border: 1px solid #e2e2e2;\r\n  	margin-top: 1px;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	border-radius: 4px !important;\r\n  	margin-left: -1px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n	width: 30%;\r\n  	padding: 6px 0 0 0;\r\n  	text-align: center;\r\n 	cursor: pointer;\r\n  	text-decoration: none;\r\n  	color: #333333;\r\n  	font-size: 17px;\r\n  	font-family: \'PT Sans\', sans-serif;\r\n  	text-shadow: 0px 1px 0px #FFF;\r\n  	display:block;\r\n  	float: left;\r\n	margin-left: 30px;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: [bg_color_1] 100%;\r\n   	box-shadow: -4px -4px 0px rgba(0, 0, 0, 0.1) inset;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	color: #fff;\r\n    font-size: 20px;\r\n    text-shadow: 1px 1px 1px #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n   box-shadow: 4px 4px 0px rgba(0, 0, 0, 0.1) inset;\r\n	\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 90%;\r\n	font-family: \'PT Sans\', sans-serif;\r\n  	color: [bg_color_1];\r\n  	font-size: 25px;\r\n  	line-height: 25px;\r\n  	display: block;\r\n  	margin-bottom: 27px;\r\n    padding: 0px 20px 0px 20px;\r\n  	text-align: center;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n  	right: -20px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}\r\n.ppsPopupShell .ppsErrorMsg{\r\n  width: 200px;\r\n}\r\n\r\n","eco.png","1","1","1","1","2015-01-10 18:59:43","9"),
("22","Orange","1","0","a:3:{s:4:\"main\";a:17:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:8:\"close_on\";s:10:\"user_close\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";}s:3:\"tpl\";a:61:{s:5:\"width\";s:3:\"824\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#fefefe\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#f54f36\";s:9:\"bg_type_2\";s:5:\"color\";s:8:\"bg_img_2\";s:0:\"\";s:10:\"bg_color_2\";s:7:\"#8bc90c\";s:9:\"bg_type_3\";s:3:\"img\";s:8:\"bg_img_3\";s:35:\"[PPS_ASSETS_URL]img/assets/logo.png\";s:10:\"bg_color_3\";s:0:\"\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#000000\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#000000\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#000000\";s:9:\"close_btn\";s:27:\"close-black-in-white-circle\";s:7:\"bullets\";s:11:\"lists_green\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:8:\"Sign-up!\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:22:\"Subscribe and Get News\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"foot_note\";s:118:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time \";s:5:\"txt_0\";s:173:\"<p>Popup by Supsystic lets you easily create elegant overlapping windows with unlimited features. Pop-ups with Slider, Lightbox, Contact and Subscription forms and more.</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"4\";s:16:\"txt_block_number\";s:1:\"1\";}}","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Didact+Gothic\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n		</div>\r\n		<div class=\"ppsRightCol\">\r\n			<div class=\"logo\"></div>\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			[if enb_sm]\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n  	width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 66%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n  	/*float: left;*/\r\n  	vertical-align: top;\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: [bg_color_1];\r\n	font-family: \'Didact Gothic\';\r\n	font-size: 36px;\r\n  	text-align:center;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	letter-spacing: -1px;\r\n	font-weight: bold;\r\n	margin-top: 80px;\r\n	margin-bottom: 16px;\r\n	padding-left: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	display: table-cell;\r\n  	/*float: right;*/\r\n  	width: 34%;\r\n  	height: 100%;\r\n  	text-align: center;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}), color-stop(100%, [bg_color_1])); /* safari4+,chrome */\r\n	background:[bg_color_1]; /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}\', endColorstr=\'[bg_color_1]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	\r\n}\r\n\r\n#ppsPopupShell_[ID] .logo{\r\n	[if bg_type_3 == \'color\']\r\n	background: [bg_color_3];\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	border-radius: 50%;\r\n	-moz-border-radius: 50%;\r\n	-webkit-border-radius: 50%;\r\n	height: 130px;\r\n	width: 130px;\r\n  	display: inline-block;\r\n  	margin: 30px 0;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 0 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 15px;\r\n  	height: 30px;\r\n  	border: 1px solid #d1b36d;\r\n  	border-radius: 4px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 10px;\r\n  	font-size: 17px;\r\n  	background-color: #fff;\r\n  	display: block;\r\n  	text-align:center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n  	\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	margin-left: -5px;\r\n  	font-size: 17px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n  	width: 105%;\r\n  	[if bg_type_2 == \'color\']\r\n  	background: [bg_color_2];\r\n    [elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	color: #fff;\r\n    font-size: 20px;\r\n    text-shadow: 2px 2px 2px #000;\r\n  	cursor: pointer;\r\n  	padding: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	text-align:center;\r\n	font-family: \'Didact Gothic\';\r\n    font-size: 25px;\r\n	float: left;\r\n  	width: 100%;\r\n  	text-align: center;\r\n    line-height: 1.2;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsErrorMsg {\r\n	color: #fff !important;\r\n}","orange.png","1","1","1","1","2015-01-10 18:59:43","23"),
("23","Girl","1","0","a:3:{s:4:\"main\";a:31:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:14:\"visit_page_cnt\";s:0:\"\";s:8:\"close_on\";s:10:\"user_close\";s:26:\"close_on_after_action_time\";s:1:\"1\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";s:24:\"hide_for_user_roles_show\";s:1:\"0\";}s:3:\"tpl\";a:123:{s:5:\"width\";s:3:\"800\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:4:\"#000\";s:14:\"bg_overlay_img\";s:0:\"\";s:18:\"bg_overlay_img_pos\";s:7:\"stretch\";s:9:\"bg_type_0\";s:3:\"img\";s:8:\"bg_img_0\";s:41:\"[PPS_ASSETS_URL]img/assets/background.jpg\";s:10:\"bg_color_0\";s:7:\"#e5e5e5\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:39:\"[PPS_ASSETS_URL]img/assets/button-1.png\";s:10:\"bg_color_1\";s:7:\"#ffffff\";s:9:\"bg_type_2\";s:3:\"img\";s:8:\"bg_img_2\";s:35:\"[PPS_ASSETS_URL]img/assets/girl.png\";s:10:\"bg_color_2\";s:0:\"\";s:9:\"bg_type_3\";s:5:\"color\";s:8:\"bg_img_3\";s:0:\"\";s:10:\"bg_color_3\";s:7:\"#3d3d3d\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#ff4411\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#000000\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#979696\";s:15:\"responsive_mode\";s:3:\"def\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:27:\"close-black-in-white-circle\";s:7:\"bullets\";s:4:\"tick\";s:19:\"layer_rel_selectors\";s:0:\"\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:28:\"Subscribe and <br />Get News\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"foot_note\";s:117:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:4:\"none\";s:14:\"anim_close_key\";s:0:\"\";s:13:\"anim_duration\";s:0:\"\";s:19:\"anim_close_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:23:\"sub_confirm_reload_time\";s:2:\"10\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:16:\"sub_gr_cycle_day\";s:1:\"0\";s:13:\"sub_ic_app_id\";s:0:\"\";s:15:\"sub_ic_app_user\";s:0:\"\";s:15:\"sub_ic_app_pass\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:13:\"sub_sf_app_id\";s:0:\"\";s:14:\"sub_ck_api_key\";s:0:\"\";s:14:\"sub_mem_acc_id\";s:0:\"\";s:15:\"sub_mem_pud_key\";s:0:\"\";s:16:\"sub_mem_priv_key\";s:0:\"\";s:14:\"sub_sb_api_key\";s:0:\"\";s:14:\"sub_v6_api_key\";s:0:\"\";s:12:\"sub_vtig_url\";s:0:\"\";s:13:\"sub_vtig_name\";s:0:\"\";s:12:\"sub_vtig_key\";s:0:\"\";s:16:\"sub_ymlp_api_key\";s:0:\"\";s:13:\"sub_ymlp_name\";s:0:\"\";s:11:\"sub_4d_name\";s:0:\"\";s:11:\"sub_4d_pass\";s:0:\"\";s:16:\"sub_dms_api_user\";s:0:\"\";s:20:\"sub_dms_api_password\";s:0:\"\";s:13:\"sub_dms_optin\";s:7:\"Unknown\";s:15:\"sub_mm_username\";s:0:\"\";s:14:\"sub_mm_api_key\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";s:10:\"set_preset\";s:0:\"\";}s:5:\"email\";a:8:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:10:\"set_preset\";s:0:\"\";s:3:\"enb\";s:1:\"1\";}}s:13:\"capt_site_key\";s:0:\"\";s:15:\"capt_secret_key\";s:0:\"\";s:9:\"blacklist\";s:0:\"\";s:15:\"blacklist_error\";s:26:\"Your email is in blacklist\";s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:15:\"admin@gmail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:15:\"admin@gmail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:2:\"Go\";s:13:\"sub_new_email\";s:15:\"admin@gmail.com\";s:15:\"sub_new_subject\";s:35:\"New Subscriber on Supsystic WP Test\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here is subscriber information:<br />[subscriber_data]\";s:8:\"login_by\";s:8:\"username\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:5:\"Login\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:27:\"Thank you for registration!\";s:21:\"reg_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"reg_redirect_url\";s:0:\"\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:15:\"admin@gmail.com\";s:28:\"reg_txt_confirm_mail_message\";s:196:\"You registered on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your registration. If you did not register here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:15:\"admin@gmail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:15:\"admin@gmail.com\";s:15:\"reg_new_message\";s:121:\"You have new member on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us member information:<br />[subscriber_data]\";s:12:\"contact_form\";s:2:\"11\";s:12:\"stat_ga_code\";s:0:\"\";s:5:\"txt_0\";s:173:\"<p>Popup by Supsystic lets you easily create elegant overlapping windows with unlimited features. Pop-ups with Slider, Lightbox, Contact and Subscription forms and more.</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"4\";s:16:\"txt_block_number\";s:1:\"1\";}}","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Didact+Gothic\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose\"></a>\r\n	<div class=\"ppsPopupListsInner\">\r\n		<div class=\"ppsPopupTblCols\">\r\n			<div class=\"ppsPopupLeftCol\">\r\n				<div class=\"bglogo\">\r\n					[if bg_type_2 == \'img\']\r\n					<img src=\"[bg_img_2]\" />\r\n					[endif]\r\n				</div>\r\n			</div>\r\n			<div class=\"ppsPopupRightCol\">\r\n				<div class=\"ppsBigArrow\"></div>\r\n				[if enb_label]\r\n					<div class=\"ppsPopupLabel\">[label]</div>\r\n				[endif]\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupTxt_0\">[txt_0]</div>\r\n				[endif]\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: Helvetica,Arial,sans-serif;\r\n  	font-size: 14px;\r\n  \r\n  	[if bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n  	font-family: \'Didact Gothic\';\r\n	color: [bg_color_1];\r\n    font-size: 50px;\r\n    font-weight: bold;\r\n	line-height: 1.2;\r\n	text-align: center;\r\n    margin-top: 15%;\r\n  	margin-bottom: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupListsInner {\r\n	\r\n	\r\n  	[if bg_type_0 == \'color\']\r\n    background: {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}; /* Old browsers */\r\n    background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* FF3.6+ */\r\n    background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%,[bg_color_0])); /* Chrome,Safari4+ */\r\n    background: -webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* Chrome10+,Safari5.1+ */\r\n    background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* Opera 12+ */\r\n    background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* IE10+ */\r\n    background: radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* W3C */\r\n    filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'#eaeaea\',GradientType=1 ); /* IE6-9 fallback on horizontal gradient */\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 .ppsTxtContent {\r\n	padding: 10px 10px 10px 50px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\nfont-size:18px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTblCols {\r\n	display: table;\r\n  	padding: 10px 10px 10px 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLeftCol {\r\n	display: table-cell;\r\n    padding: 10px;\r\n  	[if enb_subscribe]\r\n  	width: 40%;\r\n  	[else]\r\n  	width: 30%;\r\n  	min-height: 60%;\r\n  	[endif]\r\n  	vertical-align: top;\r\n}\r\n#ppsPopupShell_[ID] .bglogo{\r\n  margin: 15px 0px 10px 0px;\r\n}\r\n#ppsPopupShell_[ID] .bglogo img{\r\n  	width:100%;\r\n  	height:auto;\r\n	}\r\n#ppsPopupShell_[ID] .ppsPopupRightCol {\r\n    color: #fff;\r\n  	width: 60%;\r\n	display: table-cell;\r\n  	border-radius: 8px;\r\n	-moz-border-radius: 8px;\r\n	-webkit-border-radius: 8px;\r\n  	margin: 8px 5px 5px 5px;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 20px 0;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 35px;\r\n  	border-radius: 2px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 0px [bg_color_1] inset;\r\n  	padding-left: 10px;\r\n  	font-size: 17px;\r\n  	background: [bg_color_1];\r\n  	border: 1px solid transparent;\r\n  	color: #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	color: #fff;\r\n  	margin-left: -15px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding: 20px 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border: 3px solid #fff;\r\n    padding: 0px 0px 5px !important;\r\n  	[if bg_type_3 == \'color\']\r\n  	background: [bg_color_3];\r\n\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	color: #fff;\r\n    font-size: 20px;\r\n  	cursor: pointer;\r\n  	border-radius: 50px;\r\n 	width: auto;\r\n  min-width: 60px;\r\n  	height: 60px;\r\n  	padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	right: -20px !important;\r\n	top: -10px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n  	[if enb_subscribe]\r\n    color: #979696;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: xx-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n    text-align: left;\r\n  	margin-left: 10px;\r\n  	[else]\r\n  	margin-top: 10px;\r\n  	color: #979696;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: xx-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n    text-align: left;\r\n    margin-left: 10px;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n[if enb_subscribe]\r\n  [else]\r\n  	margin-top: 130px;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] li{\r\n	font-weight: bold;\r\n  	font-size: 13px;\r\n  	padding-top: 3px;\r\n	padding-bottom: 3px;\r\n  	color: #737E86;\r\n}","girl.png","1","1","1","1","2015-01-13 19:22:48","6"),
("24","Grey","0","0","a:3:{s:4:\"main\";a:17:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:8:\"close_on\";s:10:\"user_close\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";}s:3:\"tpl\";a:60:{s:5:\"width\";s:3:\"500\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:37:\"[PPS_ASSETS_URL]img/assets/nature.jpg\";s:10:\"bg_color_0\";s:7:\"#2e3846\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#000000\";s:9:\"bg_type_2\";s:3:\"img\";s:8:\"bg_img_2\";s:40:\"[PPS_ASSETS_URL]img/assets/grey-logo.png\";s:10:\"bg_color_2\";s:0:\"\";s:9:\"bg_type_3\";s:5:\"color\";s:8:\"bg_img_3\";s:0:\"\";s:10:\"bg_color_3\";s:7:\"#e31e24\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#000000\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#000000\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#000000\";s:9:\"close_btn\";s:11:\"classy_grey\";s:7:\"bullets\";s:11:\"lists_green\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:6:\"Submit\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:6:\"vanish\";s:13:\"anim_duration\";s:4:\"1000\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:29:\"Subscribe and<br />  Get News\";s:9:\"foot_note\";s:58:\"Your Information will never be shared with any third party\";s:5:\"txt_0\";s:189:\"<p>Turpis dis amet adipiscing hac montes odio ac velit? Porta, non rhoncus vut, vel, et adipiscing magna pulvinar adipiscing est adipiscing urna. Dignissim rhoncus scelerisque pulvinar?</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"4\";s:16:\"txt_block_number\";s:1:\"1\";}}","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Didact+Gothic\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				<div class=\"logo\"></div>\r\n				[if enb_label]\r\n					<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				[endif]\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n					[txt_0]\r\n					</div>\r\n				[endif]\r\n				<div style=\"clear: both;\"></div>\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						[sub_fields_html]\r\n						<input class=\"singup\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						<input class=\"ppsPopupClose ppsPopupClose_[close_btn]\" type=\"submit\" name=\"submit\" value=\"Close\"/>\r\n						[sub_form_end]\r\n						<div style=\"clear: both;\"></div>\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n  [if bg_type_0 == \'color\']\r\n	background:[bg_color_0]; \r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 50%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n	font-family: \'Didact Gothic\';\r\n	font-size: 50px;\r\n  	font-style: normal;\r\n	font-variant: normal;\r\n	font-weight: 500;\r\n	line-height: 46.4px;\r\n	color: #ffffff;\r\n	margin-bottom: 16px;\r\n	text-align:center;\r\n  	width:100%;\r\n  	float: left;\r\n	[if bg_type_4 == \'color\']\r\n  	color: [bg_color_4];\r\n  	[elseif bg_type_4 == \'img\']\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .logo{\r\n  	width: 300px;\r\n  	height:155px;\r\n  	display: inline-block;\r\n	[if bg_type_2 == \'color\']\r\n	background-color: [bg_color_2];\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .logo img{\r\n	width:100%;\r\n	height:auto;\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n  	width: 100%;\r\n  	height: 100%;\r\n  	margin-bottom: 30px;\r\n  	margin-top: 40px;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell {\r\n	padding: 30px 50px 0;\r\n	text-align: right;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: none;\r\n  	border-radius: 3px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	padding-left: 30px;\r\n  	font-size: 17px;\r\n  	background-image: url(\"[PPS_ASSETS_URL]img/assets/input-name.png\");\r\n	background-repeat: no-repeat;\r\n	background-position: 5px center;\r\n  	background-color: #fff;\r\n  	box-sizing: border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	margin-left: -5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"] {\r\n  	padding-left: 30px;\r\n    background-image: url(\"[PPS_ASSETS_URL]img/assets/input-email.png\");\r\n    background-repeat: no-repeat;\r\n    background-position: 5px center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n  	font-family: \'Open Sans\', arial;\r\n	font-weight: 100;\r\n	color: #ffffff;\r\n  	float: left;\r\n  	width: 40%;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	[if bg_type_3 == \'color\']\r\n  	background: [bg_color_3];\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	cursor: pointer;\r\n  	padding: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n  	opacity:0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	text-align: center;\r\n  	font-family: \'Open Sans\', arial;\r\n 	font-weight: 100;\r\n	color: #ffffff;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	font-size: 17px;\r\n  	[if bg_type_4 == \'color\']\r\n  	color: [bg_color_4];\r\n  	[elseif bg_type_4 == \'img\']\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	margin-left: 70px;\r\n	margin-right: 40px;\r\n    float: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	position: static !important;\r\n  	background-image: none !important;\r\n    height: 40px !important;\r\n  	float:right !important;\r\n    [if bg_type_1 == \'color\']\r\n	background: [bg_color_1] !important;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\") !important;\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n  	padding-left: 30px;\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/security_ico.png\");\r\n	background-repeat: no-repeat;\r\n	background-position: 5px center;\r\n  	height: 20px;\r\n  	[if bg_type_4 == \'color\']\r\n  	color: [bg_color_4];\r\n  	[elseif bg_type_4 == \'img\']\r\n  	[endif]\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg {\r\n	clear: both;\r\n  	float: left;\r\n}","grey.png","1","1","1","1","2015-01-10 18:59:43","11"),
("25","Calm","1","0","a:3:{s:4:\"main\";a:17:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:8:\"close_on\";s:10:\"user_close\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";}s:3:\"tpl\";a:65:{s:5:\"width\";s:3:\"950\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:3:\"img\";s:8:\"bg_img_0\";s:38:\"[PPS_ASSETS_URL]img/assets/calm_bg.png\";s:10:\"bg_color_0\";s:7:\"#232323\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#94b7c0\";s:9:\"bg_type_2\";s:3:\"img\";s:8:\"bg_img_2\";s:35:\"[PPS_ASSETS_URL]img/assets/logo.png\";s:10:\"bg_color_2\";s:0:\"\";s:9:\"bg_type_3\";s:3:\"img\";s:8:\"bg_img_3\";s:45:\"[PPS_ASSETS_URL]img/assets/calm_column_bg.png\";s:10:\"bg_color_3\";s:0:\"\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#000000\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#000000\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#000000\";s:9:\"close_btn\";s:11:\"classy_grey\";s:7:\"bullets\";s:11:\"lists_green\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:22:\"Subscribe and Get News\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"foot_note\";s:118:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time \";s:6:\"enb_sm\";s:1:\"1\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:4:\"boxy\";s:14:\"use_sss_prj_id\";s:1:\"0\";s:8:\"anim_key\";s:4:\"puff\";s:13:\"anim_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:6:\"Submit\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us subscriber information:<br />[subscriber_data]\";s:5:\"txt_0\";s:173:\"<p>Popup by Supsystic lets you easily create elegant overlapping windows with unlimited features. Pop-ups with Slider, Lightbox, Contact and Subscription forms and more.</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"4\";s:16:\"txt_block_number\";s:1:\"1\";}}","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Dancing+Script\" />\r\n<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Didact+Gothic\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsLeftCol\">\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n					[txt_0]\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_txt_1]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_1 ppsPopupTxt_1\">\r\n					[txt_1]\r\n					</div>\r\n				[endif]\r\n				<div class=\"logo\"></div>\r\n				[if enb_label]\r\n					<div class=\"label-window\">\r\n						<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n					</div>\r\n				[endif]\r\n				<div style=\"clear: both;\"></div>\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						[sub_fields_html]\r\n						<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						[sub_form_end]\r\n						<div style=\"clear: both;\"></div>\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_classy_grey {\r\n	top: 26px;\r\n  	right: 26px;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n  	border-radius: 25px;\r\n  	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 50%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .label-window{\r\n    width: 100%;\r\n    padding-top: 10px;\r\n    padding-bottom: 10px;\r\n    margin-top: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n	font-family: \'Dancing Script\';\r\n	font-size: 50px;\r\n	font-weight: 100;\r\n	color: #000;\r\n	text-shadow: #000000 1px 1px 1px;\r\n	\r\n	padding-left: 20px;\r\n  	text-align:center;\r\n  	line-height: 1em;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsLeftCol {\r\n	float: left;\r\n  	width: 50%;\r\n 	border-radius: 20px;\r\n  	height: 100%;\r\n  	margin-bottom: 30px;\r\n  	margin-left: 30px;\r\n  	margin-top: 10%;\r\n  	line-height: 3.2em;\r\n    text-shadow: 0px 0px 0px black, 0 0 1em black;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	/*display: table-cell;*/\r\n  	float:right;\r\n  	width: 40%;\r\n  	border-radius:20px;\r\n  	height: 100%;\r\n  	margin-bottom: 30px;\r\n  	margin-right: 30px;\r\n  	margin-top: 65px;\r\n  	[if bg_type_3 == \'color\']\r\n	background: [bg_color_3]; \r\n	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsRightCol .logo{\r\n  	display: table;\r\n    width: 150px;\r\n 	margin-left: 30%;\r\n 	margin-top: 30px;\r\n  	height: 150px;\r\n[if bg_type_2 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_2])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	[endif]\r\n  	background-repeat: no-repeat;\r\n  	background-size: auto 100%;\r\n}\r\n\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 30px 0;\r\n	text-align: right;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: none;\r\n  	border-radius: 3px;\r\n  	box-sizing: border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	padding: 5px 5px 5px 10px;\r\n  	font-size: 17px;\r\n  	color: #000;\r\n  	border: 1px solid #928C8C;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	color: #fff;\r\n  	border-top-right-radius: 3px;\r\n  	border-bottom-right-radius: 3px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n  	font-family: \'Open Sans\', arial;\r\n	font-weight: 100;\r\n	color: #ffffff;\r\n  	width: 100%;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	padding: 5px;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: [bg_color_1];\r\n    background: -moz-linear-gradient(90deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -webkit-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -o-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -ms-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: linear-gradient(0deg, [bg_color_2]) 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	text-align: center;\r\n  	font-family: \'Didact Gothic\';\r\n 	font-weight: 100;\r\n	font-size: 42px;\r\n  	color:#fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	margin: 2px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] p {\r\n	margin: 0;\r\n}","Calm.png","1","1","1","1","2015-01-10 18:59:43","12"),
("26","Highlights","1","0","a:3:{s:4:\"main\";a:17:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:8:\"close_on\";s:10:\"user_close\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";}s:3:\"tpl\";a:57:{s:5:\"width\";s:3:\"650\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:3:\"img\";s:8:\"bg_img_0\";s:44:\"[PPS_ASSETS_URL]img/assets/highlights-bg.png\";s:10:\"bg_color_0\";s:7:\"#ffffff\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#2cabbe\";s:9:\"bg_type_2\";s:3:\"img\";s:8:\"bg_img_2\";s:46:\"[PPS_ASSETS_URL]img/assets/highlights-logo.png\";s:10:\"bg_color_2\";s:7:\"#4c77f7\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#1e73be\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#81d742\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#585858\";s:9:\"close_btn\";s:27:\"close-black-in-white-circle\";s:7:\"bullets\";s:11:\"lists_green\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:6:{s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:2:\"Go\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:4:\"boxy\";s:8:\"anim_key\";s:16:\"perspective_down\";s:13:\"anim_duration\";s:0:\"\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:22:\"Subscribe and Get News\";s:9:\"foot_note\";s:118:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time \";s:5:\"txt_0\";s:38:\"<p>discounts on all types of goods</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"3\";s:16:\"txt_block_number\";s:1:\"1\";}}","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Dancing+Script\" />\r\n<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Amatic+SC\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div class=\"logo\"></div>\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input class=\"butt\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_sm]\r\n					<div style=\"clear: both;\"></div>\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: \'arial\', arial;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 100%;\r\n  	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	box-shadow: 0 0 10px rgba(0,0,0,0.5);\r\n    padding: 60px 0 60px 0;\r\n  	border-radius: 3px;\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .logo{\r\n  	display: table;\r\n    width: 150px;\r\n    margin-left: 40%;\r\n    height: 130px;\r\n[if bg_type_2 == \'color\']\r\n	background: [bg_color_2];\r\n	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: auto 100%;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #fff;\r\n    font-family: Dancing Script;\r\n	text-align: center;\r\n	font-size: 48px;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	letter-spacing: -1px;\r\n	margin-top: 35px;\r\n	display: block;\r\n  	margin-bottom: 35px;;\r\n	padding-left: 20px;\r\n  	text-shadow: 1px 1px 2px black, 0 0 1em [bg_color_1];\r\n	-moz-text-shadow: 1px 1px 2px black, 0 0 1em [bg_color_1];\r\n	-webkit-text-shadow: 1px 1px 2px black, 0 0 1em [bg_color_1];\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 1% 1% 1% 1%;\r\n	text-align:right;\r\n	margin-bottom: 20px;\r\n  	padding-left: 20px;\r\n    margin: 0 auto;\r\n  	width: 60%;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	/*width: 100%;*/\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: 0px solid #d1b36d;\r\n	border-radius: 4px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 20px;\r\n  	font-size: 15px;\r\n	width:100%;\r\n  	max-width: 284px;\r\n	display: block;\r\n	float: left;\r\n  	border: 1px solid #e2e2e2;\r\n  	margin-top: 1px;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	border-radius: 4px !important;\r\n  	margin-left: -1px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n	min-width: 65px;\r\n	height: 60px;\r\n  	padding: 6px 0 0 0;\r\n  	text-align: center;\r\n 	cursor: pointer;\r\n  	text-decoration: none;\r\n  	color: #333333;\r\n  	font-family: Dancing Script;\r\n  	border-radius:50% !important;\r\n  	text-shadow: 0px 1px 0px #FFF;\r\n  	display:block;\r\n  	float: left;\r\n	margin-left: -15px;\r\n  	margin-top: -5px;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: [bg_color_1] 100%;\r\n   	box-shadow: -4px -4px 0px rgba(0, 0, 0, 0.1) inset;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	color: #fff;\r\n    font-size: 30px;\r\n    text-shadow: 1px 1px 1px #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n   box-shadow: 4px 4px 0px rgba(0, 0, 0, 0.1) inset;\r\n	\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 90%;\r\n	font-family: \'PT Sans\', sans-serif;\r\n  	color: [bg_color_1];\r\n  	font-size: 25px;\r\n  	line-height: 25px;\r\n  	display: block;\r\n  	margin-bottom: 27px;\r\n    padding: 0px 20px 0px 20px;\r\n  	text-align: center;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: -5px !important;\r\n  	right: -10px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}\r\n.ppsPopupShell .ppsErrorMsg{\r\n  width: 200px;\r\n}\r\n\r\n","highlights.png","1","1","1","1","2015-01-10 18:59:43","10"),
("27","New York","1","0","a:3:{s:4:\"main\";a:30:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:26:\"close_on_after_action_time\";s:1:\"1\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";s:24:\"hide_for_user_roles_show\";s:1:\"0\";}s:3:\"tpl\";a:109:{s:5:\"width\";s:3:\"824\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:4:\"#000\";s:14:\"bg_overlay_img\";s:0:\"\";s:18:\"bg_overlay_img_pos\";s:7:\"stretch\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#ffffff\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#8ba6e8\";s:9:\"bg_type_2\";s:5:\"color\";s:8:\"bg_img_2\";s:0:\"\";s:10:\"bg_color_2\";s:7:\"#ffc18d\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#ffffff\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#888888\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#ffffff\";s:15:\"responsive_mode\";s:3:\"def\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:11:\"while_close\";s:7:\"bullets\";s:12:\"circle_green\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:66:\"Subscribe to our newsletter and start increasing your profits now!\";s:9:\"enb_txt_0\";s:1:\"1\";s:13:\"enb_foot_note\";s:1:\"1\";s:9:\"foot_note\";s:45:\"We never share your e-mail with third parties\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:16:\"sub_gr_cycle_day\";s:1:\"0\";s:13:\"sub_ic_app_id\";s:0:\"\";s:15:\"sub_ic_app_user\";s:0:\"\";s:15:\"sub_ic_app_pass\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:13:\"sub_sf_app_id\";s:0:\"\";s:14:\"sub_ck_api_key\";s:0:\"\";s:14:\"sub_mem_acc_id\";s:0:\"\";s:15:\"sub_mem_pud_key\";s:0:\"\";s:16:\"sub_mem_priv_key\";s:0:\"\";s:14:\"sub_sb_api_key\";s:0:\"\";s:14:\"sub_v6_api_key\";s:0:\"\";s:12:\"sub_vtig_url\";s:0:\"\";s:13:\"sub_vtig_name\";s:0:\"\";s:12:\"sub_vtig_key\";s:0:\"\";s:16:\"sub_ymlp_api_key\";s:0:\"\";s:13:\"sub_ymlp_name\";s:0:\"\";s:11:\"sub_4d_name\";s:0:\"\";s:11:\"sub_4d_pass\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:8:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";s:10:\"set_preset\";s:0:\"\";}s:5:\"email\";a:8:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:10:\"set_preset\";s:0:\"\";s:3:\"enb\";s:1:\"1\";}}s:9:\"blacklist\";s:0:\"\";s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:13:\"SUBSCRIBE NOW\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_subject\";s:28:\"New subscriber on [sitename]\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here is subscriber information:<br />[subscriber_data]\";s:8:\"login_by\";s:8:\"username\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:10:\"Логин\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"Имя\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:195:\"Ссылка для подтверждения был отправлена на ваш адрес электронной почты. Проверьте вашу электронную почту!\";s:15:\"reg_txt_success\";s:43:\"Спасибо за регистрацию!\";s:21:\"reg_txt_invalid_email\";s:58:\"Пустой или недействительный email\";s:16:\"reg_redirect_url\";s:0:\"\";s:28:\"reg_txt_confirm_mail_subject\";s:61:\"Подтвердите регистрацию на [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"reg_txt_confirm_mail_message\";s:334:\"Вы зарегистрированы на сайте <a href=\\"[siteurl]\\">[sitename]</a>. Следуйте  <a href=\\"[confirm_link]\\">this link</a> для завершения регистрации. Если вы не зарегистрировались здесь - просто игнорируйте это сообщение.\";s:31:\"reg_txt_subscriber_mail_subject\";s:45:\"[sitename]  Ваш логин и пароль\";s:28:\"reg_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:71:\"Логин: [user_login]<br />Пароль: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:14:\"admin@mail.com\";s:15:\"reg_new_message\";s:177:\"У вас новый пользователь на сайте <a href=\\"[siteurl]\\">[sitename]</a>, вот информация пользователя: <br />[subscriber_data]\";s:12:\"contact_form\";s:2:\"19\";s:12:\"stat_ga_code\";s:0:\"\";s:5:\"txt_0\";s:48:\"<p>[google_map_easy id=\\"1\\" height=\\"300\\"]</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"3\";s:16:\"txt_block_number\";s:1:\"1\";}}","<link href=\"https://fonts.googleapis.com/css?family=Lato\" rel=\"stylesheet\" type=\"text/css\" >\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n		</div><!--\r\n		--><div class=\"ppsRightCol\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			[if enb_sm]\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","@nice-blue: #5B83AD;\r\n#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 0px;\r\n  	font-family: Lato;\r\n	font-size: 13px;\r\n	line-height: normal;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: block;\r\n	text-align: right;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 59%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n	\r\n	vertical-align: middle;\r\n  	display: inline-block;\r\n  	margin: 0px;\r\n	text-align: left;\r\n	\r\n	[if bg_type_0 == \"color\"]\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\", endColorstr=\"[bg_color_0]\",GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 20px 20px 0;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-moz-placeholder { /* Firefox 19+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input:-ms-input-placeholder { /* IE 10+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input:-moz-placeholder { /* Firefox 18- */\r\n    color: #ccc;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea::-moz-placeholder { /* Firefox 19+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea:-ms-input-placeholder { /* IE 10+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea:-moz-placeholder { /* Firefox 18- */\r\n    color: #ccc;\r\n}\r\n/*For all Elements*/\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"password\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: Lato;\r\n	font-size: 16px;\r\n	font-weight: normal;\r\n	line-height: normal;\r\n	color: #aaa;\r\n	text-align:center;\r\n	width: 100%;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	border: 0px solid transparent;\r\n	display:block;\r\n    \r\n    margin: 10px 0 0;\r\n	padding: 0 10px 0 10px;\r\n	height: 40px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	height: auto;\r\n	padding-top: 9px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeForm input:first-child {\r\n	margin-top: 0px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select  {\r\n	margin: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  {\r\n	display: block;\r\n	font-family: Lato;\r\n	font-size: 16px;\r\n	font-weight: normal;\r\n	line-height: normal;\r\n	color: #fff;\r\n	\r\n	margin: 10px 0 0;\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  span {\r\n	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"][name=\"name\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/user-black-icon.png\");\r\n	background-position: 12px center;\r\n	background-repeat: no-repeat;\r\n	background-size: 16px auto;\r\n	padding: 0 25px 0 35px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/email-black-icon.png\");\r\n	background-position: 11px center;\r\n	background-repeat: no-repeat;\r\n	background-size: 18px auto;\r\n	padding: 0 25px 0 35px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"submit\"] {\r\n	display: block;\r\n	font-family: Lato;\r\n	font-size: 17px;\r\n	font-weight: bold;\r\n	line-height: normal;\r\n	color: #fff;\r\n  	cursor: pointer;\r\n	margin: 10px 0 0;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	border: 0px solid transparent;\r\n	width: 100%;\r\n	height: 50px;\r\n	\r\n  	[if bg_type_2 == \"color\"]\r\n  	background: [bg_color_2] 100%;\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n  	border-radius: 3px;\r\n	-moz-border-radius: 3px;\r\n	-webkit-border-radius: 3px;\r\n  	min-height: 350px;\r\n  	width: 40%;\r\n	display: inline-block;\r\n  	padding: 20px;\r\n	margin: 0;\r\n	vertical-align: middle;\r\n	\r\n  	[if bg_type_1 == \"color\"]\r\n	background: [bg_color_1];\r\n  	[elseif bg_type_1 == \"img\"]\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color:#ffffff;\r\n  	font-family: \"Lato\";\r\n  	font-weight: normal;\r\n	line-height: normal;\r\n  	font-size: 24px;\r\n	letter-spacing: -1px;\r\n  	padding: 0px;\r\n	margin: 20px 0 0;\r\n  	text-align: center;\r\n  	\r\n    width: 100%;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 100%;\r\n    height: 300px;\r\n	line-height: normal;\r\n  	font-size: 14px;\r\n  	font-family: Lato;\r\n	font-weight: 400;\r\n	\r\n	\r\n	padding: 0px;\r\n	margin: 0;\r\n	\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 p {\r\n	font-size: inherit !important;\r\n	font-weight: inherit !important;\r\n	font-size: inherit !important;\r\n	line-height: inherit !important;\r\n	width: 100%;\r\n	margin: 0;\r\n	padding: 0;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	top:-20px;\r\n  	right:1px;\r\n  	z-index:99999;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg {\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #ffffff;\r\n	text-align: center;\r\n    font-family: Lato;\r\n    font-size: x-small;\r\n    font-weight: bold;\r\n    line-height: 14px;\r\n  	margin: 10px 30px 5px;\r\n}","230-6-new-york-prev.png","1","1","1","1","2015-01-10 18:59:43","1"),
("28","Smart","1","0","a:3:{s:4:\"main\";a:29:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:26:\"close_on_after_action_time\";s:1:\"1\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";}s:3:\"tpl\";a:94:{s:5:\"width\";s:3:\"770\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:3:\"img\";s:8:\"bg_img_0\";s:43:\"[PPS_ASSETS_URL]img/assets/bg-form-main.png\";s:10:\"bg_color_0\";s:7:\"#3d82bf\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:39:\"[PPS_ASSETS_URL]img/assets/button-1.png\";s:10:\"bg_color_1\";s:7:\"#ffffff\";s:9:\"bg_type_2\";s:3:\"img\";s:8:\"bg_img_2\";s:40:\"[PPS_ASSETS_URL]img/assets/form-book.png\";s:10:\"bg_color_2\";s:0:\"\";s:9:\"bg_type_3\";s:5:\"color\";s:8:\"bg_img_3\";s:0:\"\";s:10:\"bg_color_3\";s:7:\"#eeee22\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#ff4411\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#000000\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#979696\";s:15:\"responsive_mode\";s:3:\"def\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:11:\"classy_grey\";s:7:\"bullets\";s:4:\"tick\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:57:\"Get it NOW! Increase more than 700% of Email Subscribers!\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"foot_note\";s:117:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:14:\"perspective_up\";s:13:\"anim_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:16:\"sub_gr_cycle_day\";s:1:\"0\";s:13:\"sub_ic_app_id\";s:0:\"\";s:15:\"sub_ic_app_user\";s:0:\"\";s:15:\"sub_ic_app_pass\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:13:\"sub_sf_app_id\";s:0:\"\";s:14:\"sub_ck_api_key\";s:0:\"\";s:14:\"sub_mem_acc_id\";s:0:\"\";s:15:\"sub_mem_pud_key\";s:0:\"\";s:16:\"sub_mem_priv_key\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:6:{s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:11:\"Get it now!\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us subscriber information:<br />[subscriber_data]\";s:8:\"login_by\";s:8:\"username\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:5:\"Login\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:27:\"Thank you for registration!\";s:21:\"reg_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"reg_redirect_url\";s:0:\"\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"reg_txt_confirm_mail_message\";s:196:\"You registered on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your registration. If you did not register here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:14:\"admin@mail.com\";s:15:\"reg_new_message\";s:121:\"You have new member on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us member information:<br />[subscriber_data]\";s:5:\"txt_0\";s:214:\"<p>Smart Popup it is the most powerful popup system for WordPress on the market. It combines a professionally designed welcome/exit window social locker and subscribing opt-in system for smart e-mail marketing.</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"4\";s:16:\"txt_block_number\";s:1:\"1\";}}","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose\"></a>\r\n	<div class=\"ppsPopupListsInner\">\r\n		<div class=\"ppsPopupTblCols\">\r\n			<div class=\"ppsPopupLeftCol\">\r\n				[if bg_type_2 == \'img\']\r\n				<img src=\"[bg_img_2]\" />\r\n				[endif]\r\n			</div>\r\n			<div class=\"ppsPopupRightCol\">\r\n				<div class=\"ppsBigArrow\"></div>\r\n				[if enb_label]\r\n					<div class=\"ppsPopupLabel\">[label]</div>\r\n				[endif]\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupTxt_0\">[txt_0]</div>\r\n				[endif]\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						[sub_fields_html]\r\n						<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						[sub_form_end]\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: Helvetica,Arial,sans-serif;\r\n  	font-size: 14px;\r\n  	[if bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: [bg_color_1];\r\n    font-size: 25px;\r\n    font-weight: bold;\r\n	line-height: 1.2;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupListsInner {\r\n  	border: 3px solid #bac0ac;\r\n  	-webkit-box-shadow: inset 0 0 0 5px #fff, 0 10px 25px rgba(0,0,0,0.5);\r\n	-moz-box-shadow: inset 0 0 0 5px #fff, 0 10px 25px rgba(0,0,0,0.5);\r\n	box-shadow: inset 0 0 0 5px #fff, 0 10px 25px rgba(0,0,0,0.5);\r\n  	[if bg_type_0 == \'color\']\r\n    background: {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}; /* Old browsers */\r\n    background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* FF3.6+ */\r\n    background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%,[bg_color_0])); /* Chrome,Safari4+ */\r\n    background: -webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* Chrome10+,Safari5.1+ */\r\n    background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* Opera 12+ */\r\n    background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* IE10+ */\r\n    background: radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* W3C */\r\n    filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'#eaeaea\',GradientType=1 ); /* IE6-9 fallback on horizontal gradient */\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 .ppsTxtContent {\r\n	padding: 10px 10px 10px 50px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTblCols {\r\n	display: table;\r\n  	padding: 10px 10px 10px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLeftCol {\r\n	display: table-cell;\r\n  	[if enb_subscribe]\r\n  	width: 30%;\r\n  	[else]\r\n  	width: 30%;\r\n  	min-height: 60%;\r\n  	[endif]\r\n  	vertical-align: middle;\r\n    text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupRightCol {\r\n  	width: 70%;\r\n	display: table-cell;\r\n  	border-radius: 8px;\r\n	-moz-border-radius: 8px;\r\n	-webkit-border-radius: 8px;\r\n  	margin: 8px 5px 5px 5px;\r\n  	text-align: left;\r\n  	padding: 30px 0 30px 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 0 0;\r\n  	text-align: center;\r\n    position: relative;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	margin-bottom: 10px;\r\n  	height: 37px !important;\r\n    width: 60%;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 0px [bg_color_1] inset;\r\n  	padding: 0 0 0 10px;\r\n  	font-size: 17px;\r\n  	background: [bg_color_1];\r\n  	border: 1px solid transparent;\r\n  	color: #993300;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	color: #fff;\r\n  	margin-left: -15px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding: 20px 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email] {\r\n    float: left;\r\n    margin-left: 7px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border: none;\r\n  	float:left;\r\n  	[if bg_type_3 == \'color\']\r\n  	background: [bg_color_3];\r\n	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	color: #993300;;\r\n    font-size: 17px;\r\n  	cursor: pointer;\r\n  	width:  auto;\r\n    text-transform: uppercase;\r\n  	-webkit-transition: all 0.5s ease;\r\n    -moz-transition: all 0.5s ease;\r\n    -o-transition: all 0.5s ease;\r\n    transition: all 0.5s ease;\r\n  	padding: 1px 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	right: -5px;\r\n	top: 2px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 90%;\r\n	font-family: \'PT Serif\', serif;\r\n  	color: #fff;\r\n  	font-size: 16px;\r\n    line-height: 24px;\r\n  	display: block;\r\n  	margin-bottom: 27px;\r\n    padding: 0px 20px 0px 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n  	[if enb_subscribe]\r\n    color: #000000;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: xx-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n    text-align: left;\r\n  	margin-left: 10px;\r\n  	[else]\r\n  	margin-top: 10px;\r\n  	color: #979696;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: xx-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n    text-align: left;\r\n    margin-left: 10px;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n[if enb_subscribe]\r\n  [else]\r\n  	margin-top: 130px;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] li{\r\n	font-weight: bold;\r\n  	font-size: 13px;\r\n  	padding-top: 3px;\r\n	padding-bottom: 3px;\r\n  	color: #737E86;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg {\r\n	clear: both;\r\n}","smart.png","1","1","1","1","2015-01-13 19:22:48","14"),
("29","Find Us","1","0","a:3:{s:4:\"main\";a:29:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:26:\"close_on_after_action_time\";s:1:\"1\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";}s:3:\"tpl\";a:88:{s:5:\"width\";s:3:\"670\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:4:\"none\";s:8:\"bg_img_0\";s:1:\"h\";s:10:\"bg_color_0\";s:7:\"#eeee22\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#dd3333\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#ffffff\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#ffffff\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#585858\";s:15:\"responsive_mode\";s:3:\"def\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:11:\"while_close\";s:7:\"bullets\";s:11:\"lists_green\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:12:\"Find us here\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"foot_note\";s:118:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time \";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:16:\"sub_gr_cycle_day\";s:1:\"0\";s:13:\"sub_ic_app_id\";s:0:\"\";s:15:\"sub_ic_app_user\";s:0:\"\";s:15:\"sub_ic_app_pass\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:13:\"sub_sf_app_id\";s:0:\"\";s:14:\"sub_ck_api_key\";s:0:\"\";s:14:\"sub_mem_acc_id\";s:0:\"\";s:15:\"sub_mem_pud_key\";s:0:\"\";s:16:\"sub_mem_priv_key\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:8:\"Sign-up!\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us subscriber information:<br />[subscriber_data]\";s:8:\"login_by\";s:8:\"username\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:5:\"Login\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:27:\"Thank you for registration!\";s:21:\"reg_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"reg_redirect_url\";s:0:\"\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"reg_txt_confirm_mail_message\";s:196:\"You registered on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your registration. If you did not register here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:14:\"admin@mail.com\";s:15:\"reg_new_message\";s:121:\"You have new member on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us member information:<br />[subscriber_data]\";s:5:\"txt_0\";s:33:\"<p>[google_map_easy id=\\"1\\"]</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"2\";s:16:\"txt_block_number\";s:1:\"1\";}}","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			[if enb_label]\r\n				<div class=\"label-window\">\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				</div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"find-form ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_sm]\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n    position: relative;\r\n  [if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n      position: relative;\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 50%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .label-window{\r\n  position:absolute;\r\n    top: 0;\r\n    background-color: rgba(10,10,10,0.6);\r\n    padding-right: 30px;\r\n    left: 40px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n  	color: #000;\r\n	font-family: \'Open Sans\', arial;\r\n	font-size: 28px;\r\n	font-weight: 100;\r\n	color: #ffffff;\r\n	text-shadow: #000000 1px 1px 1px;\r\n	margin-top: 15px;\r\n	margin-bottom: 16px;\r\n	padding-left: 20px;\r\n  	line-height: 26px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell {\r\n    bottom: 20px;\r\n    right: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	padding: 11px 24px 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	/*background-color: rgba(0,0,0,0.8) !important;\r\n  	padding-left: 10px;\r\n  	font-size: 17px;\r\n  	color: #fff;*/\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	color: #fff;\r\n  	border-top-right-radius: 3px;\r\n  	border-bottom-right-radius: 3px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	[if bg_type_1 == \'color\']\r\n  	background-color: [bg_color_1];\r\n  	background-image: none;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	color: #fff;\r\n  	cursor: pointer;\r\n	border: none;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	text-align: center;\r\n  	font-family: \'Open Sans\', arial;\r\n 	font-weight: 100;\r\n	color: #ffffff;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	font-size: 14px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	position:reletive;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n    top: -5px !important;\r\n    right: -5px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}","find-us.png","1","1","1","1","2015-01-10 18:59:43","29"),
("30","Photodoto","1","0","a:3:{s:4:\"main\";a:29:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:26:\"close_on_after_action_time\";s:1:\"1\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";}s:3:\"tpl\";a:97:{s:5:\"width\";s:3:\"600\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#ffffff\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#698c8f\";s:9:\"bg_type_2\";s:3:\"img\";s:8:\"bg_img_2\";s:44:\"[PPS_ASSETS_URL]img/assets/pop_subscribe.jpg\";s:10:\"bg_color_2\";s:0:\"\";s:9:\"bg_type_3\";s:5:\"color\";s:8:\"bg_img_3\";s:0:\"\";s:10:\"bg_color_3\";s:7:\"#d2eaea\";s:9:\"bg_type_4\";s:5:\"color\";s:8:\"bg_img_4\";s:0:\"\";s:10:\"bg_color_4\";s:7:\"#f33d2e\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#000000\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#000000\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#585858\";s:15:\"responsive_mode\";s:3:\"def\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:11:\"classy_grey\";s:7:\"bullets\";s:8:\"pop_icon\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:55:\"START MAKING MONEY DOING WHAT YOU LOVE: FREE OF COURSE!\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"foot_note\";s:118:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time \";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:4:\"boxy\";s:8:\"anim_key\";s:10:\"slide_down\";s:13:\"anim_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:16:\"sub_gr_cycle_day\";s:1:\"0\";s:13:\"sub_ic_app_id\";s:0:\"\";s:15:\"sub_ic_app_user\";s:0:\"\";s:15:\"sub_ic_app_pass\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:13:\"sub_sf_app_id\";s:0:\"\";s:14:\"sub_ck_api_key\";s:0:\"\";s:14:\"sub_mem_acc_id\";s:0:\"\";s:15:\"sub_mem_pud_key\";s:0:\"\";s:16:\"sub_mem_priv_key\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:6:{s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:20:\" I WANT THIS COURSE!\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here is subscriber information:<br />[subscriber_data]\";s:8:\"login_by\";s:8:\"username\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:5:\"Login\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:27:\"Thank you for registration!\";s:21:\"reg_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"reg_redirect_url\";s:0:\"\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"reg_txt_confirm_mail_message\";s:196:\"You registered on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your registration. If you did not register here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:14:\"admin@mail.com\";s:15:\"reg_new_message\";s:121:\"You have new member on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us member information:<br />[subscriber_data]\";s:5:\"txt_0\";s:282:\"<p>Join our email course \\"7 Days to Earning More As a Photographer\\" and learn:</p><ul><li>Tech tips that will save you $2.5K on equipment</li><li>Why bad photographers make more money than you</li><li>Mistakes every beginner makes and how to avoid them... and much more!</li></ul>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"5\";s:16:\"txt_block_number\";s:1:\"1\";}}","<link href=\'http://fonts.googleapis.com/css?family=Bitter\' rel=\'stylesheet\' type=\'text/css\'>\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"pop_form__title\">\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"text-block\">\r\n				<div class=\"logo\"> \r\n					<div class=\"logo-img\"> </div>\r\n				</div>\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n					[txt_0]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input class=\"butt\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_sm]\r\n				<div style=\"clear: both;\"></div>\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: \'arial\', arial;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	border: 5px solid #fff;\r\n    border-radius: 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 100%;\r\n  	border-radius: 4px;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .pop_form__title {\r\n    [if bg_type_1 == \'color\']\r\n  	background: [bg_color_1] 100%;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n    font-size: 24px;\r\n    color: #FFF;\r\n    line-height: 28px;\r\n    text-transform: uppercase;\r\n    font-family: \'Scolar Bold\';\r\n    text-align: center;\r\n    padding: 20px 0px;\r\n    border-radius: 5px 5px 0px 0px;\r\n    -moz-border-radius: 5px 5px 0px 0px;\r\n    -webkit-border-radius: 5px 5px 0px 0px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n    padding: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 1% 1% 1% 1%;\r\n	text-align:right;\r\n	margin-bottom: 20px;\r\n  	padding-left: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	/*width: 100%;*/\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: 0px solid #d1b36d;\r\n	border-radius: 4px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 20px;\r\n  	font-size: 17px;\r\n	width: 100%;\r\n  	max-width: 284px;\r\n	display: block;\r\n	float: left;\r\n    color: #7f7f7f;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n	border-top-right-radius: 4px;\r\n  	border-bottom-right-radius: 4px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"] {\r\n	width: 60% !important;\r\n    padding: 12px 15px!important;\r\n    float: left;\r\n    height: auto;\r\n    border-radius: 5px;\r\n    -moz-border-radius: 5px;\r\n    -webkit-border-radius: 5px;\r\n    border: none;\r\n    background: #FFF;\r\n    font-size: 16px;\r\n    color: #7f7f7f;\r\n    margin-right: 0px!important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n	height: 43px;\r\n  	display:block;\r\n  	float: left;\r\n	margin-left: 10px;\r\n  	[if bg_type_4 == \'color\']\r\n  	background: [bg_color_4] 100%;\r\n   	box-shadow: -4px -4px 0px rgba(0, 0, 0, 0.1) inset;\r\n  	background-image: none;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	color: #fff;\r\n    font-size: 16px;\r\n    text-shadow: 1px 1px 1px #000;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n   box-shadow: 4px 4px 0px rgba(0, 0, 0, 0.1) inset;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell{\r\n    [if bg_type_3 == \'color\']\r\n  	background: [bg_color_3] 100%;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n    float: left;\r\n    width: 100%;\r\n    padding: 40px 0 30px 0;\r\n}\r\n#ppsPopupShell_[ID] .logo-img{\r\n  	width:180px;\r\n  	height:180px;\r\n  	[if bg_type_2 == \'color\']\r\n	background: [bg_color_2]; \r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	position: absolute; \r\n    right: 0;\r\n}\r\n#ppsPopupShell_[ID] .text-block {\r\n    position: relative;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 65%;\r\n	text-align: left;\r\n	color: #f37362;\r\n    font-size: 23px;\r\n    line-height: 30px;\r\n    padding-left: 10px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 li{\r\n	font-size: 18px;\r\n    color: #629296;\r\n    line-height: 26px;\r\n    display: inline-block;\r\n    padding-left: 25px;\r\n    margin-bottom: 16px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n    display: inline-block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg{\r\n	clear: both;\r\n  	text-align: center;\r\n}","Photodoto.png","1","1","1","1","2015-01-10 18:59:43","24"),
("31","Map style","1","0","a:3:{s:4:\"main\";a:29:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:26:\"close_on_after_action_time\";s:1:\"1\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";}s:3:\"tpl\";a:92:{s:5:\"width\";s:3:\"670\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:4:\"none\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#232323\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#d8511c\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#ffffff\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#ffffff\";s:10:\"font_txt_1\";s:7:\"default\";s:17:\"text_font_color_1\";s:7:\"#000000\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#585858\";s:15:\"responsive_mode\";s:3:\"def\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:11:\"while_close\";s:7:\"bullets\";s:11:\"lists_green\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:23:\"SUBSCRIBE TO NEWSLETTER\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"foot_note\";s:0:\"\";s:6:\"enb_sm\";s:1:\"1\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:16:\"sub_gr_cycle_day\";s:1:\"0\";s:13:\"sub_ic_app_id\";s:0:\"\";s:15:\"sub_ic_app_user\";s:0:\"\";s:15:\"sub_ic_app_pass\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:13:\"sub_sf_app_id\";s:0:\"\";s:14:\"sub_ck_api_key\";s:0:\"\";s:14:\"sub_mem_acc_id\";s:0:\"\";s:15:\"sub_mem_pud_key\";s:0:\"\";s:16:\"sub_mem_priv_key\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:8:\"Sign-up!\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us subscriber information:<br />[subscriber_data]\";s:8:\"login_by\";s:8:\"username\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:5:\"Login\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:27:\"Thank you for registration!\";s:21:\"reg_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"reg_redirect_url\";s:0:\"\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"reg_txt_confirm_mail_message\";s:196:\"You registered on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your registration. If you did not register here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:14:\"admin@mail.com\";s:15:\"reg_new_message\";s:121:\"You have new member on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us member information:<br />[subscriber_data]\";s:5:\"txt_0\";s:33:\"<p>[google_map_easy id=\\"1\\"]</p>\";s:5:\"txt_1\";s:59:\"<p>[contact-form-7 id=\\"208\\" title=\\"Contact form 1\\"]</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"2\";s:16:\"txt_block_number\";s:1:\"2\";}}","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		[if enb_txt_0]\r\n			[txt_0]\r\n		[endif]\r\n		<div class=\"right ppsSubscribeShell\">\r\n			[if enb_subscribe]\r\n				[sub_form_start]\r\n				[sub_fields_html]\r\n				<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n				[sub_form_end]\r\n			[endif]\r\n			[if enb_txt_1]\r\n				<div class=\"another-contact-form\">\r\n				[txt_1]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	position:relative;\r\n}\r\n#ppsPopupShell_[ID] .right{\r\n	position: absolute;\r\n    bottom: 15px;\r\n    right: 15px;\r\n}\r\n#ppsPopupShell_[ID] .another-contact-form{\r\n    background-color: rgba(0, 0, 0, 0.5);\r\n    width: 100%;\r\n    padding: 10px;\r\n    box-sizing: border-box;\r\n}\r\n#ppsPopupShell_[ID] p {\r\n    margin: 0 0 5px;\r\n}\r\n#ppsPopupShell_[ID] .wpcf7-form .col-sm-8{\r\n	text-align:center;\r\n}\r\n#ppsPopupShell_[ID] .wpcf7-form label{\r\n  text-shadow: 1px 1px 2px white, 0 0 1em white;\r\n}\r\n#ppsPopupShell_[ID] .wpcf7-form  div.wpcf7-validation-errors {\r\n    border: 2px solid #F70000;\r\n    background-color: rgba(255, 254, 254, 0.5);\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n    top: -5px !important;\r\n    right: -5px !important;\r\n    z-index: 666;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsErrorMsg,\r\n#ppsPopupShell_[ID] .ppsSuccessMsg {\r\n	background-color: #333;\r\n  	padding: 5px 10px;\r\n  	border-radius: 3px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	margin-right: 5px;\r\n  	height: 40px;\r\n  	border: 1px solid #d1b36d;\r\n  	width: auto;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 10px;\r\n  	font-size: 17px;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n  	\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	margin-left: -5px;\r\n  	font-size: 17px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n  	[if bg_type_1 == \'color\']\r\n  	background-color: [bg_color_1];\r\n  	background-image: none;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	color: #fff;\r\n    font-size: 20px;\r\n    text-shadow: 2px 2px 2px #000;\r\n  	cursor: pointer;\r\n  	line-height: 1px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n}","mapstyle.png","1","1","1","1","2015-01-10 18:59:43","27"),
("32","Simple iFrame","1","0","a:3:{s:4:\"main\";a:19:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:2:\"10\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:8:\"close_on\";s:10:\"user_close\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";}s:3:\"tpl\";a:30:{s:10:\"iframe_url\";s:26:\"https://www.wikipedia.org/\";s:5:\"width\";s:3:\"400\";s:13:\"width_measure\";s:2:\"px\";s:6:\"height\";s:3:\"300\";s:14:\"height_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#424242\";s:9:\"close_btn\";s:15:\"exclusive_close\";s:11:\"layered_pos\";s:3:\"top\";s:8:\"anim_key\";s:10:\"fade_right\";s:13:\"anim_duration\";s:3:\"500\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:0:\"\";s:16:\"reg_redirect_url\";s:0:\"\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:0:\"\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:27:\"Thank you for registration!\";s:21:\"reg_txt_invalid_email\";s:22:\"Empty or invalid email\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"reg_txt_confirm_mail_message\";s:196:\"You registered on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your registration. If you did not register here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:14:\"admin@mail.com\";s:15:\"reg_new_message\";s:121:\"You have new member on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us member information:<br />[subscriber_data]\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"1\";s:16:\"txt_block_number\";s:1:\"0\";}}","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<iframe class=\"ppsMainFrame\" src=\"[iframe_url]\"></iframe>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	height: [height][height_measure];\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsMainFrame {\r\n  	width: 100%;\r\n  	height: 100%;\r\n  	border: 8px solid [bg_color_0];\r\n  	border-radius: 5px;\r\n  	padding: 0;\r\n  	margin: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	top: 15px;\r\n  	right: 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}","simple-iframe.jpg","1","1","1","4","2015-01-10 18:59:43","30"),
("33","Simple HTML","1","0","a:3:{s:4:\"main\";a:19:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:8:\"close_on\";s:10:\"user_close\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";}s:3:\"tpl\";a:32:{s:5:\"width\";s:3:\"400\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#ffffff\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#006dc1\";s:9:\"close_btn\";s:9:\"sqr_close\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_txt_0\";s:1:\"1\";s:8:\"anim_key\";s:8:\"slide_up\";s:13:\"anim_duration\";s:4:\"1000\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:0:\"\";s:16:\"reg_redirect_url\";s:0:\"\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:0:\"\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:27:\"Thank you for registration!\";s:21:\"reg_txt_invalid_email\";s:22:\"Empty or invalid email\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"reg_txt_confirm_mail_message\";s:196:\"You registered on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your registration. If you did not register here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:14:\"admin@mail.com\";s:15:\"reg_new_message\";s:121:\"You have new member on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us member information:<br />[subscriber_data]\";s:5:\"txt_0\";s:842:\"<p style=\\"text-align: left;\\"><a href=\\"[PPS_ASSETS_URL]img/assets/beautiful-blonde-flower-flowers-girl-Favim.com-143635-150x150.jpg\\"><img class=\\"wp-image-17 size-thumbnail alignleft\\" src=\\"[PPS_ASSETS_URL]img/assets/beautiful-blonde-flower-flowers-girl-Favim.com-143635-150x150.jpg\\" alt=\\"\\" width=\\"176\\" height=\\"176\\" /></a>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p><p style=\\"text-align: left;\\"><strong>Ut enim ad minim veniam</strong>, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. <em>Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.</em> Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"2\";s:16:\"txt_block_number\";s:1:\"1\";}}","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		[txt_0]\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: \'Helvetica\', arial;\r\n	font-size: 14px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] p {\r\n	margin: 14px 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	height: 100%;\r\n  	[if bg_type_1 == \'color\']\r\n  	border: 8px solid [bg_color_1];\r\n  	[endif]\r\n  	border-radius: 5px;\r\n  	padding: 10px;\r\n  	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}","simple-html.jpg","1","1","1","5","2015-01-10 18:59:43","31"),
("34","HTML 2 Columns","1","0","a:3:{s:4:\"main\";a:19:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:8:\"close_on\";s:10:\"user_close\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";}s:3:\"tpl\";a:34:{s:5:\"width\";s:3:\"600\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:3:\"img\";s:8:\"bg_img_0\";s:39:\"[PPS_ASSETS_URL]img/assets/rain-031.jpg\";s:10:\"bg_color_0\";s:7:\"#ffffff\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#000000\";s:9:\"close_btn\";s:11:\"lists_black\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"enb_txt_1\";s:1:\"1\";s:8:\"anim_key\";s:12:\"bounce_right\";s:13:\"anim_duration\";s:4:\"1000\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:0:\"\";s:16:\"reg_redirect_url\";s:0:\"\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:0:\"\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:27:\"Thank you for registration!\";s:21:\"reg_txt_invalid_email\";s:22:\"Empty or invalid email\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"reg_txt_confirm_mail_message\";s:196:\"You registered on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your registration. If you did not register here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:14:\"admin@mail.com\";s:15:\"reg_new_message\";s:121:\"You have new member on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us member information:<br />[subscriber_data]\";s:5:\"txt_0\";s:532:\"<p style=\\"text-align: center;\\"><a href=\\"[PPS_SITE_URL]wp-content/uploads/2015/11/rain-girl.jpg\\"><img class=\\"alignnone wp-image-20 size-medium\\" src=\\"[PPS_SITE_URL]wp-content/uploads/2015/11/rain-girl-300x169.jpg\\" alt=\\"\\" width=\\"300\\" height=\\"169\\" /></a></p><p style=\\"text-align: center;\\">Lorem <span style=\\"color: #993300;\\">ipsum <strong>dolor sit amet</strong>, consectetur adipiscing elit</span>, <span style=\\"color: #ff6600;\\"><em>sed do eiusmod</em></span> tempor incididunt ut labore et dolore magna aliqua.</p>\";s:5:\"txt_1\";s:620:\"<h2 style=\\"text-align: center;\\"><span style=\\"color: #ff6600;\\"><strong>ABOUT US</strong></span></h2><p style=\\"text-align: center;\\">Lorem <span style=\\"color: #99cc00;\\"><strong>ipsum dolor sit amet</strong></span>, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore<span style=\\"text-decoration: underline;\\"> et dolore magna</span> aliqua.</p><p style=\\"text-align: center;\\">Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"2\";s:16:\"txt_block_number\";s:1:\"2\";}}","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n      	[if enb_txt_0]\r\n      	<div class=\"ppsCol\">[txt_0]</div>\r\n      	[endif]\r\n      	[if enb_txt_1]\r\n      	<div class=\"ppsCol\">[txt_1]</div>\r\n      	[endif]\r\n      	<div style=\"clear: both;\"></div	>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: \'Helvetica\', arial;\r\n	font-size: 14px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #fff;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	height: 100%;\r\n  	[if bg_type_1 == \'color\']\r\n  	border: 8px solid [bg_color_1];\r\n  	[endif]\r\n  	border-radius: 5px;\r\n  	padding: 10px;\r\n  	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsCol {\r\n	float: left;\r\n  	margin: 0;\r\n  	padding: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsCol img {\r\n	width: 100% !important;\r\n  	height: auto !important;\r\n}\r\n{% if [enb_txt_0] and [enb_txt_1] %}\r\n#ppsPopupShell_[ID] .ppsCol {\r\n	width: 50%;\r\n}\r\n{% endif %}\r\n\r\n","html-2-columns.jpg","1","1","1","5","2015-01-10 18:59:43","32"),
("35","PDF PopUp","1","0","a:3:{s:4:\"main\";a:29:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:26:\"close_on_after_action_time\";s:1:\"1\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";}s:3:\"tpl\";a:14:{s:7:\"pdf_url\";s:46:\"[PPS_ASSETS_URL]img/assets/healthy-cooking.pdf\";s:5:\"width\";s:3:\"400\";s:13:\"width_measure\";s:2:\"px\";s:6:\"height\";s:3:\"540\";s:14:\"height_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:4:\"none\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#ffffff\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:11:\"lists_black\";s:11:\"layered_pos\";s:3:\"top\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:4:\"1000\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"1\";s:16:\"txt_block_number\";s:1:\"0\";}}","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<iframe class=\"ppsMainFrame\" src=\"https://docs.google.com/gview?url=[pdf_url]&embedded=true\"></iframe>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	height: [height][height_measure];\r\n  	[if bg_type_0 == \'color\']\r\n	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsMainFrame {\r\n  	width: 100%;\r\n  	height: 100%;\r\n  	[if enb_bg_0]\r\n  	border: 8px solid [bg_color_0];\r\n  	[endif]\r\n  	border-radius: 5px;\r\n  	padding: 0;\r\n  	margin: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	top: 15px;\r\n  	right: 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}","pdf-popup.jpg","1","1","1","6","2015-01-10 18:59:43","33"),
("38","Clear PopUp","1","0","a:3:{s:4:\"main\";a:15:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:10:\"show_pages\";s:3:\"all\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";}s:3:\"tpl\";a:24:{s:5:\"width\";s:3:\"400\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:1:\"1\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#ffffff\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#c6c3c3\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#c6c3c3\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#c6c3c3\";s:9:\"close_btn\";s:4:\"none\";s:11:\"layered_pos\";s:0:\"\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:11:\"Clear PopUp\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"enb_btn_0\";s:1:\"1\";s:9:\"btn_txt_0\";s:14:\"Click to Close\";s:9:\"btn_url_0\";s:1:\"#\";s:14:\"is_close_btn_0\";s:1:\"1\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:5:\"txt_0\";s:146:\"<p>Just Simple and Clear Full Screen PopUp. You can add any text, AD or Disclaimers here. Insert any Images, Videos or anything you need here.</p>\";}s:10:\"opts_attrs\";a:3:{s:9:\"bg_number\";s:1:\"1\";s:16:\"txt_block_number\";s:1:\"1\";s:11:\"btns_number\";s:1:\"1\";}}","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		[if enb_label]\r\n			<div class=\"ppsPopupLabel\">[label]</div>\r\n		[endif]\r\n		[if enb_txt_0]\r\n			<div class=\"ppsPopupTxt ppsPopupTxt_0\">[txt_0]</div>\r\n		[endif]\r\n		[if enb_btn_0]\r\n      		<a class=\"ppsBtn ppsBtn_0[if is_close_btn_0] ppsPopupClose[endif]\" href=\"[btn_url_0]\">[btn_txt_0]</a>\r\n      	[endif]\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: \"Open Sans\",arial;\r\n	font-size: 16px;\r\n	line-height: 1.475;\r\n	font-weight: normal;\r\n	color: #fff;\r\n  	text-shadow: 1px 1px 1px #000000;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	background-color: transparent;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	font-size: 32px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsBtn {\r\n  	display: inline;\r\n  	margin: 0;\r\n  	padding: 5px 20px;\r\n  	border-radius: 5px;\r\n  	transition-duration: 0.3s;\r\n  	text-decoration: none !important;\r\n  	color: #fff;\r\n  	font-size: 24px;\r\n  	border: 1px solid #000;\r\n  	color: #000;\r\n  	[if bg_type_0 == \'color\']\r\n	background:  [bg_color_0]; /* Old browsers */\r\nbackground: -moz-linear-gradient(top,   {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* FF3.6-15 */\r\nbackground: -webkit-linear-gradient(top,   {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* Chrome10-25,Safari5.1-6 */\r\nbackground: linear-gradient(to bottom,   {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* W3C, IE10+, FF16+, Chrome26+, Opera12+, Safari7+ */\r\nfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\' {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=0 ); /* IE6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsBtn:hover,\r\n#ppsPopupShell_[ID] .ppsBtn:active {\r\n	[if bg_type_0 == \'color\']\r\n	/* Permalink - use to edit and share this gradient: http://colorzilla.com/gradient-editor/ [bg_color_0]+0,7db9e8+100 */\r\nbackground:  {{ adjust_brightness(popup.params.tpl.bg_color_0, -50) }}; /* Old browsers */\r\nbackground: -moz-linear-gradient(top,   [bg_color_0] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -50) }} 100%); /* FF3.6-15 */\r\nbackground: -webkit-linear-gradient(top,   [bg_color_0] 0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, -50) }} 100%); /* Chrome10-25,Safari5.1-6 */\r\nbackground: linear-gradient(to bottom,   [bg_color_0] 0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, -50) }} 100%); /* W3C, IE10+, FF16+, Chrome26+, Opera12+, Safari7+ */\r\nfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\' [bg_color_0]\', endColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, -50) }}\',GradientType=0 ); /* IE6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	box-shadow: 1px 2px 1px #333;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	display: inline !important;\r\n}","clear-popup.jpg","1","1","1","8","2015-01-10 18:59:43","21"),
("39","Video List Flat","1","0","a:3:{s:4:\"main\";a:27:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";s:24:\"hide_for_user_roles_show\";s:1:\"0\";}s:3:\"tpl\";a:56:{s:9:\"video_url\";s:43:\"https://www.youtube.com/watch?v=nKIu9yen5nc\";s:5:\"width\";s:3:\"824\";s:13:\"width_measure\";s:2:\"px\";s:6:\"height\";s:3:\"400\";s:14:\"height_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#ebebeb\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#066dab\";s:9:\"bg_type_2\";s:5:\"color\";s:8:\"bg_img_2\";s:0:\"\";s:10:\"bg_color_2\";s:7:\"#00063f\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#000000\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#585858\";s:15:\"responsive_mode\";s:3:\"def\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:27:\"close-black-in-white-circle\";s:11:\"layered_pos\";s:0:\"\";s:5:\"label\";s:59:\"Check video and <i style=\\"color: #c2252f;\\">subscribe!</i>\";s:13:\"enb_foot_note\";s:1:\"1\";s:9:\"foot_note\";s:118:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time \";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:8:\"Sign-up!\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_subject\";s:40:\"New Subscriber on My WordPress Test Site\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here is subscriber information:<br />[subscriber_data]\";}s:10:\"opts_attrs\";a:3:{s:9:\"bg_number\";s:1:\"3\";s:16:\"txt_block_number\";s:1:\"0\";s:21:\"video_height_as_popup\";s:1:\"1\";}}","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				<div style=\"clear: both;\"></div>\r\n			[endif]\r\n			<div class=\"ppsPopupVideo \">\r\n				[video_html]\r\n			</div>\r\n			<div style=\"clear: both;\"></div>\r\n		</div>\r\n		<div class=\"ppsRightCol\">\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			[if enb_sm]\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] iframe {\r\n	width: 100% !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 66%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n	font-family: \"Myriad Pro\",\"Trebuchet MS\",\"Helvetica Neue\",Helvetica,Arial,Sans-Serif;\r\n	font-size: 30px;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	letter-spacing: -1px;\r\n	font-weight: bold;\r\n	margin-top: 15px;\r\n	margin-bottom: 16px;\r\n	padding-left: 20px;\r\n	text-shadow: 0px 0px 1px #000;\r\n	-moz-text-shadow: 0px 0px 1px #000;\r\n	-webkit-text-shadow: 0px 0px 1px #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	display: table-cell;\r\n  	width: 34%;\r\n  	height: 100%;\r\n  	vertical-align: top;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}), color-stop(100%, [bg_color_1])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ie10+ */\r\n  background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}\', endColorstr=\'[bg_color_1]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 30px 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 5px;\r\n  	height: 40px;\r\n  	border: none;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 10px;\r\n  	font-size: 17px;\r\n  	background-color: #fff;\r\n  	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	margin-left: -5px;\r\n  	font-size: 17px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/mail-icon.png\");\r\n  	background-repeat: no-repeat;\r\n  	background-position: 90% center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	color: #fff;\r\n    font-size: 20px;\r\n    text-shadow: 2px 2px 2px #000;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupVideo {\r\n  	width: 100%;\r\n  	line-height: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}","video-list-flat.jpg","1","1","1","3","2015-01-10 18:59:43","17"),
("40","List Building Neo","1","0","a:3:{s:4:\"main\";a:27:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";s:24:\"hide_for_user_roles_show\";s:1:\"0\";}s:3:\"tpl\";a:62:{s:5:\"width\";s:3:\"824\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#f4f4f4\";s:9:\"bg_type_1\";s:3:\"img\";s:8:\"bg_img_1\";s:42:\"[PPS_ASSETS_URL]img/assets/new-form-bg.png\";s:10:\"bg_color_1\";s:7:\"#4d4d4d\";s:9:\"bg_type_2\";s:5:\"color\";s:8:\"bg_img_2\";s:0:\"\";s:10:\"bg_color_2\";s:7:\"#00eaea\";s:9:\"bg_type_3\";s:3:\"img\";s:8:\"bg_img_3\";s:44:\"[PPS_ASSETS_URL]img/assets/new-form-logo.png\";s:10:\"bg_color_3\";s:7:\"#c6c6c6\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#000000\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#000000\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#000000\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:20:\"circle_big_new_close\";s:7:\"bullets\";s:14:\"circle_big_new\";s:11:\"layered_pos\";s:0:\"\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:107:\"The Best WordPress PopUp optin plugin to help you gain more subscribers, social followers or advertisement.\";s:9:\"enb_txt_0\";s:1:\"1\";s:13:\"enb_foot_note\";s:1:\"1\";s:9:\"foot_note\";s:119:\"We respect your privacy.
Your information will not be shared with any third party and you can unsubscribe at any time \";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:8:\"SIGN-UP!\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_subject\";s:40:\"New Subscriber on My WordPress Test Site\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us subscriber information:<br />[subscriber_data]\";s:12:\"stat_ga_code\";s:0:\"\";s:5:\"txt_0\";s:381:\"<p>Popup by Supsystic lets you easily create elegant overlapping windows with unlimited features. Pop-ups with Slider, Lightbox, Contact and Subscription forms and more:</p><ul><li><strong>Unlimited Content Customization</strong></li><li><strong>Auto Open Popups</strong></li><li><strong>Contact Form with pop-up</strong></li><li><strong>Popup Opening Animatio</strong>ns</li></ul>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"4\";s:16:\"txt_block_number\";s:1:\"1\";}}","<link href=\"https://fonts.googleapis.com/css?family=Montserrat\" rel=\"stylesheet\"> \r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n		</div>\r\n		<div class=\"ppsRightCol\">\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			[if enb_sm]\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n          	[if bg_type_3 == \'img\']\r\n				<img src=\"[bg_img_3]\" class=\"ppsLogo\" />\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: \"Montserrat\",\"Trebuchet MS\",\"Helvetica Neue\",Helvetica,Arial,Sans-Serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #4d4d4d;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 66%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n  	vertical-align: top;\r\n  	padding: 30px 20px;\r\n	[if bg_type_0 == \'color\']\r\n	background-color: [bg_color_0];\r\n  	background-image: none;\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	font-size: 30px;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	margin-bottom: 15px;\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	display: table-cell;\r\n  	width: 34%;\r\n  	height: 100%;\r\n  	text-align: center;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}), color-stop(100%, [bg_color_1])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ie10+ */\r\n  background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}\', endColorstr=\'[bg_color_1]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-color: [bg_color_1];\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 30px 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: none;\r\n  	border-radius: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	padding-left: 10px;\r\n  	font-size: 17px;\r\n  	background-color: #fff;\r\n  	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	margin-left: -5px;\r\n  	font-size: 17px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	border-bottom: 3px solid {{ adjust_brightness(popup.params.tpl.bg_color_2, -50) }};\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	color: #fff;\r\n    font-size: 20px;\r\n  	cursor: pointer;\r\n  	padding: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 2px 2px 1px #555;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 ul {\r\n	padding: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #fff;\r\n    font-size: x-small;\r\n    line-height: 14px;\r\n  	margin: 5px 30px 15px;\r\n}\r\n#ppsPopupShell_[ID] .ppsLogo {\r\n	\r\n}","list-building-neo.jpg","1","1","1","1","2015-01-10 18:59:43","1"),
("41","Bright Girl","1","0","a:3:{s:4:\"main\";a:28:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:14:\"visit_page_cnt\";s:0:\"\";s:8:\"close_on\";s:10:\"user_close\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";s:24:\"hide_for_user_roles_show\";s:1:\"0\";}s:3:\"tpl\";a:71:{s:5:\"width\";s:3:\"800\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:4:\"#000\";s:14:\"bg_overlay_img\";s:0:\"\";s:18:\"bg_overlay_img_pos\";s:7:\"stretch\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:41:\"[PPS_ASSETS_URL]img/assets/background.jpg\";s:10:\"bg_color_0\";s:7:\"#990a22\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:39:\"[PPS_ASSETS_URL]img/assets/button-1.png\";s:10:\"bg_color_1\";s:7:\"#ffffff\";s:9:\"bg_type_2\";s:3:\"img\";s:8:\"bg_img_2\";s:37:\"[PPS_ASSETS_URL]img/assets/girl-2.png\";s:10:\"bg_color_2\";s:0:\"\";s:9:\"bg_type_3\";s:5:\"color\";s:8:\"bg_img_3\";s:0:\"\";s:10:\"bg_color_3\";s:7:\"#3d3d3d\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#ff4411\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#000000\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#979696\";s:15:\"responsive_mode\";s:3:\"def\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:27:\"close-black-in-white-circle\";s:7:\"bullets\";s:4:\"tick\";s:11:\"layered_pos\";s:0:\"\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:22:\"Subscribe and Get News\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"foot_note\";s:117:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:4:\"none\";s:14:\"anim_close_key\";s:0:\"\";s:13:\"anim_duration\";s:0:\"\";s:19:\"anim_close_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:23:\"sub_confirm_reload_time\";s:2:\"10\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";s:10:\"set_preset\";s:0:\"\";}s:5:\"email\";a:8:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:10:\"set_preset\";s:0:\"\";s:3:\"enb\";s:1:\"1\";}}s:9:\"blacklist\";s:0:\"\";s:15:\"blacklist_error\";s:26:\"Your email is in blacklist\";s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:25:\"strilezkijslawa@gmail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:25:\"strilezkijslawa@gmail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:2:\"Go\";s:13:\"sub_new_email\";s:25:\"strilezkijslawa@gmail.com\";s:15:\"sub_new_subject\";s:40:\"New Subscriber on My WordPress Test Site\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here is subscriber information:<br />[subscriber_data]\";s:12:\"stat_ga_code\";s:0:\"\";s:5:\"txt_0\";s:173:\"<p>Popup by Supsystic lets you easily create elegant overlapping windows with unlimited features. Pop-ups with Slider, Lightbox, Contact and Subscription forms and more.</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"4\";s:16:\"txt_block_number\";s:1:\"1\";}}","<link href=\"https://fonts.googleapis.com/css?family=Montserrat\" rel=\"stylesheet\">\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose\"></a>\r\n	<div class=\"ppsPopupListsInner\">\r\n		<div class=\"ppsPopupTblCols\">\r\n          	[if bg_type_2 == \'img\']\r\n			<div class=\"ppsPopupLeftCol\">\r\n				<img src=\"[bg_img_2]\" class=\"ppsLogo\" alt=\"\"/>\r\n			</div>\r\n          	[endif]\r\n			<div class=\"ppsPopupRightCol\">\r\n				<div class=\"ppsBigArrow\"></div>\r\n				[if enb_label]\r\n					<div class=\"ppsPopupLabel\">[label]</div>\r\n				[endif]\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupTxt_0\">[txt_0]</div>\r\n				[endif]\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: \"Montserrat\",Helvetica,Arial,sans-serif;\r\n  	font-size: 14px;\r\n  	[if bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[elseif bg_type_0 == \'color\']\r\n  	background: [bg_color_0];\r\nbackground: -moz-linear-gradient(left, [bg_color_0] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 80) }} 31%, rgba(201,3,49,1) 56%, rgba(201,3,49,1) 67%);\r\nbackground: -webkit-gradient(left top, right top, color-stop(0%, [bg_color_0]), color-stop(31%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 80) }}), color-stop(56%, rgba(201,3,49,1)), color-stop(67%, rgba(201,3,49,1)));\r\nbackground: -webkit-linear-gradient(left, [bg_color_0] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 80) }} 31%, rgba(201,3,49,1) 56%, rgba(201,3,49,1) 67%);\r\nbackground: -o-linear-gradient(left, [bg_color_0] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 80) }} 31%, rgba(201,3,49,1) 56%, rgba(201,3,49,1) 67%);\r\nbackground: -ms-linear-gradient(left, [bg_color_0] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 80) }} 31%, rgba(201,3,49,1) 56%, rgba(201,3,49,1) 67%);\r\nbackground: linear-gradient(to right, [bg_color_0] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 80) }} 31%, rgba(201,3,49,1) 56%, rgba(201,3,49,1) 67%);\r\nfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'[bg_color_0]\', endColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 80) }}\', GradientType=1 );\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #fff;\r\n    font-size: 31px;\r\n	line-height: 1.2;\r\n	text-align: center;\r\n  	margin-bottom: 50px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupListsInner {\r\n  	[if bg_type_0 == \'color\']\r\n    background: {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}; /* Old browsers */\r\n    background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* FF3.6+ */\r\n    background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%,[bg_color_0])); /* Chrome,Safari4+ */\r\n    background: -webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* Chrome10+,Safari5.1+ */\r\n    background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* Opera 12+ */\r\n    background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* IE10+ */\r\n    background: radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* W3C */\r\n    filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'#eaeaea\',GradientType=1 ); /* IE6-9 fallback on horizontal gradient */\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 .ppsTxtContent {\r\n	padding: 10px 10px 10px 50px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	font-size: 12px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTblCols {\r\n	display: table;\r\n  	padding: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLeftCol {\r\n	display: table-cell;\r\n    padding: 0;\r\n  	[if enb_subscribe]\r\n  	width: 40%;\r\n  	[else]\r\n  	width: 30%;\r\n  	min-height: 60%;\r\n  	[endif]\r\n  	vertical-align: top;\r\n}\r\n#ppsPopupShell_[ID] .ppsLogo {\r\n  	width: auto;\r\n  	height: auto;\r\n  	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupRightCol {\r\n    color: #fff;\r\n  	width: 60%;\r\n	display: table-cell;\r\n  	padding: 50px 40px 20px;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 50px 0;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 35px;\r\n  	border-radius: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	background: [bg_color_1];\r\n  	border: 1px solid transparent;\r\n  	color: #000;\r\n  	padding-left: 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	color: #fff;\r\n  	margin-left: -15px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding: 20px 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border: 1px solid #fff;\r\n  	[if bg_type_3 == \'color\']\r\n  	background: [bg_color_3];\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	color: #fff;\r\n    font-size: 20px;\r\n  	cursor: pointer;\r\n  	border-radius: 0;\r\n  	padding: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	right: -20px !important;\r\n	top: -10px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n  	[if enb_subscribe]\r\n    color: #979696;\r\n    font-size: xx-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n    text-align: left;\r\n  	margin-left: 10px;\r\n  	[else]\r\n  	margin-top: 10px;\r\n  	color: #979696;\r\n    font-size: xx-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n    text-align: left;\r\n    margin-left: 10px;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	[if enb_subscribe]\r\n  	[else]\r\n  	margin-top: 130px;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] li{\r\n	font-weight: bold;\r\n  	font-size: 13px;\r\n  	padding-top: 3px;\r\n	padding-bottom: 3px;\r\n  	color: #737E86;\r\n}\r\n@media screen and (max-width: 767px){\r\n  #ppsPopupShell_[ID] .ppsPopupLeftCol{\r\n    background-image: url([bg_img_2]);\r\n    background-repeat: no-repeat;\r\n    background-size: cover;\r\n    background-position: top center;\r\n  }\r\n  #ppsPopupShell_[ID] .ppsLogo{\r\n    opacity: 0;\r\n  }\r\n  #ppsPopupShell_[ID] .ppsPopupRightCol{\r\n    padding: 20px;\r\n  }\r\n  #ppsPopupShell_[ID] .ppsSubscribeShell form{\r\n    padding: 15px 0px 0;\r\n  }\r\n}","girl-2.jpg","1","1","1","1","2015-01-13 19:22:48","1"),
("42","Sign Up Classic","1","0","a:3:{s:4:\"main\";a:27:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";s:24:\"hide_for_user_roles_show\";s:1:\"0\";}s:3:\"tpl\";a:55:{s:5:\"width\";s:3:\"400\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:9:\"bg_type_0\";s:3:\"img\";s:8:\"bg_img_0\";s:49:\"[PPS_ASSETS_URL]img/assets/sign-up-classic-bg.png\";s:10:\"bg_color_0\";s:7:\"#c9ae94\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#9c8570\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#ffffff\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#f9e6ce\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#585858\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:11:\"while_close\";s:7:\"bullets\";s:11:\"lists_green\";s:11:\"layered_pos\";s:0:\"\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:31:\"Sign Up<br />To Our Newsletter!\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"foot_note\";s:118:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time \";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:4:\"boxy\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:7:\"SIGN UP\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_subject\";s:40:\"New Subscriber on My WordPress Test Site\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us subscriber information:<br />[subscriber_data]\";s:12:\"stat_ga_code\";s:0:\"\";s:5:\"txt_0\";s:172:\"<p>Popup by Supsystic lets you easily create elegant overlapping windows with unlimited features. Pop-ups with Slider, Lightbox, Contact and Subscription forms and more</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"2\";s:16:\"txt_block_number\";s:1:\"1\";}}","<link href=\"https://fonts.googleapis.com/css?family=Dancing+Script|Gloria+Hallelujah|Hind|Pacifico|Satisfy\" rel=\"stylesheet\"> \r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_sm]\r\n					<div style=\"clear: both;\"></div>\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: \"Hind\",\"arial\",arial;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #4d4d4d;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n  	width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  	width: 100%;\r\n  	display: table-cell;\r\n  	padding: 40px;\r\n	[if bg_type_0 == \'color\']\r\n	background-color: [bg_color_0];\r\n  	background-image: none;\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	font-family: \"Dancing Script\", arial;\r\n	font-size: 40px;\r\n	line-height: 40px;\r\n	font-weight: bold;\r\n  	margin-bottom: 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	margin-bottom: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: none;\r\n	border-radius: 0;\r\n  	font-size: 17px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	padding-left: 10px;\r\n  	\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n  	color: #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	margin-left: -4px;\r\n  	font-size: 17px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: [bg_color_1] 100%;\r\n  	background-image: none;\r\n  	border: 1px solid #fff;\r\n  	box-shadow: 0 0 0 4px [bg_color_1];\r\n  	width: calc(100% - 8px);\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	color: #fff;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n   border-width: 2px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	width: 100%;\r\n	font-size: 14px;\r\n  	margin-bottom: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n  	right: 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm {\r\n	margin-top:20px;\r\n}","sign-up-classic.jpg","1","1","1","1","2015-01-10 18:59:43","1")');
		}

if(!dbPps::exist('@__popup', 'id', '43')) {
			dbPps::query('INSERT INTO @__popup (id,label,active,original_id,params,html,css,img_preview,show_on,show_to,show_pages,type_id,date_created,sort_order) VALUES
("43","Smart New Edition","1","0","a:3:{s:4:\"main\";a:30:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:13:\"overlay_click\";s:26:\"close_on_after_action_time\";s:1:\"1\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";s:24:\"hide_for_user_roles_show\";s:1:\"0\";}s:3:\"tpl\";a:102:{s:5:\"width\";s:3:\"770\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:4:\"#000\";s:14:\"bg_overlay_img\";s:0:\"\";s:18:\"bg_overlay_img_pos\";s:7:\"stretch\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:43:\"[PPS_ASSETS_URL]img/assets/bg-form-main.png\";s:10:\"bg_color_0\";s:7:\"#aaaaaa\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:39:\"[PPS_ASSETS_URL]img/assets/button-1.png\";s:10:\"bg_color_1\";s:7:\"#ffffff\";s:9:\"bg_type_2\";s:3:\"img\";s:8:\"bg_img_2\";s:40:\"[PPS_ASSETS_URL]img/assets/form-book.png\";s:10:\"bg_color_2\";s:7:\"#e8e8e8\";s:9:\"bg_type_3\";s:5:\"color\";s:8:\"bg_img_3\";s:88:\"[PPS_SITE_URL]wp-content/uploads/2016/11/5_chrischung_hongkongpark-1-1-1-1-2-1-1-1-2.jpg\";s:10:\"bg_color_3\";s:7:\"#51dcde\";s:9:\"bg_type_4\";s:5:\"color\";s:8:\"bg_img_4\";s:0:\"\";s:10:\"bg_color_4\";s:7:\"#ffffff\";s:9:\"bg_type_5\";s:5:\"color\";s:8:\"bg_img_5\";s:0:\"\";s:10:\"bg_color_5\";s:7:\"#848484\";s:9:\"bg_type_6\";s:5:\"color\";s:8:\"bg_img_6\";s:0:\"\";s:10:\"bg_color_6\";s:7:\"#51dcde\";s:10:\"font_label\";s:10:\"Montserrat\";s:16:\"label_font_color\";s:7:\"#4d4c4c\";s:10:\"font_txt_0\";s:10:\"Montserrat\";s:17:\"text_font_color_0\";s:7:\"#4d4c4c\";s:11:\"font_footer\";s:10:\"Montserrat\";s:17:\"footer_font_color\";s:7:\"#979696\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:4:\"none\";s:7:\"bullets\";s:14:\"circle_big_new\";s:19:\"layer_rel_selectors\";s:0:\"\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:131:\"Get it <span class=\\"ppsHeaderTxt2\\">NOW!</span> Increase more than <span class=\\"ppsHeaderTxt2\\">700%</span> of Email Subscribers!\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"foot_note\";s:117:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:4:\"fade\";s:13:\"anim_duration\";s:4:\"1000\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:14:\"sub_v6_api_key\";s:0:\"\";s:16:\"sub_ymlp_api_key\";s:0:\"\";s:13:\"sub_ymlp_name\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";s:10:\"set_preset\";s:0:\"\";}s:5:\"email\";a:8:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:10:\"set_preset\";s:0:\"\";s:3:\"enb\";s:1:\"1\";}}s:9:\"blacklist\";s:0:\"\";s:15:\"blacklist_error\";s:26:\"Your email is in blacklist\";s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:11:\"Get it now!\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_subject\";s:28:\"New subscriber on [sitename]\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us subscriber information:<br />[subscriber_data]\";s:8:\"login_by\";s:8:\"username\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:5:\"Login\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:27:\"Thank you for registration!\";s:21:\"reg_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"reg_redirect_url\";s:0:\"\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"reg_txt_confirm_mail_message\";s:196:\"You registered on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your registration. If you did not register here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:14:\"admin@mail.com\";s:15:\"reg_new_message\";s:121:\"You have new member on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us member information:<br />[subscriber_data]\";s:12:\"stat_ga_code\";s:0:\"\";s:5:\"txt_0\";s:173:\"<p>Popup by Supsystic lets you easily create elegant overlapping windows with unlimited features. Pop-ups with Slider, Lightbox, Contact and Subscription forms and more.</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"7\";s:16:\"txt_block_number\";s:1:\"1\";}}","<link href=\"https://fonts.googleapis.com/css?family=Montserrat\" rel=\"stylesheet\">\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose\"></a>\r\n	<div class=\"ppsPopupListsInner\">\r\n		<div class=\"ppsPopupTblCols\">\r\n			<div class=\"ppsPopupLeftCol\">\r\n				[if bg_type_2 == \"img\"]\r\n				<img src=\"[bg_img_2]\" />\r\n				[endif]\r\n			</div>\r\n			<div class=\"ppsPopupRightCol\">\r\n				<div class=\"ppsBigArrow\"></div>\r\n				[if enb_label]\r\n					<div class=\"ppsPopupLabel\">[label]</div>\r\n				[endif]\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupTxt_0\">[txt_0]</div>\r\n				[endif]\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						<div class=\"ppsFormWrap\">\r\n						[sub_fields_html]\r\n						</div><!--\r\n						--><input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						[sub_form_end]\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: Helvetica,Arial,sans-serif;\r\n  	font-size: 14px;\r\n  	[if bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupListsInner {\r\n  	[if bg_type_0 == \"color\"]\r\n	background: {{ adjust_brightness(popup.params.tpl.bg_color_0, 255) }}; /* Old browsers */\r\n	background: -moz-linear-gradient(top,  {{ adjust_brightness(popup.params.tpl.bg_color_0, 255) }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 125) }} 50%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 60) }} 75%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 0) }} 100%); /* FF3.6-15 */\r\n	background: -webkit-linear-gradient(top,  {{ adjust_brightness(popup.params.tpl.bg_color_0, 255) }} 0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 125) }} 50%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 60) }} 75%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 0) }} 100%); /* Chrome10-25,Safari5.1-6 */\r\n	background: linear-gradient(to bottom,  {{ adjust_brightness(popup.params.tpl.bg_color_0, 255) }} 0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 125) }} 50%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 60) }} 75%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 0) }} 100%); /* W3C, IE10+, FF16+, Chrome26+, Opera12+, Safari7+ */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_0, 255) }}\", endColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_0, 0) }}\",GradientType=0 ); /* IE6-9 */\r\n	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTblCols {\r\n	display: table;\r\n  	padding: 10px 10px 10px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLeftCol {\r\n	display: table-cell;\r\n  	[if enb_subscribe]\r\n  	width: 30%;\r\n  	[else]\r\n  	width: 30%;\r\n  	min-height: 60%;\r\n  	[endif]\r\n  	vertical-align: middle;\r\n    text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupRightCol {\r\n  	width: 70%;\r\n	display: table-cell;\r\n  	border-radius: 8px;\r\n	-moz-border-radius: 8px;\r\n	-webkit-border-radius: 8px;\r\n  	margin: 8px 5px 5px 5px;\r\n  	text-align: left;\r\n  	padding: 30px 0 30px 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #838383;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-moz-placeholder { /* Firefox 19+ */\r\n    color: #838383;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input:-ms-input-placeholder { /* IE 10+ */\r\n    color: #838383;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input:-moz-placeholder { /* Firefox 18- */\r\n    color: #838383;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #838383;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea::-moz-placeholder { /* Firefox 19+ */\r\n    color: #838383;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea:-ms-input-placeholder { /* IE 10+ */\r\n    color: #838383;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea:-moz-placeholder { /* Firefox 18- */\r\n    color: #838383;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell {\r\n	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 0 0;\r\n  	text-align: left;\r\n    position: relative;\r\n}\r\n#ppsPopupShell_[ID] .ppsFormWrap {\r\n	display:inline-block;\r\n	width: 60%;\r\n	vertical-align: bottom;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"password\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	border: 1px solid transparent;\r\n	width: 100%;\r\n	-webkit-border-radius: 0px;\r\n	-moz-border-radius: 0px;\r\n	border-radius: 0px;\r\n	display:block;\r\n    font-size: 17px;\r\n	font-weight: normal;\r\n    color: #636363;\r\n	padding: 0 0 0 10px;\r\n	height: 40px;\r\n	margin: 10px 0 0 0;\r\n	\r\n  	[if bg_type_1 == \"img\"]\r\n  	background: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[else]\r\n  	background: [bg_color_1];\r\n  	[endif]\r\n  	\r\n  	[if bg_type_5 == \"color\"]\r\n  	color: [bg_color_5];\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	height: auto;\r\n	padding-top: 9px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeForm input:first-child {\r\n	margin-top: 0px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select  {\r\n	margin: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  {\r\n	display: block;\r\n	font-size: 17px;\r\n	color: #636363;\r\n	margin-top: 10px;\r\n	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  span {\r\n	display: block;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n  	[if bg_type_3 == \"color\"]\r\n  	background: [bg_color_3];\r\n	background-image: none;\r\n  	[elseif bg_type_3 == \"img\"]\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	\r\n  	[if bg_type_4 == \"color\"]\r\n  	color: [bg_color_4];\r\n  	[endif]\r\n	\r\n    font-size: 17px;\r\n	font-weight: normal;\r\n  	cursor: pointer;\r\n  	width:  auto;\r\n    text-transform: uppercase;\r\n  	padding: 0px 20px;\r\n	height: 40px;\r\n	display:inline-block;\r\n	border: 1px solid transparent;\r\n	-webkit-border-radius: 0px;\r\n	-moz-border-radius: 0px;\r\n	border-radius: 0px;\r\n	vertical-align: bottom;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	right: -5px;\r\n	top: 2px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 .ppsTxtContent {\r\n	padding: 10px 10px 10px 50px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 p {\r\n	margin: 0;\r\n	padding: 0;\r\n	font-family: Montserrat;\r\n	font-size: 16px;\r\n    line-height: 24px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	width: 90%;\r\n  	color: #4d4c4c;\r\n  	display: block;\r\n  	margin: 27px 0 0;\r\n    padding: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupRightCol .ppsHeaderTxt2 {\r\n  	[if bg_type_6 == \"color\"]\r\n  	color: [bg_color_6] !important;\r\n  	[endif]\r\n	margin: 0;\r\n    padding: 0;\r\n	font-weight: bold;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #4d4c4c;\r\n	line-height: 1.2;\r\n	margin: 0 10px 0 0;\r\n	color: #4d4c4c;\r\n	font-family: Montserrat;\r\n	font-size: 25px;\r\n    font-weight: normal;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n  	[if enb_subscribe]\r\n    color: #000000;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: xx-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n    text-align: left;\r\n  	margin-left: 10px;\r\n  	[else]\r\n  	margin-top: 10px;\r\n  	color: #979696;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: xx-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n    text-align: left;\r\n    margin-left: 10px;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	[if enb_subscribe]\r\n  	[else]\r\n  	margin-top: 130px;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] li{\r\n	font-weight: bold;\r\n  	font-size: 13px;\r\n  	padding-top: 3px;\r\n	padding-bottom: 3px;\r\n  	color: #737E86;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg{\r\n	clear: both;\r\n  	text-align: center;\r\n	width: 100%;\r\n}\r\n","smart2_p4.png","1","1","1","1","2015-01-13 19:22:48","1"),
("45","XMas Sale","1","0","a:3:{s:4:\"main\";a:31:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:14:\"visit_page_cnt\";s:0:\"\";s:8:\"close_on\";s:13:\"overlay_click\";s:26:\"close_on_after_action_time\";s:1:\"1\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";s:24:\"hide_for_user_roles_show\";s:1:\"0\";}s:3:\"tpl\";a:124:{s:5:\"width\";s:3:\"675\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:4:\"#000\";s:14:\"bg_overlay_img\";s:0:\"\";s:18:\"bg_overlay_img_pos\";s:7:\"stretch\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#ffffff\";s:9:\"bg_type_1\";s:3:\"img\";s:8:\"bg_img_1\";s:52:\"[PPS_ASSETS_URL]img/assets/2016-q359-xmas_ribbon.png\";s:10:\"bg_color_1\";s:7:\"#ffffff\";s:9:\"bg_type_2\";s:5:\"color\";s:8:\"bg_img_2\";s:0:\"\";s:10:\"bg_color_2\";s:7:\"#aed1de\";s:9:\"bg_type_3\";s:5:\"color\";s:8:\"bg_img_3\";s:0:\"\";s:10:\"bg_color_3\";s:7:\"#f4130f\";s:9:\"bg_type_4\";s:5:\"color\";s:8:\"bg_img_4\";s:0:\"\";s:10:\"bg_color_4\";s:7:\"#ffffff\";s:10:\"font_label\";s:10:\"Alex Brush\";s:16:\"label_font_color\";s:7:\"#ffffff\";s:10:\"font_txt_0\";s:12:\"Josefin Sans\";s:17:\"text_font_color_0\";s:7:\"#ffffff\";s:11:\"font_footer\";s:12:\"Josefin Sans\";s:17:\"footer_font_color\";s:7:\"#4f4f4f\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:4:\"none\";s:7:\"bullets\";s:8:\"pop_icon\";s:19:\"layer_rel_selectors\";s:0:\"\";s:11:\"layered_pos\";s:3:\"top\";s:5:\"label\";s:15:\"Christmas Party\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"foot_note\";s:118:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time \";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:4:\"boxy\";s:8:\"anim_key\";s:10:\"slide_down\";s:14:\"anim_close_key\";s:0:\"\";s:13:\"anim_duration\";s:0:\"\";s:19:\"anim_close_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:23:\"sub_confirm_reload_time\";s:2:\"10\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:16:\"sub_gr_cycle_day\";s:1:\"0\";s:13:\"sub_ic_app_id\";s:0:\"\";s:15:\"sub_ic_app_user\";s:0:\"\";s:15:\"sub_ic_app_pass\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:13:\"sub_sf_app_id\";s:0:\"\";s:14:\"sub_ck_api_key\";s:0:\"\";s:14:\"sub_mem_acc_id\";s:0:\"\";s:15:\"sub_mem_pud_key\";s:0:\"\";s:16:\"sub_mem_priv_key\";s:0:\"\";s:14:\"sub_sb_api_key\";s:0:\"\";s:14:\"sub_v6_api_key\";s:0:\"\";s:12:\"sub_vtig_url\";s:0:\"\";s:13:\"sub_vtig_name\";s:0:\"\";s:12:\"sub_vtig_key\";s:0:\"\";s:16:\"sub_ymlp_api_key\";s:0:\"\";s:13:\"sub_ymlp_name\";s:0:\"\";s:11:\"sub_4d_name\";s:0:\"\";s:11:\"sub_4d_pass\";s:0:\"\";s:16:\"sub_dms_api_user\";s:0:\"\";s:20:\"sub_dms_api_password\";s:0:\"\";s:13:\"sub_dms_optin\";s:7:\"Unknown\";s:15:\"sub_mm_username\";s:0:\"\";s:14:\"sub_mm_api_key\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";s:10:\"set_preset\";s:0:\"\";}s:5:\"email\";a:8:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:10:\"set_preset\";s:0:\"\";s:3:\"enb\";s:1:\"1\";}}s:13:\"capt_site_key\";s:0:\"\";s:15:\"capt_secret_key\";s:0:\"\";s:9:\"blacklist\";s:0:\"\";s:15:\"blacklist_error\";s:26:\"Your email is in blacklist\";s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:23:\"Empty  or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:15:\"admin@gmail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:15:\"admin@gmail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:17:\"GET YOUR DISCOUNT\";s:13:\"sub_new_email\";s:15:\"admin@gmail.com\";s:15:\"sub_new_subject\";s:29:\"New subscriber for [sitename]\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here is subscriber information:<br />[subscriber_data]\";s:8:\"login_by\";s:8:\"username\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:5:\"Login\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"Имя\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:74:\"A verification link has been sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:26:\"Thank you for registering!\";s:21:\"reg_txt_invalid_email\";s:23:\" Empty or invalid email\";s:16:\"reg_redirect_url\";s:0:\"\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:15:\"admin@gmail.com\";s:28:\"reg_txt_confirm_mail_message\";s:206:\"You are registered on the site <a href=\\"[siteurl]\\">[sitename]</a>. Follow  <a href=\\"[confirm_link]\\">this link</a> to complete the registration. If you are not registered here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:38:\"[sitename]  Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:15:\"admin@gmail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:62:\"Login: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:15:\"admin@gmail.com\";s:15:\"reg_new_message\";s:115:\"You have a new user on the site <a href=\\"[siteurl]\\">[sitename]</a>, here is the user info:<br />[subscriber_data]\";s:12:\"contact_form\";s:2:\"11\";s:12:\"stat_ga_code\";s:0:\"\";s:5:\"txt_0\";s:71:\"<p>We have something for EVERYONE on YOUR list. Save Up to 70% OFF!</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"5\";s:16:\"txt_block_number\";s:1:\"1\";}}","<link href=\"https://fonts.googleapis.com/css?family=Oxygen\" rel=\"stylesheet\">\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div class=\"ppsTopBgWrapper\">\r\n				<div class=\"ppsWrapImgWr\">\r\n					[if bg_type_1 == \"img\"]\r\n					<img src=\"[bg_img_1]\" class=\"ppsImgWr\"/>\r\n					[endif]\r\n				</div>\r\n				[if enb_label]\r\n					<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				[endif]\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n					[txt_0]\r\n					</div>\r\n				[endif]\r\n				<div class=\"ppsSnow\"></div>\r\n			</div>\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input class=\"butt\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_sm]\r\n				<div style=\"clear: both;\"></div>\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n				\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n			<div class=\"\"></div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: \"Oxygen\";\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n	[if bg_type_0 == \"color\"]\r\n	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	\r\n	position: relative;\r\n	text-align: center;\r\n	padding: 0 0 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n\r\n}\r\n\r\n/*For all Elements*/\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n    \r\n    color: #4f4f4f;\r\n	text-align: center;\r\n	border: 2px solid #aaa;\r\n	font-family: \"Oxygen\";\r\n	font-size: 16px;\r\n	font-weight: normal;\r\n	width: 100%;\r\n	display:block;\r\n	margin-top: 10px;\r\n	height: 45px;\r\n	\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	[if bg_type_4 == \"color\"]\r\n	background: [bg_color_4];\r\n  	[elseif bg_type_4 == \"img\"]\r\n  	background-image: url(\"[bg_img_4]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeForm input:first-child {\r\n	margin-top: 0px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	height: auto;\r\n	padding-top: 9px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select  {\r\n	display:inline-block;\r\n	margin-top: 0px\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  {\r\n	margin-top: 10px;\r\n	font-size: 16px;\r\n    color: #4f4f4f;\r\n	text-align: center;\r\n	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  span {\r\n	display: inline-block;\r\n	padding-right: 2px;\r\n	vertical-align: middle;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=radio],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=checkbox] {\r\n	vertical-align: middle;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email] {\r\n    \r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	display:block;\r\n	height: 45px;\r\n  	color: #fff;\r\n    font-size: 18px;\r\n	width: 100%;\r\n	margin: 10px 0;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	border: 0 solid transparent;\r\n  	cursor: pointer;\r\n	text-transform: none;\r\n	padding: 0;\r\n	font-weight: 700;\r\n	font-family: \"Oxygen\";\r\n	[if bg_type_3 == \"color\"]\r\n	background: [bg_color_3];\r\n  	[elseif bg_type_3 == \"img\"]\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell {\r\n    display: inline-block;\r\n    margin: 40px 0 0;\r\n    width: 40%;\r\n	position: relative;\r\n	z-index: 100;\r\n}\r\n#ppsPopupShell_[ID] .ppsTopBgWrapper {\r\n	[if bg_type_2 == \"color\"]\r\n	background: [bg_color_2];\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	\r\n	padding: 30px 0;\r\n	position: relative;\r\n}\r\n#ppsPopupShell_[ID] .ppsWrapImgWr {\r\n	display: inline-block;\r\n    text-align: center;\r\n    width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsImgWr {\r\n	display: inline-block;\r\n	max-width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	font-size: 50px;\r\n	font-family: \"Oxygen\";\r\n	position: relative;\r\n	z-index: 100;\r\n	width: 90%;\r\n	display: inline-block;\r\n	padding-top: 30px;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt {\r\n	margin: 0;\r\n	padding: 0;\r\n	text-align: center;\r\n	font-family: \"Oxygen\";\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt p {\r\n	display: inline-block;\r\n    margin: 0;\r\n    padding: 0;\r\n    width: 90%;\r\n	position: relative;\r\n	z-index: 100;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n    font-size: 20px;\r\n	padding-top: 30px;\r\n	font-weight: bold;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n    display: inline-block;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n	color: #4f4f4f;\r\n    margin: 5px 0px;\r\n    text-align: center;\r\n    width: 80%;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg{\r\n	clear: both;\r\n  	text-align: center;\r\n}","x-mas-sale.png","1","1","1","11","2015-01-10 18:59:43","45"),
("46","Merry Christmas","1","0","a:3:{s:4:\"main\";a:31:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:14:\"visit_page_cnt\";s:0:\"\";s:8:\"close_on\";s:13:\"overlay_click\";s:26:\"close_on_after_action_time\";s:1:\"1\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";s:24:\"hide_for_user_roles_show\";s:1:\"0\";}s:3:\"tpl\";a:117:{s:5:\"width\";s:3:\"700\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:4:\"#000\";s:14:\"bg_overlay_img\";s:0:\"\";s:18:\"bg_overlay_img_pos\";s:7:\"stretch\";s:9:\"bg_type_0\";s:3:\"img\";s:8:\"bg_img_0\";s:46:\"[PPS_ASSETS_URL]img/assets/2016_360_nyt_bg.png\";s:10:\"bg_color_0\";s:7:\"#ffffff\";s:9:\"bg_type_1\";s:3:\"img\";s:8:\"bg_img_1\";s:51:\"[PPS_ASSETS_URL]img/assets/2016_360_nyt_top_img.png\";s:10:\"bg_color_1\";s:7:\"#ffffff\";s:9:\"bg_type_2\";s:5:\"color\";s:8:\"bg_img_2\";s:0:\"\";s:10:\"bg_color_2\";s:7:\"#13316c\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#ffffff\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#f9e6ce\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#585858\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:4:\"none\";s:7:\"bullets\";s:11:\"lists_green\";s:19:\"layer_rel_selectors\";s:0:\"\";s:11:\"layered_pos\";s:3:\"top\";s:5:\"label\";s:0:\"\";s:9:\"foot_note\";s:118:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time \";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:4:\"boxy\";s:8:\"anim_key\";s:4:\"none\";s:14:\"anim_close_key\";s:0:\"\";s:13:\"anim_duration\";s:0:\"\";s:19:\"anim_close_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:23:\"sub_confirm_reload_time\";s:2:\"10\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:16:\"sub_gr_cycle_day\";s:1:\"0\";s:13:\"sub_ic_app_id\";s:0:\"\";s:15:\"sub_ic_app_user\";s:0:\"\";s:15:\"sub_ic_app_pass\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:13:\"sub_sf_app_id\";s:0:\"\";s:14:\"sub_ck_api_key\";s:0:\"\";s:14:\"sub_mem_acc_id\";s:0:\"\";s:15:\"sub_mem_pud_key\";s:0:\"\";s:16:\"sub_mem_priv_key\";s:0:\"\";s:14:\"sub_sb_api_key\";s:0:\"\";s:14:\"sub_v6_api_key\";s:0:\"\";s:12:\"sub_vtig_url\";s:0:\"\";s:13:\"sub_vtig_name\";s:0:\"\";s:12:\"sub_vtig_key\";s:0:\"\";s:16:\"sub_ymlp_api_key\";s:0:\"\";s:13:\"sub_ymlp_name\";s:0:\"\";s:11:\"sub_4d_name\";s:0:\"\";s:11:\"sub_4d_pass\";s:0:\"\";s:16:\"sub_dms_api_user\";s:0:\"\";s:20:\"sub_dms_api_password\";s:0:\"\";s:13:\"sub_dms_optin\";s:7:\"Unknown\";s:15:\"sub_mm_username\";s:0:\"\";s:14:\"sub_mm_api_key\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:5:\"email\";a:8:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:11:\"Your e-mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:10:\"set_preset\";s:0:\"\";s:3:\"enb\";s:1:\"1\";}s:4:\"name\";a:8:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:9:\"Your name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";s:10:\"set_preset\";s:0:\"\";}}s:13:\"capt_site_key\";s:0:\"\";s:15:\"capt_secret_key\";s:0:\"\";s:9:\"blacklist\";s:0:\"\";s:15:\"blacklist_error\";s:26:\"Your email is in blacklist\";s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:15:\"admin@gmail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:15:\"admin@gmail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:15:\"Join right now!\";s:13:\"sub_new_email\";s:15:\"admin@gmail.com\";s:15:\"sub_new_subject\";s:29:\"New Subscriber on  [sitename]\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here us subscriber information:<br />[subscriber_data]\";s:8:\"login_by\";s:8:\"username\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:5:\"Login\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"Имя\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:74:\"A verification link has been sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:26:\"Thank you for registering!\";s:21:\"reg_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"reg_redirect_url\";s:0:\"\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:15:\"admin@gmail.com\";s:28:\"reg_txt_confirm_mail_message\";s:205:\"You are registered on the site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete the registration. If you are not registered here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:38:\"[sitename]  Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:15:\"admin@gmail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:62:\"Login: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:15:\"admin@gmail.com\";s:15:\"reg_new_message\";s:116:\"You have a new user on the site <a href=\\"[siteurl]\\">[sitename]</a>, here is the user info: <br />[subscriber_data]\";s:12:\"contact_form\";s:2:\"11\";s:12:\"stat_ga_code\";s:0:\"\";s:5:\"txt_0\";s:0:\"\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"3\";s:16:\"txt_block_number\";s:1:\"1\";}}","<link href=\"https://fonts.googleapis.com/css?family=Gentium+Basic\" rel=\"stylesheet\">\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div class=\"ppsWrapTopImg\">\r\n				[if bg_type_1 == \"img\"]\r\n				<img src=\"[bg_img_1]\" class=\"ppsTopImg\"/>\r\n				[endif]\r\n			</div>\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsBottomCol\">\r\n				[if enb_sm]\r\n					<div style=\"clear: both;\"></div>\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: \"Gentium Basic\", arial;\r\n	font-size: 13px;\r\n	font-weight: normal;\r\n	color: #000;\r\n  	text-align: center;\r\n}\r\n\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n  	width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  	width: 100%;\r\n  	padding: 40px;\r\n	[if bg_type_0 == \"color\"]\r\n	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsWrapTopImg {\r\n	display: inline-block;\r\n    text-align: center;\r\n    width: 100%;\r\n	margin-bottom: 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsTopImg {\r\n	display: inline-block;\r\n	max-width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell {\r\n	min-height: 200px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	width: 60%;\r\n	display: inline-block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeForm input:first-child {\r\n	margin-top: 0px;\r\n}\r\n/*For all Elements*/\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: \"Gentium Basic\", arial;\r\n	font-size: 17px;\r\n	font-weight: normal;\r\n	border: 1px solid transparent;\r\n	width: 100%;\r\n	display: block;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	height: 41px;\r\n	margin: 10px 0 0;\r\n	text-transform: none;\r\n	\r\n	padding-left: 15px;\r\n	background-image: none;\r\n	background-repeat: no-repeat;\r\n  	background-color: #fff;\r\n	color: #13316c;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	margin: 0;\r\n	min-height: 41px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  {\r\n	font-family: \"Gentium Basic\", arial;\r\n	font-size: 17px;\r\n	font-weight: normal;\r\n	display: block;\r\n	margin: 10px 0 0;\r\n	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  span {\r\n	display: inline-block;\r\n	padding-right: 2px;\r\n	vertical-align: middle;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=radio],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=checkbox] {\r\n	vertical-align: middle;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	height: auto;\r\n	padding-top: 9px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password], \r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email] {\r\n	padding-left: 35px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/user-black-icon.png\");\r\n	background-position: 12px center;\r\n	\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/email-black-icon.png\");\r\n	background-position: 10px center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n  	[if bg_type_2 == \"color\"]\r\n	background: [bg_color_2];\r\n	background: -moz-linear-gradient(top, {{ adjust_brightness(popup.params.tpl.bg_color_2, 75) }} 26%, [bg_color_2] 100%);\r\n	background: -webkit-linear-gradient(top, {{ adjust_brightness(popup.params.tpl.bg_color_2, 75) }} 26%,[bg_color_2] 100%);\r\n	background: linear-gradient(to bottom, {{ adjust_brightness(popup.params.tpl.bg_color_2, 75) }} 26%,[bg_color_2] 100%);\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_2, 75) }}\", endColorstr=\"[bg_color_2]\",GradientType=0 );\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	height: 41px;\r\n	text-transform: none;\r\n	margin: 10px 0 0;\r\n	-webkit-box-shadow: 2px 2px 6px 2px rgba(0, 0, 0, 0.75);\r\n	-moz-box-shadow: 2px 2px 6px 2px rgba(0, 0, 0, 0.75);\r\n	box-shadow: 2px 2px 6px 2px rgba(0, 0, 0, 0.75);\r\n	padding: 0;\r\n  	cursor: pointer;\r\n	color: #fff;\r\n	font-size: 20px;\r\n	font-family: \"Gentium Basic\", arial;\r\n	font-weight: normal;\r\n	border: 1px solid transparent;\r\n	width: 100%;\r\n	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	-webkit-box-shadow: 2px 2px  7px 2px rgba(0, 0, 0, 0.75);\r\n	-moz-box-shadow: 2px 2px  7px 2px rgba(0, 0, 0, 0.75);\r\n	box-shadow: 2px 2px  7px 2px rgba(0, 0, 0, 0.75);\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	font-size: 40px;\r\n	line-height: 40px;\r\n	font-weight: bold;\r\n  	margin: 0 30px 30px;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	width: 100%;\r\n	font-size: 14px;\r\n  	margin: 0 30px 20px;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n  	right: 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n	color: #585858;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm {\r\n	margin-top:20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg {\r\n	margin: 0px;\r\n}","merry-christmas.png","1","1","1","11","2015-01-10 18:59:43","46"),
("47","Christmas Recipes","1","0","a:3:{s:4:\"main\";a:31:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:14:\"visit_page_cnt\";s:0:\"\";s:8:\"close_on\";s:13:\"overlay_click\";s:26:\"close_on_after_action_time\";s:1:\"1\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";s:24:\"hide_for_user_roles_show\";s:1:\"0\";}s:3:\"tpl\";a:131:{s:5:\"width\";s:3:\"438\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:4:\"#000\";s:14:\"bg_overlay_img\";s:0:\"\";s:18:\"bg_overlay_img_pos\";s:7:\"stretch\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#ffffff\";s:9:\"bg_type_1\";s:3:\"img\";s:8:\"bg_img_1\";s:39:\"[PPS_ASSETS_URL]img/assets/365-1-bg.png\";s:10:\"bg_color_1\";s:7:\"#ffffff\";s:9:\"bg_type_2\";s:5:\"color\";s:8:\"bg_img_2\";s:0:\"\";s:10:\"bg_color_2\";s:7:\"#020101\";s:9:\"bg_type_3\";s:5:\"color\";s:8:\"bg_img_3\";s:0:\"\";s:10:\"bg_color_3\";s:7:\"#ffb2b2\";s:10:\"font_label\";s:10:\"Alex Brush\";s:16:\"label_font_color\";s:7:\"#ffffff\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#ffffff\";s:10:\"font_txt_1\";s:7:\"default\";s:17:\"text_font_color_1\";s:7:\"#FFB2B2\";s:10:\"font_txt_2\";s:7:\"default\";s:17:\"text_font_color_2\";s:7:\"#333333\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#b7b7b7\";s:15:\"responsive_mode\";s:3:\"def\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:4:\"none\";s:7:\"bullets\";s:8:\"pop_icon\";s:19:\"layer_rel_selectors\";s:0:\"\";s:11:\"layered_pos\";s:3:\"top\";s:5:\"label\";s:15:\"Christmas Party\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"enb_txt_1\";s:1:\"1\";s:9:\"enb_txt_2\";s:1:\"1\";s:13:\"enb_foot_note\";s:1:\"1\";s:9:\"foot_note\";s:13:\"NO, THANK YOU\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:4:\"boxy\";s:8:\"anim_key\";s:4:\"none\";s:14:\"anim_close_key\";s:0:\"\";s:13:\"anim_duration\";s:0:\"\";s:19:\"anim_close_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:23:\"sub_confirm_reload_time\";s:2:\"10\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:16:\"sub_gr_cycle_day\";s:1:\"0\";s:13:\"sub_ic_app_id\";s:0:\"\";s:15:\"sub_ic_app_user\";s:0:\"\";s:15:\"sub_ic_app_pass\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:13:\"sub_sf_app_id\";s:0:\"\";s:14:\"sub_ck_api_key\";s:0:\"\";s:14:\"sub_mem_acc_id\";s:0:\"\";s:15:\"sub_mem_pud_key\";s:0:\"\";s:16:\"sub_mem_priv_key\";s:0:\"\";s:14:\"sub_sb_api_key\";s:0:\"\";s:14:\"sub_v6_api_key\";s:0:\"\";s:12:\"sub_vtig_url\";s:0:\"\";s:13:\"sub_vtig_name\";s:0:\"\";s:12:\"sub_vtig_key\";s:0:\"\";s:16:\"sub_ymlp_api_key\";s:0:\"\";s:13:\"sub_ymlp_name\";s:0:\"\";s:11:\"sub_4d_name\";s:0:\"\";s:11:\"sub_4d_pass\";s:0:\"\";s:16:\"sub_dms_api_user\";s:0:\"\";s:20:\"sub_dms_api_password\";s:0:\"\";s:13:\"sub_dms_optin\";s:7:\"Unknown\";s:15:\"sub_mm_username\";s:0:\"\";s:14:\"sub_mm_api_key\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";s:10:\"set_preset\";s:0:\"\";}s:5:\"email\";a:8:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:10:\"set_preset\";s:0:\"\";s:3:\"enb\";s:1:\"1\";}}s:13:\"capt_site_key\";s:0:\"\";s:15:\"capt_secret_key\";s:0:\"\";s:9:\"blacklist\";s:0:\"\";s:15:\"blacklist_error\";s:26:\"Your email is in blacklist\";s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:23:\"Empty  or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:15:\"admin@gmail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:15:\"admin@gmail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:8:\"DOWNLOAD\";s:13:\"sub_new_email\";s:15:\"admin@gmail.com\";s:15:\"sub_new_subject\";s:29:\"New subscriber for [sitename]\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here is subscriber information:<br />[subscriber_data]\";s:8:\"login_by\";s:8:\"username\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:5:\"Login\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"Имя\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:74:\"A verification link has been sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:26:\"Thank you for registering!\";s:21:\"reg_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"reg_redirect_url\";s:0:\"\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:15:\"admin@gmail.com\";s:28:\"reg_txt_confirm_mail_message\";s:206:\"You are registered on the site <a href=\\"[siteurl]\\">[sitename]</a>. Follow  <a href=\\"[confirm_link]\\">this link</a> to complete the registration. If you are not registered here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:38:\"[sitename]  Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:15:\"admin@gmail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:62:\"Login: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:15:\"admin@gmail.com\";s:15:\"reg_new_message\";s:116:\"You have a new user on the site <a href=\\"[siteurl]\\">[sitename]</a>, here is the user info: <br />[subscriber_data]\";s:12:\"contact_form\";s:2:\"11\";s:12:\"stat_ga_code\";s:0:\"\";s:5:\"txt_0\";s:16:\"<p>FREE DIET</p>\";s:5:\"txt_1\";s:16:\"<p>MEAL PLAN</p>\";s:5:\"txt_2\";s:42:\"<p>Low-Carp Recipes You’ll Fall For!</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"4\";s:16:\"txt_block_number\";s:1:\"3\";}}","<link href=\"https://fonts.google.com/?query=Open+sans&selection.family=Open+Sans:400,700\" rel=\"stylesheet\">\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div class=\"ppsTopBgWrapper\">\r\n				<div class=\"ppsWrapImgWr\">\r\n					[if enb_label]\r\n						<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n					[endif]\r\n					[if enb_txt_0]\r\n						<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n						[txt_0]\r\n						</div>\r\n					[endif]\r\n					[if enb_txt_1]\r\n						<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_1 ppsPopupTxt_1\">\r\n						[txt_1]\r\n						</div>\r\n					[endif]\r\n				</div>\r\n			</div>\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsBtmBgWrapper\">\r\n				[if enb_txt_2]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_2 ppsPopupTxt_2\">\r\n					[txt_2]\r\n					</div>\r\n				[endif]\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						[sub_fields_html]\r\n						<input class=\"butt\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						[if enb_foot_note]\r\n							<a href=\"#\" class=\"ppsFootNote ppsPopupClose\">\r\n							[foot_note]\r\n							</a>\r\n						[endif]\r\n						[sub_form_end]\r\n						<div style=\"clear: both;\"></div>\r\n					</div>\r\n				[endif]\r\n				<div style=\"clear: both;\"></div>\r\n				[if enb_sm]\r\n					<div style=\"clear: both;\"></div>\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n					\r\n				[endif]\r\n			</div>\r\n			<div class=\"ppsBtmLine\"></div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: \"Open Sans\", arial;\r\n	font-size: 13px;\r\n	line-height: normal;\r\n	font-weight: normal;\r\n	color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n	[if bg_type_0 == \"color\"]\r\n	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	\r\n	position: relative;\r\n	text-align: center;\r\n	padding: 0;\r\n}\r\n/*For all Elements*/\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	margin: 10px 0 0;\r\n	font-size: 16px;\r\n	font-family: \"Open Sans\", arial;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	border: 2px solid #ccc;\r\n	width: 100%;\r\n	display:block;\r\n	background: #fff;\r\n	color: #4f4f4f;\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeForm input:first-child {\r\n	margin-top: 0px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select  {\r\n	font-size: 16px;\r\n	font-family: \"Open Sans\", arial;\r\n	border: 2px solid #ccc;\r\n	display: inline-block;\r\n	background: #fff;\r\n	color: #4f4f4f;\r\n	text-align: center;\r\n	height: 45px;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  span {\r\n	display: inline-block;\r\n	padding-right: 2px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  {\r\n	color: #333333;\r\n    display: block;\r\n    margin: 10px 0 0;\r\n	font-size: 16px;\r\n	font-family: \"Open Sans\", arial;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email] {\r\n    height: 45px;\r\n}\r\n#ppsPopupShell_[ID] input[type=submit] {\r\n	font-family: \"Open Sans\", arial;\r\n	display:inline-block;\r\n  	color: #fff;\r\n    font-size: 18px;\r\n	width: auto;\r\n	margin: 10px 0;\r\n	-webkit-border-radius: 35px;\r\n	-moz-border-radius: 35px;\r\n	border-radius: 35px;\r\n	border: 0 solid transparent;\r\n  	cursor: pointer;\r\n	text-transform: none;\r\n	padding: 13px 88px 7px 60px;\r\n	font-weight: 700;\r\n	text-shadow: 1px 2px 0px #86B80E;\r\n	text-decoration: none;text-decoration: none;\r\n	\r\n	-webkit-box-shadow: 1px 4px 0 0 rgba(134, 184, 14, 1);\r\n	-moz-box-shadow: 1px 4px 0 0 rgba(134, 184, 14, 1);\r\n	box-shadow: 1px 4px 0 0 rgba(134, 184, 14, 1);\r\n\r\n	background-color: #9cd610;\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/365-1-arr-dwn.png\");\r\n    background-position: 79% 13px;\r\n    background-repeat: no-repeat;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input.butt + a.ppsPopupClose {\r\n	display: inline-block !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell {\r\n    display: inline-block;\r\n    margin: 20px 0 20px;\r\n    width: 60%;\r\n	position: relative;\r\n	z-index: 100;\r\n}\r\n#ppsPopupShell_[ID] .ppsTopBgWrapper {\r\n	[if bg_type_1 == \"color\"]\r\n	background: [bg_color_1];\r\n  	[elseif bg_type_1 == \"img\"]\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	\r\n	padding: 70px 0 0;\r\n	position: relative;\r\n}\r\n#ppsPopupShell_[ID] .ppsWrapImgWr {\r\n	[if bg_type_2 == \"color\"]\r\n	background: {{ hex_to_rgba_str(popup.params.tpl.bg_color_2, 0.5) }};\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	\r\n	display: inline-block;\r\n    min-height: 130px;\r\n    padding: 10px 0;\r\n    text-align: center;\r\n    width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsImgWr {\r\n	display: inline-block;\r\n	max-width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	font-size: 50px;\r\n	position: relative;\r\n	z-index: 100;\r\n	width: 90%;\r\n	display: inline-block;\r\n	padding-top: 30px;\r\n	font-family: \"Open Sans\", arial;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt {\r\n	margin: 0;\r\n	padding: 0;\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt p {\r\n	display: inline-block;\r\n    margin: 0;\r\n    padding: 0;\r\n    width: 90%;\r\n	position: relative;\r\n	z-index: 100;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n    font-size: 63px;\r\n    font-weight: bold;\r\n	font-family: \"Open Sans\", arial;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_1 {\r\n    color: #ffb2b2;\r\n    font-size: 56px;\r\n    font-weight: bold;\r\n    line-height: 51px;\r\n	font-family: \"Open Sans\", arial;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_2 {\r\n    color: #333333;\r\n    font-size: 21px;\r\n    font-weight: bold;\r\n	font-family: \"Open Sans\", arial;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsBtmBgWrapper {\r\n	padding: 20px 0 0;\r\n	position: relative;\r\n}\r\n#ppsPopupShell_[ID] .ppsBtnOne:hover {\r\n	text-decoration: none;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsBtmLine {\r\n	height: 5px;\r\n	\r\n	[if bg_type_3 == \"color\"]\r\n	background: {{ hex_to_rgba_str(popup.params.tpl.bg_color_3, 0.5) }} !important;\r\n  	[elseif bg_type_3 == \"img\"]\r\n  	background-image: url(\"[bg_img_3]\") !important;\r\n  	background-repeat: no-repeat !important; \r\n  	background-size: cover !important;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	z-index: 1000;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n	border-bottom: 2px dotted #b7b7b7;\r\n    color: #b7b7b7;\r\n	display: none !important;\r\n	margin: 10px 0;\r\n	text-decoration: none;	\r\n	background: none !important;\r\n	font-size: 16px;\r\n    height: auto !important;\r\n    position: static !important;\r\n    width: auto !important;\r\n	top: 0 !important;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote:hover {\r\n	text-decoration: none;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg{\r\n	clear: both;\r\n  	text-align: center;\r\n}","christmas-1-prev.png","1","1","1","11","2015-01-10 18:59:43","47"),
("48","Christmas mood","1","0","a:3:{s:4:\"main\";a:31:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:14:\"visit_page_cnt\";s:0:\"\";s:8:\"close_on\";s:10:\"user_close\";s:26:\"close_on_after_action_time\";s:1:\"1\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";s:24:\"hide_for_user_roles_show\";s:1:\"0\";}s:3:\"tpl\";a:125:{s:5:\"width\";s:3:\"500\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:4:\"#000\";s:14:\"bg_overlay_img\";s:0:\"\";s:18:\"bg_overlay_img_pos\";s:7:\"stretch\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#ffffff\";s:9:\"bg_type_1\";s:3:\"img\";s:8:\"bg_img_1\";s:44:\"[PPS_ASSETS_URL]img/assets/365-2-top-img.png\";s:10:\"bg_color_1\";s:7:\"#ffffff\";s:9:\"bg_type_2\";s:5:\"color\";s:8:\"bg_img_2\";s:0:\"\";s:10:\"bg_color_2\";s:7:\"#f4f4f4\";s:9:\"bg_type_3\";s:5:\"color\";s:8:\"bg_img_3\";s:0:\"\";s:10:\"bg_color_3\";s:7:\"#ef2821\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#333333\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#f2362d\";s:10:\"font_txt_1\";s:7:\"default\";s:17:\"text_font_color_1\";s:7:\"#333333\";s:10:\"font_txt_2\";s:7:\"default\";s:17:\"text_font_color_2\";s:7:\"#333333\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#016823\";s:15:\"responsive_mode\";s:3:\"def\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:9:\"red_close\";s:7:\"bullets\";s:8:\"pop_icon\";s:19:\"layer_rel_selectors\";s:0:\"\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:10:\"Save up to\";s:9:\"enb_txt_0\";s:1:\"1\";s:9:\"enb_txt_1\";s:1:\"1\";s:9:\"enb_txt_2\";s:1:\"1\";s:13:\"enb_foot_note\";s:1:\"1\";s:9:\"foot_note\";s:28:\"Countinue without 50% coupon\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:4:\"boxy\";s:8:\"anim_key\";s:10:\"slide_down\";s:13:\"anim_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:16:\"sub_gr_cycle_day\";s:1:\"0\";s:13:\"sub_ic_app_id\";s:0:\"\";s:15:\"sub_ic_app_user\";s:0:\"\";s:15:\"sub_ic_app_pass\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:13:\"sub_sf_app_id\";s:0:\"\";s:14:\"sub_ck_api_key\";s:0:\"\";s:14:\"sub_mem_acc_id\";s:0:\"\";s:15:\"sub_mem_pud_key\";s:0:\"\";s:16:\"sub_mem_priv_key\";s:0:\"\";s:14:\"sub_sb_api_key\";s:0:\"\";s:14:\"sub_v6_api_key\";s:0:\"\";s:12:\"sub_vtig_url\";s:0:\"\";s:13:\"sub_vtig_name\";s:0:\"\";s:12:\"sub_vtig_key\";s:0:\"\";s:16:\"sub_ymlp_api_key\";s:0:\"\";s:13:\"sub_ymlp_name\";s:0:\"\";s:11:\"sub_4d_name\";s:0:\"\";s:11:\"sub_4d_pass\";s:0:\"\";s:16:\"sub_dms_api_user\";s:0:\"\";s:20:\"sub_dms_api_password\";s:0:\"\";s:13:\"sub_dms_optin\";s:7:\"Unknown\";s:10:\"sub_fields\";a:6:{s:4:\"name\";a:7:{s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";s:10:\"set_preset\";s:0:\"\";}s:5:\"email\";a:8:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:11:\"Your e-mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:10:\"set_preset\";s:0:\"\";s:3:\"enb\";s:1:\"1\";}i:11;a:8:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:2:\"11\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:2:\"11\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"1\";s:9:\"mandatory\";s:1:\"0\";s:10:\"set_preset\";s:0:\"\";}i:22;a:8:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:2:\"22\";s:4:\"html\";s:8:\"textarea\";s:5:\"label\";s:2:\"22\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"1\";s:9:\"mandatory\";s:1:\"0\";s:10:\"set_preset\";s:0:\"\";}i:33;a:9:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:2:\"33\";s:4:\"html\";s:9:\"selectbox\";s:5:\"label\";s:2:\"33\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"1\";s:9:\"mandatory\";s:1:\"0\";s:10:\"set_preset\";s:0:\"\";s:7:\"options\";a:2:{i:0;a:2:{s:4:\"name\";s:6:\"asfasf\";s:5:\"label\";s:3:\"saf\";}i:1;a:2:{s:4:\"name\";s:6:\"asfasf\";s:5:\"label\";s:8:\"asfdasdf\";}}}i:55;a:8:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:2:\"55\";s:4:\"html\";s:8:\"checkbox\";s:5:\"label\";s:2:\"55\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"1\";s:9:\"mandatory\";s:1:\"0\";s:10:\"set_preset\";s:0:\"\";}}s:9:\"blacklist\";s:0:\"\";s:15:\"blacklist_error\";s:26:\"Your email is in blacklist\";s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:23:\"Empty  or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:17:\"screppi@gmail.loc\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:17:\"screppi@gmail.loc\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:7:\"Sign Up\";s:13:\"sub_new_email\";s:17:\"screppi@gmail.loc\";s:15:\"sub_new_subject\";s:29:\"New subscriber for [sitename]\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here is subscriber information:<br />[subscriber_data]\";s:9:\"enb_login\";s:1:\"1\";s:8:\"login_by\";s:8:\"username\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:5:\"Login\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"Имя\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:195:\"Ссылка для подтверждения был отправлена на ваш адрес электронной почты. Проверьте вашу электронную почту!\";s:15:\"reg_txt_success\";s:43:\"Спасибо за регистрацию!\";s:21:\"reg_txt_invalid_email\";s:58:\"Пустой или недействительный email\";s:16:\"reg_redirect_url\";s:0:\"\";s:28:\"reg_txt_confirm_mail_subject\";s:61:\"Подтвердите регистрацию на [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:17:\"screppi@gmail.loc\";s:28:\"reg_txt_confirm_mail_message\";s:334:\"Вы зарегистрированы на сайте <a href=\\"[siteurl]\\">[sitename]</a>. Следуйте  <a href=\\"[confirm_link]\\">this link</a> для завершения регистрации. Если вы не зарегистрировались здесь - просто игнорируйте это сообщение.\";s:31:\"reg_txt_subscriber_mail_subject\";s:45:\"[sitename]  Ваш логин и пароль\";s:28:\"reg_txt_subscriber_mail_from\";s:17:\"screppi@gmail.loc\";s:31:\"reg_txt_subscriber_mail_message\";s:71:\"Логин: [user_login]<br />Пароль: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:17:\"screppi@gmail.loc\";s:15:\"reg_new_message\";s:177:\"У вас новый пользователь на сайте <a href=\\"[siteurl]\\">[sitename]</a>, вот информация пользователя: <br />[subscriber_data]\";s:12:\"stat_ga_code\";s:0:\"\";s:5:\"txt_0\";s:13:\"<p>50%OFF</p>\";s:5:\"txt_1\";s:37:\"<p>Instant  access to the coupon</p>\";s:5:\"txt_2\";s:110:\"<p>By clicking \\"Sign Up\\" you agree<br /> to <a class=\\"ppsTxt3Link\\" href=\\"#\\">Terms and Conditions</a></p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"4\";s:16:\"txt_block_number\";s:1:\"3\";}}","<link href=\"https://fonts.googleapis.com/css?family=Alex+Brush|Josefin+Sans\" rel=\"stylesheet\">\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div class=\"ppsWrapTopImg\">\r\n				[if bg_type_1 == \"img\"]\r\n				<img src=\"[bg_img_1]\" class=\"ppsTopImg\"/>\r\n				[endif]\r\n			</div>\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n				<div class=\"ppsTxt1Separator\"></div>\r\n			[endif]\r\n			[if enb_txt_1]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_1 ppsPopupTxt_1\">\r\n				[txt_1]\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input class=\"butt\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			[if enb_txt_2]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_2 ppsPopupTxt_2\">\r\n				[txt_2]\r\n				</div>\r\n			[endif]\r\n			<div class=\"ppsTxt1Separator\"></div>\r\n			[if enb_foot_note]\r\n				<a href=\"#\" class=\"ppsFootNote ppsPopupClose\">\r\n				[foot_note]\r\n				</a>\r\n			[endif]\r\n			\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_sm]\r\n				<div style=\"clear: both;\"></div>\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: arial;\r\n	font-size: 13px;\r\n	font-weight: normal;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n}\r\n\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n	[if bg_type_0 == \"color\"]\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\", endColorstr=\"[bg_color_0]\",GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	\r\n	position: relative;\r\n	text-align: center;\r\n	padding: 0 0 40px;\r\n	[if bg_type_3 == \"color\"]\r\n	border: 3px solid [bg_color_3];\r\n	[endif]\r\n	\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell{\r\n    display: inline-block;\r\n    margin: 0;\r\n    width: 60%;\r\n	position: relative;\r\n	z-index: 100;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeForm input:first-child {\r\n	margin-top: 0px;\r\n}\r\n/*For all Elements*/\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n	-webkit-border-radius: 0px;\r\n	-moz-border-radius: 0px;\r\n	border-radius: 0px;\r\n	border: 1px solid transparent;\r\n	height: 47px;\r\n	padding: 0;\r\n	margin: 10px 0;\r\n	display:block;\r\n	text-align: center;\r\n	color: #016823;\r\n	font-weight: normal;\r\n	font-size: 18px;\r\n	font-family: arial;\r\n	\r\n	[if bg_type_2 == \"color\"]\r\n	background: [bg_color_2];\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	margin: 0px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea { \r\n	height: auto;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  {\r\n	display:block;\r\n	margin: 10px 0 0;\r\n	color: #016823;\r\n	font-weight: normal;\r\n	font-size: 18px;\r\n	font-family: arial;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  span {\r\n	display: inline-block;\r\n	padding-right: 2px;\r\n	vertical-align: middle;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=radio],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=checkbox] {\r\n	vertical-align: middle;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email] {\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #016823;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-moz-placeholder { /* Firefox 19+ */\r\n    color: #016823;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell inpu:-ms-input-placeholder { /* IE 10+ */\r\n    color: #016823;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input:-moz-placeholder { /* Firefox 18- */\r\n    color: #016823;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	\r\n	width: 100%;\r\n	-webkit-border-radius: 0px;\r\n	-moz-border-radius: 0px;\r\n	border-radius: 0px;\r\n	border: 1px solid transparent;\r\n	height: 47px;\r\n	padding: 0;\r\n	margin: 10px 0;\r\n	text-align: center;\r\n	font-family: arial;\r\n	\r\n  	color: #fff;\r\n  	cursor: pointer;\r\n	text-transform: none;\r\n	font-weight: 700;\r\n	font-size: 20px;\r\n	display: inline-block;\r\n	border: 1px solid transparent;\r\n	\r\n	background-color: #016823;\r\n    background-image: url(\"[PPS_ASSETS_URL]img/assets/365-2-right-arr.png\");\r\n    background-position: 90% center;\r\n    background-repeat: no-repeat;\r\n}\r\n#ppsPopupShell_[ID] .ppsWrapTopImg {\r\n	display: inline-block;\r\n    text-align: center;\r\n    width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsTopImg {\r\n	display: inline-block;\r\n	max-width: 70%;\r\n}\r\n\r\n\r\n\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	font-family: arial;\r\n	font-size: 35px;\r\n	padding: 20px 20px 0; \r\n	text-align: center;\r\n	line-height: 45px;\r\n	position: relative;\r\n	z-index: 100;\r\n	color: #333333;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt {\r\n	font-family: arial;\r\n	margin: 0;\r\n	padding: 0;\r\n	text-align: center;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt p {\r\n	display: inline-block;\r\n    margin: 0;\r\n    padding: 0;\r\n    width: 90%;\r\n	position: relative;\r\n	z-index: 100;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n    color: #f2362d;\r\n    font-size: 70px;\r\n    font-weight: bold;\r\n    line-height: 60px;\r\n    margin: 10px 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_1 {\r\n    color: #333333;\r\n    font-size: 18px;\r\n    padding: 10px 0;\r\n}\r\n\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_2 {\r\n	display: block;\r\n    font-size: 16px;\r\n    margin: 0 auto 15px;\r\n    text-align: center;\r\n    width: 90%;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_2 a {\r\n	color: #f44b44;\r\n	text-decoration: none;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_2 a:hover {\r\n	text-decoration: none;\r\n}\r\n\r\n\r\n#ppsPopupShell_[ID] .ppsTxt1Separator {\r\n	background-color: #cccccc;\r\n    display: block;\r\n    height: 1px;\r\n    margin: 0 auto;\r\n    width: 15%;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n	z-index: 1000 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n    background: none !important;\r\n    border-bottom: 2px solid #016823;\r\n    color: #016823;\r\n    display: inline-block !important;\r\n    font-size: 16px;\r\n    height: auto !important;\r\n    margin: 10px 0;\r\n    position: static !important;\r\n    text-decoration: none;\r\n    top: 0 !important;\r\n    width: auto !important;\r\n	\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg{\r\n	clear: both;\r\n  	text-align: center;\r\n}\r\n","christmas-2-prev.png","1","1","1","11","2015-01-10 18:59:43","48"),
("49","Let it Snow","1","0","a:3:{s:4:\"main\";a:31:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:14:\"visit_page_cnt\";s:0:\"\";s:8:\"close_on\";s:10:\"user_close\";s:26:\"close_on_after_action_time\";s:1:\"1\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";s:24:\"hide_for_user_roles_show\";s:1:\"0\";}s:3:\"tpl\";a:123:{s:5:\"width\";s:3:\"700\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:4:\"#000\";s:14:\"bg_overlay_img\";s:0:\"\";s:18:\"bg_overlay_img_pos\";s:7:\"stretch\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#ffffff\";s:9:\"bg_type_1\";s:3:\"img\";s:8:\"bg_img_1\";s:44:\"[PPS_ASSETS_URL]img/assets/365-3-top-img.png\";s:10:\"bg_color_1\";s:7:\"#3d3d3d\";s:9:\"bg_type_2\";s:5:\"color\";s:8:\"bg_img_2\";s:0:\"\";s:10:\"bg_color_2\";s:7:\"#ffffff\";s:9:\"bg_type_3\";s:5:\"color\";s:8:\"bg_img_3\";s:0:\"\";s:10:\"bg_color_3\";s:7:\"#ffe001\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#ffffff\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#ffffff\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#cbcbcb\";s:15:\"responsive_mode\";s:3:\"def\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:11:\"classy_grey\";s:7:\"bullets\";s:8:\"pop_icon\";s:19:\"layer_rel_selectors\";s:0:\"\";s:11:\"layered_pos\";s:3:\"top\";s:5:\"label\";s:10:\"Save up to\";s:9:\"enb_txt_0\";s:1:\"1\";s:13:\"enb_foot_note\";s:1:\"1\";s:9:\"foot_note\";s:32:\"No, thank you. I’m good  to go\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:4:\"boxy\";s:8:\"anim_key\";s:10:\"slide_down\";s:14:\"anim_close_key\";s:0:\"\";s:13:\"anim_duration\";s:0:\"\";s:19:\"anim_close_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:23:\"sub_confirm_reload_time\";s:2:\"10\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:16:\"sub_gr_cycle_day\";s:1:\"0\";s:13:\"sub_ic_app_id\";s:0:\"\";s:15:\"sub_ic_app_user\";s:0:\"\";s:15:\"sub_ic_app_pass\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:13:\"sub_sf_app_id\";s:0:\"\";s:14:\"sub_ck_api_key\";s:0:\"\";s:14:\"sub_mem_acc_id\";s:0:\"\";s:15:\"sub_mem_pud_key\";s:0:\"\";s:16:\"sub_mem_priv_key\";s:0:\"\";s:14:\"sub_sb_api_key\";s:0:\"\";s:14:\"sub_v6_api_key\";s:0:\"\";s:12:\"sub_vtig_url\";s:0:\"\";s:13:\"sub_vtig_name\";s:0:\"\";s:12:\"sub_vtig_key\";s:0:\"\";s:16:\"sub_ymlp_api_key\";s:0:\"\";s:13:\"sub_ymlp_name\";s:0:\"\";s:11:\"sub_4d_name\";s:0:\"\";s:11:\"sub_4d_pass\";s:0:\"\";s:16:\"sub_dms_api_user\";s:0:\"\";s:20:\"sub_dms_api_password\";s:0:\"\";s:13:\"sub_dms_optin\";s:7:\"Unknown\";s:15:\"sub_mm_username\";s:0:\"\";s:14:\"sub_mm_api_key\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:7:{s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";s:10:\"set_preset\";s:0:\"\";}s:5:\"email\";a:8:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:11:\"Your e-mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:10:\"set_preset\";s:0:\"\";s:3:\"enb\";s:1:\"1\";}}s:13:\"capt_site_key\";s:0:\"\";s:15:\"capt_secret_key\";s:0:\"\";s:9:\"blacklist\";s:0:\"\";s:15:\"blacklist_error\";s:26:\"Your email is in blacklist\";s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:23:\"Empty  or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:15:\"admin@gmail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:15:\"admin@gmail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:35:\"YES, I want to get more Subscribers\";s:13:\"sub_new_email\";s:15:\"admin@gmail.com\";s:15:\"sub_new_subject\";s:29:\"New subscriber for [sitename]\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here is subscriber information:<br />[subscriber_data]\";s:8:\"login_by\";s:8:\"username\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:5:\"Login\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"Имя\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:74:\"A verification link has been sent to your email address. Check your email!\";s:15:\"reg_txt_success\";s:26:\"Thank you for registering!\";s:21:\"reg_txt_invalid_email\";s:22:\"Empty or invalid email\";s:16:\"reg_redirect_url\";s:0:\"\";s:28:\"reg_txt_confirm_mail_subject\";s:34:\"Confirm registration on [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:15:\"admin@gmail.com\";s:28:\"reg_txt_confirm_mail_message\";s:205:\"You are registered on the site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete the registration. If you are not registered here - just ignore this message.\";s:31:\"reg_txt_subscriber_mail_subject\";s:38:\"[sitename]  Your username and password\";s:28:\"reg_txt_subscriber_mail_from\";s:15:\"admin@gmail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:62:\"Login: [user_login]<br />Password: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:15:\"admin@gmail.com\";s:15:\"reg_new_message\";s:116:\"You have a new user on the site <a href=\\"[siteurl]\\">[sitename]</a>, here is the user info: <br />[subscriber_data]\";s:12:\"contact_form\";s:2:\"11\";s:12:\"stat_ga_code\";s:0:\"\";s:5:\"txt_0\";s:123:\"<p>Do You Want To<strong> Increase</strong> <br />Your Subscribers <br /><strong>Up To 700%</strong> <strong>?</strong></p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"4\";s:16:\"txt_block_number\";s:1:\"1\";}}","<link href=\"https://fonts.googleapis.com/css?family=Alex+Brush|Josefin+Sans\" rel=\"stylesheet\">\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div class=\"ppsWrapTopImg\">\r\n				[if enb_label]\r\n					<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				[endif]\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n					[txt_0]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input class=\"butt\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[if enb_foot_note]\r\n						<a href=\"#\" class=\"ppsFootNote ppsPopupClose\">\r\n						[foot_note]\r\n						</a>\r\n					[endif]\r\n					\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_sm]\r\n				<div style=\"clear: both;\"></div>\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: arial;\r\n	font-size: 13px;\r\n	font-weight: normal;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n	[if bg_type_0 == \"color\"]\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\", endColorstr=\"[bg_color_0]\",GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	\r\n	position: relative;\r\n	text-align: center;\r\n	padding: 0 0 40px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsWrapTopImg {\r\n	[if bg_type_1 == \"color\"]\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}), color-stop(100%, [bg_color_1])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}\", endColorstr=\"[bg_color_1]\",GradientType=1 ); /* ie6-9 */\r\n	[elseif bg_type_1 == \"img\"]\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-position: center bottom;\r\n    background-repeat: no-repeat;\r\n    background-size: cover;\r\n  	[endif]\r\n	\r\n	min-height: 210px;\r\n    padding: 40px 0 85px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell{\r\n    display: inline-block;\r\n    margin: 0;\r\n	position: relative;\r\n	z-index: 100;\r\n	width: 90%;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	position: relative;\r\n	padding: 5px 0;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input {\r\n	width: 100%;\r\n	-webkit-border-radius: 0px;\r\n	-moz-border-radius: 0px;\r\n	border-radius: 0px;\r\n	border: 0 solid transparent;\r\n	height: 47px;\r\n	padding: 0;\r\n	margin: 0;\r\n	display:block;\r\n	font-family: arial;\r\n	text-align: center;\r\n}\r\n\r\n/*For all Elements*/\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	border: 1px solid #01a2ea;\r\n    color: #777777;\r\n    font-size: 18px;\r\n	font-family: arial;\r\n	font-weight: normal;\r\n    height: 45px;\r\n    padding: 0 20px;\r\n	width: 100%;\r\n	display:block;\r\n	text-align: center;\r\n	margin-top: 10px;\r\n	\r\n	[if bg_type_2 == \"color\"]\r\n	background: [bg_color_2];\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	margin-top: 0px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeForm input:first-child {\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select  {\r\n\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  {\r\n	font-size: 18px;\r\n	font-family: arial;\r\n	font-weight: normal;\r\n	margin-top: 10px;\r\n	display:block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  span {\r\n	display: inline-block;\r\n	padding-right: 2px;\r\n	vertical-align: middle;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=radio],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=checkbox] {\r\n	vertical-align: middle;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email] {\r\n	border: 1px solid #01a2ea;\r\n    color: #777777;\r\n    font-size: 18px;\r\n    height: auto;\r\n    padding: 20px 20px 50px;\r\n	margin-top: 10px;\r\n	\r\n	[if bg_type_2 == \"color\"]\r\n	background: [bg_color_2];\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input + input:not([type=hidden]):not([type=\"submit\"]){\r\n 	padding: 20px 20px 50px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border: 10px solid #fff;\r\n  	color: #333333;\r\n  	cursor: pointer;\r\n	font-weight: 600;\r\n	font-size: 20px;\r\n	height: auto;\r\n	display: inline-block;\r\n	padding: 15px 0 13px;\r\n	-webkit-border-radius: 20px;\r\n	-moz-border-radius: 20px;\r\n	border-radius: 20px;\r\n    text-transform: none;\r\n	left: 5%;\r\n    width: 90%;\r\n  	position: absolute;\r\n  	transform: translateY(-50%);\r\n	\r\n	[if bg_type_3 == \"color\"]\r\n	background: [bg_color_3] !important;\r\n  	[elseif bg_type_3 == \"img\"]\r\n  	background-image: url(\"[bg_img_3]\") !important;\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email]::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #999999;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email]::-moz-placeholder { /* Firefox 19+ */\r\n    color: #999999;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email]:-ms-input-placeholder { /* IE 10+ */\r\n    color: #999999;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email]:-moz-placeholder { /* Firefox 18- */\r\n    color: #999999;\r\n}\r\n\r\n\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	font-family: arial;\r\n	font-size: 35px;\r\n	padding: 20px 20px 0; \r\n	text-align: center;\r\n	line-height: 45px;\r\n	position: relative;\r\n	z-index: 100;\r\n	color: #fff;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt {\r\n	font-family: arial;\r\n	margin: 0;\r\n	padding: 0;\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt p {\r\n	display: inline-block;\r\n    margin: 0;\r\n    padding: 0;\r\n    width: 90%;\r\n	position: relative;\r\n	z-index: 100;\r\n	word-wrap: break-word;\r\n	line-height: 50px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n    color: #fff;\r\n    font-size: 53px;\r\n    line-height: 50px;\r\n    margin: 10px 0;\r\n	text-shadow: 2px 2px 0 #01a2ea;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] + .ppsFootNote {\r\n	display: inline-block !important;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n	-webkit-border-radius: 10px;\r\n	-moz-border-radius: 10px;\r\n	border-radius: 10px;\r\n	\r\n	background: none !important;\r\n	border: 2px solid #cbcbcb;\r\n    color: #cbcbcb;\r\n    display: none !important;\r\n    font-size: 16px;\r\n	font-weight: bold;\r\n    height: auto !important;\r\n    margin: 40px 30px 0;\r\n	padding: 5px 20px;\r\n    position: static !important;\r\n    text-decoration: none;\r\n    top: 0 !important;\r\n    width: auto !important;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n	z-index: 1000 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg{\r\n	clear: both;\r\n  	text-align: center;\r\n}\r\n","christmas-3-prev.png","1","1","1","11","2015-01-10 18:59:43","49")');
		}
		if(dbPps::get('SELECT COUNT(*) AS total FROM @__popup WHERE id = 5 AND original_id = 0', 'one')) {
			dbPps::query('UPDATE @__popup SET label="Video List", active = "1", original_id="0", params="a:3:{s:4:\"main\";a:27:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";s:24:\"hide_for_user_roles_show\";s:1:\"0\";}s:3:\"tpl\";a:63:{s:9:\"video_url\";s:43:\"https://www.youtube.com/watch?v=nKIu9yen5nc\";s:5:\"width\";s:3:\"824\";s:13:\"width_measure\";s:2:\"px\";s:6:\"height\";s:3:\"400\";s:14:\"height_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:4:\"#000\";s:14:\"bg_overlay_img\";s:0:\"\";s:18:\"bg_overlay_img_pos\";s:7:\"stretch\";s:9:\"bg_type_0\";s:4:\"none\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#ffffff\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#3bd0d0\";s:9:\"bg_type_2\";s:5:\"color\";s:8:\"bg_img_2\";s:0:\"\";s:10:\"bg_color_2\";s:7:\"#0e6868\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#015050\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#015050\";s:15:\"responsive_mode\";s:3:\"def\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:11:\"classy_grey\";s:11:\"layered_pos\";s:0:\"\";s:5:\"label\";s:26:\"Check video and subscribe!\";s:13:\"enb_foot_note\";s:1:\"1\";s:9:\"foot_note\";s:118:\"We respect your privacy. Your information will not be shared with any third party and you can unsubscribe at any time \";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:8:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";s:10:\"set_preset\";s:0:\"\";}s:5:\"email\";a:8:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:10:\"set_preset\";s:0:\"\";s:3:\"enb\";s:1:\"1\";}}s:9:\"blacklist\";s:0:\"\";s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:7:\"SIGN-UP\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_subject\";s:28:\"New subscriber on [sitename]\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here is subscriber information:<br />[subscriber_data]\";s:12:\"contact_form\";s:2:\"19\";s:12:\"stat_ga_code\";s:0:\"\";}s:10:\"opts_attrs\";a:3:{s:9:\"bg_number\";s:1:\"3\";s:16:\"txt_block_number\";s:1:\"0\";s:21:\"video_height_as_popup\";s:1:\"1\";}}",html="<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div class=\"ppsPopupVideo \">\r\n				[video_html]\r\n			</div>\r\n			<div style=\"clear: both;\"></div>\r\n		</div>\r\n		<div class=\"ppsRightCol\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				<div style=\"clear: both;\"></div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			[if enb_sm]\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>",css="#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 0;\r\n  	font-family: arial;\r\n	font-size: 13px;\r\n	line-height: normal;\r\n	font-weight: normal;\r\n	color: #015050;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] iframe {\r\n	width: 100% !important;\r\n	margin: 0;\r\n    padding: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n	display: table-cell;\r\n	vertical-align: middle;\r\n	\r\n	{% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 66%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n\r\n	[if bg_type_0 == \"color\"]\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\", endColorstr=\"[bg_color_0]\",GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n	background-position: center top;\r\n	[else]\r\n	background: none;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	display: table-cell;\r\n  	width: 34%;\r\n  	height: 100%;\r\n  	vertical-align: middle;\r\n	padding: 15px 0;\r\n	margin: 0;\r\n	\r\n  	[if bg_type_1 == \"color\"]\r\n  	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}), color-stop(100%, [bg_color_1])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}\", endColorstr=\"[bg_color_1]\",GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_1 == \"img\"]\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n	background-position: center top;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 15px 30px 0;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-moz-placeholder { /* Firefox 19+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input:-ms-input-placeholder { /* IE 10+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input:-moz-placeholder { /* Firefox 18- */\r\n    color: #ccc;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea::-moz-placeholder { /* Firefox 19+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea:-ms-input-placeholder { /* IE 10+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea:-moz-placeholder { /* Firefox 18- */\r\n    color: #ccc;\r\n}\r\n/*For all Elements*/\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"password\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: arial;\r\n	font-size: 16px;\r\n	font-weight: normal;\r\n	line-height: normal;\r\n	color: #aaa;\r\n	text-align:center;\r\n	width: 100%;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	border: 0px solid transparent;\r\n	display:block;\r\n    \r\n    margin: 10px 0 0;\r\n	padding: 0 10px 0 10px;\r\n	height: 40px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	height: auto;\r\n	padding-top: 9px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeForm input:first-child {\r\n	margin-top: 0px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select  {\r\n	margin: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  {\r\n	display: block;\r\n	font-family: arial;\r\n	font-size: 16px;\r\n	font-weight: normal;\r\n	line-height: normal;\r\n	color: #015050;\r\n	\r\n	margin: 10px 0 0;\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  span {\r\n	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"][name=\"name\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/user-black-icon.png\");\r\n	background-position: 12px center;\r\n	background-repeat: no-repeat;\r\n	background-size: 16px auto;\r\n	padding: 0 25px 0 35px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/email-black-icon.png\");\r\n	background-position: 11px center;\r\n	background-repeat: no-repeat;\r\n	background-size: 18px auto;\r\n	padding: 0 25px 0 35px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"submit\"] {\r\n	display: block;\r\n	font-family: arial;\r\n	font-size: 17px;\r\n	font-weight: bold;\r\n	line-height: normal;\r\n	color: #fff;\r\n  	cursor: pointer;\r\n	margin: 10px 0 0;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	border: 0px solid transparent;\r\n	width: 100%;\r\n	height: 50px;\r\n	\r\n  	[if bg_type_2 == \"color\"]\r\n  	background: [bg_color_2] 100%;\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #015050;\r\n	font-family: arial;\r\n	font-size: 30px;\r\n	line-height: 40px;\r\n	font-weight: bold;\r\n	margin: 0 15px 15px;\r\n	padding: 0;\r\n	text-align: center;\r\n\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupVideo {\r\n  	width: 100%;\r\n  	line-height: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSuccessMsg {\r\n	color: #015050 !important;\r\n	font-weight: bold;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg {\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n	color: #015050;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: normal;\r\n	font-weight: bold;\r\n    line-height: 14px;\r\n  	margin: 15px 30px 5px;\r\n	padding: 0;\r\n	text-align: center;\r\n}",img_preview="2016-230-5-video-list-prev.png",show_on="1",show_to="1",show_pages="1",type_id="3",date_created="2015-01-10 18:59:43",sort_order="1" WHERE id = "5"');
		}
		if(dbPps::get('SELECT COUNT(*) AS total FROM @__popup WHERE id = 27 AND original_id = 0', 'one')) {
			dbPps::query('UPDATE @__popup SET label="New York",active="1",original_id="0",params="a:3:{s:4:\"main\";a:30:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:26:\"close_on_after_action_time\";s:1:\"1\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";s:24:\"hide_for_user_roles_show\";s:1:\"0\";}s:3:\"tpl\";a:109:{s:5:\"width\";s:3:\"824\";s:13:\"width_measure\";s:2:\"px\";s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:4:\"#000\";s:14:\"bg_overlay_img\";s:0:\"\";s:18:\"bg_overlay_img_pos\";s:7:\"stretch\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#ffffff\";s:9:\"bg_type_1\";s:5:\"color\";s:8:\"bg_img_1\";s:0:\"\";s:10:\"bg_color_1\";s:7:\"#8ba6e8\";s:9:\"bg_type_2\";s:5:\"color\";s:8:\"bg_img_2\";s:0:\"\";s:10:\"bg_color_2\";s:7:\"#ffc18d\";s:10:\"font_label\";s:7:\"default\";s:16:\"label_font_color\";s:7:\"#ffffff\";s:10:\"font_txt_0\";s:7:\"default\";s:17:\"text_font_color_0\";s:7:\"#888888\";s:11:\"font_footer\";s:7:\"default\";s:17:\"footer_font_color\";s:7:\"#ffffff\";s:15:\"responsive_mode\";s:3:\"def\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:11:\"while_close\";s:7:\"bullets\";s:12:\"circle_green\";s:11:\"layered_pos\";s:3:\"top\";s:9:\"enb_label\";s:1:\"1\";s:5:\"label\";s:66:\"Subscribe to our newsletter and start increasing your profits now!\";s:9:\"enb_txt_0\";s:1:\"1\";s:13:\"enb_foot_note\";s:1:\"1\";s:9:\"foot_note\";s:45:\"We never share your e-mail with third parties\";s:15:\"enb_sm_facebook\";s:1:\"1\";s:17:\"enb_sm_googleplus\";s:1:\"1\";s:14:\"enb_sm_twitter\";s:1:\"1\";s:9:\"sm_design\";s:6:\"simple\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:0:\"\";s:13:\"enb_subscribe\";s:1:\"1\";s:8:\"sub_dest\";s:9:\"wordpress\";s:23:\"sub_wp_create_user_role\";s:10:\"subscriber\";s:19:\"sub_aweber_listname\";s:0:\"\";s:21:\"sub_aweber_adtracking\";s:0:\"\";s:21:\"sub_mailchimp_api_key\";s:0:\"\";s:25:\"sub_mailchimp_groups_full\";s:0:\"\";s:14:\"sub_gr_api_key\";s:0:\"\";s:16:\"sub_gr_cycle_day\";s:1:\"0\";s:13:\"sub_ic_app_id\";s:0:\"\";s:15:\"sub_ic_app_user\";s:0:\"\";s:15:\"sub_ic_app_pass\";s:0:\"\";s:14:\"sub_ac_api_url\";s:0:\"\";s:14:\"sub_ac_api_key\";s:0:\"\";s:18:\"sub_ar_form_action\";s:0:\"\";s:10:\"sub_sga_id\";s:0:\"\";s:15:\"sub_sga_list_id\";s:0:\"\";s:21:\"sub_sga_activate_code\";s:0:\"\";s:13:\"sub_sf_app_id\";s:0:\"\";s:14:\"sub_ck_api_key\";s:0:\"\";s:14:\"sub_mem_acc_id\";s:0:\"\";s:15:\"sub_mem_pud_key\";s:0:\"\";s:16:\"sub_mem_priv_key\";s:0:\"\";s:14:\"sub_sb_api_key\";s:0:\"\";s:14:\"sub_v6_api_key\";s:0:\"\";s:12:\"sub_vtig_url\";s:0:\"\";s:13:\"sub_vtig_name\";s:0:\"\";s:12:\"sub_vtig_key\";s:0:\"\";s:16:\"sub_ymlp_api_key\";s:0:\"\";s:13:\"sub_ymlp_name\";s:0:\"\";s:11:\"sub_4d_name\";s:0:\"\";s:11:\"sub_4d_pass\";s:0:\"\";s:10:\"sub_fields\";a:2:{s:4:\"name\";a:8:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:4:\"Name\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";s:10:\"set_preset\";s:0:\"\";}s:5:\"email\";a:8:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:10:\"set_preset\";s:0:\"\";s:3:\"enb\";s:1:\"1\";}}s:9:\"blacklist\";s:0:\"\";s:20:\"sub_txt_confirm_sent\";s:67:\"Confirmation link was sent to your email address. Check your email!\";s:15:\"sub_txt_success\";s:24:\"Thank you for subscribe!\";s:21:\"sub_txt_invalid_email\";s:22:\"Empty or invalid email\";s:20:\"sub_txt_exists_email\";s:22:\"Empty or invalid email\";s:16:\"sub_redirect_url\";s:0:\"\";s:28:\"sub_txt_confirm_mail_subject\";s:34:\"Confirm subscription on [sitename]\";s:25:\"sub_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"sub_txt_confirm_mail_message\";s:197:\"You subscribed on site <a href=\\"[siteurl]\\">[sitename]</a>. Follow <a href=\\"[confirm_link]\\">this link</a> to complete your subscription. If you did not subscribe here - just ignore this message.\";s:31:\"sub_txt_subscriber_mail_subject\";s:37:\"[sitename] Your username and password\";s:28:\"sub_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"sub_txt_subscriber_mail_message\";s:65:\"Username: [user_login]<br />Password: [password]<br />[login_url]\";s:25:\"sub_redirect_email_exists\";s:0:\"\";s:13:\"sub_btn_label\";s:13:\"SUBSCRIBE NOW\";s:13:\"sub_new_email\";s:14:\"admin@mail.com\";s:15:\"sub_new_subject\";s:28:\"New subscriber on [sitename]\";s:15:\"sub_new_message\";s:129:\"You have new subscriber on your site <a href=\\"[siteurl]\\">[sitename]</a>, here is subscriber information:<br />[subscriber_data]\";s:8:\"login_by\";s:8:\"username\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"login_btn_label\";s:10:\"Логин\";s:23:\"reg_wp_create_user_role\";s:10:\"subscriber\";s:13:\"reg_btn_label\";s:8:\"Register\";s:10:\"reg_fields\";a:2:{s:4:\"name\";a:7:{s:3:\"enb\";s:1:\"1\";s:4:\"name\";s:4:\"name\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"Имя\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"0\";}s:5:\"email\";a:7:{s:4:\"name\";s:5:\"email\";s:4:\"html\";s:4:\"text\";s:5:\"label\";s:6:\"E-Mail\";s:5:\"value\";s:0:\"\";s:6:\"custom\";s:1:\"0\";s:9:\"mandatory\";s:1:\"1\";s:3:\"enb\";s:1:\"1\";}}s:20:\"reg_txt_confirm_sent\";s:195:\"Ссылка для подтверждения был отправлена на ваш адрес электронной почты. Проверьте вашу электронную почту!\";s:15:\"reg_txt_success\";s:43:\"Спасибо за регистрацию!\";s:21:\"reg_txt_invalid_email\";s:58:\"Пустой или недействительный email\";s:16:\"reg_redirect_url\";s:0:\"\";s:28:\"reg_txt_confirm_mail_subject\";s:61:\"Подтвердите регистрацию на [sitename]\";s:25:\"reg_txt_confirm_mail_from\";s:14:\"admin@mail.com\";s:28:\"reg_txt_confirm_mail_message\";s:334:\"Вы зарегистрированы на сайте <a href=\\"[siteurl]\\">[sitename]</a>. Следуйте  <a href=\\"[confirm_link]\\">this link</a> для завершения регистрации. Если вы не зарегистрировались здесь - просто игнорируйте это сообщение.\";s:31:\"reg_txt_subscriber_mail_subject\";s:45:\"[sitename]  Ваш логин и пароль\";s:28:\"reg_txt_subscriber_mail_from\";s:14:\"admin@mail.com\";s:31:\"reg_txt_subscriber_mail_message\";s:71:\"Логин: [user_login]<br />Пароль: [password]<br />[login_url]\";s:13:\"reg_new_email\";s:14:\"admin@mail.com\";s:15:\"reg_new_message\";s:177:\"У вас новый пользователь на сайте <a href=\\"[siteurl]\\">[sitename]</a>, вот информация пользователя: <br />[subscriber_data]\";s:12:\"contact_form\";s:2:\"19\";s:12:\"stat_ga_code\";s:0:\"\";s:5:\"txt_0\";s:48:\"<p>[google_map_easy id=\\"1\\" height=\\"300\\"]</p>\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"3\";s:16:\"txt_block_number\";s:1:\"1\";}}",html="<link href=\"https://fonts.googleapis.com/css?family=Lato\" rel=\"stylesheet\" type=\"text/css\" >\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n		</div><!--\r\n		--><div class=\"ppsRightCol\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			[if enb_sm]\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>",css="@nice-blue: #5B83AD;\r\n#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 0px;\r\n  	font-family: Lato;\r\n	font-size: 13px;\r\n	line-height: normal;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: block;\r\n	text-align: right;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 59%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n	\r\n	vertical-align: middle;\r\n  	display: inline-block;\r\n  	margin: 0px;\r\n	text-align: left;\r\n	\r\n	[if bg_type_0 == \"color\"]\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\", endColorstr=\"[bg_color_0]\",GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 20px 20px 0;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-moz-placeholder { /* Firefox 19+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input:-ms-input-placeholder { /* IE 10+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input:-moz-placeholder { /* Firefox 18- */\r\n    color: #ccc;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea::-moz-placeholder { /* Firefox 19+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea:-ms-input-placeholder { /* IE 10+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea:-moz-placeholder { /* Firefox 18- */\r\n    color: #ccc;\r\n}\r\n/*For all Elements*/\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"password\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: Lato;\r\n	font-size: 16px;\r\n	font-weight: normal;\r\n	line-height: normal;\r\n	color: #aaa;\r\n	text-align:center;\r\n	width: 100%;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	border: 0px solid transparent;\r\n	display:block;\r\n    \r\n    margin: 10px 0 0;\r\n	padding: 0 10px 0 10px;\r\n	height: 40px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	height: auto;\r\n	padding-top: 9px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeForm input:first-child {\r\n	margin-top: 0px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select  {\r\n	margin: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  {\r\n	display: block;\r\n	font-family: Lato;\r\n	font-size: 16px;\r\n	font-weight: normal;\r\n	line-height: normal;\r\n	color: #fff;\r\n	\r\n	margin: 10px 0 0;\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  span {\r\n	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"][name=\"name\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/user-black-icon.png\");\r\n	background-position: 12px center;\r\n	background-repeat: no-repeat;\r\n	background-size: 16px auto;\r\n	padding: 0 25px 0 35px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/email-black-icon.png\");\r\n	background-position: 11px center;\r\n	background-repeat: no-repeat;\r\n	background-size: 18px auto;\r\n	padding: 0 25px 0 35px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"submit\"] {\r\n	display: block;\r\n	font-family: Lato;\r\n	font-size: 17px;\r\n	font-weight: bold;\r\n	line-height: normal;\r\n	color: #fff;\r\n  	cursor: pointer;\r\n	margin: 10px 0 0;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	border: 0px solid transparent;\r\n	width: 100%;\r\n	height: 50px;\r\n	\r\n  	[if bg_type_2 == \"color\"]\r\n  	background: [bg_color_2] 100%;\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n  	border-radius: 3px;\r\n	-moz-border-radius: 3px;\r\n	-webkit-border-radius: 3px;\r\n  	min-height: 350px;\r\n  	width: 40%;\r\n	display: inline-block;\r\n  	padding: 20px;\r\n	margin: 0;\r\n	vertical-align: middle;\r\n	\r\n  	[if bg_type_1 == \"color\"]\r\n	background: [bg_color_1];\r\n  	[elseif bg_type_1 == \"img\"]\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color:#ffffff;\r\n  	font-family: \"Lato\";\r\n  	font-weight: normal;\r\n	line-height: normal;\r\n  	font-size: 24px;\r\n	letter-spacing: -1px;\r\n  	padding: 0px;\r\n	margin: 20px 0 0;\r\n  	text-align: center;\r\n  	\r\n    width: 100%;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 100%;\r\n    height: 300px;\r\n	line-height: normal;\r\n  	font-size: 14px;\r\n  	font-family: Lato;\r\n	font-weight: 400;\r\n	\r\n	\r\n	padding: 0px;\r\n	margin: 0;\r\n	\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 p {\r\n	font-size: inherit !important;\r\n	font-weight: inherit !important;\r\n	font-size: inherit !important;\r\n	line-height: inherit !important;\r\n	width: 100%;\r\n	margin: 0;\r\n	padding: 0;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	top:-20px;\r\n  	right:1px;\r\n  	z-index:99999;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg {\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #ffffff;\r\n	text-align: center;\r\n    font-family: Lato;\r\n    font-size: x-small;\r\n    font-weight: bold;\r\n    line-height: 14px;\r\n  	margin: 10px 30px 5px;\r\n}",img_preview="230-6-new-york-prev.png",show_on="1",show_to="1",show_pages="1",type_id="1",date_created="2015-01-10 18:59:43",sort_order="1" WHERE id="27"');
		}
		if(dbPps::get('SELECT COUNT(*) AS total FROM @__popup WHERE id = 4 AND original_id = 0', 'one')) {	// Update Facebook Like PopUp if it is exist
			dbPps::query('UPDATE @__popup SET params="a:3:{s:4:\"main\";a:30:{s:7:\"show_on\";s:9:\"page_load\";s:23:\"show_on_page_load_delay\";s:0:\"\";s:25:\"show_on_click_on_el_delay\";s:1:\"0\";s:27:\"show_on_scroll_window_delay\";s:1:\"0\";s:33:\"show_on_scroll_window_perc_scroll\";s:1:\"0\";s:28:\"show_on_after_inactive_value\";s:2:\"10\";s:25:\"show_on_link_follow_delay\";s:1:\"0\";s:8:\"close_on\";s:10:\"user_close\";s:26:\"close_on_after_action_time\";s:1:\"1\";s:25:\"close_on_after_time_value\";s:1:\"5\";s:10:\"show_pages\";s:3:\"all\";s:14:\"show_time_from\";s:7:\"12:00am\";s:12:\"show_time_to\";s:7:\"12:00am\";s:14:\"show_date_from\";s:0:\"\";s:12:\"show_date_to\";s:0:\"\";s:7:\"show_to\";s:8:\"everyone\";s:29:\"show_to_first_time_visit_days\";s:2:\"30\";s:30:\"show_to_until_make_action_days\";s:2:\"30\";s:15:\"count_times_num\";s:1:\"1\";s:15:\"count_times_mes\";s:3:\"day\";s:21:\"hide_for_devices_show\";s:1:\"0\";s:24:\"hide_for_post_types_show\";s:1:\"0\";s:17:\"hide_for_ips_show\";s:1:\"0\";s:12:\"hide_for_ips\";s:0:\"\";s:23:\"hide_for_countries_show\";s:1:\"0\";s:23:\"hide_for_languages_show\";s:1:\"0\";s:24:\"hide_search_engines_show\";s:1:\"0\";s:18:\"hide_preg_url_show\";s:1:\"0\";s:13:\"hide_preg_url\";s:0:\"\";s:24:\"hide_for_user_roles_show\";s:1:\"0\";}s:3:\"tpl\";a:20:{s:5:\"width\";s:3:\"300\";s:13:\"width_measure\";s:2:\"px\";s:6:\"height\";s:0:\"\";s:14:\"height_measure\";s:2:\"px\";s:12:\"fb_like_opts\";a:3:{s:4:\"href\";s:57:\"https://www.facebook.com/pages/Supsystic/1389390198028999\";s:4:\"tabs\";a:1:{i:0;s:8:\"timeline\";}s:13:\"show_facepile\";s:1:\"1\";}s:18:\"bg_overlay_opacity\";s:3:\"0.5\";s:15:\"bg_overlay_type\";s:5:\"color\";s:16:\"bg_overlay_color\";s:4:\"#000\";s:14:\"bg_overlay_img\";s:0:\"\";s:18:\"bg_overlay_img_pos\";s:7:\"stretch\";s:9:\"bg_type_0\";s:5:\"color\";s:8:\"bg_img_0\";s:0:\"\";s:10:\"bg_color_0\";s:7:\"#ffffff\";s:15:\"responsive_mode\";s:3:\"def\";s:17:\"reidrect_on_close\";s:0:\"\";s:9:\"close_btn\";s:11:\"classy_grey\";s:11:\"layered_pos\";s:3:\"top\";s:8:\"anim_key\";s:4:\"none\";s:13:\"anim_duration\";s:1:\"1\";s:12:\"stat_ga_code\";s:0:\"\";}s:10:\"opts_attrs\";a:2:{s:9:\"bg_number\";s:1:\"1\";s:16:\"txt_block_number\";s:1:\"0\";}}" WHERE id = "4"');
		}
		dbPps::setAutoIncrement('@__popup', $lastAutoIncrement);
	}
	/*
	 * Make all text-like fields - look-like text fields, designed by template
	 */
	static public function makeTextFieldsCssUpdate() {
		$updated = (int) get_option('pps_txt_files_css_updated');
		if(!$updated) {
			dbPps::query('UPDATE @__popup SET css = REPLACE(css, "#ppsPopupShell_[ID] input[type=text]", "#ppsPopupShell_[ID] input[type=text],#ppsPopupShell_[ID] input[type=password]")');
			dbPps::query('UPDATE @__popup SET css = REPLACE(css, "#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text]", "#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password]")');
			dbPps::query('UPDATE @__popup SET css = REPLACE(css, "input[type=password][name=\"email\"]", "input[name=\"email\"]")');
			dbPps::query('UPDATE wp_pps_popup SET css = REPLACE(css, "#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"]", "#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text][name=\"email\"]")');
			update_option('pps_txt_files_css_updated', 1);
		}
	}
	static public function makeTextFieldsCssUpdateRound2() {
		$updated = (int) get_option('pps_txt_files_css_updated_2');
		if(!$updated) {
			dbPps::query('UPDATE @__popup SET css = REPLACE(css, "#ppsPopupShell_[ID] input[type=text]", "#ppsPopupShell_[ID] input[type=text],#ppsPopupShell_[ID] input[type=email]")');
			dbPps::query('UPDATE @__popup SET css = REPLACE(css, "#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text]", "#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email]")');
			dbPps::query('UPDATE @__popup SET css = REPLACE(css, "input[type=email][name=\"email\"]", "input[name=\"email\"]")');
			dbPps::query('UPDATE wp_pps_popup SET css = REPLACE(css, "#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"]", "#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text][name=\"email\"]")');
			update_option('pps_txt_files_css_updated_2', 1);
		}
	}
}
