<?php


namespace WPML\LIB\WP;

use tad\FunctionMocker\FunctionMocker;
use WPML\FP\Obj;

trait OnActionMock {

	private $actions = [];
	private $filters = [];

	public function setUpOnAction() {
		FunctionMocker::setUp();
		FunctionMocker::replace( 'wpml_test_add_action', function ( $action, $callback, $priority = 10, $accepted_args = 1 ) {
			$this->actions[ $action ] = [
				'callback'      => $callback,
				'priority'      => $priority,
				'accepted_args' => $accepted_args,
			];
		} );
		FunctionMocker::replace( Hooks::class . '::onAction', function ( $action, $priority = 10, $accepted_args = 1 ) {
			return Hooks::onHook( 'wpml_test_add_action', $action, $priority, $accepted_args );
		} );

		FunctionMocker::replace( 'wpml_test_add_filter', function ( $filter, $callback, $priority = 10, $accepted_args = 1 ) {
			$this->filters[ $filter ] = [
				'callback'      => $callback,
				'priority'      => $priority,
				'accepted_args' => $accepted_args,
			];
		} );
		FunctionMocker::replace( Hooks::class . '::onFilter', function ( $action, $priority = 10, $accepted_args = 1 ) {
			return Hooks::onHook( 'wpml_test_add_filter', $action, $priority, $accepted_args );
		} );
	}

	public function tearDownOnAction() {
		FunctionMocker::tearDown();
	}

	public function assertActionAdded( $actionName, $priority = 10, $accepted_args = 1) {
		$this->assertTrue( isset( $this->actions[ $actionName ] ) );
		$this->assertTrue( is_array( $this->actions[ $actionName ] ) );
		$this->assertEquals( $this->actions[ $actionName ]['priority'], $priority );
		$this->assertEquals( $this->actions[ $actionName ]['accepted_args'], $accepted_args );
	}

	public function assertFilterAdded( $filterName, $priority = 10, $accepted_args = 1) {
		$this->assertTrue( isset( $this->filters[ $filterName ] ) );
		$this->assertTrue( is_array( $this->filters[ $filterName ] ) );
		$this->assertEquals( $this->filters[ $filterName ]['priority'], $priority );
		$this->assertEquals( $this->filters[ $filterName ]['accepted_args'], $accepted_args );
	}

	public function assertActionNotAdded( $actionName ) {
		$this->assertFalse( key_exists( $actionName, $this->actions ) );
	}

	public function runAction( $actionName = null ) {
		$args = array_slice( func_get_args(), 1 );

		if ( ! $actionName ) {
			$this->assertCount( 1, $this->actions );
			$actionName = current( array_keys( $this->actions ) );
		}

		if ( isset( $this->actions[ $actionName ]['callback'] ) ) {
			call_user_func_array( $this->actions[ $actionName ]['callback'], $args );
		}
	}

	public function runFilter( $filterName = null ) {
		$args = array_slice( func_get_args(), 1 );

		if ( ! $filterName ) {
			$this->assertCount( 1, $this->filters );
			$filterName = current( array_keys( $this->filters ) );
		}

		return isset( $this->filters[ $filterName ]['callback'] ) ?
			call_user_func_array( $this->filters[ $filterName ]['callback'], $args ) :
			Obj::propOr( null, 0, $args );
	}

}
