/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./src/js/pont-picker-block/attributes.js":
/*!************************************************!*\
  !*** ./src/js/pont-picker-block/attributes.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * External dependencies
 */
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  text: {
    type: 'string',
    default: 'Select a pickup point'
  },
  selectButton: {
    type: 'string',
    default: 'Select pickup point'
  },
  changeButton: {
    type: 'string',
    default: 'Modify'
  },
  showIcons: {
    type: 'boolean',
    default: true
  }
});

/***/ }),

/***/ "./src/js/pont-picker-block/block.js":
/*!*******************************************!*\
  !*** ./src/js/pont-picker-block/block.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash */ "lodash");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @woocommerce/blocks-checkout */ "@woocommerce/blocks-checkout");
/* harmony import */ var _woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _woocommerce_settings__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @woocommerce/settings */ "@woocommerce/settings");
/* harmony import */ var _woocommerce_settings__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_woocommerce_settings__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_7__);

/**
 * External dependencies
 */








//Store payment method ID when payment method is changed
wp.hooks.addAction('experimental__woocommerce_blocks-checkout-set-active-payment-method', 'vp-woo-pont-block', function (payment_method) {
  //But only if we have COD fees enabled, otherwise not needed
  const {
    codFeesEnabled
  } = (0,_woocommerce_settings__WEBPACK_IMPORTED_MODULE_6__.getSetting)('vp-woo-pont-picker_data', '');
  if (codFeesEnabled) {
    (0,_woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_5__.extensionCartUpdate)({
      namespace: 'vp-woo-pont-picker',
      cartPropsToReceive: ['extensions'],
      data: {
        payment_method: payment_method.value
      }
    });
  }
});
const Block = ({
  text,
  selectButton,
  changeButton,
  showIcons,
  checkoutExtensionData,
  extensions,
  cart
}) => {
  const {
    setExtensionData
  } = checkoutExtensionData;
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const debouncedSetExtensionData = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)((0,lodash__WEBPACK_IMPORTED_MODULE_4__.debounce)((namespace, key, value) => {
    setExtensionData(namespace, key, value);
  }, 1000), [setExtensionData]);

  //Setup shipping costs
  const [shippingCosts, setShippingCosts] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(() => {
    return extensions['vp-woo-pont-picker']['shipping_costs'];
  });

  //Check if we have stored info in the session
  const selectedPont = extensions['vp-woo-pont-picker'] && extensions['vp-woo-pont-picker']['selected_pont'];
  const [selectedPickupPoint, setSelectedPickupPoint] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(selectedPont || false);

  //Show a loading indicator
  const [isLoading, setIsLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);

  //Handle pickup point selection
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    const eventListener = () => {
      handlePointSelected();
    };

    //Add event listener
    jQuery(document).on('vp_woo_pont_modal_point_selected', eventListener);

    //Clean up the event listener when the component unmounts
    return () => {
      jQuery(document).off('vp_woo_pont_modal_point_selected', eventListener);
    };
  }, []);

  //Runs when a point is selected, show loading indicator and reload data
  const handlePointSelected = () => {
    //Show loading indicator
    setIsLoading(true);

    //Do a cart update, which will return the selected point data, since its stored in session(done with an ajax call in jquery map script)
    (0,_woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_5__.extensionCartUpdate)({
      namespace: 'vp-woo-pont-picker',
      cartPropsToReceive: ['extensions']
    }).then(response => {
      //Hide loading indicator
      setIsLoading(false);

      //Set selected point data
      if (response['extensions']['vp-woo-pont-picker'] && response['extensions']['vp-woo-pont-picker']['selected_pont']) {
        setSelectedPickupPoint(response['extensions']['vp-woo-pont-picker']['selected_pont']);
      }
    });
  };

  //Check if local pickup is selected
  const {
    prefersCollection
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    const checkoutStore = select('wc/store/checkout');
    return {
      prefersCollection: checkoutStore.prefersCollection()
    };
  });

  //Get an array of shipping method ids that are collectable
  const collectableMethodIds = (0,_woocommerce_settings__WEBPACK_IMPORTED_MODULE_6__.getSetting)('collectableMethodIds');

  //Loop though shipping rates and see if we only have maximum one collectable method
  const collectableShippingRates = cart.shippingRates[0].shipping_rates.filter(rate => collectableMethodIds.includes(rate.method_id));

  //If we have only have one collectable method, show pickup point selector
  const isPontMethodSelectedDefault = collectableShippingRates.length == 1;

  //Check if the selected shipping method is vp_pont
  const isPontMethodSelected = cart.shippingRates[0].shipping_rates.find(rate => rate.selected && rate.method_id === 'vp_pont');
  if (isPontMethodSelected || prefersCollection && isPontMethodSelectedDefault) {
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_7___default()('vp-woo-pont-block', {
        'wc-block-components-loading-mask': isLoading
      })
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "vp-woo-pont-block-box wc-block-components-loading-mask__children"
    }, !selectedPickupPoint ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "vp-woo-pont-block-select"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      className: "vp-woo-pont-block-select-title"
    }, text), showIcons && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "vp-woo-pont-block-select-icons"
    }, shippingCosts && Object.keys(shippingCosts).map(provider => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("i", {
      key: provider,
      className: `vp-woo-pont-provider-icon-${provider}`
    })))) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "vp-woo-pont-block-selected"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("i", {
      className: `vp-woo-pont-provider-icon-${selectedPickupPoint.provider}`
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "vp-woo-pont-block-selected-info"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("strong", null, selectedPickupPoint.name), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("br", null), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, selectedPickupPoint.addr, ", ", selectedPickupPoint.zip, ' ', selectedPickupPoint.city))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "vp-woo-pont-block-select-button",
      "data-shipping-costs": JSON.stringify(shippingCosts)
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_5__.Button, {
      className: "vp-woo-pont-show-map"
    }, selectedPickupPoint ? changeButton : selectButton))), isLoading && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
      className: "wc-block-components-spinner",
      "aria-hidden": "true"
    }));
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Block);

/***/ }),

/***/ "./node_modules/classnames/index.js":
/*!******************************************!*\
  !*** ./node_modules/classnames/index.js ***!
  \******************************************/
/***/ ((module, exports) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
	Copyright (c) 2018 Jed Watson.
	Licensed under the MIT License (MIT), see
	http://jedwatson.github.io/classnames
*/
/* global define */

(function () {
	'use strict';

	var hasOwn = {}.hasOwnProperty;
	var nativeCodeString = '[native code]';

	function classNames() {
		var classes = [];

		for (var i = 0; i < arguments.length; i++) {
			var arg = arguments[i];
			if (!arg) continue;

			var argType = typeof arg;

			if (argType === 'string' || argType === 'number') {
				classes.push(arg);
			} else if (Array.isArray(arg)) {
				if (arg.length) {
					var inner = classNames.apply(null, arg);
					if (inner) {
						classes.push(inner);
					}
				}
			} else if (argType === 'object') {
				if (arg.toString !== Object.prototype.toString && !arg.toString.toString().includes('[native code]')) {
					classes.push(arg.toString());
					continue;
				}

				for (var key in arg) {
					if (hasOwn.call(arg, key) && arg[key]) {
						classes.push(key);
					}
				}
			}
		}

		return classes.join(' ');
	}

	if ( true && module.exports) {
		classNames.default = classNames;
		module.exports = classNames;
	} else if (true) {
		// register as 'classnames', consistent with npm package name
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function () {
			return classNames;
		}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else {}
}());


/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "React" ***!
  \************************/
/***/ ((module) => {

"use strict";
module.exports = window["React"];

/***/ }),

/***/ "lodash":
/*!*************************!*\
  !*** external "lodash" ***!
  \*************************/
/***/ ((module) => {

"use strict";
module.exports = window["lodash"];

/***/ }),

/***/ "@woocommerce/blocks-checkout":
/*!****************************************!*\
  !*** external ["wc","blocksCheckout"] ***!
  \****************************************/
/***/ ((module) => {

"use strict";
module.exports = window["wc"]["blocksCheckout"];

/***/ }),

/***/ "@woocommerce/shared-hocs":
/*!********************************************!*\
  !*** external ["wc","wcBlocksSharedHocs"] ***!
  \********************************************/
/***/ ((module) => {

"use strict";
module.exports = window["wc"]["wcBlocksSharedHocs"];

/***/ }),

/***/ "@woocommerce/settings":
/*!************************************!*\
  !*** external ["wc","wcSettings"] ***!
  \************************************/
/***/ ((module) => {

"use strict";
module.exports = window["wc"]["wcSettings"];

/***/ }),

/***/ "@wordpress/data":
/*!******************************!*\
  !*** external ["wp","data"] ***!
  \******************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["data"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "./src/js/pont-picker-block/block.json":
/*!*********************************************!*\
  !*** ./src/js/pont-picker-block/block.json ***!
  \*********************************************/
/***/ ((module) => {

"use strict";
module.exports = JSON.parse('{"apiVersion":2,"name":"vp-woo-pont/pont-picker-block","version":"2.0.0","title":"Pont Picker Block","category":"woocommerce","description":"Adds a pont picker field to the checkout form.","supports":{"html":false,"align":false,"multiple":false,"reusable":false},"parent":["woocommerce/checkout-pickup-options-block"],"textdomain":"vp-woo-pont","editorStyle":"file:../../../build/style-pont-picker-block.css","attributes":{"lock":{"type":"object","default":{"move":true,"remove":true}}}}');

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be in strict mode.
(() => {
"use strict";
/*!**********************************************!*\
  !*** ./src/js/pont-picker-block/frontend.js ***!
  \**********************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @woocommerce/blocks-checkout */ "@woocommerce/blocks-checkout");
/* harmony import */ var _woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _woocommerce_shared_hocs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @woocommerce/shared-hocs */ "@woocommerce/shared-hocs");
/* harmony import */ var _woocommerce_shared_hocs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_woocommerce_shared_hocs__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _block__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./block */ "./src/js/pont-picker-block/block.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./block.json */ "./src/js/pont-picker-block/block.json");
/* harmony import */ var _attributes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./attributes */ "./src/js/pont-picker-block/attributes.js");
/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



(0,_woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_0__.registerCheckoutBlock)({
  metadata: _block_json__WEBPACK_IMPORTED_MODULE_3__,
  component: (0,_woocommerce_shared_hocs__WEBPACK_IMPORTED_MODULE_1__.withFilteredAttributes)(_attributes__WEBPACK_IMPORTED_MODULE_4__["default"])(_block__WEBPACK_IMPORTED_MODULE_2__["default"])
});
})();

/******/ })()
;
//# sourceMappingURL=pont-picker-block-frontend.js.map