<!DOCTYPE html>
<html <?php language_attributes(); ?> <?php echo (is_customize_preview()) ? 'class="no-scrollbar"' : ''; ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<?php wp_head(); ?>
	
</head>
<?php $mode = etheme_get_option('dark_styles') ? 'dark' : 'light'; ?>
<body <?php body_class(); ?> data-mode="<?php echo esc_attr( $mode ); ?>">

	<?php if (get_locale() == 'hu_HU') { $pageid=848; } else { $pageid=967;}
	
	$popup = get_field('popup',$pageid);
	if( $popup ): 
		$aktiv = $popup['aktiv'];
		$kep = $popup['kep'];
		$szoveg = $popup['szoveg'];
		$gomb_felirat = $popup['gomb_felirat'];
		$gomb_link = $popup['gomb_link'];
		$gomb_link_cel = $popup['gomb_link_cel'];
	?>

	<?php if ($aktiv == 1) { ?>
		<div id="custpopup">
			<div class="inner">
				<span id="bezar">X</span>
				
				<?php if ( $gomb_link ) { ?>
					<a target="<?php echo $gomb_link_cel; ?>" href="<?php echo $gomb_link; ?>">
				<?php } ?>
				
				<p><img src="<?php echo $kep['url']; ?>" alt="Popup"/></p>
				
				<?php if ( $gomb_link ) { ?>
					</a>
				<?php } ?>
				
				<?php if ( $gomb_link ) { ?>
					<a target="<?php echo $gomb_link_cel; ?>" href="<?php echo $gomb_link; ?>">
				<?php } ?>
				
				<?php echo $szoveg ?>
				
				<?php if ( $gomb_link ) { ?>
					</a>
				<?php } ?>
				
				<?php if ( $gomb_link ) { ?>
					<a href="<?php echo $gomb_link; ?>" class="btn flex flex-nowrap justify-content-center align-items-center medium" title="<?php echo $gomb_felirat; ?>" target="<?php echo $gomb_link_cel; ?>"> <span><?php echo $gomb_felirat; ?></span> </a>
				<?php } ?>
			</div>
		
		</div>
		<?php } ?>
	<?php endif; ?>




<?php if ( function_exists( 'wp_body_open' ) ) {
			wp_body_open();
	} else {
		do_action( 'wp_body_open' );
} ?>

<?php if ( ! function_exists( 'elementor_theme_do_location' ) || ! elementor_theme_do_location( 'header' ) ) : ?>

<?php do_action( 'et_after_body', true ); ?>

<div class="template-container">

	<?php
		/**
		 * Hook: etheme_header_before_template_content.
		 *
		 * @hooked etheme_top_panel_content - 10
		 * @hooked etheme_mobile_menu_content - 20
		 *
		 * @version 6.0.0 +
		 * @since 6.0.0 +
		 *
		 */
		do_action( 'etheme_header_before_template_content' );
	 ?>
	<div class="template-content">
		<div class="page-wrapper" data-fixed-color="<?php etheme_option( 'fixed_header_color' ); ?>">
			<?php 
			/**
			 * Hook: etheme_header.
			 *
			 * @hooked etheme_header_content - 10
			 *
			 * @version 6.0.0 +
			 * @since 6.0.0 +
			 *
			 */
			do_action( 'etheme_header' );
			do_action( 'etheme_header_mobile' );
			
endif;