<?php  if ( ! defined('ABSPATH')) exit('No direct script access allowed');
/**
 * The template for displaying theme footer
 *
 * @since   6.2.12
 * @version 1.0.0
 */

$custom_footer = etheme_get_query_custom_field('custom_footer');
$fcolor = etheme_get_option('footer_color');
?>
<div class="container">
	<?php 
	
	$kosar =  apply_filters( 'wpml_object_id', 20, 'post' );
	$penztar =  apply_filters( 'wpml_object_id', 21, 'post' );
	$adatkezeles =  apply_filters( 'wpml_object_id', 3, 'post' );
	$aszf =  apply_filters( 'wpml_object_id', 941, 'post' );
	
	if (($post->ID != $kosar) && ($post->ID != $penztar) && ($post->ID != $adatkezeles) && ($post->ID != $aszf)) { 
	
	?>
	<div class="row">
		<div class="col-lg-12">
			<?php 
				$my_current_lang = apply_filters( 'wpml_current_language', NULL );
				
				if( $my_current_lang =='hu' ) {
					echo do_shortcode( '[block id="147"]' );
					echo do_shortcode( '[block id="160"]' );
					echo do_shortcode( '[block id="158"]' );
				}
				elseif( $my_current_lang =='en' ) {
					echo do_shortcode( '[block id="348"]' );
					echo do_shortcode( '[block id="350"]' );
					echo do_shortcode( '[block id="351"]' );
				}
				else{
					echo do_shortcode( '[block id="348"]' );
					echo do_shortcode( '[block id="350"]' );
					echo do_shortcode( '[block id="351"]' );
				}
			?>
		</div>
	</div>
	<?php } ?>
</div>
<?php if($custom_footer != 'without' && ( ! empty( $custom_footer ) || is_active_sidebar('footer-1') || is_active_sidebar('footer-2') || is_active_sidebar('footer-3') || is_active_sidebar('footer-4') )): ?>
	<footer class="footer text-color-<?php echo esc_attr($fcolor); ?>">
		<div class="container">
			<div class="row">
				<div class="gere-elmenyek col-lg-12">
					<?php
						wp_nav_menu( array(
						    'menu' => 'Gere Elmenyek - HU'
						) );
					?>
				</div>
			</div>
			<?php if(empty($custom_footer)): ?>
				<div class="row">
					<?php
					$footer_columns = (int) etheme_get_option('footer_columns');
					if( $footer_columns < 1 || $footer_columns > 4) $footer_columns = 4;
					$footer_widget_class = etheme_get_footer_widget_class($footer_columns);
					for($_i=1; $_i<=$footer_columns; $_i++) {
						echo '<div class="footer-widgets ' . $footer_widget_class .'">';
							if(is_active_sidebar('footer-'.$_i)) dynamic_sidebar( 'footer-'.$_i );
						echo '</div>';
					}
					?>
				</div>
			<?php elseif(!empty($custom_footer)): ?>
				<?php etheme_static_block($custom_footer, true); ?>
			<?php endif; ?>
		</div>
	</footer>
<?php endif; ?>