	<?php
add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );
function theme_enqueue_styles() {
	etheme_child_styles();
}

function cc_mime_types($mimes) {
 $mimes['svg'] = 'image/svg+xml';
 return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');

/**
 * @snippet       Move product tabs beside the product image - WooCommerce
 * @how-to        Get CustomizeWoo.com FREE
 * @sourcecode    https://businessbloomer.com/?p=393
 * @author        Rodolfo Melogli
 * @testedwith    WooCommerce 3.5.2
 * @donate $9     https://businessbloomer.com/bloomer-armada/
 */
 
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_output_product_data_tabs', 60 );

remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );

add_action( 'woocommerce_single_product_summary', 'custom_field_display_below_title', 2 );
function custom_field_display_below_title(){
	if( get_field('product_label') ){
	?>
		<div class="custom-product-label">
	    	<?php echo get_field('product_label') ? the_field('product_label') : '&nbsp;'; ?>
	    </div>
    <?php
    }
}


remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 70 );

remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 80 );


function my_custom_js() {
    echo '<script type="text/javascript" src="' . get_template_directory_uri() . '-child/js/custom.js"></script>';
}
add_action('wp_head', 'my_custom_js');


function add_custom_menu() {
	register_nav_menus(
		array(
		  'other-websites' => __( 'Egyéb weboldalak' )
		)
	);
}
add_action( 'init', 'add_custom_menu' );


add_action( 'wp_body_open', 'add_custom_body_open_code' );
 
function add_custom_body_open_code(){
	?>
	<div class="slide-other-pages">
		<div class="slide-close"><span class="close-line"></span></div>
		<?php
		wp_nav_menu( array( 'theme_location' => 'other-websites',
							'container_class' => 'menu-other-websites'
		));
		?>
	</div>
	<?php
}
/* Woocommerce email CSS start */
add_filter( 'woocommerce_email_styles', 'add_css_to_emails', 9999, 2 );
 
function add_css_to_emails( $css, $email ) { 
   $css .= '
    #template_container {
		box-shadow: none !important;
		border: none;
		border-radius: 0px !important;
	}
	#template_header_image img {
		margin-bottom: 40px;	
	}
	#template_header {
		border-radius: 0px !important;
	}
	';
   return $css;
}
/* Woocommerce email CSS end */

function custom_woocommerce_checkout_fields( $fields ) 
{
    $fields['order']['order_comments']['label'] = __( 'Note for order', 'woocommerce' );

    return $fields;
}
add_filter( 'woocommerce_checkout_fields', 'custom_woocommerce_checkout_fields', 20, 1 );


function add_custom_fonts() {
	wp_enqueue_style( 'custom_fonts', get_template_directory_uri() . '-child/assets/fonts/stylesheet.css' );
}
add_action( 'wp_enqueue_scripts', 'add_custom_fonts' );


/**
 * Hide shipping rates when free shipping is available.
 * Updated to support WooCommerce 2.6 Shipping Zones.
 *
 * @param array $rates Array of rates found for the package.
 * @return array
 *//*
function my_hide_shipping_when_free_is_available( $rates ) {
	$free = array();
	foreach ( $rates as $rate_id => $rate ) {
		if ( 'free_shipping' === $rate->method_id ) {
			$free[ $rate_id ] = $rate;
			break;
		}
	}
	return ! empty( $free ) ? $free : $rates;
}
add_filter( 'woocommerce_package_rates', 'my_hide_shipping_when_free_is_available', 100 );*/


add_filter( 'body_class','my_body_classes' );

function my_body_classes( $classes ) {
	if ((!is_archive()) && (get_field('dark_header') == 1) || is_product() || is_cart() || is_checkout() || is_404()) {
		$classes[] = 'dark_header';
	}

    return $classes;
}

/**
 * Hides the product's weight and dimension in the single product page.
 */
add_filter( 'wc_product_enable_dimensions_display', '__return_false' );



function term_and_conditions_new_tab(){ ?>
<script>

	jQuery(function($){
		$( "a.woocommerce-terms-and-conditions-link" ).unbind( "click" );
		$( "body" ).on('click', 'a.woocommerce-terms-and-conditions-link', function( event ) {
			
			e.stopPropagation();
			$(this).attr("target", "_blank");
			window.open( $(this).attr("href"));

			return false;
		});
	});

</script>
<?php
}
add_action('wp_footer', 'term_and_conditions_new_tab');


// Replace add to cart button by a linked button to the product in Shop and archives pages
add_filter( 'woocommerce_loop_add_to_cart_link', 'replace_loop_add_to_cart_button', 10, 2 );
function replace_loop_add_to_cart_button( $button, $product  ) {
    // Not needed for variable products
    if( $product->is_type( 'variable' ) ) return $button;

    // Button text here
    $button_text = __( "View product", "woocommerce" );

    return '<a class="button" href="' . $product->get_permalink() . '">' . $button_text . '</a>';
}



/* add_filter('woocommerce_package_rates', 'conditional_free_shipping', 10, 2); 
function conditional_free_shipping( $rates, $package )
{
	if ( is_admin() && ! defined( 'DOING_AJAX' ) ) 
	return $rates;

	## -- Your settings below -- ##

	$shipping_class  = 'ingyenes-szallitas' || 'ingyenes-szallitas-en'; // "Free" shipping class products
	$min_free_amount = 25000;    // Minimal Free shipping amount for normal products

	## -- -- -- -- -- -- -- -- -- ##

	$has_free = false; // Initializing
	$products_total = 0; // Initializing

	// Loop through cart items
	foreach( $package['contents'] as $cart_item ) {
		if( $cart_item['data']->get_shipping_class() == $shipping_class ) {
			$has_free = true;
		} else {
			// Get the total purchased amount for normal product
			$products_total += $cart_item['line_total'] + $cart_item['line_tax'];
		}
	}

	foreach ( $rates as $rate_key => $rate ){
		// 1. Only Free shipping products in cart OR both products kind in cart
		if( $has_free ) {
			if( 'flat_rate' === $rate->method_id )
			unset( $rates[$rate_key] ); // Remove flat rate
		}
		// 2. Only normal products in cart
		else {
			// A. If it's under the min amount
			if( 'free_shipping' === $rate->method_id && $products_total < $min_free_amount )
				unset( $rates[$rate_key] ); // Remove Free shipping
			// B. When min amount is reached
			elseif( 'flat_rate' === $rate->method_id && $products_total >= $min_free_amount )
				unset( $rates[$rate_key] ); // Remove flat rate
		}
	}
	return $rates;
} */

add_action( 'woocommerce_cart_calculate_fees', 'custom_handling_fee', 10, 1 );
function custom_handling_fee ( $cart ) {
    if ( is_admin() && ! defined( 'DOING_AJAX' ) )
        return;
 
	$shipping_for_package_0 = WC()->session->get('shipping_for_package_0');
	$found_fs = false;

	if( isset($shipping_for_package_0['rates']) && ! empty($shipping_for_package_0['rates']) ) {
		// Loop through available shipping methods rate data
		foreach( $shipping_for_package_0['rates'] as $rate ) {
			// Targeting "Free Shipping"
			if( 'free_shipping' === $rate->method_id ) {
				$found_fs = true;
				break;
			}
		}
	}
 	

	// if ( $found_fs == false && 'cod' === WC()->session->get('chosen_payment_method')) {
	if ( 'cod' === WC()->session->get('chosen_payment_method')) {
        $fee = 500;
		
		//$get_my_current_lang = apply_filters( 'wpml_current_language', NULL );
		if(ICL_LANGUAGE_CODE=='hu'){
			$cart->add_fee( 'Utánvét kezelési költség', $fee, true );
		} else{
			$cart->add_fee( 'Cash on delivery handling fee', $fee, true );
		}
    }



	if (WC()->cart->find_product_in_cart( WC()->cart->generate_cart_id(2526)) && 'cod' === WC()->session->get('chosen_payment_method')) {
		$fee = 3000;
		$cart->add_fee( 'Cash on delivery handling fee', $fee, true );
	}
	if (WC()->cart->find_product_in_cart( WC()->cart->generate_cart_id(2522)) && 'cod' === WC()->session->get('chosen_payment_method')) {
		$fee = 3000;
		$cart->add_fee( 'Utánvét kezelési költség', $fee, true );
	}

}
 
// jQuery - Update checkout on methode payment change
add_action( 'wp_footer', 'custom_checkout_jqscript' );
function custom_checkout_jqscript() {
    if ( is_checkout() && ! is_wc_endpoint_url() ) :
    ?>
    <script type="text/javascript">
    jQuery( function($){
        $('form.checkout').on('change', 'input[name="payment_method"]', function(){
            $(document.body).trigger('update_checkout');
        });
    });
    </script>
    <?php
    endif;
}




add_filter('woocommerce_get_availability_text', 'themeprefix_change_soldout', 10, 2 );

function themeprefix_change_soldout ( $text, $product) {
if ( !$product->is_in_stock() ) {
	
	if ( get_field('elfogyott_helyett_egyedi_kiiras',$product->get_id()) ) {
		$text = get_field('elfogyott_helyett_egyedi_kiiras',$product->get_id());
	}	
	
	/*$get_my_current_lang = apply_filters( 'wpml_current_language', NULL );
		if( $get_my_current_lang =='hu' ) {
			$text = 'Új évjárat hamarosan!';
		} else {
			$text = 'New vintage coming soon!';
		}
	*/
}
return $text;
}







function add_this_script_footer(){ 

    echo "<link rel='stylesheet' id='product-tabs-css-css'  href='https://shop.gere.hu/wp-content/themes/gereshop-child/css/easy-responsive-tabs.css?ver=6.0' type='text/css' media='all' />";
    echo "<script type='text/javascript' src='https://shop.gere.hu/wp-content/themes/gereshop-child/js/easyResponsiveTabs.js'></script>";
}

add_action('wp_footer', 'add_this_script_footer');






add_filter('woocommerce_single_product_summary','custom_product_details', 55);
function custom_product_details($product){ ?>



<?php  if(isset($_GET['test'])) { ?>

    <link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css"/>
    <script type="text/javascript" src="//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>

    <?php global $product; ?>
     



        <!--Horizontal Tab-->
        <div id="parentHorizontalTab">
            <?php if( have_rows('evjarat') ): ?>
                <ul class="resp-tabs-list hor_1" id="slicktabs">
                <?php while( have_rows('evjarat') ): the_row(); 
                    $ev = get_sub_field('ev');   ?>
                    <li><?php echo $ev; ?></li>
                <?php endwhile; ?>
                </ul>
            <?php endif; ?>

            
            <div class="resp-tabs-container hor_1">
                

                <!--vertical Tabs-->
                <?php if( have_rows('evjarat') ): ?>
                   
                    <?php $i=1; while( have_rows('evjarat') ): the_row(); 
                        $leiras_hu = get_sub_field('leiras_hu');
                        $leiras_en = get_sub_field('leiras_en');
                        $evjarat_ertekelese_hu = get_sub_field('evjarat_ertekelese_hu');
                        $evjarat_ertekelese_en = get_sub_field('evjarat_ertekelese_en');
                        ?>


                                <div>
                                    <div id="ChildVerticalTab_<?php echo $i; ?>">
                                        <ul class="resp-tabs-list ver_1">
                                        <?php if (get_locale() == 'hu_HU') { ?>
                                            <li>Leírás</li>
                                            <li>Évjárat értékelése</li>
                                            <li>További információk</li>
                                        <?php } else { ?>
                                            <li>Description</li>
                                            <li>Vintage rating</li>
                                            <li>Additional information</li>
                                        <?php } ?>
                                        </ul>
                                        <div class="resp-tabs-container ver_1">
                                            <div>
                                            <?php if (get_locale() == 'hu_HU') { 
                                                echo $leiras_hu;
                                            } else {
                                                echo $leiras_en;
                                            }
                                            ?>
                                            </div>
                                            <div>
                                            <?php if (get_locale() == 'hu_HU') { 
                                                echo $evjarat_ertekelese_hu;
                                            } else {
                                                echo $evjarat_ertekelese_en;
                                            }
                                            ?>
                                            </div>
                                            <div>
                                                <?php if (get_locale() == 'hu_HU') { ?>
                                                        <?php if( have_rows('tovabbi_informaciok_hu') ): ?>
                                                            <table class="woocommerce-product-attributes shop_attributes">
                                                            <tbody>
                                                        <?php while( have_rows('tovabbi_informaciok_hu') ): the_row();  ?>
                                                            <?php $felirat_hu = get_sub_field('felirat_hu'); 
                                                                $tartalom_hu = get_sub_field('tartalom_hu');
                                                            ?>
                                                                <tr
                                                                    class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_evjarat">
                                                                    <th class="woocommerce-product-attributes-item__label">
                                                                    <?php  echo $felirat_hu; ?>
                                                                    </th>
                                                                    <td class="woocommerce-product-attributes-item__value">
                                                                        <?php echo $tartalom_hu; ?></p>
                                                                    </td>
                                                                </tr>
                                                                <?php endwhile; ?>
                                                                </tbody>
                                                                </table>
                                                        <?php endif; ?>

                                                <?php } else { ?>

                                                        <?php if( have_rows('tovabbi_informaciok_en') ): ?>
                                                            <table class="woocommerce-product-attributes shop_attributes">
                                                            <tbody>
                                                        <?php while( have_rows('tovabbi_informaciok_en') ): the_row();  ?>
                                                            <?php $felirat_en = get_sub_field('felirat_en'); 
                                                                $tartalom_en = get_sub_field('tartalom_en');
                                                            ?>
                                                                <tr
                                                                    class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_evjarat">
                                                                    <th class="woocommerce-product-attributes-item__label">
                                                                    <?php  echo $felirat_en; ?>
                                                                    </th>
                                                                    <td class="woocommerce-product-attributes-item__value">
                                                                        <?php echo $tartalom_en; ?></p>
                                                                    </td>
                                                                </tr>
                                                                <?php endwhile; ?>
                                                                </tbody>
                                                                </table>
                                                        <?php endif; ?>

                                                <?php } ?>
                                                
                                            </div>
                                        </div>
                                    </div>

                                    <div style="clear:both"></div>

                                </div>
                        
                    <?php $i++; endwhile; ?>
                   
                <?php endif; ?>
                
             
                    

               

               
            </div>
        </div>


 

    <!--Plug-in Initialisation-->

    
    <script type="text/javascript">
       jQuery(document).ready(function ($) {
            //Horizontal Tab
            $('#parentHorizontalTab').easyResponsiveTabs({
                type: 'default', //Types: default, vertical, accordion
                width: 'auto', //auto or any width like 600px
                fit: true, // 100% fit in a container
                tabidentify: 'hor_1', // The tab groups identifier
                activate: function (event) { // Callback function if tab is switched
                    var $tab = $(this);
                    var $info = $('#nested-tabInfo');
                    var $name = $('span', $info);
                    $name.text($tab.text());
                    $info.show();
                }
            });

            // Child Tab
            $('#ChildVerticalTab_1,#ChildVerticalTab_2').easyResponsiveTabs({
                type: 'vertical',
                width: 'auto',
                fit: true,
                tabidentify: 'ver_1', // The tab groups identifier
                activetab_bg: '#fff', // background color for active tabs in this group
                inactive_bg: '#F5F5F5', // background color for inactive tabs in this group
                active_border_color: '#221f20', // border color for active tabs heads in this group
                active_content_border_color: '#221f20' // border color for active tabs contect in this group so that it matches the tab head border
            });

            //Vertical Tab
            $('#parentVerticalTab').easyResponsiveTabs({
                type: 'vertical', //Types: default, vertical, accordion
                width: 'auto', //auto or any width like 600px
                fit: true, // 100% fit in a container
                closed: 'accordion', // Start closed if in accordion view
                tabidentify: 'hor_1', // The tab groups identifier
                activate: function (event) { // Callback function if tab is switched
                    var $tab = $(this);
                    var $info = $('#nested-tabInfo2');
                    var $name = $('span', $info);
                    $name.text($tab.text());
                    $info.show();
                }
            });

            jQuery('#slicktabs').slick({
            slidesToShow: 11,
            slidesToScroll: 3,
            draggable: false,
            infinite: false,
            speed: 300,
            responsive: [
            {
            breakpoint: 1600,
            settings: {
                slidesToShow: 9,
            }
            },
            {
            breakpoint: 1400,
            settings: {
                slidesToShow: 8,
                slidesToScroll: 2
            }
            },
            {
            breakpoint: 1300,
            settings: {
                slidesToShow: 7,
                slidesToScroll: 2
            }
            },
            {
             breakpoint: 1199,
                settings: {
                    slidesToShow: 6,
                    slidesToScroll: 2
                }
            }
            
            // You can unslick at a given breakpoint now by adding:
            // settings: "unslick"
            // instead of a settings object
        ]

                    });


        });
    </script>

	<style>
		.woocommerce-tabs {display:none !important}
		</style>



<?php } ?>







 
<?php }



/**
 * @snippet       Add Text to Customer Processing Order Email
 * @how-to        Get CustomizeWoo.com FREE
 * @author        Rodolfo Melogli
 * @testedwith    Woo 4.6
 * @donate $9     https://businessbloomer.com/bloomer-armada/
 */
  
add_action( 'woocommerce_email_after_order_table', 'bbloomer_add_content_specific_email', 20, 4 );
  
function bbloomer_add_content_specific_email( $order, $sent_to_admin, $plain_text, $email ) {
        if(ICL_LANGUAGE_CODE=='hu'){
            echo '<p><strong>A szállítási idő 2-4 munkanap.</strong></p>';
		} else {
            echo '<p><strong>The delivery time is 2-4 work days.</strong></p>';
		}
}


// Exclude product from all coupons in WooCommerce
// Create a custom field in the Product general setting tab
add_action( 'woocommerce_product_options_general_product_data', 'ql_add_custom_field_general_product_fields' );
function ql_add_custom_field_general_product_fields(){
global $post;

echo '<div class="product_custom_field">';

// Custom Product Checkbox Field
woocommerce_wp_checkbox( array(
'id' => '_disabled_for_coupons',
'label' => __('Disabled for coupons', 'woocommerce'),
'description' => __('Disable this product from coupon discounts', 'woocommerce'),
'desc_tip' => 'true',
) );

echo '</div>';;
}

// Save the custom field and update all the excluded product ids in WP settings
add_action( 'woocommerce_process_product_meta', 'ql_save_custom_field_general_product_fields', 10, 1 );
function ql_save_custom_field_general_product_fields( $post_id ){

$current_disabled = isset( $_POST['_disabled_for_coupons'] ) ? 'yes' : 'no';

$disabled_products = get_option( '_products_disabled_for_coupons' );
if( empty($disabled_products) ) {
if( $current_disabled == 'yes' )
$disabled_products = array( $post_id );
} else {
if( $current_disabled == 'yes' ) {
$disabled_products[] = $post_id;
$disabled_products = array_unique( $disabled_products );
} else {
if ( ( $key = array_search( $post_id, $disabled_products ) ) !== false )
unset( $disabled_products[$key] );
}
}

update_post_meta( $post_id, '_disabled_for_coupons', $current_disabled );
update_option( '_products_disabled_for_coupons', $disabled_products );
}

// Make coupons invalid at product level
add_filter('woocommerce_coupon_is_valid_for_product', 'set_coupon_validity_for_excluded_products', 12, 4);
function set_coupon_validity_for_excluded_products($valid, $product, $coupon, $values ){
if( ! count(get_option( '_products_disabled_for_coupons' )) > 0 ) return $valid;

$disabled_products = get_option( '_products_disabled_for_coupons' );
if( in_array( $product->get_id(), $disabled_products ) )
$valid = false;

return $valid;
}

// Set the product discount amount to zero
add_filter( 'woocommerce_coupon_get_discount_amount', 'zero_discount_for_excluded_products', 12, 5 );
function zero_discount_for_excluded_products($discount, $discounting_amount, $cart_item, $single, $coupon ){
if( ! count(get_option( '_products_disabled_for_coupons' )) > 0 ) return $discount;

$disabled_products = get_option( '_products_disabled_for_coupons' );
if( in_array( $cart_item['product_id'], $disabled_products ) )
$discount = 0;

return $discount;
}

/* Karacsonyi szünet kosár oldal start 
function woosuite_add_text_before_cart() {
    _e('<div class="cart-christmas-banner">
			<p style="text-transform: uppercase; font-size:18px; line-height:24px;">Kedves Borbarát!</p>
 			<p style="font-size:14px; line-height: 22px;" >Ezúton is köszönjük megrendelését. Tájékoztatni szeretnénk, hogy a Kopar 20. Jubileumi évjáratának kiszállítása megkezdődött. A nagymértékű érdeklődés okán a kiszállítások némi késéssel járnak, így akár 5-6 munkanapot is igénybe vehetnek. Megértését és türelmét ebben az átmeneti időszakban nagyon köszönjük!</p>
 
    </div>', 'shopgere' );
}
add_action( 'woocommerce_before_cart', 'woosuite_add_text_before_cart' );
add_action( 'woocommerce_before_checkout_form', 'woosuite_add_text_before_cart' );
Karacsonyi szünet kosár oldal end */


/**
 * @snippet       Shipping by Weight | WooCommerce
 * @author        Rodolfo Melogli
 * @compatible    WooCommerce 8
 * @community     https://businessbloomer.com/club/
 */
  
add_filter( 'woocommerce_package_rates', 'bbloomer_woocommerce_tiered_shipping', 9999, 2 );
    
function bbloomer_woocommerce_tiered_shipping( $rates, $package ) {
     
     if ( WC()->cart->get_cart_contents_weight() < 10 ) {
       
         if ( isset( $rates['flat_rate:9'] ) ) unset( $rates['flat_rate:10'], $rates['flat_rate:11'] );
       	

     } elseif ( WC()->cart->get_cart_contents_weight() < 20 ) {
       
         if ( isset( $rates['flat_rate:10'] ) ) unset( $rates['flat_rate:9'], $rates['flat_rate:11'] );
       
     } else {
       
         if ( isset( $rates['flat_rate:11'] ) ) unset( $rates['flat_rate:9'], $rates['flat_rate:10'] );
       
     }
    
   
   $cat_in_cart = false;
 
   
   foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
 
      if ( has_term( 'wines', 'product_cat', $cart_item['product_id'] ) || has_term( 'selections', 'product_cat', $cart_item['product_id'] ) ) {
         $cat_in_cart = true;

         break;
      }
   }
 
   if ( $cat_in_cart ) {
 
      unset( $rates['vp_pont:8']);
 		
 
   }

     return $rates;
    
}

/**
 * @snippet       Shipping Class Name @ WooCommerce Single Product
 * @tutorial      Get CustomizeWoo.com FREE
 * @author        Rodolfo Melogli
 * @compatible    WooCommerce 8
 * @community     Join https://businessbloomer.com/club/
 */
 
add_action( 'woocommerce_after_add_to_cart_button', 'bbloomer_echo_shipping_class' );
 
function bbloomer_echo_shipping_class() {
   global $product;
   if( is_product_category( array( 853 ) ) ) {
   	
   }
   	if( has_term( 853, 'product_cat' ) ) {
		echo '<div class="torekeny"><img src="/wp-content/themes/gereshop-child/images/icon-torekeny.svg" width="28" height="28" style="margin-right: 8px;">Törékeny</div>';
	}
	if( has_term( 855, 'product_cat' ) ) {
		echo '<div class="torekeny"><img src="/wp-content/themes/gereshop-child/images/icon-torekeny.svg" width="28" height="28" style="margin-right: 8px;">Fragile</div>';
	}	
   /* $class_id = $product->get_shipping_class_id();
   if ( $class_id ) {
      $term = get_term_by( 'id', $class_id, 'product_shipping_class' );
      if ( $term && ! is_wp_error( $term ) ) {
      	if ($product->get_shipping_class_id() == 851) {
        	echo '<div class="torekeny"><img src="/wp-content/themes/gereshop-child/images/icon-torekeny.svg" width="28" height="28" style="margin-right: 8px;">' . $term->name . '</div>';
        }
        if ($product->get_shipping_class_id() == 852) {
        	echo '<div class="torekeny"><img src="/wp-content/themes/gereshop-child/images/icon-torekeny.svg" width="28" height="28" style="margin-right: 8px;">' . $term->name . '</div>';
        }
        // var_dump($term);

      }
   } */
}

/* kosar penztar info boxes start */
function stop_deliver_box_before_cart_checkout() {
	_e('<div class="col-md-12" style="text-align: center; background: #fa1919; color:#fff; margin-bottom:30px; padding:20px;">
    		<p>The orders placed after 17.12.2024 12:00 will be delivered after 01.06.2025. Thank you for your understanding!</p>
    		<p>We wish you peaceful and blessed holidays!</p>
    	</div>', 'shopgere' );
}
// add_action( 'woocommerce_before_cart', 'stop_deliver_box_before_cart_checkout' );
// add_action( 'woocommerce_before_checkout_form', 'stop_deliver_box_before_cart_checkout' );
function info_box_before_cart_checkout() {
    _e('<div class="row cart-checkout-info-boxes">
    		<div class="col-md-6">
    			<div class="box-torekeny">
    				<p>MPL courier service charges an additional fee for handling shipments containing fragile products in a unique, differentiated manner!</p>
    				<p><a href="/en/terms-and-conditions/#shipping-charges">More information HERE</a></p>
    			</div>
    		</div>
    		<div class="col-md-6">
    			<div class="box-kulfold">
	    			<p>In case of ordering to a foreign address, please find our representing partners HERE. If you can\'t find Gere wines in the chosen destination country, we will be happy to help deliver the selected items to you.</p>
					<p><a href="https://gere.hu/en/where-to-buy/#!/foreign-traders" target="_blank">More information HERE</a></p>
				</div>
    		</div>
    	</div>', 'shopgere' );
}
add_action( 'woocommerce_before_cart', 'info_box_before_cart_checkout' );
add_action( 'woocommerce_before_checkout_form', 'info_box_before_cart_checkout' );
/* kosar penztar info boxes end */


/**
 * @snippet       Hide one shipping rate when Free Shipping is available
 * @how-to        Get CustomizeWoo.com FREE
 * @author        Rodolfo Melogli
 * @compatible    WooCommerce 6
 * @community     https://businessbloomer.com/club/
 */
  
add_filter( 'woocommerce_package_rates', 'bbloomer_unset_shipping_when_free_is_available_in_zone', 9999, 2 );
   
function bbloomer_unset_shipping_when_free_is_available_in_zone( $rates, $package ) {
   // Only unset rates if free_shipping is available
   if ( isset( $rates['flat_rate:13'] ) ) {
      unset( $rates['flat_rate:1'] );
   }
   if ( isset( $rates['flat_rate:3'] ) ) {
      unset( $rates['flat_rate:1'] );
   }
   if ( isset( $rates['flat_rate:6'] ) ) {
      unset( $rates['flat_rate:1'] );
   }               
   return $rates;
}

add_filter( 'woocommerce_package_rates', 'hide_specific_flat_rate_if_free_shipping', 100, 2 );

function hide_specific_flat_rate_if_free_shipping( $rates, $package ) {
    // Ellenőrizzük, hogy az ingyenes szállítás elérhető-e
    $free_shipping_available = false;

    foreach ( $rates as $rate_id => $rate ) {
        if ( strpos( $rate_id, 'free_shipping' ) !== false ) {
            $free_shipping_available = true;
            break;
        }
    }

    // Ha van ingyenes szállítás, távolítsuk el a flat_rate instance_id=1 szállítási módot
    if ( $free_shipping_available ) {
        foreach ( $rates as $rate_id => $rate ) {
            if ( strpos( $rate_id, 'flat_rate:1' ) !== false ) { // instance_id=1
                unset( $rates[ $rate_id ] );
            }
        }
    }

    return $rates;
}

// Csomagolási díj PostaPonhoz
add_action( 'woocommerce_cart_calculate_fees', 'csomagpont_csomagolasi_dij', 20, 1 );
function csomagpont_csomagolasi_dij( $cart ) {
    if ( is_admin() && ! defined( 'DOING_AJAX' ) )
        return;

    $chosen_shipping_methods = WC()->session->get( 'chosen_shipping_methods' );
    if(ICL_LANGUAGE_CODE=='hu'){
    	if( in_array( 'vp_pont:8', $chosen_shipping_methods ) ) {
        	$fee = array( 'text' => __( "Csomagolási díj", "woocommerce" ), 'amount' => 1000 );
    	}
    	if( in_array( 'flat_rate:9', $chosen_shipping_methods ) || in_array( 'flat_rate:10', $chosen_shipping_methods ) || in_array( 'flat_rate:11', $chosen_shipping_methods ) ) {
        	$fee = array( 'text' => __( "Csomagolási díj", "woocommerce" ), 'amount' => 1000 );
    	}
    }else{
    	if( in_array( 'vp_pont:8', $chosen_shipping_methods ) ) {
        	$fee = array( 'text' => __( "Packaging fee", "woocommerce" ), 'amount' => 1000 );
    	}
    	if( in_array( 'flat_rate:9', $chosen_shipping_methods ) || in_array( 'flat_rate:10', $chosen_shipping_methods ) || in_array( 'flat_rate:11', $chosen_shipping_methods ) ) {
        	$fee = array( 'text' => __( "Packaging fee", "woocommerce" ), 'amount' => 1000 );
    	}
    }
   
    if( isset($fee) ) {
        $cart->add_fee( $fee['text'], $fee['amount'], false );
    }
}


/**
 * @snippet       Check if Product Category is in the Cart - WooCommerce
 * @how-to        Get CustomizeWoo.com FREE
 * @author        Rodolfo Melogli
 * @compatible    WooCommerce 5
 * @community     https://businessbloomer.com/club/
 */
 
add_action( 'woocommerce_before_cart', 'bbloomer_check_category_in_cart' );
 
function bbloomer_check_category_in_cart() {
 

 
}

add_action('admin_head', 'my_custom_css');

function my_custom_css() {
echo '<style>
#postbox-container-2 { clear: left; }
html[dir="rtl"] #postbox-container-2 { clear: right; }
</style>';
}

add_action('woocommerce_cart_calculate_fees', 'add_custom_bottle_return_fee');

function add_custom_bottle_return_fee() {
    global $woocommerce;
    
    $fee = 0;
    $fee_label = (defined('ICL_LANGUAGE_CODE') && ICL_LANGUAGE_CODE === 'en') ? 'Return Fee' : 'Visszaváltási díj';
    
    // Ellenőrzi az egyes termékeket a kosárban
    foreach ($woocommerce->cart->get_cart() as $cart_item) {
        $product = $cart_item['data'];
        $quantity = $cart_item['quantity'];
        
        // Lekérdezi a 'return_fee' ACF mező értékét az adott termékre
        $acf_multiplier = get_field('return_fee', $product->get_id());
        
        // Ha az ACF mező értéke üres vagy nulla, akkor nem számol díjat
        if ($acf_multiplier) {
            $fee += 50 * $acf_multiplier * $quantity;
        }
    }
    
    if ($fee > 0) {
        $woocommerce->cart->add_fee($fee_label, $fee, true);
    }
}

add_filter('woocommerce_available_payment_gateways', 'restrict_cod_for_specific_product');

function restrict_cod_for_specific_product($available_gateways) {
    // Csak akkor futtassuk a kódot, ha nem az admin felületen vagyunk
    if (is_admin()) {
        return $available_gateways;
    }

    // A magyar és az angol verzió termékazonosítói
    $hungarian_product_id = 7013; // Magyar verzió termék ID
    $english_product_id = 7020; // Angol verzió termék ID
    
    // Ellenőrzés, hogy a specifikus termék bármely nyelven a kosárban van-e
    $product_in_cart = false;
    foreach (WC()->cart->get_cart() as $cart_item) {
        if ($cart_item['product_id'] == $hungarian_product_id || $cart_item['product_id'] == $english_product_id) {
            $product_in_cart = true;
            break;
        }
    }
    
    // Ha a termék a kosárban van, az utánvét (COD) fizetési módot eltávolítjuk
    if ($product_in_cart) {
        unset($available_gateways['cod']);  // Utánvét eltávolítása
    }
    
    return $available_gateways;
}

if (date_between('2025-03-06 00:00:01','2025-03-09 23:59:59')){
	 add_action( 'wp_body_open', 'info_ticker' );
}

function info_ticker(){
	?>
		<div class="ticker-container-01 desktop">
			<?php _e( "Nőnapi kedvezmény: -20% minden Grapelove termékre március 6-9. között. Kuponkód: GRAPELOVENOK", 'andreagere' ); ?>
		</div>
		<div class="ticker-container-01 mobile">
			<div class="scrolling">
				<?php _e( "Nőnapi kedvezmény: -20% minden Grapelove termékre március 6-9. között. Kuponkód: GRAPELOVENOK", 'andreagere' ); ?>
			</div>
			<div class="scrolling">
				<?php _e( "Nőnapi kedvezmény: -20% minden Grapelove termékre március 6-9. között. Kuponkód: GRAPELOVENOK", 'andreagere' ); ?>
			</div>
			<div class="scrolling">
				<?php _e( "Nőnapi kedvezmény: -20% minden Grapelove termékre március 6-9. között. Kuponkód: GRAPELOVENOK", 'andreagere' ); ?>
			</div>
			<div class="scrolling">
				<?php _e( "Nőnapi kedvezmény: -20% minden Grapelove termékre március 6-9. között. Kuponkód: GRAPELOVENOK", 'andreagere' ); ?>
			</div>
		</div>
	<?php
} 
function date_between($start, $end){
	return new \DateTime($start, new \DateTimeZone('Europe/Budapest')) <= new \DateTime('now',new \DateTimeZone('Europe/Budapest')) && new \DateTime($end, new \DateTimeZone('Europe/Budapest')) > new \DateTime('now',new \DateTimeZone('Europe/Budapest')	);
}