<?php if ( ! defined( 'ABSPATH' ) ) {
	exit( 'No direct script access allowed' );
}
/**
 * Template "Header" for 8theme dashboard.
 *
 * @since   6.0.2
 * @version 1.0.4
 */

$theme_builders_page = isset($args['theme_builders_page']);
$has_pro = $theme_builders_page ? defined( 'ELEMENTOR_PRO_VERSION' ) : false; // check only if it is needed page
$has_header_description = isset($args['theme_builders_page']) && !$has_pro;
$large_header = !!$has_header_description;
$theme                = wp_get_theme();
$theme_version        = $version = $theme->get( 'Version' );
$is_activated         = etheme_is_activated();
$is_et_core           = class_exists( 'ETC\App\Controllers\Admin\Import' );
$is_child_theme       = is_child_theme();
$settings             = array();
$xstore_branding_settings = get_option( 'xstore_white_label_branding_settings', array() );

ob_start();
if ( $theme_builders_page ) : ?>
    <svg width="242" height="24" viewBox="0 0 242 24" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
        <g clip-path="url(#clip0_2408_110)">
            <path d="M19.9397 11.2769L27.6513 0.109375H24.6482C24.5358 0.109375 24.4363 0.128645 24.3496 0.176831C24.3078 0.192886 24.2692 0.218586 24.234 0.247482C24.1183 0.340618 24.0155 0.459475 23.916 0.613637L18.6967 8.36385L18.186 9.11862C18.006 9.38788 18.167 9.15133 17.8005 9.67142L17.4279 10.2372L16.6829 11.2769L24.6482 23.3631C24.6932 23.3696 24.7414 23.3728 24.7928 23.3728H27.9115L19.9397 11.2769Z"/>
            <path d="M10.6611 11.4244L2.98226 0.108887H6.11539C6.34279 0.108887 6.51043 0.146839 6.61865 0.222431C6.7267 0.298335 6.82424 0.406547 6.91097 0.547065L12.9826 9.86582C13.0581 9.63837 13.1719 9.38965 13.3236 9.11898L19.0545 0.612305C19.1517 0.460809 19.2571 0.33911 19.371 0.246896C19.4845 0.154995 19.6225 0.108887 19.785 0.108887H22.7883L15.0769 11.2782L23.048 23.3728H19.9309C19.6928 23.3728 19.5061 23.3107 19.371 23.1862C19.2355 23.062 19.1248 22.9239 19.0382 22.7722L12.8039 13.0152C12.7282 13.2426 12.6308 13.4591 12.5118 13.6645L6.44017 22.7722C6.34278 22.9239 6.23159 23.062 6.10739 23.1862C5.98271 23.3107 5.80706 23.3728 5.57965 23.3728H2.65747L10.6611 11.4244Z"/>
            <path d="M42.1199 3.92925C42.0249 4.08818 41.9238 4.20729 41.8181 4.28695C41.7117 4.36622 41.5738 4.40605 41.4045 4.40605C41.2238 4.40605 41.0146 4.31605 40.7764 4.13567C40.5382 3.95567 40.2356 3.75691 39.8703 3.53976C39.5042 3.32262 39.0646 3.12385 38.5506 2.94347C38.0366 2.76309 37.4139 2.67309 36.6824 2.67309C35.993 2.67309 35.3834 2.76615 34.8541 2.95151C34.3233 3.13687 33.8814 3.38848 33.5263 3.70673C33.1709 4.02461 32.9036 4.39801 32.7232 4.82733C32.5428 5.25664 32.4533 5.72042 32.4533 6.21867C32.4533 6.8548 32.6095 7.38215 32.922 7.80074C33.2345 8.21934 33.6481 8.57739 34.1625 8.87387C34.6764 9.17066 35.2593 9.428 35.9111 9.64518C36.5629 9.86228 37.2309 10.0879 37.9141 10.3207C38.598 10.554 39.266 10.8163 39.9178 11.1077C40.5696 11.3996 41.1525 11.7676 41.6664 12.2126C42.1812 12.658 42.5941 13.2042 42.9073 13.8502C43.2198 14.4971 43.376 15.2921 43.376 16.2354C43.376 17.2319 43.206 18.1671 42.8675 19.0414C42.5282 19.9162 42.0326 20.6767 41.3808 21.3232C40.7289 21.9696 39.9285 22.4787 38.9795 22.8494C38.0305 23.2205 36.9528 23.4058 35.7442 23.4058C34.2712 23.4058 32.9273 23.1385 31.7137 22.6031C30.5 22.0677 29.4641 21.3447 28.6055 20.4328L29.4958 18.9698C29.5806 18.8534 29.6839 18.7554 29.8057 18.6757C29.9275 18.5965 30.0627 18.5566 30.2113 18.5566C30.4338 18.5566 30.6881 18.6757 30.9745 18.9143C31.2606 19.1529 31.6183 19.4152 32.0477 19.7014C32.4769 19.9874 32.9962 20.2498 33.606 20.4884C34.2153 20.7269 34.9598 20.846 35.8399 20.846C36.5706 20.846 37.2232 20.7457 37.7953 20.5439C38.3675 20.3428 38.8523 20.059 39.2499 19.6933C39.6474 19.3279 39.9523 18.8906 40.1644 18.3816C40.3766 17.873 40.4823 17.3062 40.4823 16.6804C40.4823 15.9915 40.3261 15.4273 40.0135 14.9873C39.7003 14.5477 39.2897 14.1792 38.7811 13.882C38.2725 13.5856 37.692 13.3336 37.0401 13.1268C36.3883 12.9203 35.7204 12.7082 35.0372 12.4911C34.3531 12.2739 33.6853 12.0219 33.0334 11.7358C32.3816 11.4497 31.8014 11.0786 31.2924 10.6229C30.7838 10.1672 30.3729 9.59726 30.0604 8.91363C29.7475 8.23009 29.5912 7.38483 29.5912 6.37761C29.5912 5.57221 29.7475 4.79324 30.0604 4.04031C30.3729 3.28776 30.8259 2.62024 31.4196 2.03697C32.0132 1.45446 32.7474 0.987616 33.6217 0.637958C34.4964 0.288301 35.4998 0.113281 36.6349 0.113281C37.9064 0.113281 39.0676 0.314726 40.1169 0.717616C41.1663 1.12051 42.0824 1.70339 42.8675 2.46628L42.1199 3.92925Z"/>
            <path d="M62.8206 0.367676V2.95927H55.4599V23.1517H52.3754V2.95927H44.9817V0.367676H62.8206Z"/>
            <path d="M85.6679 11.7676C85.6679 13.4741 85.3981 15.0405 84.8577 16.466C84.3165 17.8913 83.5541 19.1184 82.5682 20.1467C81.5823 21.1746 80.3972 21.9724 79.0144 22.5395C77.6309 23.1068 76.102 23.3901 74.4277 23.3901C72.7525 23.3901 71.226 23.1068 69.8481 22.5395C68.4701 21.9724 67.2882 21.1746 66.3025 20.1467C65.3167 19.1184 64.5538 17.8913 64.013 16.466C63.4731 15.0405 63.2026 13.4741 63.2026 11.7676C63.2026 10.061 63.4731 8.49511 64.013 7.06926C64.5538 5.64383 65.3167 4.41409 66.3025 3.38044C67.2882 2.34718 68.4701 1.54408 69.8481 0.971913C71.226 0.399364 72.7525 0.113281 74.4277 0.113281C76.102 0.113281 77.6309 0.399364 79.0144 0.971913C80.3972 1.54408 81.5823 2.34718 82.5682 3.38044C83.5541 4.41409 84.3165 5.64383 84.8577 7.06926C85.3981 8.49511 85.6679 10.061 85.6679 11.7676ZM82.5047 11.7676C82.5047 10.3686 82.3141 9.11246 81.9313 7.99949C81.5502 6.88658 81.0098 5.94599 80.3101 5.17736C79.6105 4.40873 78.7619 3.8178 77.7665 3.40457C76.77 2.99096 75.657 2.78453 74.4277 2.78453C73.2083 2.78453 72.1007 2.99096 71.1042 3.40457C70.1078 3.8178 69.2575 4.40873 68.5528 5.17736C67.8474 5.94599 67.3043 6.88658 66.9229 7.99949C66.5415 9.11246 66.3507 10.3686 66.3507 11.7676C66.3507 13.1666 66.5415 14.4201 66.9229 15.5277C67.3043 16.6356 67.8474 17.5735 68.5528 18.3421C69.2575 19.1107 70.1078 19.699 71.1042 20.1069C72.1007 20.5152 73.2083 20.7189 74.4277 20.7189C75.657 20.7189 76.77 20.5152 77.7665 20.1069C78.7619 19.699 79.6105 19.1107 80.3101 18.3421C81.0098 17.5735 81.5502 16.6356 81.9313 15.5277C82.3141 14.4201 82.5047 13.1666 82.5047 11.7676Z"/>
            <path d="M93.2683 13.6439V23.1517H90.1992V0.367676H96.6386C98.0802 0.367676 99.3257 0.513589 100.375 0.805036C101.425 1.09648 102.29 1.51814 102.975 2.06886C103.658 2.62034 104.164 3.28518 104.493 4.06454C104.822 4.8435 104.986 5.71554 104.986 6.67987C104.986 7.48566 104.859 8.23779 104.605 8.9375C104.349 9.6372 103.982 10.2653 103.499 10.8218C103.017 11.3782 102.429 11.8527 101.734 12.2445C101.04 12.637 100.254 12.9338 99.3736 13.1349C99.7547 13.3575 100.094 13.6811 100.392 14.105L107.037 23.1517H104.302C103.74 23.1517 103.327 22.9345 103.062 22.4998L97.1476 14.3593C96.9672 14.105 96.7711 13.9219 96.5594 13.8109C96.3468 13.6994 96.0292 13.6439 95.6056 13.6439H93.2683ZM93.2683 11.402H96.4958C97.3963 11.402 98.1892 11.2936 98.8724 11.0761C99.5563 10.8589 100.129 10.5513 100.59 10.1538C101.05 9.75634 101.398 9.28221 101.632 8.73067C101.865 8.17999 101.981 7.57029 101.981 6.90238C101.981 5.54588 101.534 4.52296 100.637 3.83398C99.7414 3.14502 98.4088 2.80033 96.6386 2.80033H93.2683V11.402Z"/>
            <path d="M124.399 0.367676V2.88H113.461V10.448H122.317V12.8646H113.461V20.6397H124.399V23.1517H110.36V0.367676H124.399Z"/>
            <path opacity="0.7" d="M134.905 23.2741V0.639836H141.275C142.538 0.639836 143.628 0.767804 144.546 1.02374C145.474 1.27967 146.241 1.65825 146.847 2.15945C147.451 2.64999 147.9 3.2525 148.193 3.96699C148.495 4.68147 148.646 5.49193 148.646 6.39837C148.646 6.99555 148.542 7.57141 148.333 8.12593C148.135 8.68045 147.843 9.19231 147.457 9.66158C147.071 10.1308 146.596 10.5413 146.033 10.8932C145.48 11.2345 144.843 11.4957 144.124 11.677C145.866 11.9436 147.206 12.5355 148.146 13.4526C149.084 14.3697 149.554 15.58 149.554 17.0836C149.554 18.0434 149.387 18.9072 149.053 19.675C148.719 20.4428 148.234 21.0933 147.597 21.6265C146.961 22.1597 146.178 22.5702 145.25 22.8581C144.321 23.1354 143.268 23.2741 142.089 23.2741H134.905ZM136.501 12.4289V21.9624H142.058C144.008 21.9624 145.48 21.5358 146.471 20.6827C147.462 19.8189 147.957 18.6086 147.957 17.0516C147.957 16.3372 147.822 15.6973 147.55 15.1321C147.29 14.5563 146.909 14.0711 146.408 13.6765C145.907 13.2713 145.291 12.962 144.561 12.7488C143.831 12.5355 143.002 12.4289 142.073 12.4289H136.501ZM136.501 11.2291H141.306C142.329 11.2291 143.2 11.0958 143.92 10.8292C144.65 10.5626 145.245 10.2108 145.704 9.7735C146.174 9.33631 146.518 8.84038 146.737 8.28585C146.956 7.73136 147.066 7.16084 147.066 6.57432C147.066 5.04938 146.591 3.89767 145.641 3.11921C144.702 2.33007 143.247 1.93551 141.275 1.93551H136.501V11.2291ZM155.317 7.35812V17.5315C155.317 19.0245 155.651 20.1975 156.318 21.0506C156.986 21.8931 158.003 22.3143 159.37 22.3143C160.382 22.3143 161.326 22.053 162.202 21.5305C163.079 20.9973 163.867 20.2615 164.566 19.3231V7.35812H166.068V23.2741H165.239C164.947 23.2741 164.795 23.1354 164.785 22.8581L164.644 20.4908C163.924 21.4079 163.09 22.1437 162.14 22.6982C161.201 23.2527 160.152 23.53 158.995 23.53C158.129 23.53 157.372 23.3914 156.725 23.1141C156.078 22.8368 155.541 22.437 155.113 21.9144C154.685 21.3919 154.362 20.7627 154.143 20.0269C153.924 19.2911 153.814 18.4593 153.814 17.5315V7.35812H155.317ZM173.065 7.35812V23.2741H171.578V7.35812H173.065ZM173.722 1.87152C173.722 2.06347 173.68 2.24476 173.597 2.41539C173.524 2.57534 173.425 2.71931 173.3 2.84727C173.174 2.97524 173.029 3.07655 172.862 3.1512C172.694 3.22585 172.517 3.26317 172.329 3.26317C172.142 3.26317 171.964 3.22585 171.797 3.1512C171.63 3.07655 171.484 2.97524 171.359 2.84727C171.234 2.71931 171.134 2.57534 171.061 2.41539C170.989 2.24476 170.952 2.06347 170.952 1.87152C170.952 1.67957 170.989 1.49828 171.061 1.32766C171.134 1.14637 171.234 0.99175 171.359 0.863778C171.484 0.735812 171.63 0.634505 171.797 0.559856C171.964 0.485209 172.142 0.447886 172.329 0.447886C172.517 0.447886 172.694 0.485209 172.862 0.559856C173.029 0.634505 173.174 0.735812 173.3 0.863778C173.425 0.99175 173.524 1.14637 173.597 1.32766C173.68 1.49828 173.722 1.67957 173.722 1.87152ZM180.492 0V23.2741H179.006V0H180.492ZM197.029 23.2741C196.768 23.2741 196.617 23.1354 196.575 22.8581L196.418 20.3468C195.73 21.3066 194.921 22.069 193.993 22.6342C193.075 23.1994 192.042 23.482 190.894 23.482C188.984 23.482 187.492 22.8049 186.418 21.4505C185.354 20.0962 184.822 18.0648 184.822 15.3561C184.822 14.1937 184.968 13.1113 185.259 12.1089C185.562 11.0958 186.001 10.2214 186.575 9.48557C187.158 8.73912 187.868 8.1526 188.703 7.72603C189.548 7.29947 190.518 7.08619 191.614 7.08619C192.668 7.08619 193.58 7.28881 194.352 7.69404C195.125 8.08859 195.792 8.66979 196.356 9.43757V0H197.858V23.2741H197.029ZM191.316 22.2504C192.349 22.2504 193.283 21.9784 194.118 21.4346C194.952 20.8906 195.698 20.1335 196.356 19.1631V10.7653C195.751 9.85883 195.083 9.21898 194.352 8.84571C193.633 8.47253 192.813 8.28585 191.896 8.28585C190.977 8.28585 190.174 8.45653 189.485 8.79779C188.797 9.13897 188.218 9.62424 187.748 10.2534C187.289 10.8719 186.94 11.6184 186.7 12.4928C186.47 13.3566 186.355 14.311 186.355 15.3561C186.355 17.7235 186.783 19.4671 187.638 20.5868C188.494 21.6958 189.72 22.2504 191.316 22.2504ZM208.951 7.10219C209.827 7.10219 210.636 7.25682 211.376 7.56607C212.128 7.87533 212.775 8.32852 213.317 8.92571C213.87 9.51224 214.298 10.2374 214.601 11.1011C214.914 11.9649 215.07 12.9567 215.07 14.0764C215.07 14.311 215.034 14.471 214.961 14.5563C214.898 14.6416 214.794 14.6843 214.648 14.6843H203.395V14.9882C203.395 16.1825 203.531 17.2329 203.802 18.1394C204.073 19.0458 204.459 19.8083 204.96 20.4268C205.461 21.0346 206.066 21.4932 206.775 21.8024C207.485 22.1117 208.278 22.2664 209.154 22.2664C209.937 22.2664 210.615 22.181 211.189 22.0104C211.763 21.8291 212.243 21.6318 212.629 21.4186C213.025 21.1946 213.338 20.9973 213.568 20.8267C213.797 20.6454 213.964 20.5548 214.068 20.5548C214.204 20.5548 214.308 20.608 214.382 20.7147L214.788 21.2266C214.538 21.5465 214.204 21.8451 213.786 22.1224C213.38 22.3996 212.921 22.6395 212.409 22.8421C211.909 23.0341 211.366 23.1887 210.782 23.3061C210.208 23.4233 209.629 23.482 209.044 23.482C207.981 23.482 207.01 23.2954 206.134 22.9221C205.258 22.5383 204.506 21.9838 203.88 21.2586C203.254 20.5335 202.769 19.6483 202.425 18.6033C202.09 17.5475 201.924 16.3425 201.924 14.9882C201.924 13.8472 202.08 12.7967 202.393 11.837C202.717 10.8665 203.176 10.0348 203.771 9.34165C204.376 8.63778 205.111 8.08859 205.977 7.69404C206.854 7.29948 207.845 7.10219 208.951 7.10219ZM208.967 8.23793C208.163 8.23793 207.443 8.36586 206.807 8.62178C206.171 8.87771 205.618 9.24564 205.148 9.7255C204.689 10.2054 204.313 10.7813 204.021 11.4531C203.739 12.1249 203.552 12.8767 203.458 13.7085H213.724C213.724 12.8554 213.609 12.0929 213.38 11.4211C213.15 10.7386 212.827 10.1628 212.409 9.6935C211.992 9.22431 211.492 8.86705 210.907 8.62178C210.323 8.36586 209.676 8.23793 208.967 8.23793ZM219.069 23.2741V7.35812H219.851C220.028 7.35812 220.154 7.39545 220.227 7.47009C220.311 7.54475 220.357 7.67271 220.368 7.854L220.493 11.2131C220.994 9.92284 221.661 8.91505 222.496 8.18993C223.331 7.4541 224.358 7.08619 225.579 7.08619C226.049 7.08619 226.482 7.13951 226.878 7.24615C227.275 7.34213 227.65 7.48609 228.005 7.67804L227.802 8.73379C227.77 8.90438 227.666 8.98972 227.489 8.98972C227.426 8.98972 227.337 8.96838 227.222 8.92571C227.108 8.88305 226.962 8.83504 226.784 8.78179C226.617 8.72845 226.409 8.68045 226.159 8.63779C225.908 8.59512 225.621 8.57378 225.297 8.57378C224.119 8.57378 223.148 8.94705 222.387 9.6935C221.635 10.44 221.025 11.5171 220.555 12.9247V23.2741H219.069ZM240.086 9.32565C240.013 9.4749 239.898 9.54957 239.742 9.54957C239.627 9.54957 239.476 9.48557 239.288 9.35765C239.11 9.21898 238.87 9.06972 238.568 8.90971C238.276 8.73912 237.911 8.58978 237.473 8.46186C237.044 8.32319 236.518 8.25393 235.892 8.25393C235.328 8.25393 234.812 8.33919 234.342 8.50986C233.883 8.66979 233.487 8.88838 233.153 9.16564C232.829 9.4429 232.574 9.76817 232.386 10.1414C232.209 10.504 232.12 10.8879 232.12 11.2931C232.12 11.7943 232.245 12.2102 232.496 12.5408C232.746 12.8714 233.075 13.154 233.482 13.3886C233.889 13.6232 234.348 13.8258 234.859 13.9964C235.381 14.167 235.913 14.3377 236.455 14.5083C236.998 14.679 237.524 14.8709 238.036 15.0841C238.557 15.2867 239.022 15.5427 239.429 15.8519C239.836 16.1612 240.164 16.5398 240.415 16.9876C240.665 17.4356 240.79 17.9794 240.79 18.6193C240.79 19.3124 240.665 19.9576 240.415 20.5548C240.175 21.152 239.82 21.6692 239.35 22.1064C238.891 22.5436 238.323 22.8901 237.644 23.1461C236.967 23.402 236.194 23.53 235.328 23.53C234.232 23.53 233.289 23.3541 232.496 23.0021C231.703 22.6395 230.993 22.1704 230.367 21.5945L230.727 21.0506C230.779 20.9653 230.837 20.9013 230.899 20.8587C230.962 20.8161 231.05 20.7947 231.166 20.7947C231.301 20.7947 231.468 20.88 231.666 21.0506C231.865 21.2212 232.12 21.4079 232.433 21.6105C232.756 21.8024 233.153 21.9838 233.622 22.1544C234.102 22.325 234.692 22.4103 235.391 22.4103C236.048 22.4103 236.627 22.3196 237.128 22.1384C237.629 21.9464 238.046 21.6905 238.38 21.3706C238.714 21.0506 238.964 20.6774 239.131 20.2509C239.309 19.8136 239.397 19.3551 239.397 18.8752C239.397 18.342 239.273 17.8994 239.022 17.5475C238.771 17.1956 238.443 16.897 238.036 16.6518C237.629 16.4064 237.164 16.1985 236.643 16.0279C236.132 15.8573 235.6 15.6867 235.047 15.5161C234.504 15.3454 233.972 15.1588 233.45 14.9562C232.939 14.7535 232.48 14.4976 232.073 14.1884C231.666 13.8791 231.338 13.5059 231.087 13.0686C230.837 12.6208 230.712 12.0663 230.712 11.4051C230.712 10.8399 230.832 10.296 231.072 9.7735C231.312 9.25098 231.65 8.79246 232.089 8.39786C232.538 8.00326 233.08 7.68871 233.716 7.4541C234.352 7.21949 235.068 7.10219 235.861 7.10219C236.81 7.10219 237.65 7.24082 238.38 7.51809C239.121 7.79535 239.799 8.22193 240.415 8.79779L240.086 9.32565Z"/>
        </g>
        <defs>
            <clipPath id="clip0_2408_110">
                <rect width="241.575" height="23.53"/>
            </clipPath>
        </defs>
    </svg>
<?php else : ?>
    <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg"
     xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     width="300px"
     viewBox="0 0 382.6038818 30" style="enable-background:new 0 0 382.6038818 30;" xml:space="preserve" fill="currentColor">
    <g id="lato">
        <path class="st0" d="M25.4224033,14.3775072l9.8320942-14.2383194h-3.8288116c-0.1433411,0-0.2702847,0.024569-0.3808575,0.086004
                    c-0.0532112,0.02047-0.102375,0.053237-0.1474133,0.090078C30.75,0.4340158,30.6189575,0.5855537,30.4920139,0.7821057
                    l-6.6543732,9.8812351l-0.6510906,0.9623146c-0.2295856,0.3433647-0.0243073,0.0417557-0.4916496,0.7048759l-0.4749699,0.721386
                    l-0.9498615,1.3255901l10.1556168,15.4094839c0.0573101,0.008173,0.1187458,0.0122719,0.1842556,0.0122719h3.9762516
                    L25.4224033,14.3775072z"/>
        <g class="st1">
            <path class="st0" d="M13.5925827,14.5656862L3.8023758,0.1388132h3.9946237c0.2899289,0,0.5036769,0.0483882,0.641643,0.1447646
                        C8.5764084,0.3803541,8.700778,0.5183204,8.8113508,0.6974766l7.741107,11.8810959
                        c0.0963764-0.2899294,0.2413425-0.6070518,0.4346943-0.9521675l7.3068142-10.8457489
                        c0.12397-0.1931528,0.258337-0.3483149,0.4035015-0.4658861c0.1447639-0.1171713,0.3207226-0.175957,0.5278702-0.175957h3.8290653
                        l-9.8317966,14.2405186l10.1629162,15.4202309H25.411293c-0.3035259,0-0.5414677-0.0791798-0.7138252-0.2379417
                        c-0.1727581-0.1583614-0.3139229-0.3343182-0.4242954-0.5278702l-7.9484577-12.4397602
                        c-0.0965767,0.2899303-0.220747,0.5658627-0.372509,0.8277988L8.2110977,29.0337505
                        c-0.1241693,0.193552-0.2659345,0.3695087-0.4242959,0.5278702c-0.1589613,0.158762-0.3829064,0.2379417-0.6728358,0.2379417
                        H3.3882768L13.5925827,14.5656862z"/>
        </g>
    </g>
    <g>
        <path class="st0" d="M53.7016754,5.0097628c-0.1210938,0.2026367-0.25,0.3544922-0.3847656,0.4560547
                    c-0.1357422,0.1010742-0.3115234,0.1518555-0.5273438,0.1518555c-0.2304688,0-0.4970703-0.1147461-0.8007812-0.3447266
                    c-0.3037109-0.2294922-0.6894531-0.4829102-1.1552734-0.7597656c-0.4667969-0.2768555-1.0273438-0.5302734-1.6826172-0.7602539
                    s-1.4492188-0.3447266-2.3818359-0.3447266c-0.8789062,0-1.65625,0.1186523-2.3310547,0.3549805
                    c-0.6767578,0.2363281-1.2402344,0.5571289-1.6928711,0.9628906c-0.453125,0.4052734-0.7939453,0.8813477-1.0239258,1.4287109
                    s-0.3442383,1.1386719-0.3442383,1.7739258c0,0.8110352,0.1992188,1.4833984,0.5976562,2.0170898
                    s0.9257812,0.9902344,1.581543,1.3681641c0.6552734,0.378418,1.3984375,0.706543,2.2294922,0.9833984
                    s1.6826172,0.5644531,2.5537109,0.8613281c0.8720703,0.2973633,1.7236328,0.6318359,2.5546875,1.003418
                    c0.8310547,0.3720703,1.5742188,0.8413086,2.2294922,1.4086914c0.65625,0.567872,1.1826172,1.2641611,1.5820312,2.0878916
                    c0.3984375,0.824707,0.5976562,1.8383789,0.5976562,3.0410156c0,1.2705078-0.2167969,2.4628906-0.6484375,3.5776367
                    c-0.4326172,1.1152344-1.0644531,2.0849609-1.8955078,2.9091797s-1.8515625,1.4731445-3.0615234,1.9458008
                    c-1.2099609,0.4731445-2.5839844,0.7094727-4.125,0.7094727c-1.8779297,0-3.5913086-0.3408203-5.1386719-1.0234375
                    s-2.8681641-1.6044922-3.9628906-2.7670898l1.1352539-1.8652344c0.1079102-0.1484375,0.2397461-0.2734375,0.3950195-0.375
                    c0.1552734-0.1010742,0.3276367-0.1518555,0.5170898-0.1518555c0.2836914,0,0.6079102,0.1518555,0.9731445,0.4560547
                    c0.3647461,0.3041992,0.8208008,0.6386719,1.3681641,1.003418s1.2094727,0.6992188,1.9868164,1.003418
                    c0.7768555,0.3041992,1.7260742,0.4560547,2.8481445,0.4560547c0.9316406,0,1.7636719-0.1279297,2.4931641-0.3852539
                    c0.7294922-0.2563477,1.3476562-0.6181641,1.8544922-1.0844727c0.5068359-0.4658203,0.8955078-1.0234375,1.1660156-1.6723633
                    c0.2705078-0.6484375,0.4052734-1.3710938,0.4052734-2.1689453c0-0.878418-0.1992188-1.5976562-0.5976562-2.1586914
                    c-0.3994141-0.5605469-0.9228516-1.0302734-1.5712891-1.4091797c-0.6484375-0.3779297-1.3886719-0.6992188-2.2197266-0.9628906
                    c-0.8310547-0.2631836-1.6826172-0.5336914-2.5537109-0.8105478c-0.8720703-0.2768555-1.7236328-0.5981445-2.5546875-0.9628906
                    s-1.5708008-0.8378906-2.2197266-1.4189453c-0.6484375-0.5810547-1.1723633-1.3076172-1.5708008-2.1791992
                    c-0.3989258-0.871582-0.5981445-1.9492188-0.5981445-3.2333984c0-1.0268555,0.1992188-2.0200195,0.5981445-2.9799805
                    c0.3984375-0.9594727,0.9760742-1.8105469,1.7329102-2.5541992c0.7568359-0.7426758,1.6928711-1.3378906,2.8076172-1.7836914
                    c1.1152344-0.4458008,2.3945312-0.6689453,3.8417969-0.6689453c1.6210938,0,3.1015625,0.2568359,4.4394531,0.7705078
                    s2.5058594,1.2568359,3.5068359,2.2294922L53.7016754,5.0097628z"/>
        <path class="st0" d="M80.0942535,0.4687472v3.3041992h-9.3847656v25.7446289h-3.9326172V3.7729464h-9.4267578V0.4687472H80.0942535
                    z"/>
        <path class="st0" d="M109.2241364,15.0034151c0,2.1757822-0.34375,4.1728525-1.0332031,5.9902353
                    s-1.6621094,3.3818359-2.9189453,4.6928711c-1.2568359,1.3105469-2.7675781,2.3276367-4.53125,3.0507812
                    s-3.7128906,1.0844727-5.8476562,1.0844727c-2.1357422,0-4.0820312-0.3613281-5.8388672-1.0844727
                    s-3.2636719-1.7402344-4.5205078-3.0507812c-1.2568359-1.3110352-2.2294922-2.8754883-2.9189453-4.6928711
                    c-0.6884766-1.8173828-1.0332031-3.8144531-1.0332031-5.9902353s0.3447266-4.1723633,1.0332031-5.9902344
                    c0.6894531-1.8173828,1.6621094-3.3852539,2.9189453-4.703125c1.2568359-1.3173828,2.7636719-2.3413086,4.5205078-3.0708008
                    c1.7568359-0.7299805,3.703125-1.0947266,5.8388672-1.0947266c2.1347656,0,4.0839844,0.3647461,5.8476562,1.0947266
                    c1.7636719,0.7294922,3.2744141,1.753418,4.53125,3.0708008c1.2568359,1.3178711,2.2294922,2.8857422,2.9189453,4.703125
                    C108.8803864,10.8310518,109.2241364,12.8276339,109.2241364,15.0034151z M105.1909332,15.0034151
                    c0-1.7836914-0.2431641-3.3852539-0.7304688-4.8041992c-0.4863281-1.4189453-1.1757812-2.6181641-2.0673828-3.5981445
                    s-1.9736328-1.7333984-3.2431641-2.2602539c-1.2705078-0.5273438-2.6894531-0.7905273-4.2568359-0.7905273
                    c-1.5546875,0-2.9667969,0.2631836-4.2373047,0.7905273c-1.2705078,0.5268555-2.3544922,1.2802734-3.2529297,2.2602539
                    c-0.8994141,0.9799805-1.5917969,2.1791992-2.078125,3.5981445s-0.7294922,3.0205078-0.7294922,4.8041992
                    s0.2431641,3.3818369,0.7294922,4.7939463c0.4863281,1.4125977,1.1787109,2.6083984,2.078125,3.5883789
                    c0.8984375,0.9799805,1.9824219,1.7299805,3.2529297,2.25c1.2705078,0.5205078,2.6826172,0.7802734,4.2373047,0.7802734
                    c1.5673828,0,2.9863281-0.2597656,4.2568359-0.7802734c1.2695312-0.5200195,2.3515625-1.2700195,3.2431641-2.25
                    s1.5810547-2.1757812,2.0673828-3.5883789C104.9477692,18.385252,105.1909332,16.7871075,105.1909332,15.0034151z"/>
        <path class="st0" d="M118.9135895,17.3955059v12.1220703h-3.9121094V0.4687472h8.2099609
                    c1.8378906,0,3.4257812,0.1860351,4.7636719,0.5576171s2.4423828,0.9091797,3.3144531,1.6113281
                    c0.8710938,0.703125,1.5166016,1.5507812,1.9355469,2.5444336c0.4189453,0.9931641,0.6289062,2.1049805,0.6289062,3.3344727
                    c0,1.0273438-0.1621094,1.9863281-0.4863281,2.878418c-0.3251953,0.8920898-0.7949219,1.6928711-1.4091797,2.4023438
                    c-0.6152344,0.7094727-1.3652344,1.3144531-2.25,1.8139648c-0.8857422,0.5004892-1.8886719,0.8789072-3.0107422,1.1352549
                    c0.4863281,0.2836914,0.9189453,0.6962891,1.2978516,1.2368164l8.4726562,11.5341797h-3.4863281
                    c-0.7167969,0-1.2431641-0.2768555-1.5810547-0.8310547l-7.5410156-10.3789062
                    c-0.2294922-0.3242188-0.4794922-0.5576172-0.75-0.6992188c-0.2705078-0.1420898-0.6757812-0.2128906-1.2158203-0.2128906
                    H118.9135895z M118.9135895,14.5371065h4.1152344c1.1484375,0,2.1591797-0.1381836,3.0302734-0.4155273
                    c0.8720703-0.2768555,1.6015625-0.6689453,2.1894531-1.1757812s1.0302734-1.1113281,1.328125-1.8144531
                    c0.296875-0.7021484,0.4462891-1.4794922,0.4462891-2.3310547c0-1.7294922-0.5712891-3.0336914-1.7138672-3.9121094
                    c-1.1416016-0.878418-2.8408203-1.3178711-5.0976562-1.3178711h-4.2978516V14.5371065z"/>
        <path class="st0" d="M158.6049957,0.4687472v3.203125h-13.9462891v9.6489258h11.2910156v3.0810556h-11.2910156v9.9130859
                    h13.9462891v3.2026367h-17.8994141V0.4687472H158.6049957z"/>
    </g>
    <g class="st2">
        <path class="st0" d="M194.5533142,24.7578125c0.1337891,0,0.2470703,0.046875,0.3398438,0.1396484l0.8007812,0.8603516
                    c-0.5869141,0.6259766-1.2275391,1.1894531-1.9199219,1.6894531c-0.6943359,0.5-1.4501953,0.9267578-2.2705078,1.2802734
                    s-1.7197266,0.6269531-2.7001953,0.8193359c-0.9794922,0.1933594-2.0566406,0.2900391-3.2294922,0.2900391
                    c-1.9599609,0-3.7568359-0.3427734-5.390625-1.0292969c-1.6328125-0.6865234-3.0332031-1.6601562-4.1992188-2.9199219
                    c-1.1669922-1.2607422-2.0771484-2.7832031-2.7304688-4.5703125c-0.6533203-1.7861328-0.9794922-3.7734375-0.9794922-5.9599609
                    c0-2.1464844,0.3359375-4.1064453,1.0097656-5.8798828c0.6728516-1.7729492,1.6201172-3.2963867,2.8398438-4.5698242
                    s2.6796875-2.2602539,4.3798828-2.9599609c1.7001953-0.7001953,3.5761719-1.050293,5.6298828-1.050293
                    c1.0263672,0,1.9667969,0.0771484,2.8203125,0.2299805c0.8525391,0.1538086,1.6494141,0.3735352,2.3896484,0.6601562
                    s1.4365234,0.6435547,2.0898438,1.0698242c0.6533203,0.4272461,1.2939453,0.9199219,1.9199219,1.4799805l-0.6191406,0.9003906
                    c-0.1074219,0.159668-0.2734375,0.2397461-0.5,0.2397461c-0.1201172,0-0.2734375-0.0698242-0.4599609-0.2099609
                    c-0.1875-0.1401367-0.4238281-0.3129883-0.7109375-0.5200195c-0.2861328-0.206543-0.6328125-0.4331055-1.0390625-0.6801758
                    c-0.4072266-0.246582-0.890625-0.4731445-1.4501953-0.6796875c-0.5605469-0.206543-1.2070312-0.3798828-1.9404297-0.5200195
                    s-1.5664062-0.2099609-2.5-0.2099609c-1.7197266,0-3.2998047,0.296875-4.7402344,0.8896484
                    c-1.4394531,0.59375-2.6796875,1.4404297-3.7197266,2.5400391c-1.0400391,1.1000977-1.8496094,2.4335938-2.4296875,4
                    c-0.5800781,1.5668945-0.8701172,3.3237305-0.8701172,5.2700195c0,2,0.2861328,3.7871094,0.8603516,5.3603516
                    c0.5722656,1.5732422,1.3662109,2.9033203,2.3798828,3.9892578c1.0126953,1.0869141,2.2099609,1.9199219,3.5898438,2.5
                    s2.8759766,0.8701172,4.4902344,0.8701172c1.0126953,0,1.9160156-0.0664062,2.7099609-0.2001953
                    c0.7929688-0.1328125,1.5224609-0.3330078,2.1894531-0.5996094s1.2871094-0.5927734,1.8603516-0.9804688
                    c0.5732422-0.3857422,1.1396484-0.8398438,1.7001953-1.359375c0.0664062-0.0537109,0.1298828-0.0966797,0.1894531-0.1298828
                    C194.4039001,24.7744141,194.4732361,24.7578125,194.5533142,24.7578125z"/>
        <path class="st0" d="M207.1539001,9.2973633c1.4257812,0,2.703125,0.2436523,3.8300781,0.7299805
                    c1.1259766,0.4873047,2.0761719,1.1772461,2.8496094,2.0703125c0.7734375,0.8935547,1.3632812,1.9697266,1.7695312,3.2299805
                    c0.4072266,1.2592773,0.6103516,2.6694336,0.6103516,4.2299805c0,1.5595703-0.203125,2.9667969-0.6103516,4.2197266
                    c-0.40625,1.2539062-0.9960938,2.3271484-1.7695312,3.2197266c-0.7734375,0.8935547-1.7236328,1.5800781-2.8496094,2.0605469
                    c-1.1269531,0.4794922-2.4042969,0.7197266-3.8300781,0.7197266c-1.4267578,0-2.7041016-0.2402344-3.8300781-0.7197266
                    c-1.1269531-0.4804688-2.0800781-1.1669922-2.8603516-2.0605469c-0.7802734-0.8925781-1.3730469-1.9658203-1.7802734-3.2197266
                    c-0.40625-1.2529297-0.609375-2.6601562-0.609375-4.2197266c0-1.5605469,0.203125-2.9707031,0.609375-4.2299805
                    c0.4072266-1.2602539,1-2.3364258,1.7802734-3.2299805c0.7802734-0.8930664,1.7333984-1.5830078,2.8603516-2.0703125
                    C204.4497986,9.5410156,205.7271423,9.2973633,207.1539001,9.2973633z M207.1539001,28.2773438
                    c1.1865234,0,2.2226562-0.203125,3.109375-0.6103516c0.8867188-0.40625,1.6269531-0.9892578,2.2207031-1.75
                    c0.5927734-0.7597656,1.0361328-1.6757812,1.3300781-2.75c0.2929688-1.0732422,0.4394531-2.2763672,0.4394531-3.609375
                    c0-1.3203125-0.1464844-2.5205078-0.4394531-3.6000977c-0.2939453-1.0800781-0.7373047-2.0029297-1.3300781-2.7700195
                    c-0.59375-0.7666016-1.3339844-1.3564453-2.2207031-1.7700195c-0.8867188-0.4130859-1.9228516-0.6201172-3.109375-0.6201172
                    c-1.1875,0-2.2236328,0.2070312-3.1103516,0.6201172c-0.8867188,0.4135742-1.6269531,1.003418-2.2197266,1.7700195
                    c-0.59375,0.7670898-1.0400391,1.6899414-1.3398438,2.7700195c-0.3007812,1.0795898-0.4501953,2.2797852-0.4501953,3.6000977
                    c0,1.3330078,0.1494141,2.5361328,0.4501953,3.609375c0.2998047,1.0742188,0.7460938,1.9902344,1.3398438,2.75
                    c0.5927734,0.7607422,1.3330078,1.34375,2.2197266,1.75C204.9302673,28.0742188,205.9664001,28.2773438,207.1539001,28.2773438z"/>
        <path class="st0" d="M219.6128845,29.5175781V9.6176758h1.0400391c0.3466797,0,0.5458984,0.1669922,0.5996094,0.5l0.1796875,3
                    c0.9072266-1.1464844,1.9638672-2.0703125,3.1708984-2.7700195c1.2060547-0.7001953,2.5498047-1.050293,4.0292969-1.050293
                    c1.09375,0,2.0566406,0.1738281,2.890625,0.5200195c0.8330078,0.347168,1.5224609,0.847168,2.0693359,1.5
                    c0.546875,0.6538086,0.9599609,1.4404297,1.2402344,2.3603516s0.4199219,1.9599609,0.4199219,3.1191406v12.7207031h-1.8994141
                    V16.796875c0-1.8657227-0.4277344-3.3291016-1.2802734-4.3891602c-0.8535156-1.0600586-2.1601562-1.590332-3.9199219-1.590332
                    c-1.3076172,0-2.5205078,0.3369141-3.640625,1.0102539s-2.1201172,1.5966797-3,2.7700195v14.9199219H219.6128845z"/>
        <path class="st0" d="M245.0718689,29.8369141c-1.3466797,0-2.3935547-0.3730469-3.140625-1.1191406
                    c-0.7460938-0.7470703-1.1191406-1.9003906-1.1191406-3.4599609V11.6577148h-2.8603516
                    c-0.1464844,0-0.2666016-0.0400391-0.3603516-0.1201172c-0.0927734-0.0800781-0.1396484-0.1933594-0.1396484-0.3398438v-0.7402344
                    l3.4003906-0.2397461l0.4746094-7.1201172c0.0126953-0.1201172,0.0625-0.2265625,0.1484375-0.3203125
                    c0.0849609-0.0927734,0.2011719-0.1396484,0.3466797-0.1396484h0.8896484v7.6000977h6.2597656v1.4199219h-6.2597656v13.4995117
                    c0,0.546875,0.0703125,1.0166016,0.2099609,1.4101562c0.140625,0.3935547,0.3330078,0.7167969,0.5800781,0.9697266
                    c0.2470703,0.2539062,0.5371094,0.4404297,0.8701172,0.5605469s0.6933594,0.1796875,1.0800781,0.1796875
                    c0.4794922,0,0.8935547-0.0703125,1.2402344-0.2099609s0.6464844-0.2929688,0.8994141-0.4599609
                    c0.2539062-0.1669922,0.4599609-0.3203125,0.6201172-0.4599609s0.2871094-0.2099609,0.3798828-0.2099609
                    c0.1064453,0,0.2138672,0.0664062,0.3203125,0.2001953l0.5195312,0.8398438
                    c-0.5068359,0.5595703-1.1494141,1.0097656-1.9296875,1.3496094S245.9117126,29.8369141,245.0718689,29.8369141z"/>
        <path class="st0" d="M252.3121033,29.5175781V9.6176758h1c0.2265625,0,0.3896484,0.046875,0.4902344,0.1401367
                    c0.0996094,0.0932617,0.15625,0.253418,0.1699219,0.4799805l0.1591797,4.199707
                    c0.640625-1.6132812,1.4931641-2.8764648,2.5605469-3.7900391c1.0664062-0.9130859,2.3798828-1.3701172,3.9394531-1.3701172
                    c0.6005859,0,1.1533203,0.0634766,1.6601562,0.1904297c0.5068359,0.1264648,0.9873047,0.3095703,1.4404297,0.5498047
                    l-0.2597656,1.3198242c-0.0400391,0.2133789-0.1738281,0.3203125-0.4003906,0.3203125
                    c-0.0800781,0-0.1933594-0.0268555-0.3398438-0.0800781c-0.1474609-0.0532227-0.3300781-0.1132812-0.5498047-0.1801758
                    c-0.2207031-0.0664062-0.4902344-0.1264648-0.8105469-0.1796875c-0.3193359-0.0532227-0.6865234-0.0800781-1.0996094-0.0800781
                    c-1.5068359,0-2.7431641,0.4667969-3.7099609,1.3999023c-0.9667969,0.9335938-1.75,2.2797852-2.3505859,4.0395508v12.9404297
                    H252.3121033z"/>
        <path class="st0" d="M274.1714783,9.2973633c1.4257812,0,2.703125,0.2436523,3.8300781,0.7299805
                    c1.1259766,0.4873047,2.0761719,1.1772461,2.8496094,2.0703125c0.7734375,0.8935547,1.3632812,1.9697266,1.7695312,3.2299805
                    c0.4072266,1.2592773,0.6103516,2.6694336,0.6103516,4.2299805c0,1.5595703-0.203125,2.9667969-0.6103516,4.2197266
                    c-0.40625,1.2539062-0.9960938,2.3271484-1.7695312,3.2197266c-0.7734375,0.8935547-1.7236328,1.5800781-2.8496094,2.0605469
                    c-1.1269531,0.4794922-2.4042969,0.7197266-3.8300781,0.7197266c-1.4267578,0-2.7041016-0.2402344-3.8300781-0.7197266
                    c-1.1269531-0.4804688-2.0800781-1.1669922-2.8603516-2.0605469c-0.7802734-0.8925781-1.3730469-1.9658203-1.7802734-3.2197266
                    c-0.40625-1.2529297-0.609375-2.6601562-0.609375-4.2197266c0-1.5605469,0.203125-2.9707031,0.609375-4.2299805
                    c0.4072266-1.2602539,1-2.3364258,1.7802734-3.2299805c0.7802734-0.8930664,1.7333984-1.5830078,2.8603516-2.0703125
                    C271.4673767,9.5410156,272.7447205,9.2973633,274.1714783,9.2973633z M274.1714783,28.2773438
                    c1.1865234,0,2.2226562-0.203125,3.109375-0.6103516c0.8867188-0.40625,1.6269531-0.9892578,2.2207031-1.75
                    c0.5927734-0.7597656,1.0361328-1.6757812,1.3300781-2.75c0.2929688-1.0732422,0.4394531-2.2763672,0.4394531-3.609375
                    c0-1.3203125-0.1464844-2.5205078-0.4394531-3.6000977c-0.2939453-1.0800781-0.7373047-2.0029297-1.3300781-2.7700195
                    c-0.59375-0.7666016-1.3339844-1.3564453-2.2207031-1.7700195c-0.8867188-0.4130859-1.9228516-0.6201172-3.109375-0.6201172
                    c-1.1875,0-2.2236328,0.2070312-3.1103516,0.6201172c-0.8867188,0.4135742-1.6269531,1.003418-2.2197266,1.7700195
                    c-0.59375,0.7670898-1.0400391,1.6899414-1.3398438,2.7700195c-0.3007812,1.0795898-0.4501953,2.2797852-0.4501953,3.6000977
                    c0,1.3330078,0.1494141,2.5361328,0.4501953,3.609375c0.2998047,1.0742188,0.7460938,1.9902344,1.3398438,2.75
                    c0.5927734,0.7607422,1.3330078,1.34375,2.2197266,1.75C271.9478455,28.0742188,272.9839783,28.2773438,274.1714783,28.2773438z"/>
        <path class="st0" d="M289.0904236,0.4174805v29.1000977h-1.9003906V0.4174805H289.0904236z"/>
        <path class="st0" d="M304.2496033,18.1171875v11.4003906h-2.0400391V1.2177734h7.2998047
                    c3.3203125,0,5.8232422,0.7265625,7.5107422,2.1796875c1.6865234,1.4536133,2.5292969,3.5268555,2.5292969,6.2202148
                    c0,1.2397461-0.2294922,2.3798828-0.6894531,3.4199219s-1.1240234,1.9370117-1.9902344,2.6899414
                    c-0.8671875,0.7529297-1.9199219,1.3398438-3.1601562,1.7597656s-2.6396484,0.6298828-4.2001953,0.6298828H304.2496033z
                     M304.2496033,16.4775391h5.2597656c1.2539062,0,2.3730469-0.1728516,3.3603516-0.5200195
                    c0.9863281-0.3466797,1.8232422-0.8266602,2.5097656-1.4399414s1.2138672-1.3364258,1.5800781-2.1699219
                    c0.3671875-0.8330078,0.5498047-1.7431641,0.5498047-2.7299805c0-2.1733398-0.6699219-3.8466797-2.0097656-5.0200195
                    s-3.3369141-1.7602539-5.9902344-1.7602539h-5.2597656V16.4775391z"/>
        <path class="st0" d="M334.4898376,29.5175781c-0.4003906,0-0.6474609-0.1865234-0.7402344-0.5605469l-0.2802734-2.5400391
                    c-0.546875,0.5341797-1.0898438,1.0136719-1.6298828,1.4404297s-1.1035156,0.7871094-1.6904297,1.0800781
                    s-1.2197266,0.5166016-1.8994141,0.6699219c-0.6806641,0.1533203-1.4267578,0.2294922-2.2402344,0.2294922
                    c-0.6796875,0-1.3398438-0.0996094-1.9794922-0.2998047c-0.640625-0.2001953-1.2070312-0.5058594-1.7001953-0.9199219
                    c-0.4941406-0.4130859-0.890625-0.9433594-1.1904297-1.5898438s-0.4501953-1.4228516-0.4501953-2.3300781
                    c0-0.8398438,0.2402344-1.6201172,0.7207031-2.3398438c0.4794922-0.7197266,1.2294922-1.3466797,2.25-1.8798828
                    c1.0195312-0.5332031,2.3330078-0.9599609,3.9394531-1.2802734s3.5371094-0.5068359,5.7900391-0.5595703v-2.0800781
                    c0-1.8398438-0.3964844-3.2568359-1.1894531-4.25c-0.7939453-0.9931641-1.9707031-1.4902344-3.5302734-1.4902344
                    c-0.9599609,0-1.7773438,0.1337891-2.4501953,0.4003906c-0.6738281,0.2666016-1.2431641,0.5595703-1.7099609,0.8798828
                    c-0.4667969,0.3198242-0.8466797,0.6132812-1.1396484,0.8798828c-0.2939453,0.2670898-0.5400391,0.3999023-0.7402344,0.3999023
                    c-0.2666016,0-0.4667969-0.1196289-0.5996094-0.3598633L321.6890564,12.4375
                    c1.0400391-1.0400391,2.1337891-1.8266602,3.2802734-2.3598633s2.4462891-0.800293,3.9003906-0.800293
                    c1.0664062,0,2,0.1704102,2.7998047,0.5102539s1.4628906,0.8266602,1.9902344,1.4599609
                    c0.5263672,0.6333008,0.9228516,1.3999023,1.1894531,2.2998047c0.2666016,0.9003906,0.4003906,1.9038086,0.4003906,3.0102539
                    v12.9599609H334.4898376z M326.4898376,28.4570312c0.7724609,0,1.4824219-0.0830078,2.1298828-0.25
                    c0.6464844-0.1660156,1.2460938-0.3994141,1.7998047-0.6992188c0.5527344-0.3007812,1.0703125-0.6572266,1.5498047-1.0703125
                    c0.4804688-0.4130859,0.953125-0.8603516,1.4199219-1.3398438v-5.1806641
                    c-1.8935547,0.0537109-3.5234375,0.1972656-4.8896484,0.4306641c-1.3671875,0.2333984-2.4931641,0.5498047-3.3798828,0.9492188
                    c-0.8867188,0.4003906-1.5400391,0.8769531-1.9599609,1.4306641s-0.6298828,1.1835938-0.6298828,1.8896484
                    c0,0.6669922,0.109375,1.2431641,0.3291016,1.7304688c0.2207031,0.4863281,0.5107422,0.8867188,0.8701172,1.1992188
                    c0.3603516,0.3134766,0.7802734,0.5439453,1.2607422,0.6904297
                    C325.4693298,28.3837891,325.9693298,28.4570312,326.4898376,28.4570312z"/>
        <path class="st0" d="M339.6499939,29.5175781V9.6176758h1.0400391c0.3466797,0,0.5458984,0.1669922,0.5996094,0.5l0.1796875,3
                    c0.9072266-1.1464844,1.9638672-2.0703125,3.1708984-2.7700195c1.2060547-0.7001953,2.5498047-1.050293,4.0292969-1.050293
                    c1.09375,0,2.0566406,0.1738281,2.890625,0.5200195c0.8330078,0.347168,1.5224609,0.847168,2.0693359,1.5
                    c0.546875,0.6538086,0.9599609,1.4404297,1.2402344,2.3603516s0.4199219,1.9599609,0.4199219,3.1191406v12.7207031h-1.8994141
                    V16.796875c0-1.8657227-0.4277344-3.3291016-1.2802734-4.3891602c-0.8535156-1.0600586-2.1601562-1.590332-3.9199219-1.590332
                    c-1.3076172,0-2.5205078,0.3369141-3.640625,1.0102539s-2.1201172,1.5966797-3,2.7700195v14.9199219H339.6499939z"/>
        <path class="st0" d="M367.1890564,9.2973633c1.1201172,0,2.15625,0.1938477,3.109375,0.5800781
                    c0.953125,0.387207,1.7802734,0.9501953,2.4804688,1.6899414c0.7001953,0.7402344,1.2460938,1.6503906,1.6396484,2.7299805
                    c0.3935547,1.0800781,0.5898438,2.3198242,0.5898438,3.7202148c0,0.2929688-0.0429688,0.4931641-0.1298828,0.5996094
                    c-0.0859375,0.1074219-0.2226562,0.1601562-0.4091797,0.1601562h-14.3603516v0.3798828
                    c0,1.4931641,0.1728516,2.8066406,0.5195312,3.9404297c0.3466797,1.1328125,0.8398438,2.0830078,1.4804688,2.8496094
                    c0.6396484,0.7666016,1.4130859,1.34375,2.3203125,1.7304688c0.90625,0.3867188,1.9199219,0.5800781,3.0390625,0.5800781
                    c1,0,1.8671875-0.1103516,2.6005859-0.3300781c0.7333984-0.2207031,1.3496094-0.4667969,1.8496094-0.7402344
                    s0.8964844-0.5205078,1.1904297-0.7402344c0.2929688-0.2197266,0.5068359-0.3300781,0.6396484-0.3300781
                    c0.1728516,0,0.3066406,0.0673828,0.4003906,0.2001953l0.5195312,0.6396484
                    c-0.3193359,0.4003906-0.7431641,0.7734375-1.2695312,1.1201172c-0.5273438,0.3466797-1.1132812,0.6435547-1.7597656,0.890625
                    c-0.6474609,0.2460938-1.3408203,0.4433594-2.0800781,0.5898438c-0.7402344,0.1464844-1.4833984,0.2197266-2.2304688,0.2197266
                    c-1.3603516,0-2.5996094-0.2373047-3.7197266-0.7099609c-1.1201172-0.4736328-2.0810547-1.1630859-2.8828125-2.0703125
                    c-0.8027344-0.90625-1.4228516-2.0166016-1.8603516-3.3300781c-0.4384766-1.3125-0.6572266-2.8164062-0.6572266-4.5097656
                    c0-1.4267578,0.203125-2.7431641,0.6103516-3.949707c0.40625-1.206543,0.9931641-2.246582,1.7597656-3.1201172
                    c0.7666016-0.8730469,1.7070312-1.5561523,2.8203125-2.0498047C364.5122986,9.5444336,365.7749939,9.2973633,367.1890564,9.2973633
                    z M367.2183533,10.7177734c-1.0253906,0-1.9443359,0.159668-2.7558594,0.4799805
                    c-0.8125,0.3198242-1.5146484,0.7797852-2.1074219,1.3798828c-0.5917969,0.6000977-1.0712891,1.3198242-1.4375,2.1601562
                    c-0.3662109,0.8398438-0.609375,1.7797852-0.7285156,2.8198242h13.0996094c0-1.0664062-0.1464844-2.0229492-0.4394531-2.8701172
                    c-0.2929688-0.8466797-0.7050781-1.5629883-1.2382812-2.1499023c-0.5322266-0.5864258-1.1708984-1.0366211-1.9169922-1.3500977
                    C368.948822,10.8745117,368.1236267,10.7177734,367.2183533,10.7177734z"/>
        <path class="st0" d="M380.9888611,0.4174805v29.1000977h-1.9003906V0.4174805H380.9888611z"/>
    </g>
            </svg>
<?php
endif;
$settings['logo'] = ob_get_clean();

$settings['available'] = true;

if ( $is_child_theme ) :
	$parent        = wp_get_theme( 'xstore' );
	$theme_version = $parent->version;
endif;
$settings['version'] = 'v.' . esc_html( $theme_version );

if ( count( $xstore_branding_settings ) ) {
	if ( isset( $xstore_branding_settings['control_panel']['logo'] ) && ! empty( $xstore_branding_settings['control_panel']['logo'] ) ) {
		$settings['available'] = false;
		ob_start(); ?>

        <img src="<?php echo esc_url( $xstore_branding_settings['control_panel']['logo'] ); ?>" alt="panel-logo">
		
		<?php $settings['logo'] = ob_get_clean();
	}
	if ( isset($xstore_branding_settings['control_panel']['hide_updates']) && $xstore_branding_settings['control_panel']['hide_updates'] == 'on' ){
		$settings['available'] = false;
    }
	if ( isset( $xstore_branding_settings['control_panel']['theme_version'] ) && ! empty( $xstore_branding_settings['control_panel']['theme_version'] ) ) {
		$settings['version'] = $xstore_branding_settings['control_panel']['theme_version'];
	}
}
$check_update = new ETheme_Version_Check();
$header_classes = array(
    'etheme-page-header',
    'flex',
    'justify-content-between',
    'align-items-center'
);
if ( $has_header_description )
    $header_classes[] = 'has-description';
if ( $large_header )
    $header_classes[] = 'size-lg';

$allow_full_access = !etheme_activation_required();
$global_admin_class = EthemeAdmin::get_instance();
$dark_light_default = get_option('et_panel_dark_light_default', 'light');

?>

<div class="etheme-page-wrapper" data-mode="<?php echo esc_attr($dark_light_default); ?>">
    <div class="et_panel-popup"></div>
    <?php if ($_GET['page'] == 'et-panel-demos' ) : ?>
        <div class="et_panel-popup et_panel-popup-code-error hidden" style="max-width: 650px"></div>
	<?php endif; ?>
    <div class="<?php echo implode(' ', $header_classes); ?>">
        <div class="etheme-logo">
			<?php echo '<div class="logo-img"><a href="'.admin_url( 'admin.php?page=et-panel-welcome' ).'">' . $settings['logo'] . '</a></div>'; ?>
        </div>

	    <?php if ( !$theme_builders_page ) : ?>
            <div class="theme-status-block">
	            <?php if( $settings['available'] && ($is_activated || $allow_full_access) && $check_update->is_update_available() ) : ?>
                    <div class="update-notice-block">
                        <div>
                            <span class="opacity-light"><?php esc_html_e('A new version available', 'xstore'); ?></span>
                            <span class="current-theme-version uppercase">
		                    <?php esc_html_e('new version', 'xstore'); ?>
		                    <?php echo '<span>' . $check_update->information->new_version . '</span>'; ?>
                        </span>
                        </div>

                        <div>
                            <a href="<?php echo admin_url('update-core.php?force-check=1'); ?>" class="et-button et-button-green no-loader<?php if ( !$is_activated ) echo ' trigger-xstore-control-register-licence-popup' ?>"><?php esc_html_e('Update Now', 'xstore'); ?></a>
                        </div>
                    </div>
	            <?php else: ?>
                    <div class="current-status-block">
                        <div>
                            <span class="opacity-light"><?php esc_html_e('Theme is up to date', 'xstore'); ?></span>
                            <span class="current-theme-version uppercase">
		                    <?php echo sprintf(esc_html__('your version %s', 'xstore'), $settings['version']); ?>
                        </span>
                        </div>

                        <div>
                            <a href="<?php echo admin_url( 'admin.php?page=et-panel-welcome&force-check=1' ); ?>" class="et-button et-button-white et_theme-refresh">
                                <span class="dashicons dashicons-update"></span>
                                <?php
                                esc_html_e('refresh', 'xstore');
                                $global_admin_class->get_loader();
                                ?>
                            </a>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
	    <?php endif; ?>

        <?php if ( !$theme_builders_page && $is_child_theme ) : ?>
            <span class="activate-note is-child-theme-note"><?php echo esc_html__( 'Child theme', 'xstore' ) . ' v.' . $version; ?></span>
        <?php endif; ?>
        <div class="et_panel-dark-light-switcher">
                <span class="switcher <?php echo esc_attr($dark_light_default); ?>-mode">
                    <span class="on"><?php echo esc_html__('Light', 'xstore'); ?></span>
                    <span class="off"><?php echo esc_html__('Dark', 'xstore'); ?></span>
                    <i>
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 35 35" style="enable-background:new 0 0 35 35;" xml:space="preserve" class="light" width="1em" height="1em" fill="currentColor">
                          <g id="Sun">
                              <g>
                                  <path style="fill-rule:evenodd;clip-rule:evenodd;" d="M6,17.5C6,16.672,5.328,16,4.5,16h-3C0.672,16,0,16.672,0,17.5    S0.672,19,1.5,19h3C5.328,19,6,18.328,6,17.5z M7.5,26c-0.414,0-0.789,0.168-1.061,0.439l-2,2C4.168,28.711,4,29.086,4,29.5    C4,30.328,4.671,31,5.5,31c0.414,0,0.789-0.168,1.06-0.44l2-2C8.832,28.289,9,27.914,9,27.5C9,26.672,8.329,26,7.5,26z M17.5,6    C18.329,6,19,5.328,19,4.5v-3C19,0.672,18.329,0,17.5,0S16,0.672,16,1.5v3C16,5.328,16.671,6,17.5,6z M27.5,9    c0.414,0,0.789-0.168,1.06-0.439l2-2C30.832,6.289,31,5.914,31,5.5C31,4.672,30.329,4,29.5,4c-0.414,0-0.789,0.168-1.061,0.44    l-2,2C26.168,6.711,26,7.086,26,7.5C26,8.328,26.671,9,27.5,9z M6.439,8.561C6.711,8.832,7.086,9,7.5,9C8.328,9,9,8.328,9,7.5    c0-0.414-0.168-0.789-0.439-1.061l-2-2C6.289,4.168,5.914,4,5.5,4C4.672,4,4,4.672,4,5.5c0,0.414,0.168,0.789,0.439,1.06    L6.439,8.561z M33.5,16h-3c-0.828,0-1.5,0.672-1.5,1.5s0.672,1.5,1.5,1.5h3c0.828,0,1.5-0.672,1.5-1.5S34.328,16,33.5,16z     M28.561,26.439C28.289,26.168,27.914,26,27.5,26c-0.828,0-1.5,0.672-1.5,1.5c0,0.414,0.168,0.789,0.439,1.06l2,2    C28.711,30.832,29.086,31,29.5,31c0.828,0,1.5-0.672,1.5-1.5c0-0.414-0.168-0.789-0.439-1.061L28.561,26.439z M17.5,29    c-0.829,0-1.5,0.672-1.5,1.5v3c0,0.828,0.671,1.5,1.5,1.5s1.5-0.672,1.5-1.5v-3C19,29.672,18.329,29,17.5,29z M17.5,7    C11.71,7,7,11.71,7,17.5S11.71,28,17.5,28S28,23.29,28,17.5S23.29,7,17.5,7z M17.5,25c-4.136,0-7.5-3.364-7.5-7.5    c0-4.136,3.364-7.5,7.5-7.5c4.136,0,7.5,3.364,7.5,7.5C25,21.636,21.636,25,17.5,25z"></path>
                              </g>
                          </g>
                        </svg>
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 100 100" xml:space="preserve" class="dark" width="1em" height="1em" fill="currentColor">
                          <path d="M96.76,66.458c-0.853-0.852-2.15-1.064-3.23-0.534c-6.063,2.991-12.858,4.571-19.655,4.571  C62.022,70.495,50.88,65.88,42.5,57.5C29.043,44.043,25.658,23.536,34.076,6.47c0.532-1.08,0.318-2.379-0.534-3.23  c-0.851-0.852-2.15-1.064-3.23-0.534c-4.918,2.427-9.375,5.619-13.246,9.491c-9.447,9.447-14.65,22.008-14.65,35.369  c0,13.36,5.203,25.921,14.65,35.368s22.008,14.65,35.368,14.65c13.361,0,25.921-5.203,35.369-14.65  c3.872-3.871,7.064-8.328,9.491-13.246C97.826,68.608,97.611,67.309,96.76,66.458z"></path>
                        </svg>
                    </i>
                </span>
        </div>
        <?php if ( !$theme_builders_page ) : ?>
            <div class="text-center theme-active-status">
                <?php if ( $is_activated ): ?>
                    <span class="activate-note activated">
                        <a href="<?php echo admin_url( 'admin.php?page=et-panel-welcome&section-focus=licence-form' ); ?>" style="text-decoration: none;color: currentColor; outline: none;box-shadow: none;">
                            <span class="dashicons dashicons-saved" style="width: 1em;height: 1em;font-size: 1.4em;vertical-align: -22%;margin-right: 3px;"></span><strong><?php esc_html_e( 'Registered', 'xstore' ); ?></strong>
                        </a>
                        <?php if ( count( $xstore_branding_settings ) < 1) { ?>
                            <?php if ( ! $check_update->is_subscription) :?>
                                <span class="activated-info">
                                    <h4 class="text-left"><?php echo esc_html__('Your theme is successfully registered!', 'xstore'); ?></h4>
                                        <p><?php echo sprintf(esc_html__('You now get access to 1-click updates via %s, as well as all exclusive theme features.', 'xstore'), '<a href="'.admin_url( 'update-core.php' ).'" target="_blank">'.esc_html__('Dashboard → Updates', 'xstore').'</a>'); ?></p>
                                        <p><?php echo sprintf(esc_html__('Each license is valid for a single project. To manage your licenses or domains, simply go to %s.', 'xstore'), '<a href="https://www.8theme.com/" target="_blank">'.esc_html__('8theme.com', 'xstore').'</a> → '. esc_html__('My Account → Dashboard', 'xstore')); ?></p>
    <!--                                    <p>If you want to use this theme more than one project or unlimited, please check our <a href="https://www.8theme.com/woocommerce-themes/#price-section-anchor" target="_blank">8theme's subscription plan.</a></p>-->
                                    <br/>
                                    <span style="display: block; text-align: left">
                                        <span style="font-size: 1.2em; line-height: 1.7">
                                            <a class="et-button no-loader no-transform" href="https://www.8theme.com/account/" target="_blank" style="margin-right: 20px;">
                                                <?php echo esc_html__('Manage Domains', 'xstore'); ?>
                                            </a>
                                        </span>
                                        <span style="font-size: 1.2em; line-height: 1.7">
                                            <span class="dashicons dashicons-cart" style="vertical-align: -.15em;"></span>
                                            <a class="et-animated-link" href="https://1.envato.market/2rXmmA" target="_blank">
                                                <?php echo esc_html__('Buy license', 'xstore'); ?>
                                            </a>
                                        </span>
                                    </span>
                                </span>
                            <?php endif; ?>
                        <?php } ?>
                    </span>
                <?php elseif (true): ?>
                    <span class="activate-note deactivated">
                        <a href="<?php echo admin_url( 'admin.php?page=et-panel-welcome&section-focus=licence-form&section-highlighted=1' ); ?>" style="text-decoration: none;color: currentColor; outline: none;box-shadow: none;">
                            <strong><?php esc_html_e( 'Not registered', 'xstore' ); ?></strong>
                        </a>
                        <?php if ( count( $xstore_branding_settings ) < 1) { ?>
                                <span class="activated-info">
                                    <h4 class="text-left"><?php echo esc_html__('Your theme is not registered!', 'xstore'); ?></h4>
                                    <p><?php echo sprintf(esc_html__('Unlock the full power of %s — get access to automatic updates and premium features.', 'xstore'), apply_filters('etheme_theme_label', 'XStore')); ?></p>
                                    <p><?php echo esc_html__('You can activate your license in just one click — it’s quick, safe, and takes only a few seconds.', 'xstore'); ?></p>
                                    <p><?php echo esc_html__('Simply click the button below to register.', 'xstore'); ?></p>
                                    <br/>
                                    <span style="display: block; text-align: left">
                                        <a class="et-button no-loader no-transform" href="<?php echo admin_url( 'admin.php?page=et-panel-welcome&section-focus=licence-form&section-highlighted=1' ); ?>" style="margin-right: 20px;">
                                            <?php echo esc_html__('Activate now', 'xstore'); ?>
                                        </a>
                                        <span style="font-size: 1.2em; line-height: 1.7">
                                            <span class="dashicons dashicons-cart" style="vertical-align: -.15em;"></span>
                                            <a class="et-animated-link" href="https://1.envato.market/2rXmmA" target="_blank">
                                                <?php echo esc_html__('Buy license', 'xstore'); ?>
                                            </a>
                                        </span>
                                    </span>
                                </span>
                        <?php } ?>
                    </span>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <?php if ( $theme_builders_page ) :
            $global_admin_class->get_search_form('theme-builder', esc_html__('Search for builders', 'xstore'));
        endif; ?>
    </div>