<?php

namespace WPML\API;

use WPML\FP\Fns;
use WPML\FP\Obj;

trait PostTypesMock {

	/** @var array */
	private $translatable;

	/** @var array */
	private $displayAsTranslatable;

	protected function setUpPostTypesMock() {
		$this->translatable          = [ 'page', 'post' ];
		$this->displayAsTranslatable = [];

		global $sitepress;
		if ( ! $sitepress ) {
			$sitepress = \Mockery::mock( '\SitePress' );
		}

		$sitepress->shouldReceive( 'get_translatable_documents' )->andReturnUsing( function () {
			return wpml_collect( $this->translatable )
				->mapWithKeys( Obj::objOf( Fns::__, 1 ) )
				->toArray();
		} );

		$sitepress->shouldReceive( 'get_display_as_translated_documents' )->andReturnUsing( function () {
			return wpml_collect( $this->displayAsTranslatable )
				->mapWithKeys( Obj::objOf( Fns::__, 1 ) )
				->toArray();
		} );
	}

	protected function setTranslatablePostTypes( array $postTypes ) {
		$this->translatable = $postTypes;
	}

	protected function setDisplayAsTranslatablePostTypes( array $postTypes ) {
		$this->displayAsTranslatable = $postTypes;
	}
}
