<?php

namespace WPML\LIB\WP;

use tad\FunctionMocker\FunctionMocker;
use WPML\FP\Maybe;

trait CacheMock {

	private $cache;

	public function setUpCache() {
		$this->cache = [];

		FunctionMocker::replace( Cache::class . '::getInternal', function ( $group, $key ) {
			if ( array_key_exists( $group, $this->cache ) && array_key_exists( $key, $this->cache[ $group ] ) ) {
				return Maybe::just( $this->cache[ $group ][ $key ] );
			}

			return Maybe::nothing();
		} );

		FunctionMocker::replace( Cache::class . '::setInternal', function ( $group, $key, $value ) {
			if ( ! isset( $this->cache[ $group ] ) ) {
				$this->cache[ $group ] = [];
			}
			$this->cache[ $group ][ $key ] = $value;

			return true;
		} );
	}

}
