<?php
add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );
function theme_enqueue_styles() {
	etheme_child_styles();
}

function cc_mime_types($mimes) {
 $mimes['svg'] = 'image/svg+xml';
 return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');

/**
 * @snippet       Move product tabs beside the product image - WooCommerce
 * @how-to        Get CustomizeWoo.com FREE
 * @sourcecode    https://businessbloomer.com/?p=393
 * @author        Rodolfo Melogli
 * @testedwith    WooCommerce 3.5.2
 * @donate $9     https://businessbloomer.com/bloomer-armada/
 */
 
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_output_product_data_tabs', 60 );

remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );

add_action( 'woocommerce_single_product_summary', 'custom_field_display_below_title', 2 );
function custom_field_display_below_title(){
	if( get_field('product_label') ){
	?>
		<div class="custom-product-label">
	    	<?php echo get_field('product_label') ? the_field('product_label') : '&nbsp;'; ?>
	    </div>
    <?php
    }
}


remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 70 );

remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 80 );


function my_custom_js() {
    echo '<script type="text/javascript" src="' . get_template_directory_uri() . '-child/js/custom.js"></script>';
}
add_action('wp_head', 'my_custom_js');


function add_custom_menu() {
	register_nav_menus(
		array(
		  'other-websites' => __( 'Egyéb weboldalak' )
		)
	);
}
add_action( 'init', 'add_custom_menu' );


add_action( 'wp_body_open', 'add_custom_body_open_code' );
 
function add_custom_body_open_code(){
	?>
	<div class="slide-other-pages">
		<div class="slide-close"><span class="close-line"></span></div>
		<?php
		wp_nav_menu( array( 'theme_location' => 'other-websites',
							'container_class' => 'menu-other-websites'
		));
		?>
	</div>
	<?php
}
/* Woocommerce email CSS start */
add_filter( 'woocommerce_email_styles', 'add_css_to_emails', 9999, 2 );
 
function add_css_to_emails( $css, $email ) { 
   $css .= '
    #template_container {
		box-shadow: none !important;
		border: none;
		border-radius: 0px !important;
	}
	#template_header_image img {
		margin-bottom: 40px;	
	}
	#template_header {
		border-radius: 0px !important;
	}
	';
   return $css;
}
/* Woocommerce email CSS end */

function custom_woocommerce_checkout_fields( $fields ) 
{
    $fields['order']['order_comments']['label'] = __( 'Note for order', 'woocommerce' );

    return $fields;
}
add_filter( 'woocommerce_checkout_fields', 'custom_woocommerce_checkout_fields', 20, 1 );


function add_custom_fonts() {
	wp_enqueue_style( 'custom_fonts', get_template_directory_uri() . '-child/assets/fonts/stylesheet.css' );
}
add_action( 'wp_enqueue_scripts', 'add_custom_fonts' );


/**
 * Hide shipping rates when free shipping is available.
 * Updated to support WooCommerce 2.6 Shipping Zones.
 *
 * @param array $rates Array of rates found for the package.
 * @return array
 *//*
function my_hide_shipping_when_free_is_available( $rates ) {
	$free = array();
	foreach ( $rates as $rate_id => $rate ) {
		if ( 'free_shipping' === $rate->method_id ) {
			$free[ $rate_id ] = $rate;
			break;
		}
	}
	return ! empty( $free ) ? $free : $rates;
}
add_filter( 'woocommerce_package_rates', 'my_hide_shipping_when_free_is_available', 100 );*/


add_filter( 'body_class','my_body_classes' );

function my_body_classes( $classes ) {
	if ((!is_archive()) && (get_field('dark_header') == 1) || is_product() || is_cart() || is_checkout() || is_404()) {
		$classes[] = 'dark_header';
	}

    return $classes;
}

/**
 * Hides the product's weight and dimension in the single product page.
 */
add_filter( 'wc_product_enable_dimensions_display', '__return_false' );



function term_and_conditions_new_tab(){ ?>
<script>

	jQuery(function($){
		$( "a.woocommerce-terms-and-conditions-link" ).unbind( "click" );
		$( "body" ).on('click', 'a.woocommerce-terms-and-conditions-link', function( event ) {
			
			e.stopPropagation();
			$(this).attr("target", "_blank");
			window.open( $(this).attr("href"));

			return false;
		});
	});

</script>
<?php
}
add_action('wp_footer', 'term_and_conditions_new_tab');


// Replace add to cart button by a linked button to the product in Shop and archives pages
add_filter( 'woocommerce_loop_add_to_cart_link', 'replace_loop_add_to_cart_button', 10, 2 );
function replace_loop_add_to_cart_button( $button, $product  ) {
    // Not needed for variable products
    if( $product->is_type( 'variable' ) ) return $button;

    // Button text here
    $button_text = __( "View product", "woocommerce" );

    return '<a class="button" href="' . $product->get_permalink() . '">' . $button_text . '</a>';
}

function google_tag_code(){ ?>

	<!-- Global site tag (gtag.js) - Google Analytics -->
	<script async src="https://www.googletagmanager.com/gtag/js?id=UA-65070191-3"></script>
	<script>
	  window.dataLayer = window.dataLayer || [];
	  function gtag(){dataLayer.push(arguments);}
	  gtag('js', new Date());

	  gtag('config', 'UA-65070191-3');
	</script>




	<!-- Google Tag Manager -->	
	<noscript><iframe src="//www.googletagmanager.com/ns.html?id=GTM-W5992F"
	height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
	<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
	new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
	j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
	'//www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
	})(window,document,'script','dataLayer','GTM-W5992F');</script>
	<!-- End Google Tag Manager -->
	<script type="text/javascript">
	
		(function(i, s, o, g, r, a, m) {
			i["GoogleAnalyticsObject"] = r;
			i[r] = i[r] || function() {
			(i[r].q = i[r].q || []).push(arguments)
			}, i[r].l = 1 * new Date();
			a = s.createElement(o),
			m = s.getElementsByTagName(o)[0];
			a.async = 1;
			a.src = g;
			m.parentNode.insertBefore(a, m)
		})(window, document, "script", "//www.google-analytics.com/analytics.js", "ga");
		
		ga('create', 'UA-65070191-3','shop.gere.hu');

		if(EnableUserId){
			if('' != ""){
				ga('set', '&uid', '' );
				ga('send', 'event', 'userid', {"nonInteraction": 1});
			}
		}
		ga("require", "displayfeatures");
		if(EnableClientId){
			ga(function(tracker) {
			tvc_clientID = tracker.get('clientId');
				ga("set", "dimension15", tvc_clientID);
			});
		}
		
		/* Set Anonymize ip */
			
			
		
		/* Complete Anonymize ip*/
		ga('send', 'pageview');
		ga("require", "ec", "ec.js");

		var $t_jQuery = jQuery.noConflict(); 
		
						
			var cg_enable = false;
			var groupIndexed="";
				if(cg_enable){
			ga('set', groupIndexed, 'Home Page'); 
		}
        
	</script>

<?php
}
//add_action('wp_head', 'google_tag_code');



add_filter('woocommerce_package_rates', 'conditional_free_shipping', 10, 2); 
function conditional_free_shipping( $rates, $package )
{
	if ( is_admin() && ! defined( 'DOING_AJAX' ) ) 
	return $rates;

	## -- Your settings below -- ##

	$shipping_class  = 'ingyenes-szallitas' || 'ingyenes-szallitas-en'; // "Free" shipping class products
	$min_free_amount = 25000;    // Minimal Free shipping amount for normal products

	## -- -- -- -- -- -- -- -- -- ##

	$has_free = false; // Initializing
	$products_total = 0; // Initializing

	// Loop through cart items
	foreach( $package['contents'] as $cart_item ) {
		if( $cart_item['data']->get_shipping_class() == $shipping_class ) {
			$has_free = true;
		} else {
			// Get the total purchased amount for normal product
			$products_total += $cart_item['line_total'] + $cart_item['line_tax'];
		}
	}

	foreach ( $rates as $rate_key => $rate ){
		// 1. Only Free shipping products in cart OR both products kind in cart
		if( $has_free ) {
			if( 'flat_rate' === $rate->method_id )
			unset( $rates[$rate_key] ); // Remove flat rate
		}
		// 2. Only normal products in cart
		else {
			// A. If it's under the min amount
			if( 'free_shipping' === $rate->method_id && $products_total < $min_free_amount )
				unset( $rates[$rate_key] ); // Remove Free shipping
			// B. When min amount is reached
			elseif( 'flat_rate' === $rate->method_id && $products_total >= $min_free_amount )
				unset( $rates[$rate_key] ); // Remove flat rate
		}
	}
	return $rates;
}

add_action( 'woocommerce_cart_calculate_fees', 'custom_handling_fee', 10, 1 );
function custom_handling_fee ( $cart ) {
    if ( is_admin() && ! defined( 'DOING_AJAX' ) )
        return;
 
	$shipping_for_package_0 = WC()->session->get('shipping_for_package_0');
	$found_fs = false;

	if( isset($shipping_for_package_0['rates']) && ! empty($shipping_for_package_0['rates']) ) {
		// Loop through available shipping methods rate data
		foreach( $shipping_for_package_0['rates'] as $rate ) {
			// Targeting "Free Shipping"
			if( 'free_shipping' === $rate->method_id ) {
				$found_fs = true;
				break;
			}
		}
	}
 
	if ( $found_fs == false && 'cod' === WC()->session->get('chosen_payment_method')) {
        $fee = 200;
		
		//$get_my_current_lang = apply_filters( 'wpml_current_language', NULL );
		if(ICL_LANGUAGE_CODE=='hu'){
			$cart->add_fee( 'Utánvét kezelési költség', $fee, true );
		} else{
			$cart->add_fee( 'Cash on delivery handling fee', $fee, true );
		}
    }
}
 
// jQuery - Update checkout on methode payment change
add_action( 'wp_footer', 'custom_checkout_jqscript' );
function custom_checkout_jqscript() {
    if ( is_checkout() && ! is_wc_endpoint_url() ) :
    ?>
    <script type="text/javascript">
    jQuery( function($){
        $('form.checkout').on('change', 'input[name="payment_method"]', function(){
            $(document.body).trigger('update_checkout');
        });
    });
    </script>
    <?php
    endif;
}




add_filter('woocommerce_get_availability_text', 'themeprefix_change_soldout', 10, 2 );

function themeprefix_change_soldout ( $text, $product) {
if ( !$product->is_in_stock() ) {
	
	if ( get_field('elfogyott_helyett_egyedi_kiiras',$product->get_id()) ) {
		$text = get_field('elfogyott_helyett_egyedi_kiiras',$product->get_id());
	}	
	
	/*$get_my_current_lang = apply_filters( 'wpml_current_language', NULL );
		if( $get_my_current_lang =='hu' ) {
			$text = 'Új évjárat hamarosan!';
		} else {
			$text = 'New vintage coming soon!';
		}
	*/
}
return $text;
}







function add_this_script_footer(){ 

    echo "<link rel='stylesheet' id='product-tabs-css-css'  href='https://shop.gere.hu/wp-content/themes/gereshop-child/css/easy-responsive-tabs.css?ver=6.0' type='text/css' media='all' />";
    echo "<script type='text/javascript' src='https://shop.gere.hu/wp-content/themes/gereshop-child/js/easyResponsiveTabs.js'></script>";
}

add_action('wp_footer', 'add_this_script_footer');






add_filter('woocommerce_single_product_summary','custom_product_details', 55);
function custom_product_details(){ ?>



<?php  if(isset($_GET['test'])) { ?>




     
        <!--Horizontal Tab-->
        <div id="parentHorizontalTab">
            <ul class="resp-tabs-list hor_1" id="slicktabs">
                <li>2017</li>
                <li>2016</li>
                <li>2015</li>
                <li>2014</li>
                <li>2013</li>
                <li>2012</li>
                <li>2011</li>
                <li>2010</li>
                <li>2009</li>
                <li>2008</li>
                <li>2007</li>
                <li>2006</li>
                <li>2005</li>
                <li>2004</li>
                <li>2003</li>
                <li>2002</li>
                <li>2001</li>
                <li>2000</li>
                <li>1999</li>
                <li>1998</li>
            </ul>
            <div class="resp-tabs-container hor_1">
                <div>

                    <!--vertical Tabs-->

                    <div id="ChildVerticalTab_1">
                        <ul class="resp-tabs-list ver_1">
                            <li>Leírás</li>
                            <li>Évjárat értékelése</li>
                            <li>További információk</li>
                        </ul>
                        <div class="resp-tabs-container ver_1">
                            <div>
                                <p>Színe élénk, bíborba hajló mély árnyalat. Illatát szépen integrálódott hordófűszerek
                                    és vibráló, gyümölcshangsúlyos aromakép jellemzi. Meggy, füge, hecsedli, jól beérett
                                    gyümölcsaromák. Kóstoláskor a korty mindent kitölt, tartalmas, hosszan tartó, benne
                                    egy meleg, ám kiegyensúlyozott évjáratra jellemző gyümölcsösség találkozik érett
                                    tanninokkal. Ígéretes és kiegyensúlyozott, már jól fogyasztható, de még évekkel
                                    csúcsa előtt.</p>
                            </div>
                            <div>
                                <p>Ideális volt ez az év, magas átlaghőmérséklettel, elegendő csapadékkal, és különösebb
                                    szélsőségek nélkül. A több éve tartó biológiai növényvédelemnek köszönhetően
                                    mostanra a szőlő héja olyan rugalmas és kemény lett, hogy maga is képes már a
                                    védekezésre a betegségek ellen, így ezzel sem volt gondunk. Még minket is meglepett
                                    az a rendkívüli gyümölcsíz, amit idén a szőlőbogyókban éreztünk, az optimális
                                    érettségben szüretelt fürtök mellett ez is okot ad az évjárat boraiban való
                                    bizakodásra.</p>
                            </div>
                            <div>
                                <table class="woocommerce-product-attributes shop_attributes">
                                    <tbody>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_evjarat">
                                            <th class="woocommerce-product-attributes-item__label">Évjárat</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>2017</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_szolofajta">
                                            <th class="woocommerce-product-attributes-item__label">Szőlőfajta</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>100% Cabernet Sauvignon</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_termohely">
                                            <th class="woocommerce-product-attributes-item__label">Termőhely</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>Csillagvölgy-dűlő</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_tokek-eletkora-ev">
                                            <th class="woocommerce-product-attributes-item__label">Tőkék életkora (év)
                                            </th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>20-35</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_toke-hektar">
                                            <th class="woocommerce-product-attributes-item__label">Tőke/hektár</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>5400</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_muvelesmod">
                                            <th class="woocommerce-product-attributes-item__label">Művelésmód</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>Középmagas kordon; 230 x 120-as ikertőke</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_szuret-idopontja">
                                            <th class="woocommerce-product-attributes-item__label">Szüret időpontja</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>Október eleje</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_borkeszites">
                                            <th class="woocommerce-product-attributes-item__label">Borkészítés</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>Az alkoholos erjesztés acéltartályban történt kb. 10 napig, a
                                                    biológiai almasavbontás már fahordóban ment végbe. Másod-, harmad
                                                    töltésű kis hordókban érlelődött 16 hónapig.</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_alkoholtartalom">
                                            <th class="woocommerce-product-attributes-item__label">Alkoholtartalom</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>13 %</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_cukormentes-extrakt">
                                            <th class="woocommerce-product-attributes-item__label">Cukormentes extrakt
                                            </th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>29,2 g/l</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_savtartalom">
                                            <th class="woocommerce-product-attributes-item__label">Savtartalom</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>5,3 g/l</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_maradekcukor">
                                            <th class="woocommerce-product-attributes-item__label">Maradékcukor</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>2,6 g/l</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_forgalomba-kerules">
                                            <th class="woocommerce-product-attributes-item__label">Forgalomba kerülés
                                            </th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>2021. december</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_kiszerel%c3%a9s">
                                            <th class="woocommerce-product-attributes-item__label">Kiszerelés</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>0,75 l</p>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div style="clear:both"></div>
                </div>
                <div>



                    <!--vertical Tabs-->

                    <div id="ChildVerticalTab_2">
                        <ul class="resp-tabs-list ver_1">
                            <li>Leírás</li>
                            <li>Évjárat értékelése</li>
                            <li>További információk</li>
                        </ul>
                        <div class="resp-tabs-container ver_1">
                            <div>
                                <p>Színe élénk, bíborba hajló mély árnyalat. Illatát szépen integrálódott hordófűszerek
                                    és vibráló, gyümölcshangsúlyos aromakép jellemzi. Meggy, füge, hecsedli, jól beérett
                                    gyümölcsaromák. Kóstoláskor a korty mindent kitölt, tartalmas, hosszan tartó, benne
                                    egy meleg, ám kiegyensúlyozott évjáratra jellemző gyümölcsösség találkozik érett
                                    tanninokkal. Ígéretes és kiegyensúlyozott, már jól fogyasztható, de még évekkel
                                    csúcsa előtt.</p>
                            </div>
                            <div>
                                <p>Ideális volt ez az év, magas átlaghőmérséklettel, elegendő csapadékkal, és különösebb
                                    szélsőségek nélkül. A több éve tartó biológiai növényvédelemnek köszönhetően
                                    mostanra a szőlő héja olyan rugalmas és kemény lett, hogy maga is képes már a
                                    védekezésre a betegségek ellen, így ezzel sem volt gondunk. Még minket is meglepett
                                    az a rendkívüli gyümölcsíz, amit idén a szőlőbogyókban éreztünk, az optimális
                                    érettségben szüretelt fürtök mellett ez is okot ad az évjárat boraiban való
                                    bizakodásra.</p>
                            </div>
                            <div>
                                <table class="woocommerce-product-attributes shop_attributes">
                                    <tbody>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_evjarat">
                                            <th class="woocommerce-product-attributes-item__label">Évjárat</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>2016</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_szolofajta">
                                            <th class="woocommerce-product-attributes-item__label">Szőlőfajta</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>100% Cabernet Sauvignon</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_termohely">
                                            <th class="woocommerce-product-attributes-item__label">Termőhely</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>Csillagvölgy-dűlő</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_tokek-eletkora-ev">
                                            <th class="woocommerce-product-attributes-item__label">Tőkék életkora (év)
                                            </th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>20-35</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_toke-hektar">
                                            <th class="woocommerce-product-attributes-item__label">Tőke/hektár</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>5400</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_muvelesmod">
                                            <th class="woocommerce-product-attributes-item__label">Művelésmód</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>Középmagas kordon; 230 x 120-as ikertőke</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_szuret-idopontja">
                                            <th class="woocommerce-product-attributes-item__label">Szüret időpontja</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>Október eleje</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_borkeszites">
                                            <th class="woocommerce-product-attributes-item__label">Borkészítés</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>Az alkoholos erjesztés acéltartályban történt kb. 10 napig, a
                                                    biológiai almasavbontás már fahordóban ment végbe. Másod-, harmad
                                                    töltésű kis hordókban érlelődött 16 hónapig.</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_alkoholtartalom">
                                            <th class="woocommerce-product-attributes-item__label">Alkoholtartalom</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>13 %</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_cukormentes-extrakt">
                                            <th class="woocommerce-product-attributes-item__label">Cukormentes extrakt
                                            </th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>29,2 g/l</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_savtartalom">
                                            <th class="woocommerce-product-attributes-item__label">Savtartalom</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>5,3 g/l</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_maradekcukor">
                                            <th class="woocommerce-product-attributes-item__label">Maradékcukor</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>2,6 g/l</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_forgalomba-kerules">
                                            <th class="woocommerce-product-attributes-item__label">Forgalomba kerülés
                                            </th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>2021. december</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_kiszerel%c3%a9s">
                                            <th class="woocommerce-product-attributes-item__label">Kiszerelés</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>0,75 l</p>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div style="clear:both"></div>

                </div>
                <div>

                    <!--vertical Tabs-->

                    <div id="ChildVerticalTab_3">
                        <ul class="resp-tabs-list ver_1">
                            <li>Leírás</li>
                            <li>Évjárat értékelése</li>
                            <li>További információk</li>
                        </ul>
                        <div class="resp-tabs-container ver_1">
                            <div>
                                <p>Színe élénk, bíborba hajló mély árnyalat. Illatát szépen integrálódott hordófűszerek
                                    és vibráló, gyümölcshangsúlyos aromakép jellemzi. Meggy, füge, hecsedli, jól beérett
                                    gyümölcsaromák. Kóstoláskor a korty mindent kitölt, tartalmas, hosszan tartó, benne
                                    egy meleg, ám kiegyensúlyozott évjáratra jellemző gyümölcsösség találkozik érett
                                    tanninokkal. Ígéretes és kiegyensúlyozott, már jól fogyasztható, de még évekkel
                                    csúcsa előtt.</p>
                            </div>
                            <div>
                                <p>Ideális volt ez az év, magas átlaghőmérséklettel, elegendő csapadékkal, és különösebb
                                    szélsőségek nélkül. A több éve tartó biológiai növényvédelemnek köszönhetően
                                    mostanra a szőlő héja olyan rugalmas és kemény lett, hogy maga is képes már a
                                    védekezésre a betegségek ellen, így ezzel sem volt gondunk. Még minket is meglepett
                                    az a rendkívüli gyümölcsíz, amit idén a szőlőbogyókban éreztünk, az optimális
                                    érettségben szüretelt fürtök mellett ez is okot ad az évjárat boraiban való
                                    bizakodásra.</p>
                            </div>
                            <div>
                                <table class="woocommerce-product-attributes shop_attributes">
                                    <tbody>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_evjarat">
                                            <th class="woocommerce-product-attributes-item__label">Évjárat</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>2015</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_szolofajta">
                                            <th class="woocommerce-product-attributes-item__label">Szőlőfajta</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>100% Cabernet Sauvignon</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_termohely">
                                            <th class="woocommerce-product-attributes-item__label">Termőhely</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>Csillagvölgy-dűlő</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_tokek-eletkora-ev">
                                            <th class="woocommerce-product-attributes-item__label">Tőkék életkora (év)
                                            </th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>20-35</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_toke-hektar">
                                            <th class="woocommerce-product-attributes-item__label">Tőke/hektár</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>5400</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_muvelesmod">
                                            <th class="woocommerce-product-attributes-item__label">Művelésmód</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>Középmagas kordon; 230 x 120-as ikertőke</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_szuret-idopontja">
                                            <th class="woocommerce-product-attributes-item__label">Szüret időpontja</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>Október eleje</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_borkeszites">
                                            <th class="woocommerce-product-attributes-item__label">Borkészítés</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>Az alkoholos erjesztés acéltartályban történt kb. 10 napig, a
                                                    biológiai almasavbontás már fahordóban ment végbe. Másod-, harmad
                                                    töltésű kis hordókban érlelődött 16 hónapig.</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_alkoholtartalom">
                                            <th class="woocommerce-product-attributes-item__label">Alkoholtartalom</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>13 %</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_cukormentes-extrakt">
                                            <th class="woocommerce-product-attributes-item__label">Cukormentes extrakt
                                            </th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>29,2 g/l</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_savtartalom">
                                            <th class="woocommerce-product-attributes-item__label">Savtartalom</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>5,3 g/l</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_maradekcukor">
                                            <th class="woocommerce-product-attributes-item__label">Maradékcukor</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>2,6 g/l</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_forgalomba-kerules">
                                            <th class="woocommerce-product-attributes-item__label">Forgalomba kerülés
                                            </th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>2021. december</p>
                                            </td>
                                        </tr>
                                        <tr
                                            class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_kiszerel%c3%a9s">
                                            <th class="woocommerce-product-attributes-item__label">Kiszerelés</th>
                                            <td class="woocommerce-product-attributes-item__value">
                                                <p>0,75 l</p>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div style="clear:both"></div>
                </div>
            </div>
        </div>


 

    <!--Plug-in Initialisation-->
    <link rel="stylesheet" type="text/css" href="https://shop.gere.hu/wp-content/themes/gereshop/css/slick-theme.css"/>
    <script type="text/javascript">
       jQuery(document).ready(function ($) {
            //Horizontal Tab
            $('#parentHorizontalTab').easyResponsiveTabs({
                type: 'default', //Types: default, vertical, accordion
                width: 'auto', //auto or any width like 600px
                fit: true, // 100% fit in a container
                tabidentify: 'hor_1', // The tab groups identifier
                activate: function (event) { // Callback function if tab is switched
                    var $tab = $(this);
                    var $info = $('#nested-tabInfo');
                    var $name = $('span', $info);
                    $name.text($tab.text());
                    $info.show();
                }
            });

            // Child Tab
            $('#ChildVerticalTab_1,#ChildVerticalTab_2,#ChildVerticalTab_3').easyResponsiveTabs({
                type: 'vertical',
                width: 'auto',
                fit: true,
                tabidentify: 'ver_1', // The tab groups identifier
                activetab_bg: '#fff', // background color for active tabs in this group
                inactive_bg: '#F5F5F5', // background color for inactive tabs in this group
                active_border_color: '#221f20', // border color for active tabs heads in this group
                active_content_border_color: '#221f20' // border color for active tabs contect in this group so that it matches the tab head border
            });

            //Vertical Tab
            $('#parentVerticalTab').easyResponsiveTabs({
                type: 'vertical', //Types: default, vertical, accordion
                width: 'auto', //auto or any width like 600px
                fit: true, // 100% fit in a container
                closed: 'accordion', // Start closed if in accordion view
                tabidentify: 'hor_1', // The tab groups identifier
                activate: function (event) { // Callback function if tab is switched
                    var $tab = $(this);
                    var $info = $('#nested-tabInfo2');
                    var $name = $('span', $info);
                    $name.text($tab.text());
                    $info.show();
                }
            });

            jQuery('#slicktabs').slick({
            slidesToShow: 11,
            slidesToScroll: 3,
            draggable: false,
            infinite: false,
            speed: 300,
            responsive: [
            {
            breakpoint: 1600,
            settings: {
                slidesToShow: 9,
            }
            },
            {
            breakpoint: 1400,
            settings: {
                slidesToShow: 8,
                slidesToScroll: 2
            }
            },
            {
            breakpoint: 1300,
            settings: {
                slidesToShow: 7,
                slidesToScroll: 2
            }
            },
            {
             breakpoint: 1199,
                settings: {
                    slidesToShow: 6,
                    slidesToScroll: 2
                }
            }
            
            // You can unslick at a given breakpoint now by adding:
            // settings: "unslick"
            // instead of a settings object
        ]

                    });


        });
    </script>

	<style>
		.woocommerce-tabs {display:none !important}
		</style>



<?php } ?>







 
<?php }



/**
 * @snippet       Add Text to Customer Processing Order Email
 * @how-to        Get CustomizeWoo.com FREE
 * @author        Rodolfo Melogli
 * @testedwith    Woo 4.6
 * @donate $9     https://businessbloomer.com/bloomer-armada/
 */
  
add_action( 'woocommerce_email_after_order_table', 'bbloomer_add_content_specific_email', 20, 4 );
  
function bbloomer_add_content_specific_email( $order, $sent_to_admin, $plain_text, $email ) {
        if(ICL_LANGUAGE_CODE=='hu'){
            echo '<p><strong>A szállítási idő 2-4 munkanap.</strong></p>';
		} else {
            echo '<p><strong>The delivery time is 2-4 work days.</strong></p>';
		}
}